/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;
import jet.universe.resultfile.JArray;
import toolkit.db.gui.MappingSQLType;

public class DbArray
extends DbValue {
    Object I = null;
    int[] QOIV = null;

    public DbArray() {
    }

    public DbArray(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public void set(int n, Object object) {
        if (this.desc.sqlType == 2003) {
            this.desc.setSqlType(MappingSQLType.mapColType(n));
        }
        this.I = object;
    }

    public void set(Array array) throws SQLException {
        switch (this.desc.sqlType) {
            case -7: {
                this.I = ((boolean[])array.getArray()).clone();
                break;
            }
            case -6: {
                this.I = ((byte[])array.getArray()).clone();
                break;
            }
            case 5: {
                this.I = ((short[])array.getArray()).clone();
                break;
            }
            case 4: {
                this.I = ((int[])array.getArray()).clone();
                break;
            }
            case -5: {
                this.I = ((long[])array.getArray()).clone();
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array.getArray();
                this.I = new long[dateArray.length];
                int n = 0;
                while (n < dateArray.length) {
                    ((long[])this.I)[n] = dateArray[n].getTime();
                    ++n;
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array.getArray();
                this.I = new long[timeArray.length];
                int n = 0;
                while (n < timeArray.length) {
                    ((long[])this.I)[n] = timeArray[n].getTime();
                    ++n;
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array.getArray();
                this.I = new long[timestampArray.length];
                this.QOIV = new int[timestampArray.length];
                int n = 0;
                while (n < timestampArray.length) {
                    ((long[])this.I)[n] = timestampArray[n].getTime();
                    this.QOIV[n] = timestampArray[n].getNanos();
                    ++n;
                }
                break;
            }
            case 6: 
            case 7: {
                this.I = ((float[])array.getArray()).clone();
                break;
            }
            case 8: {
                this.I = ((double[])array.getArray()).clone();
                break;
            }
            case 2: 
            case 3: {
                this.I = ((BigDecimal[])array.getArray()).clone();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.I = ((String[])array.getArray()).clone();
                break;
            }
        }
    }

    public String toString() {
        if (this.bNull) {
            return "";
        }
        String string = "[ ";
        switch (this.desc.sqlType) {
            case -7: {
                boolean[] blArray = (boolean[])this.I;
                int n = 0;
                while (n < blArray.length) {
                    string = string + blArray[n] + " ";
                    ++n;
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])this.I;
                int n = 0;
                while (n < byArray.length) {
                    string = string + byArray[n] + " ";
                    ++n;
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])this.I;
                int n = 0;
                while (n < sArray.length) {
                    string = string + sArray[n] + " ";
                    ++n;
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])this.I;
                int n = 0;
                while (n < nArray.length) {
                    string = string + nArray[n] + " ";
                    ++n;
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])this.I;
                int n = 0;
                while (n < lArray.length) {
                    string = string + lArray[n] + " ";
                    ++n;
                }
                break;
            }
            case 91: 
            case 92: {
                long[] lArray = (long[])this.I;
                int n = 0;
                while (n < lArray.length) {
                    string = string + new Date(lArray[n]) + " ";
                    ++n;
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])this.I;
                int n = 0;
                while (n < lArray.length) {
                    string = string + new Date(lArray[n] + (long)(this.QOIV[n] / 1000000)) + " ";
                    ++n;
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])((DbArray)this.I).getValue();
                int n = 0;
                while (n < fArray2.length) {
                    string = string + fArray2[n] + " ";
                    ++n;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])((DbArray)this.I).getValue();
                int n = 0;
                while (n < dArray.length) {
                    string = string + dArray[n] + " ";
                    ++n;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])this.I;
                int n = 0;
                while (n < bigDecimalArray.length) {
                    string = string + bigDecimalArray[n] + " ";
                    ++n;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])this.I;
                int n = 0;
                while (n < stringArray.length) {
                    string = string + stringArray[n] + " ";
                    ++n;
                }
                break;
            }
        }
        return string + ']';
    }

    public void set(ResultSet resultSet, int n) throws SQLException {
        Array array = resultSet.getArray(n);
        if (resultSet.wasNull()) {
            this.bNull = true;
        } else {
            if (this.desc.sqlType == 2003) {
                this.desc.setSqlType(MappingSQLType.mapColType(array.getBaseType()));
            }
            this.set(array);
            this.bNull = false;
        }
    }

    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        Array array = jRHierarchicalDataset.getArray(n);
        if (jRHierarchicalDataset.wasNull()) {
            this.bNull = true;
        } else {
            this.set(array);
            this.bNull = false;
        }
    }

    public void set(DbValue dbValue) {
        this.bNull = dbValue.bNull;
        this.I = ((DbArray)dbValue).I;
        this.QOIV = ((DbArray)dbValue).QOIV;
    }

    public boolean equals(DbValue dbValue) {
        return false;
    }

    public int compareTo(DbValue dbValue) {
        return 0;
    }

    public void setValue(String string) {
    }

    public void setValue(Object object, int n) {
        this.I = object;
        this.bNull = n <= 0;
    }

    public void setNanos(int[] nArray) {
        this.QOIV = nArray;
    }

    public Object getValue() {
        return this.I;
    }

    public int[] getNanos() {
        return this.QOIV;
    }

    public Array toSqlArray() {
        return new JArray(this.I, this.desc.sqlType);
    }

    public Object clone() {
        DbArray dbArray = new DbArray(this.desc);
        dbArray.bNull = this.bNull;
        if (!this.bNull) {
            Object object = null;
            switch (this.desc.sqlType) {
                case -7: {
                    object = ((boolean[])this.I).clone();
                    break;
                }
                case -6: {
                    object = ((byte[])this.I).clone();
                    break;
                }
                case 5: {
                    object = ((short[])this.I).clone();
                    break;
                }
                case 4: {
                    object = ((int[])this.I).clone();
                    break;
                }
                case -5: {
                    object = ((long[])this.I).clone();
                    break;
                }
                case 91: {
                    object = ((Date[])this.I).clone();
                    break;
                }
                case 92: {
                    object = ((Time[])this.I).clone();
                    break;
                }
                case 93: {
                    object = ((Timestamp[])this.I).clone();
                    break;
                }
                case 6: 
                case 7: {
                    object = ((float[])this.I).clone();
                    break;
                }
                case 8: {
                    object = ((double[])this.I).clone();
                    break;
                }
                case 2: 
                case 3: {
                    object = ((BigDecimal[])this.I).clone();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object = ((String[])this.I).clone();
                    break;
                }
            }
            dbArray.I = object;
        } else {
            dbArray.I = null;
        }
        return dbArray;
    }

    public void setValues(String[] stringArray, String string) throws ParseException {
        if (stringArray == null || stringArray.length == 0) {
            this.bNull = true;
        } else {
            this.bNull = false;
            this.desc.setArray(false);
            DbValue dbValue = DbValue.makeDbValue(this.desc);
            switch (this.desc.sqlType) {
                case -7: {
                    boolean[] blArray = new boolean[stringArray.length];
                    if (!(dbValue instanceof DbBit)) break;
                    DbBit dbBit = (DbBit)dbValue;
                    int n = 0;
                    while (n < stringArray.length) {
                        dbBit.setValue(stringArray[n]);
                        blArray[n] = dbBit.get();
                        ++n;
                    }
                    this.I = blArray;
                    break;
                }
                case -6: {
                    byte[] byArray = new byte[stringArray.length];
                    if (dbValue instanceof DbTinyInt) {
                        DbTinyInt dbTinyInt = (DbTinyInt)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbTinyInt.setValue(stringArray[n]);
                            byArray[n] = dbTinyInt.byteValue();
                            ++n;
                        }
                    }
                    this.I = byArray;
                    break;
                }
                case 5: {
                    short[] sArray = new short[stringArray.length];
                    if (dbValue instanceof DbSmallInt) {
                        DbSmallInt dbSmallInt = (DbSmallInt)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbSmallInt.setValue(stringArray[n]);
                            sArray[n] = dbSmallInt.shortValue();
                            ++n;
                        }
                    }
                    this.I = sArray;
                    break;
                }
                case 4: {
                    int[] nArray = new int[stringArray.length];
                    if (dbValue instanceof DbInteger) {
                        DbInteger dbInteger = (DbInteger)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbInteger.setValue(stringArray[n]);
                            nArray[n] = dbInteger.intValue();
                            ++n;
                        }
                    }
                    this.I = nArray;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    long[] lArray = new long[stringArray.length];
                    int[] nArray = new int[stringArray.length];
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                    if (dbValue instanceof DbTimestamp) {
                        DbTimestamp dbTimestamp = (DbTimestamp)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbTimestamp.set(simpleDateFormat.parse(stringArray[n]).getTime());
                            lArray[n] = dbTimestamp.get();
                            nArray[n] = dbTimestamp.getNanos();
                            ++n;
                        }
                        this.QOIV = nArray;
                    } else if (dbValue instanceof DbDateTime) {
                        DbDateTime dbDateTime = (DbDateTime)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbDateTime.set(simpleDateFormat.parse(stringArray[n]).getTime());
                            lArray[n] = dbDateTime.get();
                            ++n;
                        }
                    }
                    this.I = lArray;
                    break;
                }
                case -5: {
                    long[] lArray = new long[stringArray.length];
                    if (dbValue instanceof DbBigInt) {
                        DbBigInt dbBigInt = (DbBigInt)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbBigInt.setValue(stringArray[n]);
                            lArray[n] = dbBigInt.get();
                            ++n;
                        }
                    }
                    this.I = lArray;
                    break;
                }
                case 6: 
                case 7: {
                    float[] fArray2 = new float[stringArray.length];
                    if (dbValue instanceof DbReal) {
                        DbReal dbReal = (DbReal)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbReal.setValue(stringArray[n]);
                            fArray2[n] = dbReal.floatValue();
                            ++n;
                        }
                    }
                    this.I = fArray2;
                    break;
                }
                case 8: {
                    double[] dArray = new double[stringArray.length];
                    if (dbValue instanceof DbDouble) {
                        DbDouble dbDouble = (DbDouble)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbDouble.setValue(stringArray[n]);
                            dArray[n] = dbDouble.doubleValue();
                            ++n;
                        }
                    }
                    this.I = dArray;
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal[] bigDecimalArray = new BigDecimal[stringArray.length];
                    if (dbValue instanceof DbDecimal) {
                        DbDecimal dbDecimal = (DbDecimal)dbValue;
                        int n = 0;
                        while (n < stringArray.length) {
                            dbDecimal.setValue(stringArray[n]);
                            bigDecimalArray[n] = dbDecimal.get();
                            ++n;
                        }
                    }
                    this.I = bigDecimalArray;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.I = stringArray;
                    break;
                }
            }
        }
        this.desc.setArray(true);
    }
}

