/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDecimal;
import jet.connect.DbValue;

public class DbBigDecimalColumnBuffer
extends DbColumnBuffer {
    byte[][] QOIV;
    int arraycopy = 0;
    byte[] clearMem;
    byte[] decimalNeedBytes;
    byte[] get;

    public byte[][] getBuffer() {
        return this.QOIV;
    }

    public DbBigDecimalColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.arraycopy = DbBuffer.decimalNeedBytes(dbColDesc);
        this.clearMem = new byte[this.arraycopy];
        this.decimalNeedBytes = new byte[this.arraycopy];
        this.get = new byte[this.arraycopy];
        int n2 = 0;
        while (n2 < this.arraycopy) {
            this.clearMem[n2] = 0;
            this.decimalNeedBytes[n2] = -1;
            ++n2;
        }
        this.QOIV = new byte[n][this.arraycopy];
    }

    public void updateCell(int n, DbValue dbValue) {
        if (((DbDecimal)dbValue).get() == null) {
            System.arraycopy(this.clearMem, 0, this.QOIV[n], 0, this.arraycopy);
        } else {
            byte[] byArray = ((DbDecimal)dbValue).get().movePointRight(this.C.getScale()).toBigInteger().toByteArray();
            if ((byArray[0] & 0x80) != 128) {
                System.arraycopy(this.clearMem, 0, this.QOIV[n], 0, this.arraycopy);
            } else {
                System.arraycopy(this.decimalNeedBytes, 0, this.QOIV[n], 0, this.arraycopy);
            }
            System.arraycopy(byArray, 0, this.QOIV[n], this.arraycopy - byArray.length, byArray.length);
        }
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbDecimal)dbValue).set(new BigDecimal(new BigInteger(this.QOIV[n]), this.C.getScale()));
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataOutput.write(this.QOIV[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.QOIV.length) {
            dataInput.readFully(this.QOIV[n]);
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.QOIV = null;
        this.clearMem = null;
        this.decimalNeedBytes = null;
        this.get = null;
    }
}

