/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.datasource.JRHierarchicalDataset;

public class DbInteger
extends DbNumber {
    public int value;

    public DbInteger() {
    }

    public DbInteger(int n) {
        this.value = n;
        this.bNull = false;
    }

    public DbInteger(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public int get() {
        return this.value;
    }

    public void set(int n) {
        this.value = n;
        this.bNull = false;
    }

    public void set(ResultSet resultSet, int n) throws SQLException {
        this.value = resultSet.getInt(n);
        this.bNull = resultSet.wasNull();
    }

    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        this.value = jRHierarchicalDataset.getInt(n);
        this.bNull = jRHierarchicalDataset.wasNull();
    }

    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    public Object clone() {
        DbInteger dbInteger = new DbInteger(this.desc);
        dbInteger.bNull = this.bNull;
        dbInteger.value = this.value;
        return dbInteger;
    }

    public boolean equals(DbValue dbValue) {
        if (dbValue instanceof DbInteger) {
            DbInteger dbInteger = (DbInteger)dbValue;
            if (dbInteger.bNull != this.bNull) {
                return false;
            }
            if (this.bNull) {
                return true;
            }
            return this.value == dbInteger.value;
        }
        return false;
    }

    public int compareTo(DbValue dbValue) {
        DbInteger dbInteger = (DbInteger)dbValue;
        if (dbInteger.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbInteger.bNull) {
                return 0;
            }
            return -1;
        }
        if (this.value == dbInteger.value) {
            return 0;
        }
        if (this.value < dbInteger.value) {
            return -1;
        }
        return 1;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void set(DbValue dbValue) {
        this.value = ((DbInteger)dbValue).value;
        this.bNull = dbValue.bNull;
    }

    public void setValue(DbNumber dbNumber) {
        if (dbNumber instanceof DbInteger) {
            this.set(dbNumber);
        } else {
            this.bNull = dbNumber.bNull;
            if (!this.bNull) {
                this.value = dbNumber.intValue();
            }
        }
    }

    public void setValue(String string) {
        this.value = Integer.parseInt(string);
        this.bNull = false;
    }
}

