/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbLongColumnBuffer
extends DbColumnBuffer {
    long[] B;

    public long[] getBuffer() {
        return this.B;
    }

    public DbLongColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.B = new long[n];
    }

    public void updateCell(int n, DbValue dbValue) {
        this.B[n] = ((DbBigInt)dbValue).get();
    }

    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBigInt)dbValue).set(this.B[n]);
    }

    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.B.length) {
            dataOutput.writeLong(this.B[n]);
            ++n;
        }
    }

    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.B.length) {
            this.B[n] = dataInput.readLong();
            ++n;
        }
    }

    public void clearMem() {
        super.clearMem();
        this.B = null;
    }
}

