/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.dbbuffer;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.RelationMetaData;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordModelInfo;

public class MetaDataTool {
    public static DbColDesc[] getCols(JRelationMetaData jRelationMetaData) throws DSException {
        int n = jRelationMetaData.getColumnCount();
        DbColDesc[] dbColDescArray = new DbColDesc[n];
        int n2 = 0;
        while (n2 < n) {
            JAttribute jAttribute = jRelationMetaData.getAttribute(n2 + 1);
            dbColDescArray[n2] = MetaDataTool.createrDbColDesc(jAttribute);
            ++n2;
        }
        return dbColDescArray;
    }

    public static DbColDesc createrDbColDesc(JAttribute jAttribute) {
        DbColDesc dbColDesc = new DbColDesc(jAttribute.getAliasName(), Types.typeToSQLType(jAttribute.getDataType()), jAttribute.getPrecision(), jAttribute.getScale(), jAttribute.isNullable(), jAttribute.isCurrency());
        int n = jAttribute.getUseEncodingType();
        dbColDesc.setNotAutoEncode(n != 0);
        dbColDesc.setEncode(n == 1);
        dbColDesc.setConvertEncoding(jAttribute.getFromEncoding(), jAttribute.getToEncoding());
        if (dbColDesc.getSqlType() == 2003) {
            dbColDesc.setArray(true);
            dbColDesc.setSqlType(jAttribute.getBaseType());
        }
        dbColDesc.setReadOnly(jAttribute.isReadOnly());
        dbColDesc.setConstant(jAttribute.isConstant());
        return dbColDesc;
    }

    public static JRelationMetaData convert2RelationMetaData(RecordModelInfo recordModelInfo) {
        DbColDesc[] dbColDescArray = recordModelInfo.getColDescs();
        return MetaDataTool.ColDesc2RelationMetaData(dbColDescArray);
    }

    public static JRelationMetaData convert2RelationMetaData(JRecordModel jRecordModel) {
        DbColDesc[] dbColDescArray = jRecordModel.getColDescs();
        return MetaDataTool.ColDesc2RelationMetaData(dbColDescArray);
    }

    public static JRelationMetaData ColDesc2RelationMetaData(DbColDesc[] dbColDescArray) {
        JAttribute[] jAttributeArray = new JAttribute[dbColDescArray.length];
        int n = 0;
        while (n < dbColDescArray.length) {
            String string = dbColDescArray[n].getColName();
            int n2 = Types.sqlTypeToType(dbColDescArray[n].getSqlType());
            if (dbColDescArray[n].isArray()) {
                n2 = 2003;
            }
            int n3 = dbColDescArray[n].getPrecision();
            int n4 = dbColDescArray[n].getScale();
            int n5 = dbColDescArray[n].getNullable();
            int n6 = 0;
            boolean bl = dbColDescArray[n].isCurrency();
            boolean bl2 = dbColDescArray[n].isReadOnly();
            boolean bl3 = dbColDescArray[n].isGroupable() || dbColDescArray[n].isConstant() || dbColDescArray[n].isGroupLevel();
            jAttributeArray[n] = new Attribute(string, n2, n3, n4, n6, n5, bl, bl2, bl3);
            if (dbColDescArray[n].isArray()) {
                jAttributeArray[n].setBaseType(Types.sqlTypeToType(dbColDescArray[n].getSqlType()));
            }
            ++n;
        }
        return new RelationMetaData("noName", jAttributeArray);
    }
}

