/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSSection;
import jet.datastream.DSTableRow;
import jet.report.ChartDefine;
import jet.udo.chart.SingleChartDataset;
import jet.util.CharBinaryFormat;
import jet.util.IntVector;
import jet.util.Propertiable;

public class DSChartDataset
extends ChartDefine
implements SingleChartDataset {
    public int recordIndex = -1;
    public int groupLevel = -1;
    public int leafIndex = -1;
    public int branchIndex = -1;
    IntVector xRecords = new IntVector();
    Vector zRecords = null;
    public Groupable groupList;
    JRecord record;
    boolean bFooter = false;
    boolean bReportOrder = true;
    Vector vzmap;
    Object[] zValues;
    Vector vZValues;
    Vector vXValues;
    Vector vZGroupValues;
    Vector vXGroupValues;
    public int xGroupIndex = -1;
    public int zGroupIndex = -1;
    boolean samelevel = false;
    boolean bDHtml = false;
    CharBinaryFormat charFormat;
    String encoding = "XXXXXXXXX...";

    public DSChartDataset() {
    }

    public DSChartDataset(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, Object object) {
        super(string, string2, string3, bl, bl2, bl3, object);
    }

    public DSChartDataset(ChartDefine chartDefine) {
        super(chartDefine.x, chartDefine.y, chartDefine.z, chartDefine.xGroup, chartDefine.zGroup, chartDefine.b3D, chartDefine.owner);
    }

    public DSChartDataset(DSSection dSSection) {
        this.setDSSection(dSSection);
    }

    public void setDSSection(DSSection dSSection) {
        block3: {
            this.recordIndex = dSSection.recordIndex;
            this.groupLevel = dSSection.groupLevel;
            JRecord jRecord = dSSection.getRecord();
            this.groupList = jRecord.getRecordModel().getGroupable();
            this.leafIndex = ((DbNumber)jRecord.getCell(0)).intValue();
            try {
                this.record = jRecord.getDependCursor().createRecord();
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, dSException);
                JRLog.trace(5, "this dbbufferCursor is:" + jRecord.getDependCursor());
            }
        }
        this.bFooter = dSSection.getObjectType() == 518 || dSSection.getObjectType() == 516 || dSSection.getObjectType() == 2562;
        Propertiable propertiable = dSSection.getTemplate().getPropertyByName("BranchIdx");
        if (propertiable != null) {
            this.branchIndex = (Integer)propertiable.getNormalObject();
        }
    }

    public void setDSSection(DSTableRow dSTableRow) {
        this.recordIndex = dSTableRow.getRecordIndex();
        this.groupLevel = dSTableRow.getGroupLevel();
        JRecord jRecord = dSTableRow.getRecord();
        this.groupList = jRecord.getRecordModel().getGroupable();
        this.leafIndex = ((DbNumber)jRecord.getCell(0)).intValue();
        try {
            this.record = jRecord.getDependCursor().createRecord();
        }
        catch (DSException dSException) {
            dSException.printStackTrace();
        }
        this.bFooter = dSTableRow.getObjectType() == 0x1000005 || dSTableRow.getObjectType() == 0x1000003;
        Propertiable propertiable = dSTableRow.getTemplate().getPropertyByName("BranchIdx");
        if (propertiable != null) {
            this.branchIndex = (Integer)propertiable.getNormalObject();
        }
    }

    public void setReportOrder(boolean bl) {
        this.bReportOrder = bl;
    }

    public boolean isFooter() {
        return this.bFooter;
    }

    public boolean is3D() {
        return this.b3D;
    }

    public void initZ(String string) {
        this.encoding = string;
        boolean bl = false;
        if (this.b3D) {
            Vector<Object> vector = this.vZValues;
            if (this.vZValues == null) {
                vector = new Vector<Object>();
                Object[] objectArray = this.getX(this.encoding);
                if (objectArray == null) {
                    return;
                }
                int n = objectArray.length;
                this.vzmap = new Vector(n);
                int n2 = 0;
                while (n2 < n) {
                    Object[] objectArray2 = this.QOIV(n2, this.z);
                    IntVector intVector = new IntVector();
                    int n3 = 0;
                    while (n3 < objectArray2.length) {
                        int n4 = vector.indexOf(objectArray2[n3]);
                        if (n4 == -1) {
                            bl = true;
                            vector.addElement(((DbValue)objectArray2[n3]).clone());
                            n4 = vector.size() - 1;
                        }
                        intVector.addElement(n4);
                        ++n3;
                    }
                    this.vzmap.addElement(intVector);
                    ++n2;
                }
            }
            this.zValues = new Object[vector.size()];
            int n = 0;
            while (n < this.zValues.length) {
                this.zValues[n] = vector.elementAt(n);
                if (!bl && this.zValues[n] instanceof DbChar) {
                    this.zValues[n] = this.format(this.zValues[n]);
                }
                ++n;
            }
        }
    }

    public void initZ() {
        if (this.b3D) {
            Vector<Object> vector = this.vZValues;
            if (this.vZValues == null) {
                vector = new Vector<Object>();
                Object[] objectArray = this.getX(this.encoding);
                if (objectArray == null) {
                    return;
                }
                int n = objectArray.length;
                this.vzmap = new Vector(n);
                int n2 = 0;
                while (n2 < n) {
                    Object[] objectArray2 = this.QOIV(n2, this.z);
                    IntVector intVector = new IntVector();
                    int n3 = 0;
                    while (n3 < objectArray2.length) {
                        int n4 = vector.indexOf(objectArray2[n3]);
                        if (n4 == -1) {
                            vector.addElement(((DbValue)objectArray2[n3]).clone());
                            n4 = vector.size() - 1;
                        }
                        intVector.addElement(n4);
                        ++n3;
                    }
                    this.vzmap.addElement(intVector);
                    ++n2;
                }
            }
            this.zValues = new Object[vector.size()];
            int n = 0;
            while (n < this.zValues.length) {
                this.zValues[n] = vector.elementAt(n);
                if (this.zValues[n] instanceof DbChar) {
                    this.zValues[n] = this.format(this.zValues[n]);
                }
                ++n;
            }
        }
    }

    public void addXValue(DbValue dbValue) {
        if (this.vXValues == null) {
            this.vXValues = new Vector();
        }
        this.vXValues.addElement(dbValue.clone());
    }

    public void addXRecord(int n) {
        this.xRecords.addElement(n);
        if (this.b3D) {
            if (this.zRecords == null) {
                this.zRecords = new Vector();
            }
            this.zRecords.addElement(new IntVector());
        }
    }

    public void addZRecord(int n, int n2) {
        IntVector intVector = (IntVector)this.zRecords.elementAt(n);
        intVector.addElement(n2);
    }

    public void addZValue(int n, DbValue dbValue, DbValue dbValue2) {
        if (this.vZValues == null) {
            this.vZValues = new Vector();
            this.vZGroupValues = new Vector();
        }
        if (this.vzmap == null) {
            this.vzmap = new Vector();
        }
        if (this.vzmap.size() <= n) {
            this.vzmap.addElement(new IntVector());
        }
        IntVector intVector = (IntVector)this.vzmap.elementAt(n);
        int n2 = this.vZValues.indexOf(dbValue);
        int n3 = ((IntVector)this.zRecords.elementAt(n)).size();
        if (n2 == -1 || n3 > this.vZValues.size()) {
            this.vZValues.addElement(dbValue.clone());
            n2 = this.vZValues.size() - 1;
            this.vZGroupValues.addElement(dbValue2.clone());
        } else if (intVector.contains(n2)) {
            while (intVector.contains(n2 = this.vZValues.indexOf(dbValue, n2 + 1))) {
            }
            if (n2 == -1) {
                this.vZValues.addElement(dbValue.clone());
                n2 = this.vZValues.size() - 1;
                this.vZGroupValues.addElement(dbValue2.clone());
            }
        }
        intVector.addElement(n2);
    }

    public Object[] getX(String string) {
        JRLog.indent("getX");
        if (string != "XXXXXXXXX...") {
            this.encoding = string;
        }
        if (this.bReportOrder || !this.b3D) {
            if (this.vXValues != null) {
                Object[] objectArray = new DbValue[this.vXValues.size()];
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = this.vXValues.elementAt(n);
                    if ((DbValue)objectArray[n] instanceof DbChar) {
                        objectArray[n] = this.format(objectArray[n]);
                    }
                    ++n;
                }
                JRLog.deIndent("getX");
                return objectArray;
            }
            JRLog.deIndent("getX");
            return this.addElement(this.x);
        }
        JRLog.deIndent("getX");
        return this.zValues;
    }

    public Object[] getZ(String string) {
        JRLog.indent("getZ");
        this.encoding = string;
        if (this.bReportOrder || !this.b3D) {
            return this.zValues;
        }
        if (this.vXValues != null) {
            Object[] objectArray = new DbValue[this.vXValues.size()];
            int n = 0;
            while (n < this.zValues.length) {
                objectArray[n] = this.vXValues.elementAt(n);
                if ((DbValue)objectArray[n] instanceof DbChar) {
                    objectArray[n] = this.format(objectArray[n]);
                }
                ++n;
            }
            JRLog.deIndent("getZ");
            return objectArray;
        }
        JRLog.deIndent("getZ");
        return this.add(this.x);
    }

    public Object[] getY(int n) {
        JRLog.indent("getY");
        JRLog.deIndent("getY");
        return this.getValues(n, this.y.toUpperCase());
    }

    public Object[] getValues(int n, String string) {
        if (this.bReportOrder) {
            Object[] objectArray = this.QOIV(n, string);
            if (this.b3D) {
                IntVector intVector = (IntVector)this.vzmap.elementAt(n);
                Object[] objectArray2 = new Object[this.zValues.length];
                int n2 = 0;
                while (n2 < objectArray.length) {
                    objectArray2[intVector.elementAt((int)n2)] = objectArray[n2];
                    ++n2;
                }
                objectArray = objectArray2;
            }
            return objectArray;
        }
        int n3 = this.xRecords.size();
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        while (n4 < n3) {
            Object[] objectArray3 = this.QOIV(n4, string);
            if (this.b3D) {
                IntVector intVector = (IntVector)this.vzmap.elementAt(n4);
                Object[] objectArray4 = new Object[this.zValues.length];
                int n5 = 0;
                while (n5 < objectArray3.length) {
                    objectArray4[intVector.elementAt((int)n5)] = objectArray3[n5];
                    ++n5;
                }
                objectArray3 = objectArray4;
            }
            objectArray[n4] = objectArray3[n];
            ++n4;
        }
        return objectArray;
    }

    public Object[] getValues(String string) {
        return this.add(string);
    }

    private Object[] QOIV(int n, String string) {
        Object[] objectArray = null;
        if (!this.b3D) {
            objectArray = this.add(string);
        } else {
            IntVector intVector = (IntVector)this.zRecords.elementAt(n);
            if (this.zGroup) {
                int n2 = intVector.size();
                int n3 = n2 == 0 ? 0 : intVector.firstElement();
                objectArray = new DbValue[n2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < n2) {
                    n4 = n5 == 0 ? n3 + 1 : (n4 += intVector.elementAt(n5));
                    this.record.setRecordIndex(n4);
                    this.record.refresh(false);
                    objectArray[n5] = (DbValue)this.record.getCell(string).clone();
                    if ((DbValue)objectArray[n5] instanceof DbChar) {
                        objectArray[n5] = this.format(objectArray[n5]);
                    }
                    ++n5;
                }
            } else {
                int n6;
                int n7 = intVector.size();
                int n8 = n6 = n7 == 0 ? 0 : intVector.firstElement();
                if (!this.bDHtml && n7 > 1) {
                    n7 = intVector.elementAt(1);
                }
                objectArray = new DbValue[n7];
                if (!this.bDHtml) {
                    int n9 = 0;
                    while (n9 < n7) {
                        this.record.setRecordIndex(n9 + n6);
                        this.record.refresh(false);
                        objectArray[n9] = (DbValue)this.record.getCell(string).clone();
                        if ((DbValue)objectArray[n9] instanceof DbChar) {
                            objectArray[n9] = this.format(objectArray[n9]);
                        }
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n7) {
                        this.record.setRecordIndex(intVector.elementAt(n10));
                        this.record.refresh(false);
                        objectArray[n10] = (DbValue)this.record.getCell(string).clone();
                        if ((DbValue)objectArray[n10] instanceof DbChar) {
                            objectArray[n10] = this.format(objectArray[n10]);
                        }
                        ++n10;
                    }
                }
            }
        }
        return objectArray;
    }

    public void setDhtml(boolean bl) {
        this.bDHtml = bl;
    }

    private Object[] add(String string) {
        int n = this.xRecords.size();
        if (n == 0) {
            return null;
        }
        if (!this.bDHtml && !this.xGroup && n > 1) {
            n = this.xRecords.elementAt(1);
        }
        if (this.bDHtml && !this.xGroup) {
            --n;
        }
        int n2 = n == 0 ? 0 : this.xRecords.firstElement();
        Object[] objectArray = new DbValue[n];
        if (string == null || string.length() < 1) {
            if (this.xGroup) {
                objectArray[0] = new DbChar("Report");
            } else {
                int n3 = 0;
                while (n3 < n) {
                    objectArray[n3] = new DbChar("" + n3);
                    ++n3;
                }
            }
        } else if (this.xGroup) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                n4 = n5 == 0 ? n2 : (n4 += this.xRecords.elementAt(n5));
                this.record.setRecordIndex(n4);
                this.record.refresh(false);
                objectArray[n5] = (DbValue)this.record.getCell(string).clone();
                if ((DbValue)objectArray[n5] instanceof DbChar) {
                    objectArray[n5] = this.format(objectArray[n5]);
                }
                ++n5;
            }
        } else if (!this.bDHtml) {
            int n6 = 0;
            while (n6 < n) {
                this.record.setRecordIndex(n6 + n2);
                this.record.refresh(false);
                objectArray[n6] = (DbValue)this.record.getCell(string).clone();
                if ((DbValue)objectArray[n6] instanceof DbChar) {
                    objectArray[n6] = this.format(objectArray[n6]);
                }
                ++n6;
            }
        } else {
            int n7 = this.xRecords.elementAt(1);
            int n8 = 2;
            while (n8 <= n) {
                if (this.xRecords.elementAt(n8) > n7) {
                    n7 = this.xRecords.elementAt(n8);
                }
                ++n8;
            }
            int n9 = n7;
            int n10 = 0;
            if (n2 > n7) {
                while (n2 > n9) {
                    n9 += n7;
                }
                n10 = n9 - n;
            }
            if (n2 == this.xRecords.elementAt(1) + n10) {
                int n11 = 0;
                while (n11 < n) {
                    this.record.setRecordIndex(n10 + this.xRecords.elementAt(n11 + 1));
                    this.record.refresh(false);
                    objectArray[n11] = (DbValue)this.record.getCell(string).clone();
                    if ((DbValue)objectArray[n11] instanceof DbChar) {
                        objectArray[n11] = this.format(objectArray[n11]);
                    }
                    ++n11;
                }
            } else {
                int n12 = 0;
                while (n12 < n) {
                    this.record.setRecordIndex(n10 + n12 + 1);
                    this.record.refresh(false);
                    objectArray[n12] = (DbValue)this.record.getCell(string).clone();
                    if ((DbValue)objectArray[n12] instanceof DbChar) {
                        objectArray[n12] = this.format(objectArray[n12]);
                    }
                    ++n12;
                }
            }
        }
        return objectArray;
    }

    private Object[] addElement(String string) {
        int n = this.xRecords.size();
        if (n == 0) {
            return null;
        }
        if (!this.bDHtml && !this.xGroup && n > 1) {
            n = this.xRecords.elementAt(1);
        }
        if (this.bDHtml && !this.xGroup) {
            --n;
        }
        int n2 = n == 0 ? 0 : this.xRecords.firstElement();
        Object[] objectArray = new DbValue[n];
        if (string == null || string.length() < 1) {
            if (this.xGroup) {
                objectArray[0] = new DbChar("Report");
            } else {
                int n3 = 0;
                while (n3 < n) {
                    objectArray[n3] = new DbChar("" + n3);
                    ++n3;
                }
            }
        } else if (this.xGroup) {
            int n4 = 0;
            boolean bl = false;
            if (this.vXValues == null) {
                this.vXValues = new Vector();
                this.vXGroupValues = new Vector();
                bl = true;
            }
            int n5 = 0;
            while (n5 < n) {
                n4 = n5 == 0 ? n2 : (n4 += this.xRecords.elementAt(n5));
                this.record.setRecordIndex(n4);
                this.record.refresh(false);
                objectArray[n5] = (DbValue)this.record.getCell(string).clone();
                if (bl) {
                    this.vXValues.add(objectArray[n5]);
                    this.vXGroupValues.add(objectArray[n5]);
                }
                if ((DbValue)objectArray[n5] instanceof DbChar) {
                    objectArray[n5] = this.format(objectArray[n5]);
                }
                ++n5;
            }
        } else if (!this.bDHtml) {
            int n6 = 0;
            while (n6 < n) {
                this.record.setRecordIndex(n6 + n2);
                this.record.refresh(false);
                objectArray[n6] = (DbValue)this.record.getCell(string).clone();
                if ((DbValue)objectArray[n6] instanceof DbChar) {
                    objectArray[n6] = this.format(objectArray[n6]);
                }
                ++n6;
            }
        } else {
            int n7 = this.xRecords.elementAt(1);
            int n8 = 2;
            while (n8 <= n) {
                if (this.xRecords.elementAt(n8) > n7) {
                    n7 = this.xRecords.elementAt(n8);
                }
                ++n8;
            }
            int n9 = n7;
            int n10 = 0;
            if (n2 > n7) {
                while (n2 > n9) {
                    n9 += n7;
                }
                n10 = n9 - n;
            }
            if (n2 == this.xRecords.elementAt(1) + n10) {
                int n11 = 0;
                while (n11 < n) {
                    this.record.setRecordIndex(n10 + this.xRecords.elementAt(n11 + 1));
                    this.record.refresh(false);
                    objectArray[n11] = (DbValue)this.record.getCell(string).clone();
                    if ((DbValue)objectArray[n11] instanceof DbChar) {
                        objectArray[n11] = this.format(objectArray[n11]);
                    }
                    ++n11;
                }
            } else {
                int n12 = 0;
                while (n12 < n) {
                    this.record.setRecordIndex(n10 + n12 + 1);
                    this.record.refresh(false);
                    objectArray[n12] = (DbValue)this.record.getCell(string).clone();
                    if ((DbValue)objectArray[n12] instanceof DbChar) {
                        objectArray[n12] = this.format(objectArray[n12]);
                    }
                    ++n12;
                }
            }
        }
        return objectArray;
    }

    public void setSLevel(boolean bl) {
        this.samelevel = bl;
    }

    public boolean getSLevel() {
        return this.samelevel;
    }

    private DbValue format(Object object) {
        this.charFormat = new CharBinaryFormat(this.encoding);
        DbChar dbChar = new DbChar(this.charFormat.format(object.toString()));
        object = null;
        object = dbChar;
        this.charFormat = null;
        return (DbValue)object;
    }

    public Object[] getX() {
        return null;
    }

    public Object[] getZ() {
        return null;
    }

    public void addXGroupValue(DbValue dbValue) {
        if (this.vXGroupValues == null) {
            this.vXGroupValues = new Vector();
        }
        this.vXGroupValues.addElement(dbValue.clone());
    }
}

