/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbChar;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTextObj;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.TextobjFieldable;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderText;
import jet.util.Containable;
import jet.util.Converter;
import jet.util.DbValueFormat;
import jet.util.HashVector;
import jet.util.JFieldValueNLSManager;
import jet.util.NLSBundleInfo;
import jet.util.Propertiable;
import jet.util.ReportFormat;
import jet.util.VersionControlable;

public class DSField
extends JRVisiableResult {
    Render C = null;
    Integer B = null;
    int append = -1;
    int D;
    int clearCacheRecord;
    int convertGraphicsToGraphics2D;
    int convertTextForTextObject;
    int convertUnitToPixel;
    int createConcreteRender;
    int createRender;
    int[][] drawImage = null;
    int dupRenderText;
    int equals;
    protected Locale locale;
    protected int resolution = -1;
    protected TimeZone timezone;
    private boolean format = false;
    private int get = 0;
    private int getBounds = 0;
    private int getCommunicator = -1;
    private ImageObserver getEveryLineHeight;
    protected boolean isRuntimeConvert = false;
    protected int fromEncoding = -1;
    protected int toEncoding = -1;
    protected JFieldValueNLSManager nlsManager;
    protected NLSBundleInfo nlsBundle;
    boolean getEveryLinePos = false;
    private int getFieldNLSManager = -1;
    private Record getFromEncoding = null;

    public void setStringValue(String string) {
    }

    public void setLineBreakPos(int[][] nArray) {
        if (nArray.length > 0) {
            this.drawImage = nArray;
        }
    }

    public int[][] getLineBreakPos() {
        return this.drawImage;
    }

    public void setStartLine(int n) {
        this.dupRenderText = n;
    }

    public void setStartLine_split(int n) {
        this.dupRenderText = n + 1;
    }

    public int getStartLine() {
        return this.dupRenderText;
    }

    public void setEndLine(int n) {
        this.equals = n;
    }

    public int getEndLine() {
        return this.equals;
    }

    protected void beforeWrite() {
        super.beforeWrite();
        this.flag = (byte)(this.flag | (this.getCommunicator != -1 ? 64 : 0));
        this.flag = (byte)(this.flag | (this.drawImage != null ? -128 : 0));
    }

    public String getText(JRecord jRecord) {
        String string;
        Object object;
        if (this.getObjectType() == 257 || this.getObjectType() == 393473) {
            object = this.getPropertyByName("DispTextInfo", jRecord);
            string = object == null || object.getObject().equals("") ? (String)this.getPropertyByName("Text", jRecord).getObject() : (String)object.getObject();
        } else {
            throw new RuntimeException();
        }
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        } else {
            object = this.getCommunicator();
            this.fromEncoding = object.getFromEncoding();
            this.toEncoding = object.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        }
        return string;
    }

    public String getText() {
        String string;
        Object object;
        if (this.getObjectType() == 257 || this.getObjectType() == 393473) {
            object = this.getPropertyByName("DispTextInfo");
            string = object == null || object.getObject().equals("") ? (String)this.getPropertyByName("Text").getObject() : (String)object.getObject();
        } else {
            throw new RuntimeException();
        }
        if (this.isRuntimeConvert) {
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        } else {
            object = this.getCommunicator();
            this.fromEncoding = object.getFromEncoding();
            this.toEncoding = object.getToEncoding();
            if (this.fromEncoding != -1 && this.toEncoding != -1) {
                string = Converter.convertString(string, this.fromEncoding, this.toEncoding);
            }
        }
        return string;
    }

    public void setStretchHeight(int n) {
        this.append = n;
    }

    public int getStretchHeight() {
        return this.append == -1 ? this.getHeight() : this.append;
    }

    public void setLineNum(int n) {
        this.D = n;
    }

    public int getLineNum() {
        return this.D;
    }

    public void setStartChar(short s) {
        this.clearCacheRecord = s;
    }

    public int getStartChar() {
        return this.clearCacheRecord;
    }

    public void setCharLength(short s) {
        this.convertGraphicsToGraphics2D = s;
    }

    public int getCharLength() {
        return this.convertGraphicsToGraphics2D;
    }

    public void setBaseline(int n) {
        this.convertTextForTextObject = n;
    }

    public int getBaseline() {
        return Unit.convertUnitToPixel(this.convertTextForTextObject, this.getResolution());
    }

    public void setUnderlineWidth(int n) {
        this.convertUnitToPixel = n;
    }

    public int getUnderlineWidth() {
        return Unit.convertUnitToPixel(this.convertUnitToPixel, this.getResolution());
    }

    public void setStrikeline(int n) {
        this.createConcreteRender = n;
    }

    public int getStrikeline() {
        return Unit.convertUnitToPixel(this.createConcreteRender, this.getResolution());
    }

    public void setStrikelineWidth(int n) {
        this.createRender = n;
    }

    public int getStrikelineWidth() {
        return Unit.convertUnitToPixel(this.createRender, this.getResolution());
    }

    public static final String convertTextForTextObject(String string) {
        string = string.replace('\t', ' ');
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        return string;
    }

    public String toString() {
        String string = this.getText();
        if (this.isTextobjFieldable()) {
            int n = (string = DSField.convertTextForTextObject(string)).length();
            if (this.clearCacheRecord < n && this.clearCacheRecord + this.convertGraphicsToGraphics2D <= n) {
                string = string.substring(this.clearCacheRecord, this.clearCacheRecord + this.convertGraphicsToGraphics2D);
            } else if (this.getObjectType() == 257 && this.clearCacheRecord < n && this.clearCacheRecord + this.convertGraphicsToGraphics2D > n) {
                int n2 = this.clearCacheRecord;
                String string2 = string;
                while (n2 < this.clearCacheRecord + this.convertGraphicsToGraphics2D) {
                    string2 = string2 + string;
                    n2 += n;
                }
                string = string2.substring(this.clearCacheRecord, this.clearCacheRecord + this.convertGraphicsToGraphics2D);
            }
        }
        return string;
    }

    private void B(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        JFieldValueNLSManager jFieldValueNLSManager;
        int n;
        boolean bl = true;
        if (dataInput instanceof VersionControlable && (0 == (n = ((VersionControlable)((Object)dataInput)).getVersion()) || n > 262160)) {
            bl = false;
        }
        if (bl) {
            if (this.isTextobjFieldable()) {
                if (dataInput instanceof VersionControlable) {
                    n = ((VersionControlable)((Object)dataInput)).getVersion();
                    if (n >= 131072 || n == 0) {
                        this.D = dataInput.readInt();
                        this.clearCacheRecord = dataInput.readInt();
                        this.convertGraphicsToGraphics2D = dataInput.readInt();
                        this.convertTextForTextObject = dataInput.readInt();
                        this.convertUnitToPixel = dataInput.readInt();
                        this.createConcreteRender = dataInput.readInt();
                        this.createRender = dataInput.readInt();
                        if (n < 131087 && n != 0) {
                            this.convertTextForTextObject = (int)Math.round((double)this.convertTextForTextObject * 5760.0 / 65535.0);
                            this.convertUnitToPixel = (int)Math.round((double)this.convertUnitToPixel * 5760.0 / 65535.0);
                            this.createConcreteRender = (int)Math.round((double)this.createConcreteRender * 5760.0 / 65535.0);
                            this.createRender = (int)Math.round((double)this.createRender * 5760.0 / 65535.0);
                        }
                    } else {
                        this.D = dataInput.readShort();
                        this.clearCacheRecord = dataInput.readShort();
                        this.convertGraphicsToGraphics2D = dataInput.readShort();
                        this.convertTextForTextObject = dataInput.readShort();
                        this.convertUnitToPixel = dataInput.readShort();
                        this.createConcreteRender = dataInput.readShort();
                        this.createRender = dataInput.readShort();
                    }
                }
            } else {
                this.append = dataInput.readInt();
            }
        }
        if (dataInput instanceof VersionControlable) {
            int n2;
            n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n >= 7 && n < 131076) {
                n2 = 0;
                while (n2 < 2) {
                    dataInput.readInt();
                    ++n2;
                }
            }
            if (n >= 10 && n < 131085) {
                n2 = dataInput.readShort();
                if (n2 != 0) {
                    this.drawImage = new int[n2][2];
                    int n3 = 0;
                    while (n3 < n2) {
                        this.drawImage[n3][0] = dataInput.readShort();
                        this.drawImage[n3][1] = dataInput.readShort();
                        ++n3;
                    }
                    this.dupRenderText = dataInput.readShort();
                    this.equals = dataInput.readShort();
                }
            } else if (n >= 131085 && n <= 262160) {
                n2 = dataInput.readInt();
                if (n2 != 0) {
                    this.drawImage = new int[n2][2];
                    int n4 = 0;
                    while (n4 < n2) {
                        this.drawImage[n4][0] = dataInput.readInt();
                        this.drawImage[n4][1] = dataInput.readInt();
                        ++n4;
                    }
                    this.dupRenderText = dataInput.readInt();
                    this.equals = dataInput.readInt();
                }
            } else if ((n > 262160 || n == 0) && (this.flag & 0xFFFFFF80) != 0 && (n2 = dataInput.readInt()) != 0) {
                this.drawImage = new int[n2][2];
                int n5 = 0;
                while (n5 < n2) {
                    this.drawImage[n5][0] = dataInput.readInt();
                    this.drawImage[n5][1] = dataInput.readInt();
                    ++n5;
                }
                this.dupRenderText = dataInput.readInt();
                this.equals = dataInput.readInt();
            }
            if (n >= 131098 && n <= 262160) {
                this.getFieldNLSManager = dataInput.readInt();
            }
            if (n >= 262145 || n == 0) {
                n2 = dataInput.readBoolean() ? 1 : 0;
                if (n2 != 0) {
                    this.QOIV(dataInput);
                }
                if (n > 0 && n <= 262160) {
                    this.getCommunicator = dataInput.readInt();
                } else if ((this.flag & 0x40) != 0) {
                    this.getCommunicator = dataInput.readInt();
                }
            }
        }
        if (this.nlsManager == null && dSDataStreamable.getCommunicator() != null && (jFieldValueNLSManager = dSDataStreamable.getCommunicator().getFieldNLSManager()) != null && jFieldValueNLSManager.isContainSelfDefinedMapping()) {
            this.nlsManager = jFieldValueNLSManager;
        }
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.B(dataInput, dSDataStreamable);
    }

    public int getRenderType() {
        int n = 0;
        if (this.B != null) {
            n = this.B;
        } else {
            Propertiable propertiable = this.getPropertyByName("renderType");
            if (propertiable != null) {
                this.B = (Integer)propertiable.getObject();
                n = this.B;
            }
        }
        return n;
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        super.writeProperties(dataOutput);
        if (this.drawImage != null) {
            dataOutput.writeInt(this.drawImage.length);
            n = 0;
            while (n < this.drawImage.length) {
                dataOutput.writeInt(this.drawImage[n][0]);
                dataOutput.writeInt(this.drawImage[n][1]);
                ++n;
            }
            dataOutput.writeInt(this.dupRenderText);
            dataOutput.writeInt(this.equals);
        }
        n = 1;
        if (this.C == null || this.B != null && this.B != 0) {
            n = 0;
        }
        dataOutput.writeBoolean(n != 0);
        if (n != 0) {
            this.writeRenderTextProperties(dataOutput);
        }
        if (this.getCommunicator != -1) {
            dataOutput.writeInt(this.getCommunicator);
        }
    }

    protected void writeRenderTextProperties(DataOutput dataOutput) throws IOException {
        RenderText renderText = (RenderText)this.C;
        dataOutput.writeInt(this.C.getX());
        dataOutput.writeInt(this.C.getY());
        dataOutput.writeInt(this.C.getWidth());
        dataOutput.writeInt(this.C.getHeight());
        Vector vector = renderText.getVLines();
        int n = vector == null ? 0 : vector.size();
        dataOutput.writeInt(n);
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                dataOutput.writeUTF((String)vector.get(n2));
                ++n2;
            }
            int[][] nArray = renderText.getEveryLinePos();
            int n3 = 0;
            while (n3 < n) {
                dataOutput.writeInt(nArray[n3][0]);
                dataOutput.writeInt(nArray[n3][1]);
                ++n3;
            }
        }
    }

    private void QOIV(DataInput dataInput) throws IOException {
        this.C = new RenderText(this);
        this.C.setX(dataInput.readInt());
        this.C.setY(dataInput.readInt());
        this.C.setWidth(dataInput.readInt());
        this.C.setHeight(dataInput.readInt());
        int n = dataInput.readInt();
        if (n != 0) {
            Object object;
            Vector<String> vector = new Vector<String>(n);
            int n2 = 0;
            while (n2 < n) {
                object = dataInput.readUTF();
                vector.add((String)object);
                ++n2;
            }
            ((RenderText)this.C).setVLines(vector);
            object = new int[n][2];
            int n3 = 0;
            while (n3 < n) {
                object[n3][0] = dataInput.readInt();
                object[n3][1] = dataInput.readInt();
                ++n3;
            }
            ((RenderText)this.C).setEveryLinePos((int[][])object);
        }
        RenderCreator.setCommonRenderProperteis(this.C, this);
    }

    private int UTFLength(Render render) {
        int n = 0;
        if (render != null && render instanceof RenderText) {
            n += 16;
            Vector vector = ((RenderText)render).getVLines();
            int n2 = vector == null ? 0 : vector.size();
            n += 4;
            if (n2 != 0) {
                int n3 = 0;
                while (n3 < n2) {
                    n += JRObjectResult.UTFLength((String)vector.get(n3)) + 2;
                    ++n3;
                }
                n += n2 * 2 * 4;
            }
        }
        return n;
    }

    protected int propLength() {
        int n = super.propLength();
        if (this.drawImage != null) {
            n += 12 + 8 * this.drawImage.length;
        }
        ++n;
        n += this.UTFLength(this.C);
        if (this.getCommunicator != -1) {
            n += 4;
        }
        return n;
    }

    public boolean isTextobjFieldable() {
        return ((TextobjFieldable)((Object)this.getTemplate())).isTextobjFieldable();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        try {
            this.locale = this.getCommunicator().getLocale();
        }
        catch (NullPointerException nullPointerException) {
            this.locale = null;
        }
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public Object clone() {
        return this.dup(new DSField());
    }

    public DSField dup(DSField dSField) {
        super.dup(dSField);
        dSField.append = this.append;
        dSField.D = this.D;
        dSField.clearCacheRecord = this.clearCacheRecord;
        dSField.convertGraphicsToGraphics2D = this.convertGraphicsToGraphics2D;
        dSField.convertTextForTextObject = this.convertTextForTextObject;
        dSField.convertUnitToPixel = this.convertUnitToPixel;
        dSField.createConcreteRender = this.createConcreteRender;
        dSField.createRender = this.createRender;
        dSField.drawImage = this.drawImage;
        dSField.dupRenderText = this.dupRenderText;
        dSField.equals = this.equals;
        dSField.locale = this.locale;
        dSField.timezone = this.timezone;
        dSField.getFieldNLSManager = this.getFieldNLSManager;
        if (this.C != null && this.C instanceof RenderText) {
            dSField.C = this.dupRenderText((RenderText)this.C);
        }
        dSField.getCommunicator = this.getCommunicator;
        return dSField;
    }

    public Render dupRenderText(RenderText renderText) {
        renderText.setX(this.C.getX());
        renderText.setY(this.C.getY());
        renderText.setWidth(this.C.getWidth());
        renderText.setHeight(this.C.getHeight());
        renderText.setVLines(((RenderText)this.C).getVLines());
        renderText.setEveryLineHeight(((RenderText)this.C).getEveryLineHeight());
        renderText.setEveryLinePos(((RenderText)this.C).getEveryLinePos());
        return renderText;
    }

    protected String get(DbChar dbChar) {
        String string = (String)this.getPropertyByName("Format").getObject();
        DbValueFormat dbValueFormat = null;
        try {
            dbValueFormat = ReportFormat.getOneFormat(dbChar.getSqlType(), string, this.locale);
        }
        catch (Exception exception) {
            dbValueFormat = null;
        }
        return dbValueFormat != null ? dbValueFormat.format(dbChar) : dbChar.toString();
    }

    public String toStringPipe() {
        this.getEveryLinePos = true;
        return this.toString();
    }

    public int getTextObjParaFmtNO() {
        return this.getFieldNLSManager;
    }

    public void setTextObjParaFmtNO(int n) {
        this.getFieldNLSManager = n;
    }

    public HashVector getTextObjParaFmts() {
        Containable containable = this.getParent();
        if (this.getFieldNLSManager < 0 || containable == null || !(containable instanceof DSTextObj)) {
            return null;
        }
        return ((DSTextObj)containable).getParaFormat(this.getFieldNLSManager);
    }

    protected Render createRender() {
        Propertiable propertiable = this.getPropertyByName("renderType");
        if (propertiable == null) {
            if (JRLog.isAd()) {
                JRLog.print("RenderType is null or the report you opened is not version8 or earlier, It will provide Text Type to this field.");
            }
            this.B = null;
            return RenderCreator.createConcreteRender(0, this);
        }
        this.B = (Integer)propertiable.getObject();
        return RenderCreator.createConcreteRender(this.B, this);
    }

    public Record getSynRecord() {
        if (this.getFromEncoding != null) {
            return this.getFromEncoding;
        }
        return super.getSynRecord();
    }

    public void clearCacheRecord() {
        this.getFromEncoding = null;
    }

    public Render getRenderWithCascade() {
        this.C = this.createRender();
        return this.C;
    }

    public Render getRender() {
        if (this.C == null) {
            Render render = this.createRender();
            this.clearCacheRecord();
            return render;
        }
        this.C.setField(this);
        RenderCreator.setCommonRenderProperteis(this.C, this);
        this.clearCacheRecord();
        return this.C;
    }

    public boolean hasRender() {
        return this.C != null;
    }

    public Render getRender(ImageObserver imageObserver) {
        if (this.C == null) {
            this.C = this.createRender();
        }
        this.C.setResolution(this.getResolution());
        this.C.setImageObserver(imageObserver);
        return this.C;
    }

    public void paint(Graphics graphics) {
        Render render = this.getRender();
        render.setPaintCalledByField(true);
        double d = render.getRotation();
        if (this.format) {
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, this.getBounds());
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            graphics2D.rotate(d, render.getRotationX(), render.getRotationY());
            render.paintFieldBackground(graphics2D);
            render.paint(graphics2D);
            render.paintFieldBorder(graphics2D);
            graphics2D.rotate(-d, render.getRotationX(), render.getRotationY());
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else if (render instanceof RenderBarCode && !this.format) {
            Rectangle rectangle = new Rectangle(0, 0, 1, 1);
            if (this.getWidth() <= 0) {
                rectangle.setBounds(0, 0, 1, 1);
            } else {
                rectangle = this.getBounds();
            }
            BufferedImage bufferedImage = RenderGraphicsToolkit.convertGraphicsToGraphics2D(graphics, rectangle);
            Graphics2D graphics2D = null;
            graphics2D = bufferedImage != null ? (Graphics2D)bufferedImage.getGraphics() : (Graphics2D)graphics;
            render.paintFieldBackground(graphics2D);
            render.paint(graphics2D);
            render.paintFieldBorder(graphics2D);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
            }
        } else {
            render.paintFieldBackground(graphics);
            render.paint(graphics);
            render.paintFieldBorder(graphics);
        }
        render.setPaintCalledByField(false);
    }

    public int getBeforeRotationHeight() {
        return this.getBounds;
    }

    public void setBeforeRotationHeight(int n) {
        this.getBounds = n;
    }

    public int getBeforeRotationWidth() {
        return this.get;
    }

    public void setBeforeRotationWidth(int n) {
        this.get = n;
    }

    public void setFormIndex(int n) {
        this.getCommunicator = n;
    }

    public int getFormIndex() {
        return this.getCommunicator;
    }

    public String getPreviousText() {
        return this.getText();
    }

    public void setCacheRecord(Record record) {
        this.getFromEncoding = record;
    }

    public Record getCacheRecord() {
        return this.getFromEncoding;
    }

    public void setRender(Render render) {
        this.C = render;
    }

    public void setNLSManager(JFieldValueNLSManager jFieldValueNLSManager) {
        this.nlsManager = jFieldValueNLSManager;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.getEveryLineHeight = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.getEveryLineHeight;
    }

    public NLSBundleInfo getNlsBundle() {
        return this.nlsBundle;
    }

    public void setNlsBundle(NLSBundleInfo nLSBundleInfo) {
        this.nlsBundle = nLSBundleInfo;
    }

    public void setRuntimeComvert(boolean bl) {
        this.isRuntimeConvert = bl;
    }

    public void setFromEncoding(int n) {
        this.fromEncoding = n;
    }

    public void setToEncoding(int n) {
        this.toEncoding = n;
    }

    public int getResolution() {
        if (this.resolution != -1) {
            return this.resolution;
        }
        return super.getResolution();
    }

    public void setResolution(int n) {
        this.resolution = n;
    }
}

