/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.ReportEnv;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSSubReport;
import jet.datastream.RandomByteArrayInputStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.io.FileBlockInputStream;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataInput;
import jet.ie.io.PJFDataOutput;
import jet.util.RAFile;
import jet.util.TempFile;

public class SubReportBuffer {
    protected int cacheSize = 100;
    private Vector QOIV;
    private int addElement = 0;
    protected Vector pageLengthes = new Vector();
    private TempFile clear;
    private File close;
    protected RAFile bufFile;
    protected FileBlockOutputStream out;
    private DSDataStreamable createTempFile;
    private FileBlockInputStream delete = null;
    private boolean elementAt = false;
    boolean error = false;
    int get = 0;

    public SubReportBuffer() {
    }

    public SubReportBuffer(int n, DSDataStreamable dSDataStreamable, boolean bl) {
        if (n > 0) {
            this.cacheSize = n;
        }
        this.QOIV = new Vector(n);
        this.createTempFile = dSDataStreamable;
        this.elementAt = bl;
    }

    void QOIV() {
        block3: {
            try {
                File file = new File(ReportEnv.temporaryPath);
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                this.clear = new TempFile(ReportEnv.temporaryPath, "subDatastream");
                this.close = this.clear.createTempFile();
                this.bufFile = new RAFile(this.close, "rw");
                this.out = new FileBlockOutputStream(this.bufFile);
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, exception);
            }
        }
    }

    public synchronized DSSubReport nextPage() {
        DSSubReport dSSubReport = null;
        do {
            int n;
            if ((n = this.QOIV.size()) > 0) {
                dSSubReport = (DSSubReport)this.QOIV.elementAt(0);
            }
            if (dSSubReport == null) {
                if (this.error) break;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, interruptedException);
                }
                continue;
            }
            this.QOIV.removeElementAt(0);
        } while (dSSubReport == null);
        this.notifyAll();
        return dSSubReport;
    }

    public synchronized DSSubReport getPage(int n) throws JRStopEngineException {
        DSSubReport dSSubReport;
        block18: {
            dSSubReport = null;
            int n2 = this.QOIV.size();
            int n3 = 0;
            int n4 = 0;
            if (n2 > 0) {
                n3 = ((DSSubReport)this.QOIV.elementAt(n2 - 1)).getPageNum();
                n4 = n3 - n2 + 1;
            }
            if (n >= n4 && n <= n3) {
                dSSubReport = (DSSubReport)this.QOIV.elementAt(n - n4);
            } else if (!this.elementAt) {
                do {
                    if ((dSSubReport = (DSSubReport)this.QOIV.get(n)) != null) continue;
                    if (this.error) break;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!JRLog.isError(2)) continue;
                        JRLog.error(2, interruptedException);
                    }
                } while (dSSubReport == null);
                this.notifyAll();
            } else {
                Closeable closeable;
                Object object;
                block17: {
                    if (n == 1) {
                        try {
                            object = new RandomByteArrayOutputStream(this.addElement);
                            closeable = new PJFDataOutput((OutputStream)object);
                            int n5 = 0;
                            while (n5 < this.QOIV.size()) {
                                DSSubReport dSSubReport2 = (DSSubReport)this.QOIV.elementAt(n5);
                                dSSubReport2.write((DataOutput)((Object)closeable));
                                dSSubReport2 = null;
                                ++n5;
                            }
                            this.out.write(((ByteArrayOutputStream)object).toByteArray());
                            ((ByteArrayOutputStream)object).close();
                            this.QOIV.removeAllElements();
                            this.bufFile.seek(0L);
                        }
                        catch (IOException iOException) {
                            if (!JRLog.isError(2)) break block17;
                            JRLog.error(2, iOException);
                        }
                    }
                }
                this.QOIV.removeAllElements();
                this.addElement = 0;
                int n6 = 0;
                while (n6 < this.cacheSize && n + n6 <= this.pageLengthes.size()) {
                    this.addElement += ((Integer)this.pageLengthes.elementAt(n + n6 - 1)).intValue();
                    ++n6;
                }
                try {
                    if (this.delete == null) {
                        this.delete = new FileBlockInputStream(this.bufFile);
                    }
                    this.delete.reset(this.addElement);
                    object = new byte[this.addElement];
                    this.delete.read((byte[])object);
                    closeable = new RandomByteArrayInputStream((byte[])object);
                    PJFDataInput pJFDataInput = new PJFDataInput((InputStream)closeable);
                    int n7 = 0;
                    while (n7 < this.cacheSize && n + n7 <= this.pageLengthes.size()) {
                        pJFDataInput.readInt();
                        dSSubReport = new DSSubReport();
                        dSSubReport.read(pJFDataInput, this.createTempFile);
                        this.QOIV.addElement(dSSubReport);
                        ++n7;
                    }
                    ((ByteArrayInputStream)closeable).close();
                    dSSubReport = (DSSubReport)this.QOIV.elementAt(0);
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block18;
                    JRLog.error(2, iOException);
                }
            }
        }
        return dSSubReport;
    }

    public boolean hasTemp() {
        return this.bufFile != null;
    }

    public synchronized void finish() {
        this.error = true;
        this.notifyAll();
    }

    public synchronized void cachePage(DSSubReport dSSubReport) {
        block10: {
            if (this.QOIV.size() >= this.cacheSize) {
                if (this.elementAt) {
                    if (this.bufFile == null) {
                        this.QOIV();
                    }
                    try {
                        RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(this.addElement);
                        PJFDataOutput pJFDataOutput = new PJFDataOutput(randomByteArrayOutputStream);
                        int n = 0;
                        while (n < this.cacheSize) {
                            DSSubReport dSSubReport2 = (DSSubReport)this.QOIV.elementAt(n);
                            dSSubReport2.write(pJFDataOutput);
                            dSSubReport2 = null;
                            ++n;
                        }
                        this.out.write(randomByteArrayOutputStream.toByteArray());
                        randomByteArrayOutputStream.close();
                        this.QOIV.removeAllElements();
                        this.addElement = 0;
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break block10;
                        JRLog.error(2, iOException);
                    }
                } else {
                    this.get = dSSubReport.getPageNum();
                    while (this.QOIV.size() >= this.cacheSize) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            if (!JRLog.isError(2)) continue;
                            JRLog.error(2, exception);
                        }
                    }
                }
            }
        }
        this.QOIV.addElement(dSSubReport);
        this.notifyAll();
        int n = dSSubReport.length();
        this.addElement += n;
        this.pageLengthes.addElement(new Integer(n));
    }

    public int size() {
        if (this.elementAt) {
            return this.pageLengthes.size();
        }
        return this.get;
    }

    public void clearMem() {
        block5: {
            if (this.QOIV != null) {
                this.QOIV.clear();
            }
            this.QOIV = null;
            if (this.close != null) {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    this.bufFile.close();
                    this.close.delete();
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block5;
                    JRLog.error(2, iOException);
                }
            }
        }
    }
}

