/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import barcode.linearBarcode.BarcodeConstraints;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import jet.datastream.DSField;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;

public class RenderBarCode
extends Render {
    private BarcodeConstraints QOIV;
    private int WHITE = 0;
    private int Z = 0;
    private int abs = 0;
    private int autoFit = 0;
    private Color calculateCoordinate = null;
    private int calculatePadding = 0;
    private int[] calculateWidth;

    public RenderBarCode(DSField dSField) {
        this.dsField = dSField;
        this.QOIV = new BarcodeConstraints();
        this.resolution = dSField.getResolution();
    }

    public void locate() {
        Render.Box box = new Render.Box(this);
        super.calculatePadding(box);
        this.WHITE();
        this.calculateCoordinate(box);
        if (this.isRotation) {
            this.rotation();
        }
    }

    protected void calculateCoordinate(Render.Box box) {
        int n;
        Dimension dimension = this.QOIV.getPreferredSize();
        if (this.calculatePadding % 180 != 0) {
            n = Unit.convertPixelToUnit(dimension.width, this.resolution);
            int n2 = Unit.convertPixelToUnit(dimension.height, this.resolution);
            int[] nArray = this.QOIV(n, n2, this.calculatePadding);
            this.calculateWidth = nArray;
            this.width = this.abs = nArray[0];
            this.height = this.autoFit = nArray[1];
        } else {
            this.width = this.abs = Unit.convertPixelToUnit(dimension.width, this.resolution);
            this.height = this.autoFit = Unit.convertPixelToUnit(dimension.height, this.resolution);
        }
        if (this.isAutoFit) {
            super.autoFit(box);
        }
        this.x = box.x;
        this.y = box.y;
        this.width = this.width < box.I ? this.width : box.I;
        this.height = this.height < box.Z ? this.height : box.Z;
        this.WHITE = this.abs / 2;
        this.Z = this.autoFit / 2;
        switch (this.layout) {
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                n = box.Z - this.height;
                n = n < 0 ? 0 : n;
                this.y = box.y + n / 2;
                this.Z = box.Z / 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n = box.Z - this.height;
                n = n < 0 ? 0 : n;
                this.y = box.y + n;
                this.Z = box.Z - this.height / 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                this.y = box.y;
                this.Z = this.height / 2;
            }
        }
        switch (this.layout) {
            case 2: 
            case 5: 
            case 8: {
                this.x = box.x + (box.I - this.width) / 2;
                this.WHITE = box.I / 2;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                this.x = box.x + (box.I - this.width);
                this.WHITE = box.I - this.width / 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                this.x = box.x;
                this.WHITE = this.width / 2;
            }
        }
    }

    private int[] QOIV(int n, int n2, int n3) {
        int[] nArray = new int[2];
        double d = (double)n3 * Math.PI / 180.0;
        nArray[0] = (int)Math.abs(Math.cos(d) * (double)n + Math.sin(d) * (double)n2);
        nArray[1] = (int)Math.abs(Math.sin(d) * (double)n + Math.cos(d) * (double)n2);
        return nArray;
    }

    protected void calculateAutoSize() {
    }

    private void WHITE() {
        this.QOIV.setUnit(this.resolution);
        try {
            this.QOIV.calculateWidth();
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        this.getParent().setRender(null);
        this.getParent().getRender();
        this.QOIV.setIsExportToPDF(true);
        graphics.setColor(RenderUtil.getColorPropertyByName(this.dsField, "Foreground"));
        this.QOIV.setForeground(RenderUtil.getColorPropertyByName(this.dsField, "Foreground"));
        Color color = RenderUtil.getColorPropertyByName(this.dsField, "Background");
        if (color == null && this.calculateCoordinate == null) {
            this.Z(this.dsField);
            color = this.calculateCoordinate;
        }
        if (this.calculateCoordinate != null) {
            color = this.calculateCoordinate;
        }
        this.QOIV.setBackground(color);
        Color color2 = RenderUtil.getColorPropertyByName(this.dsField, "PatternColor");
        int n5 = RenderUtil.getIntPropertyByName(this.dsField, "PatternStyle");
        RenderGraphicsToolkit.drawPattern(graphics, new Rectangle(0, 0, this.width, this.height), color2, n5);
        if (super.isPaintCalledByField()) {
            graphics.translate(Unit.convertUnitToPixel(this.WHITE, this.resolution), Unit.convertUnitToPixel(this.Z, this.resolution));
            this.QOIV.paint(graphics);
            graphics.translate(-Unit.convertUnitToPixel(this.WHITE, this.resolution), -Unit.convertUnitToPixel(this.Z, this.resolution));
        } else {
            graphics.translate(Unit.convertUnitToPixel(this.width / 2), Unit.convertUnitToPixel(this.height / 2));
            this.QOIV.paint(graphics);
            graphics.translate(Unit.convertUnitToPixel(-this.width / 2), Unit.convertUnitToPixel(-this.height / 2));
        }
    }

    public Image getImage() {
        if (this.width == 0 || this.height == 0) {
            Render.logger.error("BufferedImage can not be generated for its size is zero.");
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = RenderUtil.getColorPropertyByName(this.dsField, "Background");
        if (color == null && this.calculateCoordinate == null) {
            this.Z(this.dsField);
            color = this.calculateCoordinate;
        }
        if (this.calculateCoordinate != null) {
            color = this.calculateCoordinate;
        }
        graphics2D.setColor(color);
        if (this.calculateWidth == null) {
            graphics2D.fillRect(0, 0, Unit.convertUnitToPixel(this.width, this.resolution), Unit.convertUnitToPixel(this.height, this.resolution));
        } else {
            graphics2D.fillRect(0, 0, Unit.convertUnitToPixel(this.calculateWidth[0], this.resolution), Unit.convertUnitToPixel(this.calculateWidth[1], this.resolution));
        }
        this.paint(graphics2D);
        return bufferedImage;
    }

    public BarcodeConstraints getBarCode() {
        return this.QOIV;
    }

    public int getBarcodeX() {
        return this.WHITE;
    }

    public void setBarcodeX(int n) {
        this.WHITE = n;
    }

    public int getBarcodeY() {
        return this.Z;
    }

    public void setBarcodeY(int n) {
        this.Z = n;
    }

    private void Z(JRObjectResult jRObjectResult) {
        if (this.calculateCoordinate == null) {
            JRObjectResult jRObjectResult2;
            if (jRObjectResult.getParent() != null && jRObjectResult.getParent() instanceof JRObjectResult) {
                jRObjectResult2 = (JRObjectResult)((Object)jRObjectResult.getParent());
                Color color = RenderUtil.getColorPropertyByName(jRObjectResult2, "Background");
                if (color != null) {
                    this.calculateCoordinate = color;
                    return;
                }
            } else {
                this.calculateCoordinate = Color.WHITE;
                return;
            }
            this.Z(jRObjectResult2);
            return;
        }
    }

    public void setOrientation(int n) {
        this.calculatePadding = n;
    }
}

