/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCreator;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderUtil;

public class RenderList
extends Render {
    private Vector DEFAULT_SHADOW_WIDTH;
    private Vector QOIV;
    private Vector black;
    private Vector convertPixelToUnit;
    private boolean convertUnitToPixel;
    private Color drawBorder = Color.white;
    private Color get = Color.black;
    private int getBooleanPropertyByName = -1;
    private DSMultiValueContainer getBounds;

    public RenderList(DSField dSField) {
        this.dsField = dSField;
        this.resolution = dSField.getResolution();
    }

    public RenderList(DSMultiValueContainer dSMultiValueContainer) {
        this.getBounds = dSMultiValueContainer;
        this.resolution = dSMultiValueContainer.getResolution();
    }

    protected void calculateAutoSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.DEFAULT_SHADOW_WIDTH.size()) {
            int n4 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(n3), this.font).getWidth(), this.resolution) + 4;
            int n5 = Unit.convertPixelToUnit((int)RenderGraphicsToolkit.getBounds((String)this.DEFAULT_SHADOW_WIDTH.get(n3), this.font).getHeight(), this.resolution) + 4;
            if (n < n4) {
                n = n4;
            }
            n2 += n5;
            ++n3;
        }
        this.width = n;
        this.height = n2;
    }

    protected void paintConcreteRender(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.getBounds != null) {
            this.get = RenderUtil.getColorPropertyByName(this.getBounds, "Foreground");
            this.drawBorder = RenderUtil.getColorPropertyByName(this.getBounds, "Background");
        }
        this.DEFAULT_SHADOW_WIDTH(graphics);
        RenderGraphicsToolkit.paintList(graphics, this.DEFAULT_SHADOW_WIDTH, this.getBooleanPropertyByName, this.font, n, n2, n3, n4, this.convertUnitToPixel, this.get, this.drawBorder, this.black);
    }

    private void DEFAULT_SHADOW_WIDTH(Graphics graphics) {
        if (this.getBounds == null) {
            return;
        }
        Rectangle rectangle = null;
        int n = this.getBounds.getResolution();
        rectangle = new Rectangle(0, 0, Unit.convertUnitToPixel(this.getBounds.getWidth(), n), Unit.convertUnitToPixel(this.getBounds.getHeight(), n));
        Color color = RenderUtil.getColorPropertyByName(this.getBounds, "Background");
        Color color2 = RenderUtil.getColorPropertyByName(this.getBounds, "BorderColor");
        Color color3 = RenderUtil.getColorPropertyByName(this.getBounds, "ShadowColor");
        int n2 = RenderUtil.getIntPropertyByName(this.getBounds, "LeftLine");
        int n3 = RenderUtil.getIntPropertyByName(this.getBounds, "RightLine");
        int n4 = RenderUtil.getIntPropertyByName(this.getBounds, "TopLine");
        int n5 = RenderUtil.getIntPropertyByName(this.getBounds, "BottomLine");
        int n6 = RenderUtil.getIntPropertyByName(this.getBounds, "BorderWidth");
        int n7 = Unit.convertUnitToPixel(RenderCreator.DEFAULT_SHADOW_WIDTH, n);
        boolean bl = RenderUtil.getBooleanPropertyByName(this.getBounds, "Shadow");
        boolean bl2 = color != null;
        Color color4 = graphics.getColor();
        RenderGraphicsToolkit.drawBorder(graphics, rectangle, bl2 ? color : null, color2, Unit.convertUnitToPixel(n6, n), n4, n5, n2, n3, bl, color3, n7);
        graphics.setColor(color4);
    }

    public boolean isDisabled() {
        return this.convertUnitToPixel;
    }

    public void setDisabled(boolean bl) {
        this.convertUnitToPixel = bl;
    }

    public Vector getTexts() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    public void setTexts(Vector vector) {
        this.DEFAULT_SHADOW_WIDTH = vector;
    }

    public Vector getValues() {
        return this.QOIV;
    }

    public void setValues(Vector vector) {
        this.QOIV = vector;
    }

    public Vector getSelectedValues() {
        return this.convertPixelToUnit;
    }

    public void setSelectedValues(Vector vector) {
        this.convertPixelToUnit = vector;
    }

    public Vector getSelectedText() {
        return this.black;
    }

    public void setSelectedText(Vector vector) {
        this.black = vector;
    }

    public void setIndex(int n) {
        this.getBooleanPropertyByName = n;
    }
}

