/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel;

import java.awt.Color;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.export.util.ImageEncoder;
import jet.udos.JHyperLinkRslt;
import jet.util.JpegEncoder;
import jet.util.MessageDigestMaker;

public class ExcelToolkit {
    private static MessageDigestMaker Compress = new MessageDigestMaker();

    public static int getY(JRVisiableResult jRVisiableResult, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSSection) {
            JRObjectResult jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent());
            if ((jRObjectResult.getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded")) && ((DSSubReport)jRObjectResult).getStartLocation() != 0) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartLocation());
                n2 = n4;
                n3 = n2 > 0 ? n2 : 0;
                return n3;
            }
            return jRVisiableResult.getY() - n;
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        return n3;
    }

    public static long createKey(int n, int n2) {
        long l = n;
        l <<= 32;
        return l += (long)n2;
    }

    public static int getFactor1FromKey(long l) {
        int n = (int)(l >> 32);
        return n;
    }

    public static int getFactor2FromKey(long l) {
        return (int)l;
    }

    public static byte[] encodeImg(Image image) throws IOException {
        ImageEncoder imageEncoder = new ImageEncoder();
        byte[] byArray = imageEncoder.renderImageToPNG(image);
        return byArray;
    }

    public static byte[] encodeImg2(Image image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JpegEncoder jpegEncoder = new JpegEncoder(image, 80, byteArrayOutputStream);
        jpegEncoder.Compress();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String trimSpace(String string) {
        int n = 0;
        while ((n = string.indexOf(32, n)) != -1) {
            int n2 = 1;
            int n3 = n + 1;
            while (n3 < string.length()) {
                if (string.charAt(n3) != ' ') break;
                ++n2;
                ++n3;
            }
            string = string.substring(0, n) + string.substring(n + n2);
        }
        return string;
    }

    public static int calculateColor(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }

    public static int checkIntValue(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public static String getFontFacePropertyNamebyObject(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            return "fontFace";
        }
        return "FontFace";
    }

    public static String getFontSizePropertyNamebyObject(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            return "fontSize";
        }
        return "FontSize";
    }

    public static String getFontBoldPropertyNamebyObject(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            return "fontBold";
        }
        return "Bold";
    }

    public static String getFontItalicPropertyNamebyObject(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult instanceof JHyperLinkRslt) {
            return "fontItalic";
        }
        return "Italic";
    }

    public static void waitImage(Image image) {
        ExportUtil.waitImage(image);
    }

    public static int genImageKey(Image image) {
        int n = Math.abs(Compress.generate(image));
        return n;
    }

    public static int[] getContainerWH(DSContainer dSContainer) {
        int[] nArray = new int[]{5000, 1600};
        return nArray;
    }
}

