/*
 * Decompiled with CFR 0.152.
 */
package jet.export.xml;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.controls.JetColor;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReferences;
import jet.controls.JetString;
import jet.export.xml.FormatOutputCtrl;
import jet.export.xml.LoadXSDException;
import jet.export.xml.OutputFormatInfo;
import jet.export.xml.OutputReport;
import jet.export.xml.XSSerializer;
import jet.export.xml.xs.RefElement;
import jet.export.xml.xs.SchemaSymbols;
import jet.export.xml.xs.XSComplexType;
import jet.export.xml.xs.XSElement;
import jet.export.xml.xs.XSObject;
import jet.export.xml.xs.XSSimpleElement;
import jet.jetc.ReadFailureException;
import jet.naming.ClassType;
import jet.reportLogic.objectInfo.FormattedInfo;
import jet.util.LinkPar;
import jet.xml.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLToFormatInfo
extends FormatOutputCtrl {
    private Document ATT_TYPE = null;
    private OutputFormatInfo DELIM;
    static Hashtable QOIV = new Hashtable();

    public XMLToFormatInfo() {
        QOIV.put("Map", "jet.reportLogic.objectInfo.MapInfo");
        QOIV.put("Area", "jet.reportLogic.objectInfo.AreaInfo");
    }

    public Object loadFrom(String string) throws ReadFailureException, LoadXSDException {
        String string2 = null;
        try {
            this.ATT_TYPE = XMLTools.getDocument(string);
        }
        catch (IOException iOException) {
            string2 = iOException.getMessage();
            throw new ReadFailureException(200074, (Throwable)iOException);
        }
        if (this.ATT_TYPE == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "XMLToInfo\n" + string2 == null ? "Fail to parse XML Document!" : string2);
            }
            throw new LoadXSDException(200084);
        }
        this.D = this.ATT_TYPE("resource/images/XMapInfo.gif");
        if (this.D != null) {
            String string3 = this.D.getNotation();
            this.DELIM = new OutputFormatInfo();
            if (string3 != null) {
                if (!string3.equalsIgnoreCase(FormatOutputCtrl.B)) {
                    throw new LoadXSDException(200015, new String[]{string, string3}, null);
                }
                try {
                    return this.DELIM(this.ATT_TYPE.getDocumentElement());
                }
                catch (Throwable throwable) {
                    throw new ReadFailureException(200101, new String[]{string}, throwable);
                }
            }
            throw new LoadXSDException(200017, new String[]{this.D.getExistFullPath(), string3}, null);
        }
        throw new LoadXSDException(200018, new String[]{string}, null);
    }

    private XSSerializer ATT_TYPE(String string) throws LoadXSDException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        try {
            XSSerializer xSSerializer = XSSerializer.setExistXSInputStream(inputStream, false);
            return xSSerializer;
        }
        catch (IOException iOException) {
            throw new LoadXSDException(200070, (Throwable)iOException);
        }
    }

    private Object DELIM(Element element) throws LoadXSDException, ReadFailureException {
        int n;
        String string = element.getAttribute(SchemaSymbols.ATT_TYPE);
        int n2 = n = string.trim().length() == 0 ? 0 : Integer.parseInt(string);
        if (n == Integer.parseInt("0")) {
            return this.QOIV(element);
        }
        return this.add(element);
    }

    private JetObject QOIV(Element element) throws LoadXSDException, ReadFailureException {
        String string = element.getNodeName();
        XSComplexType xSComplexType = this.D.getComplexType(string);
        JetObject jetObject = (JetObject)this.append(ClassType.getClassNameByClassTag(string));
        jetObject.setEditable();
        this.charAt(jetObject, xSComplexType);
        this.currentThread(jetObject, element);
        XSElement xSElement = this.D.getElement(string);
        Vector vector = xSElement.getRefElements();
        if (vector != null && jetObject instanceof JetContainable) {
            NodeList nodeList = element.getChildNodes();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < vector.size()) {
                hashSet.add(((RefElement)vector.elementAt(n)).getName());
                ++n;
            }
            Node node = null;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                JetObject jetObject2;
                node = nodeList.item(n2);
                String string2 = node.getNodeName();
                if (hashSet.contains(string2) && (jetObject2 = this.QOIV((Element)node)) != null) {
                    ((JetContainable)((Object)jetObject)).add(jetObject2);
                }
                ++n2;
            }
        }
        return jetObject;
    }

    private FormattedInfo add(Element element) throws LoadXSDException, ReadFailureException {
        Object object;
        Object object2;
        Object object3;
        String string = element.getNodeName();
        XSComplexType xSComplexType = this.D.getComplexType(string);
        FormattedInfo formattedInfo = (FormattedInfo)this.append((String)QOIV.get(string));
        Vector vector = xSComplexType.simpleElements;
        int n = 0;
        while (n < vector.size()) {
            object3 = (XSSimpleElement)vector.get(n);
            object2 = ((XSObject)object3).getName();
            String string2 = xSComplexType.getValue((String)object2);
            object = this.endsWith(this.elementAt(element.getChildNodes()), (String)object2);
            if (((Vector)object).size() > 0 && ((Node)((Vector)object).get(0)).getFirstChild() != null) {
                string2 = ((Node)((Vector)object).get(0)).getFirstChild().getNodeValue();
            }
            if ((string2 = this.DELIM.I(string2)).length() > 2 && string2.startsWith(this.D.D) && string2.endsWith(this.D.D)) {
                string2 = string2.substring(1, string2.length() - 1);
                formattedInfo.setXMLProperty((String)object2, string2, true);
            } else {
                formattedInfo.setXMLProperty((String)object2, string2, false);
            }
            ++n;
        }
        object3 = new Vector();
        vector = this.D.getElement(string).getRefElements();
        object2 = new HashSet();
        int n2 = 0;
        while (n2 < vector.size()) {
            ((HashSet)object2).add(((RefElement)vector.get(n2)).getName());
            ++n2;
        }
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Object object4;
            node = nodeList.item(n3);
            object = node.getNodeName();
            if (((HashSet)object2).contains(object) && (object4 = this.DELIM((Element)node)) != null) {
                object3.add(object4);
            }
            ++n3;
        }
        formattedInfo.setXMLChildren((List)object3);
        return formattedInfo;
    }

    private Object append(String string) throws LoadXSDException {
        if (string != null) {
            try {
                return Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new LoadXSDException(200010, new String[]{string}, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new LoadXSDException(200076, new String[]{string}, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LoadXSDException(200077, new String[]{string}, illegalAccessException);
            }
        }
        throw new LoadXSDException(200011, new String[]{string}, null);
    }

    private void charAt(JetObject jetObject, XSComplexType xSComplexType) throws LoadXSDException {
        Hashtable hashtable = jetObject.getProperties();
        Object[] objectArray = XSSerializer.sortPropKey(hashtable, false);
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            String string2 = this.DELIM.getTag(string, true);
            String string3 = xSComplexType.getValue(string2);
            if (string3 != null && string3.length() > 0) {
                string3 = this.DELIM.I(string3);
                JetProperty jetProperty = jetObject.nameToProperty(string);
                if (string3.length() > 2 && string3.startsWith(this.D.D) && string3.endsWith(this.D.D)) {
                    string3 = string3.substring(1, string3.length() - 1);
                    jetProperty.setChangeByObject(string3);
                } else {
                    this.contains(string3, jetProperty);
                }
            }
            ++n;
        }
    }

    private void contains(String string, JetProperty jetProperty) {
        int n = jetProperty.getPropType();
        switch (n) {
            case 4: {
                jetProperty.setUnitValue(String.valueOf(Unit.convertInchToUnit(Double.parseDouble(string))));
                break;
            }
            case 2: {
                if (string.equalsIgnoreCase("Transparent")) break;
                ((JetColor)jetProperty).set(new Color(Integer.parseInt(string.substring(2), 16)));
                break;
            }
            case 10: {
                break;
            }
            case 9: 
            case 12: {
                char c;
                int n2;
                if (OutputReport.I(string.charAt(0)) && (n2 = string.indexOf(c = string.charAt(0), 1)) > -1) {
                    try {
                        int n3 = Integer.parseInt(string.substring(1, n2));
                        if (n3 > 0 && this.convertInchToUnit(string, c) == n3 + 1) {
                            string = string.substring(string.indexOf(c, 1) + 1);
                            string = string.replace(c, "\u0007".charAt(0));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JRLog.trace(6, 6200000, (Throwable)numberFormatException);
                    }
                }
                jetProperty.set(string);
                break;
            }
            case 14: {
                char c;
                int n4;
                if (OutputReport.I(string.charAt(0)) && (n4 = string.indexOf(c = string.charAt(0), 1)) > -1) {
                    try {
                        int n5 = Integer.parseInt(string.substring(1, n4));
                        if (n5 > 0 && this.convertInchToUnit(string, c) == n5 + 1) {
                            string = string.substring(string.indexOf(c, 1) + 1);
                            string = string.replace(c, "\u0007".charAt(0));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JRLog.trace(6, 6200000, (Throwable)numberFormatException);
                    }
                }
                jetProperty.set(string);
            }
            case 3: {
                jetProperty.set(string);
                break;
            }
            case 0: {
                if (jetProperty instanceof JetReferences) {
                    if (string.indexOf(39) > -1) {
                        string = string.replace('\'', "\u0007".charAt(0));
                    }
                    ((JetReferences)jetProperty).set(string);
                }
            }
            case 7: {
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL != null && (uRL.toString().startsWith("file://") || uRL.toString().startsWith("FILE://")) && uRL.getAuthority().indexOf(":") != -1) {
                    string = uRL.getAuthority() + uRL.getFile();
                }
                jetProperty.set(string);
                break;
            }
            case 8: 
            case 13: {
                if (string.indexOf("~@PAR~") != -1) {
                    string = string.replaceAll("~@PAR~", new String(LinkPar.DELIM));
                }
                jetProperty.set(string);
                break;
            }
            default: {
                if (jetProperty instanceof JetString && string.indexOf("~@CR7~") != -1) {
                    string = string.replaceAll("~@CR7~", new String("\u0007"));
                }
                jetProperty.set(string);
            }
        }
    }

    private int convertInchToUnit(String string, char c) {
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n != -1) {
            if ((n = string.indexOf(c, n)) <= -1) break;
            ++n2;
            ++n;
        }
        return n2;
    }

    private void currentThread(JetObject jetObject, Element element) throws ReadFailureException {
        if (jetObject != null) {
            Hashtable hashtable = jetObject.getProperties();
            Object[] objectArray = XSSerializer.sortPropKey(hashtable, false);
            int n = 0;
            while (n < objectArray.length) {
                String string = (String)objectArray[n];
                String string2 = this.DELIM.getTag(string, true);
                boolean bl = false;
                if (string2 != null) {
                    Object object;
                    if (this.DELIM.isAttStartTag(string2)) {
                        string2 = OutputFormatInfo.trimHeader(string2);
                        bl = true;
                    }
                    String string3 = null;
                    if (bl) {
                        object = element.getAttributeNode(string2);
                        if (object != null) {
                            string3 = object.getValue();
                        }
                    } else {
                        object = this.endsWith(this.elementAt(element.getChildNodes()), string2);
                        if (((Vector)object).size() > 0) {
                            string3 = ((Node)((Vector)object).get(0)).getFirstChild() == null ? "" : ((Node)((Vector)object).get(0)).getFirstChild().getNodeValue();
                        }
                    }
                    object = jetObject.nameToProperty(string);
                    if (string3 != null) {
                        if ((string3 = this.DELIM.I(string3)).length() >= 2 && string3.startsWith(this.D.D) && string3.endsWith(this.D.D)) {
                            string3 = string3.substring(1, string3.length() - 1);
                            ((JetProperty)object).setChangeByObject(string3);
                        } else {
                            this.contains(string3, (JetProperty)object);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private Vector elementAt(NodeList nodeList) {
        int n = nodeList.getLength();
        Vector<Node> vector = new Vector<Node>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.add(nodeList.item(n2));
            ++n2;
        }
        return vector;
    }

    private Vector endsWith(Vector vector, String string) {
        Vector<Node> vector2 = new Vector<Node>();
        int n = vector.size() - 1;
        while (n > -1) {
            Node node = (Node)vector.get(n);
            if (node != null) {
                if (string.equalsIgnoreCase("position")) {
                    if (node.getNodeName().equals(string)) {
                        vector2.insertElementAt(node, 0);
                    }
                } else if (node != null && node.getNodeName().equalsIgnoreCase(string)) {
                    vector2.insertElementAt(node, 0);
                }
            }
            --n;
        }
        return vector2;
    }
}

