/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.util.Vector;
import jet.JResource;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.controls.JetColumn;
import jet.controls.JetString;
import jet.exception.FormulaSyntaxErrorException;
import jet.formula.DataTypeDef;
import jet.formula.ExecutableJavaFormula;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.FormulatoJava;
import jet.formula.JavaFormula;
import jet.formula.SqlwNode;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.formula.fArray;
import jet.formula.formula;
import jet.formula.syntaxtree.Symbol;
import jet.log.JRLogger;

public class JetRptFormula
extends JetColumn {
    public static final int NOGUI = -1;
    public static final int DETAIL = 1;
    public static final int BEFORGROUP = 2;
    public static final int AFTERGROUP = 3;
    public JetString name = new JetString(this, "Name");
    public JetString expr = new JetString(this, "Expression");
    public FormulaInfo formulainfo;
    public int GUIinfo = -1;
    public String expectGroup;
    public int pass = -1;
    FormulaContainer I = null;
    String FmlToSql = null;
    boolean Z = false;
    boolean C = false;
    FormulatoJava GroupbyNames;
    DbColDesc B = null;
    public static String executingformula = null;
    public String expectedvalue = null;
    private static JRLogger IsSum = JRLogger.getLogger((class$jet$formula$JetRptFormula == null ? (class$jet$formula$JetRptFormula = JetRptFormula.class$("jet.formula.JetRptFormula")) : class$jet$formula$JetRptFormula).getName());
    protected ExecutableJavaFormula executableJavaFormula;
    static Class class$jet$formula$JetRptFormula;

    public JetRptFormula() {
    }

    public JetRptFormula(String string, String string2, FormulaContainer formulaContainer, FormulaInfo formulaInfo) {
        this(string, string2, formulaContainer);
        this.formulainfo = formulaInfo;
    }

    public JetRptFormula(String string, String string2, FormulaContainer formulaContainer) {
        this.name.set(string);
        this.expr.set(string2);
        this.I = formulaContainer;
    }

    public void setExecutableJavaFormula(ExecutableJavaFormula executableJavaFormula) {
        this.executableJavaFormula = executableJavaFormula;
    }

    public DbValue execConstFML(JavaFormula javaFormula) {
        JavaFormula javaFormula2 = javaFormula;
        if (javaFormula2.isJavaFormulaContainer()) {
            javaFormula2 = this.executableJavaFormula;
        }
        try {
            javaFormula2.setCurrentExecutingFormula(this);
            return javaFormula2.schedule(this.formulainfo.callee);
        }
        catch (ArithmeticException arithmeticException) {
            throw new RuntimeException(JResource.getMessage("FML_36", (Object)this.getName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
        }
    }

    public void exec(JavaFormula javaFormula) {
        DbValue dbValue;
        try {
            dbValue = javaFormula.getRecord().getCell(this.B);
        }
        catch (Exception exception) {
            dbValue = javaFormula.getRecord().getCell(this.name.get().toUpperCase());
            this.B.setColIndex(dbValue.getColDesc().getColIndex());
        }
        try {
            javaFormula.setCurrentExecutingFormula(this);
            DbValue dbValue2 = javaFormula.schedule(this.formulainfo.callee);
            int n = this.formulainfo.formulatype.getDataType();
            if (DataTypeDef.isArray(n)) {
                fArray fArray2 = (fArray)dbValue2;
                ((DbArray)dbValue).setValue(fArray2.getArray(n), fArray2.value.length);
            } else {
                dbValue.set(dbValue2);
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new RuntimeException(JResource.getMessage("FML_36", (Object)this.getName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
        }
        catch (NumberFormatException numberFormatException) {
            throw numberFormatException;
        }
    }

    public DbValue execSpec(JavaFormula javaFormula) {
        DbValue dbValue;
        block5: {
            JavaFormula javaFormula2 = javaFormula;
            if (javaFormula2.isJavaFormulaContainer()) {
                javaFormula2 = this.executableJavaFormula;
            }
            dbValue = null;
            try {
                javaFormula2.setCurrentExecutingFormula(this);
                dbValue = javaFormula2.schedule(this.formulainfo.callee);
            }
            catch (ArithmeticException arithmeticException) {
                throw new RuntimeException(JResource.getMessage("FML_36", (Object)this.getName()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
            }
            catch (NumberFormatException numberFormatException) {
                if (!IsSum.isDebugEnabled()) break block5;
                IsSum.debug(numberFormatException.getMessage(), numberFormatException);
            }
        }
        return dbValue;
    }

    public VarsTable getGVarTable() {
        try {
            return this.I.getGVarTable();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JetRptFormula getFormula(String string) throws Exception {
        return this.I.getFormula(string);
    }

    public String getRealDbFieldName(String string) {
        return this.formulainfo.getRealDbFieldName(string);
    }

    public FormulaInfo getFormulaInfo(FormulatoJava formulatoJava) throws FormulaSyntaxErrorException {
        if (this.formulainfo != null && this.formulainfo.parseOK) {
            return this.formulainfo;
        }
        this.parseFormula(formulatoJava);
        return this.formulainfo;
    }

    public SymbolInfo getParameterInfo(String string) {
        return this.I.getParameterType(string);
    }

    public SymbolInfo getDbFieldInfo(String string) throws Exception {
        DbColDesc dbColDesc = this.I.getDbSQLType(string);
        int n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency());
        if (dbColDesc.isArray()) {
            n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency()) + 11;
        }
        return new SymbolInfo(string, null, n, -1, 2, -1, false);
    }

    public Vector getRefDbFld() {
        return this.formulainfo.refDBfield;
    }

    public Vector getRefFormuFld() {
        return this.formulainfo.refFormula;
    }

    public Vector getRefParamFld() {
        return this.formulainfo.refParameter;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String string) {
        this.name.set(string);
    }

    public String getBrokeGroup() {
        return this.FmlToSql;
    }

    public void setDataSource(FormulaContainer formulaContainer) {
        this.I = formulaContainer;
    }

    public Vector getGroupByVector() {
        return this.formulainfo.GroupbyNames;
    }

    public Vector getFullGroup() {
        return this.formulainfo.GroupbyNames;
    }

    public DbColDesc getColDesc() {
        if (this.B == null) {
            int n = this.formulainfo.formulatype.getDataType();
            int n2 = this.formulainfo.formulatype.getPrecise();
            int n3 = this.formulainfo.formulatype.getScale();
            this.B = DataTypeDef.toDbColDesc(n, n2, n3);
            this.B.setColName(this.getName());
        }
        if (DataTypeDef.isArray(this.formulainfo.formulatype.getDataType())) {
            this.B.sqlType = DataTypeDef.FmlToSql(this.formulainfo.formulatype.getDataType() - 11);
            this.B.setArray(true);
        }
        return this.B;
    }

    public void setColDesc(DbColDesc dbColDesc) {
        this.B = dbColDesc;
        dbColDesc.setColName(dbColDesc.getColName().toUpperCase());
    }

    public void execMe(JavaFormula javaFormula) {
        block3: {
            try {
                javaFormula.setCurrentExecutingFormula(this);
                DbValue dbValue = javaFormula.schedule(this.formulainfo.callee);
                if (!dbValue.toString().equalsIgnoreCase(this.expectedvalue)) {
                    System.out.println("FORMULA " + this.getName() + " ERROR!!!  result=" + dbValue.toString() + "; expected=" + this.expectedvalue);
                }
            }
            catch (Exception exception) {
                if (!IsSum.isErrorEnabled()) break block3;
                IsSum.error("", exception);
            }
        }
    }

    public void parseFormula(FormulatoJava formulatoJava) throws FormulaSyntaxErrorException {
        if (this.Z) {
            return;
        }
        if (this.C) {
            String string = JResource.getMessage("FML_38", (Object)this.getName());
            throw new FormulaSyntaxErrorException(this.getName(), string);
        }
        this.GroupbyNames = formulatoJava;
        try {
            formula formula2 = new formula(this, formulatoJava);
            this.C = true;
            this.formulainfo = formula2.parse();
            this.Z = true;
            this.C = false;
            this.formulainfo.parseOK = this.Z;
            this.GroupbyNames = null;
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            this.Z = false;
            this.C = false;
            this.GroupbyNames = null;
            throw formulaSyntaxErrorException;
        }
    }

    public String getExpression() {
        return this.expr.get();
    }

    public void setExpression(String string) {
        this.expr.set(string);
        this.Z = false;
        this.C = false;
    }

    public String getPrefix() {
        return "formula";
    }

    public boolean isGroupBy(String string) {
        return this.formulainfo.GroupbyNames.contains(string.toUpperCase());
    }

    public boolean isGroupBy() {
        return this.formulainfo.GroupbyNames.size() != 0;
    }

    public boolean isGlobal() {
        return this.formulainfo.isGlobal;
    }

    public String getFullName(boolean bl) {
        return this.name.get();
    }

    public boolean isparsedOK() {
        if (this.formulainfo == null) {
            return false;
        }
        return this.formulainfo.parseOK;
    }

    public void setParseStatus(boolean bl) {
        this.Z = bl;
        this.C = false;
    }

    public boolean isSumFormula() {
        return this.formulainfo.formulatype.IsSum();
    }

    public boolean isConstant() {
        return this.formulainfo.formulatype.getAttr() == 9;
    }

    public void setFormulaInfo(FormulaInfo formulaInfo) {
        this.formulainfo = formulaInfo;
    }

    public SqlwNode getSqlWhere() throws Exception {
        if (this.formulainfo.root == null) {
            throw new Exception("cannot be translated into sql statement");
        }
        return this.formulainfo.root;
    }

    public boolean equals(JetRptFormula jetRptFormula) {
        return this.getName().equals(jetRptFormula.getName());
    }

    public boolean useSysVars() {
        return this.formulainfo.isSysVar();
    }

    public boolean isNextPrev() {
        return this.formulainfo.isNextPrev();
    }

    public boolean usePageVars() {
        return this.formulainfo.isUsePageVar();
    }

    public boolean isNoRecordCalled() {
        return this.formulainfo.isNoRecordCalled();
    }

    public Symbol getSyntaxTree() {
        return this.formulainfo.getSyntaxTree();
    }

    public FormulaContainer getFormulaContainer() {
        return this.I;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

