/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jet.Env;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.ie.PJFAux;
import jet.ie.RSTExporter;
import jet.ie.RSTWriteTool;
import jet.ie.VersionException;
import jet.util.FileUtil;
import jet.util.JFieldValueNLSManager;
import jet.util.TempFile;

public abstract class AbstractRSTExporter
implements RSTExporter {
    public static final byte[] PJF_TAG = PJFAux.PJF_TAG;
    public static final int PJF_VER_NO = 262416;
    public static final long UDTRevNo = 1311768467294899695L;
    public static final int UDTVerNo = 4386;
    public static final String SUF_STRING = ".rst";
    protected String _fileName;
    protected Hashtable _communicators = new Hashtable();
    protected Hashtable _nlsManager = new Hashtable();
    protected String _catalogPath;
    protected Map _mapInfo;
    protected Map _attachInfo;
    protected boolean _isZipRst = false;
    protected RSTWriteTool rstTool = new RSTWriteTool();

    public abstract void setCommunicators(String var1, String var2, Communicator var3) throws VersionException;

    public abstract void setNLSManager(String var1, String var2, JFieldValueNLSManager var3);

    public void setFileName(String string) {
        this._fileName = string.endsWith(SUF_STRING) ? string : string + SUF_STRING;
    }

    public void setReportInfos(Map map) {
        this._mapInfo = map;
    }

    public void setReportAttachInfos(Map map) {
        this._attachInfo = map;
    }

    public void setCatalogPath(String string) {
        this._catalogPath = string;
    }

    public void zipRST(boolean bl) {
        this._isZipRst = bl;
    }

    public void clear() {
        this._communicators.clear();
        this._communicators = null;
        this._nlsManager.clear();
        this._nlsManager = null;
        this._mapInfo.clear();
        this._mapInfo = null;
        this._attachInfo.clear();
        this._attachInfo = null;
    }

    protected void zipFile(String string) throws IOException {
        File file = new TempFile(Env.temporaryPath, "jrst").createTempFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        File file2 = new File(string);
        ZipEntry zipEntry = new ZipEntry(file2.getName());
        long l = file2.length();
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file2);
        l = fileInputStream.read(byArray);
        fileInputStream.close();
        zipEntry.setSize(l);
        zipEntry.setComment(file2.getName());
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, (int)l);
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        fileOutputStream.close();
        file2.delete();
        file2 = new File(string);
        FileUtil.copy(file, file2);
        file.delete();
    }

    public abstract void saveRSTFile() throws VersionException, JRStopEngineException;
}

