/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.ie.AbstractRSTExporter;
import jet.ie.ConvertToJCommunicator;
import jet.ie.RSTBlockWriter;
import jet.ie.RSTWriteTool;
import jet.ie.VersionException;
import jet.ie.io.FileBlockOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.rptengine.JCommunicator;
import jet.security.PageFilter;
import jet.util.JFieldValueNLSManager;
import jet.util.RAFile;

public class RSTSaveControler
extends AbstractRSTExporter {
    public RSTSaveControler(String string) {
        this.setFileName(string);
        this._communicators = new Hashtable();
        this._nlsManager = new Hashtable();
        this._isZipRst = false;
    }

    public RSTSaveControler() {
        this._communicators = new Hashtable();
        this._nlsManager = new Hashtable();
        this._isZipRst = false;
    }

    public void saveRSTFile() throws VersionException, JRStopEngineException {
        try {
            File file;
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4407001);
                JRLog.trace(4, 4407002, this._fileName);
                JRLog.trace(4, 4407003, new Integer(262416));
            }
            if ((file = new File(this._fileName)).exists()) {
                file.delete();
            }
            RAFile rAFile = new RAFile(file, "rw");
            PJFDataOutput pJFDataOutput = new PJFDataOutput(new FileBlockOutputStream(rAFile));
            pJFDataOutput.write(AbstractRSTExporter.PJF_TAG);
            this.PJF_TAG(pJFDataOutput);
            if (this._mapInfo == null) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407001);
                }
                throw new VersionException(407001);
            }
            RSTWriteTool.writeMapInfo(this._mapInfo, pJFDataOutput);
            if (this._attachInfo == null) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2407001);
                }
                throw new VersionException(407001);
            }
            RSTWriteTool.writeMapInfo(this._attachInfo, pJFDataOutput);
            this.QOIV(pJFDataOutput);
            RSTWriteTool.writeNLSManagers(pJFDataOutput, this._nlsManager);
            rAFile.close();
            pJFDataOutput.close();
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4407004);
            }
        }
        catch (Throwable throwable) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407002);
            }
            throw new VersionException(407002, throwable);
        }
    }

    private void PJF_TAG(PJFDataOutput pJFDataOutput) throws IOException {
        pJFDataOutput.writeInt(262416);
        pJFDataOutput.writeLong(1311768467294899695L);
        pJFDataOutput.writeInt(4386);
        pJFDataOutput.writeBoolean(this._isZipRst);
    }

    private void QOIV(PJFDataOutput pJFDataOutput) throws VersionException, JRStopEngineException {
        try {
            long l = pJFDataOutput.getPosition();
            pJFDataOutput.writeLong(0L);
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>(this._communicators.size());
            Enumeration enumeration = this._communicators.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JCommunicator jCommunicator = (JCommunicator)this._communicators.get(string);
                hashtable.put(string, new Long(pJFDataOutput.getPosition()));
                this.Z(jCommunicator, pJFDataOutput);
            }
            long l2 = pJFDataOutput.getPosition();
            pJFDataOutput.writeInt(hashtable.size());
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                long l3 = (Long)hashtable.get(string);
                pJFDataOutput.writeUTF(string);
                pJFDataOutput.writeLong(l3);
            }
            long l4 = pJFDataOutput.getPosition();
            pJFDataOutput.seek(l);
            pJFDataOutput.writeLong(l2);
            pJFDataOutput.seek(l4);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407004);
            }
            throw new VersionException(407004, (Throwable)iOException);
        }
    }

    private void Z(JCommunicator jCommunicator, PJFDataOutput pJFDataOutput) throws VersionException, JRStopEngineException {
        try {
            RSTBlockWriter rSTBlockWriter = new RSTBlockWriter(jCommunicator, this._isZipRst);
            rSTBlockWriter.setCatalogPath(this._catalogPath);
            long l = pJFDataOutput.getPosition();
            pJFDataOutput.writeLong(0L);
            rSTBlockWriter.write(pJFDataOutput);
            long l2 = pJFDataOutput.getPosition();
            long l3 = l2 - l - 4L;
            pJFDataOutput.seek(l);
            pJFDataOutput.writeLong(l3);
            pJFDataOutput.seek(l2);
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2407004);
            }
            throw new VersionException(407004, (Throwable)iOException);
        }
    }

    public void setCommunicators(String string, String string2, Communicator communicator) throws VersionException {
        String string3 = string.length() + string + string2.length() + string2;
        if (communicator instanceof PageFilter) {
            this._communicators.put(string3, new ConvertToJCommunicator((PageFilter)communicator));
        } else {
            this._communicators.put(string3, communicator);
        }
    }

    public void setNLSManager(String string, String string2, JFieldValueNLSManager jFieldValueNLSManager) {
        if (jFieldValueNLSManager != null) {
            String string3 = string.length() + string + string2.length() + string2;
            this._nlsManager.put(string3, jFieldValueNLSManager);
        }
    }
}

