/*
 * Decompiled with CFR 0.152.
 */
package jet.ie.io;

import java.io.IOException;
import java.io.InputStream;
import jet.util.RandomInputable;

public class FileBlockInputStream
extends InputStream {
    private RandomInputable QOIV;
    int available = 0;
    int read = 0;

    public FileBlockInputStream(RandomInputable randomInputable) {
        this.QOIV = randomInputable;
    }

    public void reset(long l, int n) throws IOException {
        this.available = n;
        this.QOIV.seek(l);
        this.read = 0;
    }

    public void reset(int n) throws IOException {
        this.available = n;
        this.read = 0;
    }

    public int read() throws IOException {
        if (this.read >= this.available) {
            throw new IOException("End of Stream");
        }
        int n = this.QOIV.read();
        ++this.read;
        return n;
    }

    public int available() throws IOException {
        return this.available - this.read;
    }

    public long skip(long l) throws IOException {
        int n = this.available();
        if (n == 0) {
            throw new IOException("End of Stream");
        }
        l = l < (long)n ? l : (long)n;
        this.read = (int)((long)this.read + l);
        return this.QOIV.skipBytes((int)l);
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.available();
        int n2 = byArray.length;
        if (n == 0) {
            throw new IOException("End of Stream");
        }
        n2 = n2 < n ? n2 : n;
        this.read += n2;
        return this.QOIV.read(byArray, 0, n2);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.available();
        if (n3 == 0) {
            throw new IOException("End of Stream");
        }
        n2 = n2 < n3 ? n2 : n3;
        this.read += n2;
        return this.QOIV.read(byArray, 0, n2);
    }
}

