/*
 * Decompiled with CFR 0.152.
 */
package jet.net2.www.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.net2.Authenticator;
import jet.net2.ConnectionListener;
import jet.net2.PasswordAuthentication;
import jet.net2.ProgressData;
import jet.net2.ProgressEntry;
import jet.net2.URL;
import jet.net2.www.HeaderParser;
import jet.net2.www.MessageHeader;
import jet.net2.www.http.CookiePool;
import jet.net2.www.http.HttpClient;
import jet.net2.www.protocol.http.AuthenticationInfo;
import jet.net2.www.protocol.http.BasicAuthentication;
import jet.net2.www.protocol.http.DigestAuthentication;
import jet.net2.www.protocol.http.EmptyInputStream;
import jet.net2.www.protocol.http.Handler;
import jet.net2.www.protocol.http.HttpAuthenticator;

public class HttpURLConnection
extends java.net.HttpURLConnection
implements ConnectionListener {
    public static final String userAgent = "JRClient-NET/1.1";
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps = null;
    private static HttpAuthenticator I;
    private MessageHeader New = new MessageHeader();
    protected ProgressEntry pe;
    private MessageHeader QOIV = new MessageHeader();
    private InputStream add = null;
    private ByteArrayOutputStream addConnectionListener = null;
    private boolean addElement = false;
    private boolean append = false;
    private boolean authString = true;
    private static Vector authorized;
    private static Vector charAt;

    private static PasswordAuthentication I(InetAddress inetAddress, int n, String string, String string2, String string3, URLConnection uRLConnection) {
        return Authenticator.requestPasswordAuthentication(inetAddress, n, string, string2, string3, uRLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void New() throws IOException {
        if (!this.addElement) {
            Object object;
            long l;
            AuthenticationInfo authenticationInfo;
            this.New.prepend(this.method + " " + this.http.getURLFile() + " " + "HTTP/1.0", null);
            this.New.setIfNotSet("User-Agent", userAgent);
            int n = this.url.getPort();
            String string = this.url.getHost();
            if (n != -1 && n != 80) {
                string = string + ":" + String.valueOf(n);
            }
            this.New.setIfNotSet("Host", string);
            this.New.setIfNotSet("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
            if (!this.append && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.New.set("Proxy-Connection", "Keep-Alive");
                } else if (!this.append && !this.http.usingProxy) {
                    this.New.set("Connection", "Keep-Alive");
                }
            } else if (this.append || !this.http.getHttpKeepAliveSet()) {
                this.New.set("Connection", "Close");
            }
            if (this.http.usingProxy && (authenticationInfo = AuthenticationInfo.I(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && authenticationInfo.supportsPreemptiveAuthorization()) {
                this.New.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue());
            }
            if ((l = this.getIfModifiedSince()) != 0L) {
                object = new Date(l);
                this.New.setIfNotSet("If-Modified-Since", ((Date)object).toGMTString());
            }
            if ((object = AuthenticationInfo.I(this.url)) != null && ((AuthenticationInfo)object).supportsPreemptiveAuthorization()) {
                this.New.setIfNotSet(((AuthenticationInfo)object).getHeaderName(), ((AuthenticationInfo)object).getHeaderValue());
            }
            if (this.addConnectionListener != null) {
                ByteArrayOutputStream byteArrayOutputStream = this.addConnectionListener;
                synchronized (byteArrayOutputStream) {
                    if (!this.method.equals("PUT")) {
                        String string2 = "application/x-www-form-urlencoded";
                        this.New.setIfNotSet("Content-type", string2);
                    }
                    this.New.set("Content-length", String.valueOf(this.addConnectionListener.size()));
                }
            }
            this.addElement = true;
        }
        if (URL.isCookieEnabled()) {
            String string;
            String string3 = this.url.getFile();
            int n = string3.indexOf(63);
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
            if ((n = string3.indexOf(35)) >= 0) {
                string3 = string3.substring(0, n);
            }
            if (string3.length() == 0) {
                string3 = "/";
            }
            if ((string = CookiePool.getCookie(this.url.getHost(), this.url.getPort(), string3)) != null) {
                this.New.setIfNotSet("Cookie", string);
                try {
                    int n2 = authorized.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        ConnectionListener connectionListener = (ConnectionListener)authorized.elementAt(n3);
                        if (connectionListener.isUnauthorized(this)) {
                            this.New.set("Cookie", string);
                        }
                        ++n3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.http.writeRequests(this.New);
        if (this.addConnectionListener != null) {
            this.addConnectionListener.writeTo(this.ps);
            this.ps.flush();
        }
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.append) {
                throw new IOException("Error writing to server");
            }
            this.append = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.QOIV = new MessageHeader();
            this.New = new MessageHeader();
            this.addElement = false;
            this.New();
        }
    }

    protected HttpClient getNewClient(java.net.URL uRL) throws IOException {
        return new HttpClient(uRL, null, -1);
    }

    protected HttpClient getProxiedClient(java.net.URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n);
    }

    protected HttpURLConnection(java.net.URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.handler = handler;
    }

    public HttpURLConnection(java.net.URL uRL, String string, int n) throws IOException {
        this(uRL, new Handler(string, n));
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        I = httpAuthenticator;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 305 || n2 == 304) continue;
            java.net.URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            java.net.URL uRL2 = null;
            if (string != null) {
                uRL2 = new java.net.URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !HttpURLConnection.QOIV(uRL, uRL2) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return inputStream;
    }

    private static boolean QOIV(java.net.URL uRL, java.net.URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        boolean[] blArray = new boolean[]{false};
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            blArray[0] = inetAddress.equals(inetAddress2);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return blArray[0];
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = ("http".equals(this.url.getProtocol()) || "https".equals(this.url.getProtocol())) && !this.append ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && ("http".equals(this.url.getProtocol()) || "https".equals(this.url.getProtocol()))) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.add != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.addConnectionListener == null) {
                this.addConnectionListener = new ByteArrayOutputStream();
            }
            return this.addConnectionListener;
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.add != null) {
            return this.add;
        }
        int n = 0;
        AuthenticationInfo authenticationInfo = null;
        AuthenticationInfo authenticationInfo2 = null;
        Object var4_4 = null;
        HttpURLConnection.addConnectionListener(this);
        try {
            do {
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.New();
                this.http.parseHTTP(this.QOIV, this.pe);
                this.add = this.http.getInputStream();
                int n2 = this.getResponseCode();
                if (n2 == 407 && n < 5) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.Z();
                    }
                    if ((authenticationInfo2 = this.add()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 401 && n < 5) {
                    this.authString();
                    if (authenticationInfo != null) {
                        authenticationInfo.Z();
                    }
                    if ((authenticationInfo = this.addConnectionListener()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                this.authorized();
                if (n2 == 200 || n2 >= 300 && n2 <= 305) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.I();
                    }
                    if (authenticationInfo != null) {
                        authenticationInfo.I();
                    }
                } else if (n >= 5) {
                    throw new ProtocolException("Server redirected too many times (" + n + ")");
                }
                if (this.addElement()) {
                    ++n;
                    continue;
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                    this.disconnect();
                    this.add = new EmptyInputStream();
                    return this.add;
                }
                String string = this.url.getFile();
                if (!(n2 < 400 || string == null || string.endsWith(".html") || string.endsWith(".htm") || string.endsWith("/") || string.endsWith(".txt"))) {
                    throw new FileNotFoundException(this.url.toString() + "\n" + this.append());
                }
                HttpURLConnection.removeConnectionListener(this);
                return this.add;
            } while (n <= 5);
            throw new ProtocolException("Server redirected too many times (" + n + ")");
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    private AuthenticationInfo add() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("Proxy-authenticate");
        String string2 = this.http.getProxyHostUsed();
        int n = this.http.getProxyPortUsed();
        if (string2 != null && string != null) {
            Object object;
            Serializable serializable;
            HeaderParser headerParser = new HeaderParser(string);
            String string3 = headerParser.findValue("realm");
            String string4 = headerParser.findKey(0);
            authenticationInfo = AuthenticationInfo.I(string2, n, string3);
            if (authenticationInfo == null && "basic".equalsIgnoreCase(string4)) {
                serializable = null;
                try {
                    serializable = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                object = HttpURLConnection.I(serializable, n, "http", string3, string4, this);
                if (object != null) {
                    authenticationInfo = new BasicAuthentication(true, string2, n, string3, (PasswordAuthentication)object);
                }
            }
            if (authenticationInfo == null && I != null && I.schemeSupported(string4)) {
                try {
                    serializable = new java.net.URL("http", string2, n, "/");
                    object = I.authString((java.net.URL)serializable, string4, string3);
                    if (object != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n, string3, (String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (authenticationInfo != null && !authenticationInfo.I(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo addConnectionListener() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("WWW-Authenticate");
        if (string != null) {
            Object object;
            HeaderParser headerParser = new HeaderParser(string);
            String string2 = headerParser.findValue("realm");
            String string3 = headerParser.findKey(0);
            authenticationInfo = AuthenticationInfo.I(this.url, string2);
            InetAddress inetAddress = null;
            if (authenticationInfo == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (authenticationInfo == null && "basic".equalsIgnoreCase(string3) && (object = HttpURLConnection.I(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3, this)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && "digest".equalsIgnoreCase(string3) && (object = HttpURLConnection.I(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3, this)) != null) {
                authenticationInfo = new DigestAuthentication(this.url, string2, string3, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && I != null && I.schemeSupported(string3) && (object = I.authString(this.url, string3, string2)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (String)object);
            }
            if (authenticationInfo != null && !authenticationInfo.I(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private boolean addElement() throws IOException {
        if (!this.authString) {
            return false;
        }
        if (!java.net.HttpURLConnection.getFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 305 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        this.disconnect();
        this.QOIV = new MessageHeader();
        if (n == 305) {
            java.net.URL uRL = new java.net.URL(string);
            this.http = this.getProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.New.set(0, this.method + " " + this.http.getURLFile() + " " + "HTTP/1.0", null);
            this.connected = true;
        } else {
            this.url = new java.net.URL(this.url, string);
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.New = new MessageHeader();
                this.addElement = false;
                this.setRequestMethod("GET");
                this.addConnectionListener = null;
                this.connect();
            } else {
                this.connect();
                this.New.set(0, this.method + " " + this.http.getURLFile() + " " + "HTTP/1.0", null);
                this.New.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.QOIV.findValue(string);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.QOIV.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.QOIV.getKey(n);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if ("set-cookie".equalsIgnoreCase(string)) {
            this.New.add(string, string2);
        } else {
            this.New.set(string, string2);
        }
    }

    void I(String string, String string2) {
        this.New.set(string, string2);
    }

    public String getRequestProperty(String string) {
        return this.New.findValue(string);
    }

    public void finalize() {
    }

    String I() {
        return this.method;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.authString = bl;
    }

    public HttpClient getClient() {
        return this.http;
    }

    private String append() {
        try {
            int n;
            String string = "Error from server:" + this.getResponseCode() + ":" + this.getResponseMessage();
            String string2 = this.getHeaderField("JRS-MESSAGE");
            if (string2 != null) {
                string = string + ", extra information: " + CSUtil.convertEscapes(string2);
            }
            if ((n = this.getContentLength()) > 0) {
                byte[] byArray = new byte[n];
                DataInputStream dataInputStream = new DataInputStream(this.getInputStream());
                dataInputStream.readFully(byArray, 0, n);
                return string + "\n" + new String(byArray);
            }
            return string;
        }
        catch (IOException iOException) {
            return "No detailed information since error information cannot be parsed";
        }
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        this.getInputStream();
        String string = this.getHeaderField(0);
        try {
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            this.responseCode = Integer.parseInt(string.substring(n, n + 3));
            this.responseMessage = string.substring(n + 4).trim();
            return this.responseCode;
        }
        catch (Exception exception) {
            return this.responseCode;
        }
    }

    public void removeAuthInfoFromCache(String string) {
        AuthenticationInfo authenticationInfo = AuthenticationInfo.I(this.url, string);
        authenticationInfo = string != null ? AuthenticationInfo.I(this.url, string) : AuthenticationInfo.I(this.url);
        if (authenticationInfo != null) {
            authenticationInfo.Z();
        }
    }

    private void authString() {
        try {
            int n = authorized.size();
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener connectionListener = (ConnectionListener)authorized.elementAt(n2);
                connectionListener.unauthorized(this);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void authorized() {
        try {
            int n = authorized.size();
            int n2 = 0;
            while (n2 < n) {
                ConnectionListener connectionListener = (ConnectionListener)authorized.elementAt(n2);
                connectionListener.authorized(this);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void unauthorized(URLConnection uRLConnection) {
        if (uRLConnection != null && !charAt.contains(uRLConnection)) {
            charAt.addElement(uRLConnection);
        }
    }

    public void authorized(URLConnection uRLConnection) {
        if (uRLConnection != null && !charAt.contains(uRLConnection)) {
            charAt.removeElement(uRLConnection);
        }
    }

    public boolean isUnauthorized(URLConnection uRLConnection) {
        if (uRLConnection != null) {
            return charAt.contains(uRLConnection);
        }
        return false;
    }

    public static void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener != null && !authorized.contains(connectionListener)) {
            authorized.addElement(connectionListener);
        }
    }

    public static void removeConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener != null) {
            authorized.removeElement(connectionListener);
        }
    }

    static {
        authorized = new Vector(8);
        charAt = new Vector();
    }
}

