/*
 * Decompiled with CFR 0.152.
 */
package jet.report;

import guitools.toolkit.JDebug;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetAttachable;
import jet.controls.JetColor;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetUnitNumber;
import jet.exception.UserException;
import jet.report.JRObjectTemplate;
import jet.report.JetRptBox;
import jet.report.JetRptLineWidth;
import jet.report.JetRptReportPanel;

public abstract class JetRptRectangle
extends JetRptBox
implements JetContainable {
    public JetRptLineWidth topBorderWidth;
    public JetRptLineWidth bottomBorderWidth;
    public JetRptLineWidth leftBorderWidth;
    public JetRptLineWidth rightBorderWidth;
    public JetColor topBorderColor;
    public JetColor bottomBorderColor;
    public JetColor leftBorderColor;
    public JetColor rightBorderColor;
    public JetUnitNumber topMargin;
    public JetUnitNumber bottomMargin;
    public JetUnitNumber leftMargin;
    public JetUnitNumber rightMargin;
    public JetEnumeration alignment;
    private Vector WARNING = new Vector();
    private Vector beforeRemoved = new Vector();
    private static HashMap getParent = null;

    public JetRptRectangle() {
        this.WARNING();
        this.add();
    }

    public Vector getChildren() {
        return this.WARNING;
    }

    public Vector getJetGuidelines() {
        return this.beforeRemoved;
    }

    public void beforeRemoved() {
        int n = this.WARNING.size();
        int n2 = 0;
        while (n2 < n) {
            JetObject jetObject = (JetObject)this.WARNING.elementAt(n2);
            jetObject.beforeRemoved();
            ++n2;
        }
        super.beforeRemoved();
    }

    public JetObject remove(JetObject jetObject) {
        jetObject.beforeRemoved();
        jetObject.setParent(null);
        if (jetObject instanceof JetAttachable) {
            JetAttachable jetAttachable = (JetAttachable)((Object)jetObject);
            this.beforeRemoved.removeElement(jetAttachable);
            jetAttachable.setRefObj(null);
        } else {
            JetRptReportPanel jetRptReportPanel;
            this.WARNING.removeElement(jetObject);
            if (jetObject instanceof JRObjectTemplate && (jetRptReportPanel = JetRptReportPanel.getReportPanel(this)) != null) {
                try {
                    jetRptReportPanel.setLevel(1);
                }
                catch (UserException userException) {
                    JDebug.WARNING(userException);
                }
            }
        }
        return jetObject;
    }

    public JetObject add(JetObject jetObject) {
        JetContainable jetContainable = jetObject.getParent();
        if (jetContainable != null) {
            jetContainable.remove(jetObject);
        }
        jetObject.setParent(this);
        if (jetObject instanceof JetAttachable) {
            JetAttachable jetAttachable = (JetAttachable)((Object)jetObject);
            jetAttachable.setRefObj(this);
            this.beforeRemoved.addElement(jetAttachable);
        } else {
            if (jetObject instanceof JRObjectTemplate && this.isAfterInit()) {
                JetRptReportPanel jetRptReportPanel = JetRptReportPanel.getReportPanel(this);
                try {
                    jetRptReportPanel.setLevel(1);
                }
                catch (UserException userException) {
                    JDebug.WARNING(userException);
                }
            }
            this.WARNING.addElement(jetObject);
        }
        return jetObject;
    }

    public JetObject add(JetObject jetObject, int n) {
        jetObject = this.add(jetObject);
        int n2 = this.WARNING.size();
        if (n >= 0 && n != n2) {
            this.WARNING.removeElementAt(n2 - 1);
            this.WARNING.insertElementAt(jetObject, n);
        }
        return jetObject;
    }

    public void broadcast(JetObject jetObject, int n) {
    }

    private void WARNING() {
        this.topBorderWidth = new JetRptLineWidth(this, "border-top-width", 0);
        this.bottomBorderWidth = new JetRptLineWidth(this, "border-bottom-width", 0);
        this.leftBorderWidth = new JetRptLineWidth(this, "border-left-width", 0);
        this.rightBorderWidth = new JetRptLineWidth(this, "border-right-width", 0);
        this.topBorderColor = new JetColor(this, "border-top-color", Color.black);
        this.bottomBorderColor = new JetColor(this, "border-bottom-color", Color.black);
        this.leftBorderColor = new JetColor(this, "border-left-color", Color.black);
        this.rightBorderColor = new JetColor(this, "border-right-color", Color.black);
        this.topMargin = new JetUnitNumber(this, "margin-top");
        this.bottomMargin = new JetUnitNumber(this, "margin-bottom");
        this.leftMargin = new JetUnitNumber(this, "margin-left");
        this.rightMargin = new JetUnitNumber(this, "margin-right");
        this.alignment = new JetEnumeration(this, "Alignment", 0);
        this.alignment.set(new Integer(5));
    }

    private void add() {
        this.borderWidth.set(0);
    }

    public HashMap getIndecialMap() {
        if (getParent != null) {
            return getParent;
        }
        getParent = new HashMap();
        HashMap hashMap = super.getIndecialMap();
        getParent.putAll(hashMap);
        int n = hashMap.size();
        getParent.put("border-top-width", new Integer(n++));
        getParent.put("border-bottom-width", new Integer(n++));
        getParent.put("border-left-width", new Integer(n++));
        getParent.put("border-right-width", new Integer(n++));
        getParent.put("border-top-color", new Integer(n++));
        getParent.put("border-bottom-color", new Integer(n++));
        getParent.put("border-left-color", new Integer(n++));
        getParent.put("border-right-color", new Integer(n++));
        getParent.put("margin-top", new Integer(n++));
        getParent.put("margin-bottom", new Integer(n++));
        getParent.put("margin-left", new Integer(n++));
        getParent.put("margin-right", new Integer(n++));
        getParent.put("Alignment", new Integer(n++));
        return getParent;
    }
}

