/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.ChartDefinition;
import chart.ChartRenderInfo;
import chart.chart3d.ChartMatrix;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartCoordinatePaperProperties;
import chart.properties.ChartGraphProperties;
import chart.properties.ChartNumericAxisProperties;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetDoubleNumber;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.datastream.JetChartPropertyValues;
import jet.report.JRObjectTemplate;
import jet.report.chart.JetChartBackground;
import jet.report.chart.JetChartCategoryAxisProperties;
import jet.report.chart.JetChartNumericAxisProperties;
import jet.report.chart.JetChartPenStyle;
import jet.report.chart.JetChartTextStyle;
import jet.report.chart.JetChartWallProperties;
import jet.report.chart.JetRptChartComponent;
import jet.report.chart.JetRptChartPlatform;
import jet.reportset.JetRptReport;
import jet.util.HashVector;

public class JetRptChartPaper
extends JetRptChartComponent {
    public static final int WIDTH_DEF = 375;
    public static final int HEIGHT_DEF = 285;
    public static final int X_DEF = 10;
    public static final int Y_DEF = 30;
    private ChartDefinition ARROW_STYLE_INTEGERS;
    public JetUnitNumber topMargin;
    public JetUnitNumber leftMargin;
    public JetUnitNumber rightMargin;
    public JetUnitNumber bottomMargin;
    public JetChartBackground background;
    public JetNumber scaleX;
    public JetNumber scaleY;
    public JetNumber scaleZ;
    public JetNumber angleX;
    public JetNumber angleY;
    public JetNumber angleZ;
    public JetVector rotationMatrix;
    public JetEnumeration graphPosition;
    public JetBoolean reversePaintingOrder;
    public JetBoolean interactive;
    public JetNumber perspective;
    public JetString valueLabelPositionList;
    public JetChartTextStyle hintTextStyle;
    public JetBoolean showTips;
    public JetBoolean shadowContents;
    public JetBoolean showWall;
    public JetChartWallProperties wallProperties;
    public JetBoolean showFloor;
    public JetChartWallProperties floorProperties;
    public JetBoolean showAxisX;
    public JetChartNumericAxisProperties axisX;
    public JetBoolean showAxisY;
    public JetChartNumericAxisProperties axisY;
    public JetBoolean showAxisY2;
    public JetChartNumericAxisProperties axisY2;
    public JetBoolean showAxisZ;
    public JetChartCategoryAxisProperties axisZ;
    public JetBoolean contour;
    public JetChartPenStyle contourPen;
    public JetBoolean useDropline;
    public JetNumber barWidth;
    public JetUnitNumber barDepth;
    public JetBoolean useDepth;
    public JetNumber barDepthDirection;
    public JetBoolean varyColorByValues;
    public JetNumber barGap;
    public JetUnitNumber lineThickness;
    public JetEnumeration lineNodeStyle;
    public JetUnitNumber lineNodeWidth;
    public JetUnitNumber lineNodeHeight;
    public JetBoolean radarIsFill;
    public JetNumber radarFillTransparence;
    public JetBoolean radarIsShowColumnName;
    public JetEnumeration radarArrowStyle;
    public JetColor stockUpBarColor;
    public JetColor stockDownBarColor;
    public JetColor stockLineColor;
    public JetDoubleNumber gaugeNormalValueMin;
    public JetDoubleNumber gaugeNormalValueMax;
    public JetDoubleNumber gaugeAlertValueMin;
    public JetDoubleNumber gaugeAlertValueMax;
    public JetDoubleNumber gaugeErrorValueMin;
    public JetDoubleNumber gaugeErrorValueMax;
    public JetColor gaugeNormalColor;
    public JetColor gaugeAlertColor;
    public JetColor gaugeErrorColor;
    public JetNumber gaugeDialStartAngle;
    public JetNumber gaugeDialStopAngle;
    public JetEnumeration gaugeDialLineStyle;
    public JetEnumeration gaugeDialLineArrowStyle;
    public JetBoolean gaugeDialCurveIsFill;
    public JetUnitNumber gaugeDialOuterInnerGap;
    public JetEnumeration gaugeDialCurveStyle;
    public JetDoubleNumber radiusRange;
    public JetUnitNumber horizonMargin;
    public JetUnitNumber verticalMargin;
    public JetChartPenStyle gaugeBarPen;
    public JetEnumeration gaugeBarLayout;
    public JetBoolean showThresholdLine;
    public JetDoubleNumber thresholdValue;
    public JetColor thresholdLineColor;
    public JetBoolean fillThreshold;
    public JetBoolean showThresholdLine2;
    public JetDoubleNumber thresholdValue2;
    public JetColor thresholdLineColor2;
    public JetBoolean fillThreshold2;
    public JetEnumeration thresholdLineStyle;
    public JetDoubleNumber fillTransparent;
    public JetBoolean showMeanLine;
    public JetColor meanLineColor;
    public JetEnumeration meanLineNodeStyle;
    public JetEnumeration meanLineType;
    public JetUnitNumber pieExplodeDistance;
    public JetUnitNumber spiGap;
    public JetEnumeration valueLabelType;
    public JetBoolean suppressZeroLabel;
    public JetBoolean showPieName;
    public JetBoolean use3DEffect;
    public JetBoolean rotate;
    public JetBoolean showCategoryAndSeries;
    public JetVector areaPatternList;
    private static final HashMap CHART_PATTERN_LIST_EDITOR = new HashMap(590);
    private static final HashVector GAUGE_BAR_LAYOUT_INTEGERS;

    private void ARROW_STYLE_INTEGERS() {
        this.topMargin = new JetUnitNumber(this, "TopMargin", JRObjectTemplate.convertSize(10));
        this.leftMargin = new JetUnitNumber(this, "LeftMargin", JRObjectTemplate.convertSize(10));
        this.rightMargin = new JetUnitNumber(this, "RightMargin", JRObjectTemplate.convertSize(10));
        this.bottomMargin = new JetUnitNumber(this, "BottomMargin", JRObjectTemplate.convertSize(10));
        this.background = new JetChartBackground(this, "Paper");
        this.scaleX = new JetNumber(this, "ScaleX", 100);
        this.scaleY = new JetNumber(this, "ScaleY", 100);
        this.scaleZ = new JetNumber(this, "ScaleZ", 100);
        this.angleX = new JetNumber(this, "AngleX", 0);
        this.angleY = new JetNumber(this, "AngleY", 0);
        this.angleZ = new JetNumber(this, "AngleZ", 0);
        this.rotationMatrix = new JetVector(this, "RotationMatrix");
        this.graphPosition = new JetEnumeration(this, "GraphPosition", 15);
        this.reversePaintingOrder = new JetBoolean(this, "ReversePaintingOrder", false);
        this.interactive = new JetBoolean(this, "Interactive", true);
        this.perspective = new JetNumber(this, "Perspective", -1);
        this.valueLabelPositionList = new JetString(this, "ValueLabelPositionList");
        this.hintTextStyle = new JetChartTextStyle(this, "Hint");
        this.showTips = new JetBoolean(this, "ShowTips", true);
        this.showCategoryAndSeries = new JetBoolean(this, "ShowCategoryAndSeries", false);
        this.shadowContents = new JetBoolean(this, "ShadowContents", false);
        this.showWall = new JetBoolean(this, "ShowWall", true);
        this.wallProperties = new JetChartWallProperties(this, "Wall");
        this.showFloor = new JetBoolean(this, "ShowFloor", true);
        this.floorProperties = new JetChartWallProperties(this, "Floor");
        this.showAxisX = new JetBoolean(this, "ShowAxisX", true);
        this.axisX = new JetChartNumericAxisProperties(this, "X");
        this.showAxisY = new JetBoolean(this, "ShowAxisY", true);
        this.axisY = new JetChartNumericAxisProperties(this, "Y");
        this.showAxisY2 = new JetBoolean(this, "ShowAxisY2", true);
        this.axisY2 = new JetChartNumericAxisProperties(this, "Y2");
        this.showAxisZ = new JetBoolean(this, "ShowAxisZ", true);
        this.axisZ = new JetChartCategoryAxisProperties(this, "Z");
        this.contour = new JetBoolean(this, "Contour", false);
        this.contourPen = new JetChartPenStyle(this, "Contour");
        this.useDropline = new JetBoolean(this, "UseDropline", false);
        this.barWidth = new JetNumber(this, "BarWidth", 80);
        this.barDepth = new JetUnitNumber(this, "BarDepth", JRObjectTemplate.convertSize(10));
        this.useDepth = new JetBoolean(this, "UseDepth", false);
        this.barDepthDirection = new JetNumber(this, "BarDepthDirection", 45);
        this.varyColorByValues = new JetBoolean(this, "VaryColorByValues", true);
        this.barGap = new JetNumber(this, "BarGap", 30);
        this.lineThickness = new JetUnitNumber(this, "LineThickness", JRObjectTemplate.convertSize(3));
        this.areaPatternList = new JetVector(this, "AreaPatternList");
        this.lineNodeStyle = new JetEnumeration(this, "LineNodeStyle", 59);
        this.lineNodeWidth = new JetUnitNumber(this, "LineNodeWidth", JRObjectTemplate.convertSize(10));
        this.lineNodeHeight = new JetUnitNumber(this, "LineNodeHeight", JRObjectTemplate.convertSize(10));
        this.radarIsFill = new JetBoolean(this, "RadarIsFill", false);
        this.radarFillTransparence = new JetNumber(this, "RadarFillTransparence", 40);
        this.radarIsShowColumnName = new JetBoolean(this, "RadarIsShowColumnName", true);
        this.radarArrowStyle = new JetEnumeration(this, "RadarArrowStyle", 9);
        this.stockUpBarColor = new JetColor(this, "StockUpBarColor", Color.red, true);
        this.stockDownBarColor = new JetColor(this, "StockDownBarColor", Color.green, true);
        this.stockLineColor = new JetColor(this, "StockLineColor", Color.black, true);
        this.gaugeNormalValueMin = new JetDoubleNumber(this, "GaugeNormalValueMin", 0);
        this.gaugeNormalValueMax = new JetDoubleNumber(this, "GaugeNormalValueMax", 0);
        this.gaugeAlertValueMin = new JetDoubleNumber(this, "GaugeAlertValueMin", 0);
        this.gaugeAlertValueMax = new JetDoubleNumber(this, "GaugeAlertValueMax", 0);
        this.gaugeErrorValueMin = new JetDoubleNumber(this, "GaugeErrorValueMin", 0);
        this.gaugeErrorValueMax = new JetDoubleNumber(this, "GaugeErrorValueMax", 0);
        this.gaugeNormalColor = new JetColor(this, "GaugeNormalColor", Color.green, true);
        this.gaugeAlertColor = new JetColor(this, "GaugeAlertColor", Color.orange, true);
        this.gaugeErrorColor = new JetColor(this, "GaugeErrorColor", Color.red, true);
        this.gaugeDialStartAngle = new JetNumber(this, "GaugeDialStartAngle", 0);
        this.gaugeDialStopAngle = new JetNumber(this, "GaugeDialStopAngle", 180);
        this.gaugeDialLineStyle = new JetEnumeration(this, "GaugeDialLineStyle", 62);
        this.gaugeDialLineArrowStyle = new JetEnumeration(this, "GaugeDialLineArrowStyle", 9);
        this.gaugeDialCurveIsFill = new JetBoolean(this, "GaugeDialCurveIsFill", true);
        this.gaugeDialOuterInnerGap = new JetUnitNumber(this, "GaugeDialOuterInnerGap", JRObjectTemplate.convertSize(26));
        this.gaugeDialCurveStyle = new JetEnumeration(this, "GaugeDialCurveStyle", 42);
        this.radiusRange = new JetDoubleNumber(this, "RadiusRange", 80);
        this.horizonMargin = new JetUnitNumber(this, "HorizontalMargin", JRObjectTemplate.convertSize(40));
        this.verticalMargin = new JetUnitNumber(this, "VerticalMargin", JRObjectTemplate.convertSize(20));
        this.gaugeBarPen = new JetChartPenStyle(this, "GaugeBar");
        this.gaugeBarLayout = new JetEnumeration(this, "GaugeBarLayout", 41);
        this.showThresholdLine = new JetBoolean(this, "ShowThresholdLine", false);
        this.thresholdValue = new JetDoubleNumber(this, "ThresholdValue", 60);
        this.thresholdLineColor = new JetColor(this, "ThresholdLineColor", Color.red, true);
        this.fillThreshold = new JetBoolean(this, "FillThreshold", true);
        this.showThresholdLine2 = new JetBoolean(this, "ShowThresholdLine2", false);
        this.thresholdValue2 = new JetDoubleNumber(this, "ThresholdValue2", 20);
        this.thresholdLineColor2 = new JetColor(this, "ThresholdLineColor2", Color.blue, true);
        this.fillThreshold2 = new JetBoolean(this, "FillThreshold2", true);
        this.thresholdLineStyle = new JetEnumeration(this, "ThresholdLineStyle", 63);
        this.fillTransparent = new JetDoubleNumber(this, "FillTransparent", 60);
        this.showMeanLine = new JetBoolean(this, "ShowMeanLine", false);
        this.meanLineColor = new JetColor(this, "MeanLineColor", Color.yellow, true);
        this.meanLineNodeStyle = new JetEnumeration(this, "MeanLineNodeStyle", 59);
        this.meanLineType = new JetEnumeration(this, "MeanLineType", 16);
        this.pieExplodeDistance = new JetUnitNumber(this, "SectionExplodeGap");
        this.spiGap = new JetUnitNumber(this, "PieGap", 0);
        this.valueLabelType = new JetEnumeration(this, "ValueLabelType", 102);
        this.suppressZeroLabel = new JetBoolean(this, "SuppressZeroLabel", false);
        this.showPieName = new JetBoolean(this, "ShowPieName", false);
        this.use3DEffect = new JetBoolean(this, "Use3DEffect", false);
        this.rotate = new JetBoolean(this, "RotationMode", false);
    }

    public JetRptChartPaper() {
        this.ARROW_STYLE_INTEGERS();
        this.setTemplateIndex(72);
        this.CHART_PATTERN_LIST_EDITOR();
        this.graphPosition.set("FitSize");
        this.lineNodeStyle.set("None");
        this.radarArrowStyle.set("Arrow1");
        this.gaugeDialLineStyle.set("Diamond");
        this.gaugeDialLineArrowStyle.set("Arrow1");
        this.gaugeDialCurveStyle.set("OutIn");
        this.thresholdLineStyle.set("Style1");
        this.meanLineNodeStyle.set("Star2");
        this.meanLineType.set("Line");
        this.valueLabelType.set("Value");
        this.gaugeBarLayout.set("Horizontal");
        this.areaPatternList.setEditorType(JetProperty.CHART_PATTERN_LIST_EDITOR);
    }

    public void afterInit() {
        super.afterInit();
        this.definitionChanged();
        JetRptReport jetRptReport = JetRptReport.getReport(this);
        if (jetRptReport != null) {
            String string = jetRptReport.getResourcePath();
            this.background.fillPattern.imageFile.setPath(string);
            this.wallProperties.fillPattern.imageFile.setPath(string);
            this.floorProperties.fillPattern.imageFile.setPath(string);
        }
    }

    private void CHART_PATTERN_LIST_EDITOR() {
        this.x.setUnitValue(JRObjectTemplate.convertSize(10));
        this.y.setUnitValue(JRObjectTemplate.convertSize(30));
        this.width.setUnitValue(JRObjectTemplate.convertSize(375));
        this.height.setUnitValue(JRObjectTemplate.convertSize(285));
        this.axisX.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisX.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisX.labelTextStyle.pattern.type.set("Color");
        this.axisX.labelTextStyle.pattern.color.set(Color.black);
        this.axisX.labelTextStyle.rotation.set(0);
        this.axisY.showGrid.set(true);
        this.axisY.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY.labelTextStyle.pattern.type.set("Color");
        this.axisY.labelTextStyle.pattern.color.set(Color.black);
        this.axisY2.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY2.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY2.labelTextStyle.pattern.type.set("Color");
        this.axisY2.labelTextStyle.pattern.color.set(Color.black);
        this.axisZ.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisZ.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisZ.labelTextStyle.pattern.type.set("Color");
        this.axisZ.labelTextStyle.pattern.color.set(Color.black);
        float[] fArray2 = new float[12];
        fArray2[0] = 1.0f;
        fArray2[5] = 1.0f;
        fArray2[10] = 1.0f;
        this.rotationMatrix.set(JetChartPropertyValues.mapRotationMatrixList(fArray2));
        int[] nArray = new int[]{0};
        this.valueLabelPositionList.set(JetChartPropertyValues.mapValueLabelPositionList(nArray));
        ChartTextStyle chartTextStyle = new ChartTextStyle();
        chartTextStyle.setFontSize(14);
        chartTextStyle.setFontStyle(1);
        this.hintTextStyle.setChartTextStyle(chartTextStyle);
        this.areaPatternList.set(JetChartPropertyValues.getDefaultAreaPatternString());
    }

    public void definitionChanged() {
        this.ARROW_STYLE_INTEGERS = ((JetRptChartPlatform)this.getParent()).definition.getChartDefinition();
        this.removePropertyGroup("Excel");
        this.removePropertyGroup("Color");
        this.removePropertyGroup("Others");
        this.removePropertyGroup("Border");
        this.removePropertyGroup("CoordinatePaper");
        this.removePropertyGroup("Hint");
        this.removePropertyGroup("AxisX");
        this.removePropertyGroup("AxisY");
        this.removePropertyGroup("AxisY2");
        this.removePropertyGroup("AxisZ");
        this.removePropertyGroup("Wall");
        this.removePropertyGroup("Floor");
        this.removePropertyGroup("Graph");
        this.removePropertyGroup("Background");
        this.removePropertyGroup("ThresholdLine");
        this.removePropertyGroup("MeanLine");
        this.removePropertyGroup("Contour");
        if (this.ARROW_STYLE_INTEGERS.is3DEffect()) {
            int n;
            int n2;
            this.GAUGE_DIAL_LINESTYLE_INTEGERS();
            this.addPropertyToGroup(this.ARROW_STYLE_INTEGERS);
            this.add();
            this.GRAPH_POSITION_INTEGERS();
            this.LINENODE_STYLE_INTEGERS();
            this.MEANLINE_TYPE_INTEGERS();
            ChartDataSetInfo[] chartDataSetInfoArray = this.ARROW_STYLE_INTEGERS.getChartDataSetInfos();
            if (chartDataSetInfoArray != null && chartDataSetInfoArray.length > 0 && (n2 = ChartTypeInfo.getSubType(n = chartDataSetInfoArray[0].getChartType())) == 768) {
                this.THRESHOLDLINE_STYLE_INTEGERS();
            }
            this._xrot();
            this.addToGroup2();
        } else {
            this.GAUGE_DIAL_CURVESTYLE_INTEGERS();
            ChartDataSetInfo[] chartDataSetInfoArray = this.ARROW_STYLE_INTEGERS.getChartDataSetInfos();
            this.addPropertyGroup(chartDataSetInfoArray);
            this.add();
            this.GRAPH_POSITION_INTEGERS();
            if (chartDataSetInfoArray != null && chartDataSetInfoArray.length > 0) {
                int n = chartDataSetInfoArray[0].getChartType();
                int n3 = ChartTypeInfo.getPrimType(n);
                if (n3 == 9 || n3 == 8) {
                    this.GAUGE_BAR_LAYOUT_INTEGERS();
                } else {
                    this.LINENODE_STYLE_INTEGERS();
                }
                if (this.ARROW_STYLE_INTEGERS.getY1Datasets() != null && this.ARROW_STYLE_INTEGERS.getY1Datasets().size() > 0) {
                    this.MEANLINE_TYPE_INTEGERS();
                }
                if (this.ARROW_STYLE_INTEGERS.getY2Datasets() != null && this.ARROW_STYLE_INTEGERS.getY2Datasets().size() > 0) {
                    this.QOIV();
                }
                if (n3 != 6 && n3 != 5) {
                    this.VALUELABEL_TYPE_INTEGERS();
                    if (n3 != 8 && n3 != 9 && n3 != 10) {
                        this.addToGroup();
                        this.angleX();
                    }
                } else {
                    int n4 = ChartTypeInfo.getSubType(n);
                    if (n4 == 512) {
                        this.THRESHOLDLINE_STYLE_INTEGERS();
                    }
                }
            }
        }
    }

    private void GAUGE_BAR_LAYOUT_INTEGERS() {
        this.addPropertyGroup("AxisX");
        this.addPropertyToGroup("ShowAxisX", "AxisX");
        this.axisX.addToGroup2("AxisX");
    }

    private void GAUGE_DIAL_CURVESTYLE_INTEGERS() {
        this.addPropertyGroup("CoordinatePaper");
        this.addPropertyToGroup("ScaleX", "CoordinatePaper");
        this.addPropertyToGroup("ScaleY", "CoordinatePaper");
        this.addPropertyToGroup("GraphPosition", "CoordinatePaper");
        this.addPropertyToGroup("ReversePaintingOrder", "CoordinatePaper");
        this.addPropertyToGroup("Interactive", "CoordinatePaper");
        this.addPropertyToGroup("ShadowContents", "CoordinatePaper");
        this.addPropertyGroup("Background");
        this.background.addToGroup("Background");
    }

    private void GAUGE_DIAL_LINESTYLE_INTEGERS() {
        this.addPropertyGroup("CoordinatePaper");
        this.addPropertyToGroup("ScaleX", "CoordinatePaper");
        this.addPropertyToGroup("ScaleY", "CoordinatePaper");
        this.addPropertyToGroup("ScaleZ", "CoordinatePaper");
        this.addPropertyToGroup("AngleX", "CoordinatePaper");
        this.addPropertyToGroup("AngleY", "CoordinatePaper");
        this.addPropertyToGroup("AngleZ", "CoordinatePaper");
        this.addPropertyToGroup("Perspective", "CoordinatePaper");
        this.addPropertyToGroup("Interactive", "CoordinatePaper");
        this.addPropertyGroup("Background");
        this.background.addToGroup("Background");
        this.rotate.set(false);
    }

    private void GRAPH_POSITION_INTEGERS() {
        this.addPropertyGroup("Hint");
        this.addPropertyToGroup("ShowTips", "Hint");
        this.addPropertyToGroup("ShowCategoryAndSeries", "Hint");
        this.hintTextStyle.addToGroup("Hint");
        this.removePropertyFromGroup("Hint", this.hintTextStyle.wordWrap.getName());
    }

    private void LINENODE_STYLE_INTEGERS() {
        this.addPropertyGroup("AxisX");
        this.addPropertyToGroup("ShowAxisX", "AxisX");
        this.axisX.addToGroup("AxisX");
    }

    private void MEANLINE_TYPE_INTEGERS() {
        this.addPropertyGroup("AxisY");
        this.addPropertyToGroup("ShowAxisY", "AxisY");
        this.axisY.addToGroup("AxisY");
    }

    private void QOIV() {
        this.addPropertyGroup("AxisY2");
        this.addPropertyToGroup("ShowAxisY2", "AxisY2");
        this.axisY2.addToGroup("AxisY2");
    }

    private void THRESHOLDLINE_STYLE_INTEGERS() {
        this.addPropertyGroup("AxisZ");
        this.addPropertyToGroup("ShowAxisZ", "AxisZ");
        this.axisZ.addToGroup("AxisZ");
    }

    private void VALUELABEL_TYPE_INTEGERS() {
        this.addPropertyGroup("Wall");
        this.addPropertyToGroup("ShowWall", "Wall");
        this.wallProperties.addToGroup("Wall");
    }

    private void _xrot() {
        this.addPropertyGroup("Wall");
        this.addPropertyToGroup("ShowWall", "Wall");
        this.wallProperties.addToGroup("Wall");
        this.addPropertyGroup("Floor");
        this.addPropertyToGroup("ShowFloor", "Floor");
        this.floorProperties.addToGroup("Floor");
    }

    private void add() {
        this.addPropertyGroup("Contour");
        this.addPropertyToGroup("Contour", "Contour");
        this.contourPen.addToGroup("Contour");
    }

    private void addPropertyGroup(ChartDataSetInfo[] chartDataSetInfoArray) {
        this.addPropertyGroup("Graph");
        if (chartDataSetInfoArray != null && chartDataSetInfoArray.length > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = chartDataSetInfoArray.length;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            int n4 = 0;
            while (n4 < n3) {
                n = chartDataSetInfoArray[n4].getChartType();
                n2 = ChartTypeInfo.getPrimType(n);
                switch (n2) {
                    case 0: 
                    case 1: {
                        if (bl) break;
                        this.addPropertyToGroup("SuppressZeroLabel", "Graph");
                        this.addPropertyToGroup("BarWidth", "Graph");
                        this.addPropertyToGroup("BarGap", "Graph");
                        this.addPropertyToGroup("UseDepth", "Graph");
                        this.addPropertyToGroup("BarDepth", "Graph");
                        this.addPropertyToGroup("BarDepthDirection", "Graph");
                        this.addPropertyToGroup("VaryColorByValues", "Graph");
                        this.addPropertyToGroup("ValueLabelType", "Graph");
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (bl2) break;
                        this.addPropertyToGroup("SuppressZeroLabel", "Graph");
                        this.addPropertyToGroup("UseDropline", "Graph");
                        this.addPropertyToGroup("UseDepth", "Graph");
                        this.addPropertyToGroup("BarDepth", "Graph");
                        this.addPropertyToGroup("BarDepthDirection", "Graph");
                        this.addPropertyToGroup("ValueLabelType", "Graph");
                        bl2 = true;
                        break;
                    }
                    case 6: {
                        if (bl3) break;
                        this.addPropertyToGroup("GaugeNormalValueMin", "Graph");
                        this.addPropertyToGroup("GaugeNormalValueMax", "Graph");
                        this.addPropertyToGroup("GaugeAlertValueMin", "Graph");
                        this.addPropertyToGroup("GaugeAlertValueMax", "Graph");
                        this.addPropertyToGroup("GaugeErrorValueMin", "Graph");
                        this.addPropertyToGroup("GaugeErrorValueMax", "Graph");
                        this.addPropertyToGroup("GaugeNormalColor", "Graph");
                        this.addPropertyToGroup("GaugeAlertColor", "Graph");
                        this.addPropertyToGroup("GaugeErrorColor", "Graph");
                        int n5 = ChartTypeInfo.getSubType(n);
                        if (n5 == 512) {
                            this.addPropertyToGroup("RadiusRange", "Graph");
                            this.addPropertyToGroup("HorizontalMargin", "Graph");
                            this.addPropertyToGroup("VerticalMargin", "Graph");
                        } else if (n5 == 256) {
                            this.addPropertyToGroup("GaugeBarLayout", "Graph");
                            this.gaugeBarPen.addToGroup("Graph");
                        } else if (n5 == 0) {
                            this.addPropertyToGroup("GaugeDialStartAngle", "Graph");
                            this.addPropertyToGroup("GaugeDialStopAngle", "Graph");
                            this.addPropertyToGroup("GaugeDialLineStyle", "Graph");
                            this.addPropertyToGroup("GaugeDialLineArrowStyle", "Graph");
                            this.addPropertyToGroup("GaugeDialCurveIsFill", "Graph");
                            this.addPropertyToGroup("GaugeDialOuterInnerGap", "Graph");
                            this.addPropertyToGroup("GaugeDialCurveStyle", "Graph");
                            this.addPropertyToGroup("RadiusRange", "Graph");
                        }
                        bl3 = true;
                        break;
                    }
                    case 9: {
                        if (bl4) break;
                        this.addPropertyToGroup("Use3DEffect", "Graph");
                        bl4 = true;
                        break;
                    }
                    case 2: {
                        if (bl5) break;
                        this.addPropertyToGroup("SuppressZeroLabel", "Graph");
                        this.addPropertyToGroup("LineThickness", "Graph");
                        this.addPropertyToGroup("LineNodeStyle", "Graph");
                        this.addPropertyToGroup("AreaPatternList", "Graph");
                        this.addPropertyToGroup("LineNodeWidth", "Graph");
                        this.addPropertyToGroup("LineNodeHeight", "Graph");
                        this.addPropertyToGroup("UseDepth", "Graph");
                        this.addPropertyToGroup("BarDepth", "Graph");
                        this.addPropertyToGroup("BarDepthDirection", "Graph");
                        this.addPropertyToGroup("ValueLabelType", "Graph");
                        bl5 = true;
                        break;
                    }
                    case 4: {
                        if (bl6) break;
                        this.addPropertyToGroup("ShowPieName", "Graph");
                        this.addPropertyToGroup("SuppressZeroLabel", "Graph");
                        this.addPropertyToGroup("AngleX", "Graph");
                        this.addPropertyToGroup("AngleY", "Graph");
                        this.addPropertyToGroup("ValueLabelType", "Graph");
                        this.addPropertyToGroup("SectionExplodeGap", "Graph");
                        this.addPropertyToGroup("PieGap", "Graph");
                        bl6 = true;
                        break;
                    }
                    case 5: {
                        if (bl7) break;
                        this.addPropertyToGroup("SuppressZeroLabel", "Graph");
                        this.addPropertyToGroup("RadarIsFill", "Graph");
                        this.addPropertyToGroup("RadarFillTransparence", "Graph");
                        this.addPropertyToGroup("RadarIsShowColumnName", "Graph");
                        this.addPropertyToGroup("RadarArrowStyle", "Graph");
                        this.addPropertyToGroup("LineThickness", "Graph");
                        this.addPropertyToGroup("LineNodeStyle", "Graph");
                        this.addPropertyToGroup("LineNodeWidth", "Graph");
                        this.addPropertyToGroup("LineNodeHeight", "Graph");
                        this.addPropertyToGroup("ValueLabelType", "Graph");
                        bl7 = true;
                        break;
                    }
                    case 8: {
                        if (bl9) break;
                        this.addPropertyToGroup("LineThickness", "Graph");
                        this.addPropertyToGroup("LineNodeStyle", "Graph");
                        this.addPropertyToGroup("LineNodeWidth", "Graph");
                        this.addPropertyToGroup("LineNodeHeight", "Graph");
                        bl9 = true;
                        break;
                    }
                    case 10: {
                        if (bl8) break;
                        this.addPropertyToGroup("LineThickness", "Graph");
                        this.addPropertyToGroup("StockLineColor", "Graph");
                        this.addPropertyToGroup("BarWidth", "Graph");
                        this.addPropertyToGroup("StockUpBarColor", "Graph");
                        this.addPropertyToGroup("StockDownBarColor", "Graph");
                        bl8 = true;
                    }
                }
                ++n4;
            }
        }
    }

    private void addPropertyToGroup(ChartDefinition chartDefinition) {
        ChartDataSetInfo[] chartDataSetInfoArray = chartDefinition.getChartDataSetInfos();
        int n = chartDataSetInfoArray[0].getChartType();
        int n2 = ChartTypeInfo.getPrimType(n);
        if (n2 == 0) {
            this.addPropertyGroup("Graph");
            this.addPropertyToGroup("BarWidth", "Graph");
        } else if (n2 == 2) {
            this.addPropertyGroup("Graph");
            this.addPropertyToGroup("LineThickness", "Graph");
        }
    }

    private void addToGroup() {
        this.addPropertyGroup("ThresholdLine");
        this.addPropertyToGroup("ShowThresholdLine", "ThresholdLine");
        this.addPropertyToGroup("ThresholdValue", "ThresholdLine");
        this.addPropertyToGroup("ThresholdLineColor", "ThresholdLine");
        this.addPropertyToGroup("FillThreshold", "ThresholdLine");
        this.addPropertyToGroup("ShowThresholdLine2", "ThresholdLine");
        this.addPropertyToGroup("ThresholdValue2", "ThresholdLine");
        this.addPropertyToGroup("ThresholdLineColor2", "ThresholdLine");
        this.addPropertyToGroup("FillThreshold2", "ThresholdLine");
        this.addPropertyToGroup("ThresholdLineStyle", "ThresholdLine");
        this.addPropertyToGroup("FillTransparent", "ThresholdLine");
    }

    private void addToGroup2() {
        this.addPropertyGroup("ThresholdLine");
        this.addPropertyToGroup("ShowThresholdLine", "ThresholdLine");
        this.addPropertyToGroup("ThresholdValue", "ThresholdLine");
        this.addPropertyToGroup("ThresholdLineColor", "ThresholdLine");
        this.addPropertyToGroup("ShowThresholdLine2", "ThresholdLine");
        this.addPropertyToGroup("ThresholdValue2", "ThresholdLine");
        this.addPropertyToGroup("ThresholdLineColor2", "ThresholdLine");
        this.addPropertyToGroup("FillTransparent", "ThresholdLine");
    }

    private void angleX() {
        this.addPropertyGroup("MeanLine");
        this.addPropertyToGroup("ShowMeanLine", "MeanLine");
        this.addPropertyToGroup("MeanLineColor", "MeanLine");
        this.addPropertyToGroup("MeanLineNodeStyle", "MeanLine");
        this.addPropertyToGroup("MeanLineType", "MeanLine");
    }

    public ChartCoordinatePaperProperties getChartCoordinatePaperProperties() {
        ChartCoordinatePaperProperties chartCoordinatePaperProperties = new ChartCoordinatePaperProperties();
        chartCoordinatePaperProperties.setTopMargin(this.topMargin.intValue());
        chartCoordinatePaperProperties.setLeftMargin(this.leftMargin.intValue());
        chartCoordinatePaperProperties.setRightMargin(this.rightMargin.intValue());
        chartCoordinatePaperProperties.setBottomMargin(this.bottomMargin.intValue());
        chartCoordinatePaperProperties.setBackground(this.background.getChartBackground());
        chartCoordinatePaperProperties.setScaleX((float)this.scaleX.get() / 100.0f);
        chartCoordinatePaperProperties.setScaleY((float)this.scaleY.get() / 100.0f);
        chartCoordinatePaperProperties.setScaleZ((float)this.scaleZ.get() / 100.0f);
        chartCoordinatePaperProperties.setAngleX(this.angleX.get());
        chartCoordinatePaperProperties.setAngleY(this.angleY.get());
        chartCoordinatePaperProperties.setAngleZ(this.angleZ.get());
        ChartMatrix chartMatrix = new ChartMatrix();
        chartMatrix._xrot(this.angleX.get());
        chartMatrix.yrot(this.angleY.get());
        chartMatrix.zrot(this.angleZ.get());
        chartCoordinatePaperProperties.setRotationMatrix(chartMatrix.getMatrix());
        chartCoordinatePaperProperties.setGraphPosition(this.graphPosition.intValue());
        chartCoordinatePaperProperties.setReversePaintingOrder(this.reversePaintingOrder.booleanValue());
        chartCoordinatePaperProperties.setPerspective(this.perspective.intValue());
        chartCoordinatePaperProperties.setInteractive(this.interactive.booleanValue());
        chartCoordinatePaperProperties.setValueLabelPositionList(JetChartPropertyValues.mapValueLabelPositions(this.valueLabelPositionList.get()));
        chartCoordinatePaperProperties.setHintTextStyle(this.hintTextStyle.getChartTextStyle());
        chartCoordinatePaperProperties.setShowTips(this.showTips.booleanValue());
        chartCoordinatePaperProperties.setShowCategoryAndSeries(this.showCategoryAndSeries.booleanValue());
        chartCoordinatePaperProperties.setShadowContents(this.shadowContents.booleanValue());
        chartCoordinatePaperProperties.setShowWall(this.showWall.booleanValue());
        chartCoordinatePaperProperties.setWallProperties(this.wallProperties.getWallProperties());
        chartCoordinatePaperProperties.setShowFloor(this.showFloor.booleanValue());
        chartCoordinatePaperProperties.setFloorProperties(this.floorProperties.getWallProperties());
        chartCoordinatePaperProperties.setShowAxisX(this.showAxisX.booleanValue());
        chartCoordinatePaperProperties.setAxisXProperties(this.axisX.getChartAxisProperties());
        chartCoordinatePaperProperties.setShowAxisY(this.showAxisY.booleanValue());
        chartCoordinatePaperProperties.setAxisYProperties((ChartNumericAxisProperties)this.axisY.getChartAxisProperties());
        chartCoordinatePaperProperties.setShowAxisY2(this.showAxisY2.booleanValue());
        chartCoordinatePaperProperties.setAxisY2Properties((ChartNumericAxisProperties)this.axisY2.getChartAxisProperties());
        chartCoordinatePaperProperties.setShowAxisZ(this.showAxisZ.booleanValue());
        chartCoordinatePaperProperties.setAxisZProperties(this.axisZ.getChartAxisProperties());
        ChartGraphProperties chartGraphProperties = chartCoordinatePaperProperties.getGraphProperties();
        chartGraphProperties.setContour(this.contour.booleanValue());
        chartGraphProperties.setContourPen(this.contourPen.getChartPenStyle());
        chartGraphProperties.setUseDropline(this.useDropline.booleanValue());
        chartGraphProperties.setBarWidth((float)this.barWidth.get() / 100.0f);
        chartGraphProperties.setDepth(this.barDepth.intValue());
        chartGraphProperties.setUseDepth(this.useDepth.booleanValue());
        chartGraphProperties.setDepthDirection(this.barDepthDirection.get());
        chartGraphProperties.setVaryColorbyValues(this.varyColorByValues.get());
        chartGraphProperties.setBarGap((float)this.barGap.get() / 100.0f);
        chartGraphProperties.setLineThickness(this.lineThickness.intValue());
        chartGraphProperties.setLineNodeStyle(this.lineNodeStyle.intValue());
        chartGraphProperties.setLineNodeWidth(this.lineNodeWidth.intValue());
        chartGraphProperties.setLineNodeHeight(this.lineNodeHeight.intValue());
        chartGraphProperties.setAreaPatternList(JetChartPropertyValues.mapPatterns(this.areaPatternList));
        chartGraphProperties.setRadarIsFill(this.radarIsFill.booleanValue());
        chartGraphProperties.setRadarFillTransparence((float)this.radarFillTransparence.get() / 100.0f);
        chartGraphProperties.setRadarIsShowColumnName(this.radarIsShowColumnName.booleanValue());
        chartGraphProperties.setRadarArrowStyle(this.radarArrowStyle.intValue());
        chartGraphProperties.setStockUpBarColor(this.stockUpBarColor.get());
        chartGraphProperties.setStockDownBarColor(this.stockDownBarColor.get());
        chartGraphProperties.setStockLineColor(this.stockLineColor.get());
        chartGraphProperties.setGaugeNormalValueMin(this.gaugeNormalValueMin.doubleValue());
        chartGraphProperties.setGaugeNormalValueMax(this.gaugeNormalValueMax.doubleValue());
        chartGraphProperties.setGaugeAlertValueMin(this.gaugeAlertValueMin.doubleValue());
        chartGraphProperties.setGaugeAlertValueMax(this.gaugeAlertValueMax.doubleValue());
        chartGraphProperties.setGaugeErrorValueMin(this.gaugeErrorValueMin.doubleValue());
        chartGraphProperties.setGaugeErrorValueMax(this.gaugeErrorValueMax.doubleValue());
        chartGraphProperties.setGaugeNormalColor(this.gaugeNormalColor.get());
        chartGraphProperties.setGaugeAlertColor(this.gaugeAlertColor.get());
        chartGraphProperties.setGaugeErrorColor(this.gaugeErrorColor.get());
        chartGraphProperties.setGaugeDialStartAngle(this.gaugeDialStartAngle.get());
        chartGraphProperties.setGaugeDialStopAngle(this.gaugeDialStopAngle.get());
        chartGraphProperties.setGaugeDialLineStyle(this.gaugeDialLineStyle.intValue());
        chartGraphProperties.setGaugeDialLineArrowStyle(this.gaugeDialLineArrowStyle.intValue());
        chartGraphProperties.setGaugeDialCurveIsFill(this.gaugeDialCurveIsFill.booleanValue());
        chartGraphProperties.setGaugeDialOuterInnerGap(this.gaugeDialOuterInnerGap.intValue());
        chartGraphProperties.setGaugeDialCurveStyle(this.gaugeDialCurveStyle.intValue());
        chartGraphProperties.setHorizonalMargin(this.horizonMargin.get());
        chartGraphProperties.setVerticalMargin(this.verticalMargin.get());
        chartGraphProperties.setGaugeBarLayout(this.gaugeBarLayout.intValue());
        chartGraphProperties.setGaugeBarPen(this.gaugeBarPen.getChartPenStyle());
        chartGraphProperties.setShowThresholdLine(this.showThresholdLine.booleanValue());
        chartGraphProperties.setThresholdValue(this.thresholdValue.doubleValue());
        chartGraphProperties.setThresholdLineColor(this.thresholdLineColor.get());
        chartGraphProperties.setFillThreshold(this.fillThreshold.booleanValue());
        chartGraphProperties.setShowThresholdLine2(this.showThresholdLine2.booleanValue());
        chartGraphProperties.setThresholdValue2(this.thresholdValue2.doubleValue());
        chartGraphProperties.setThresholdLineColor2(this.thresholdLineColor2.get());
        chartGraphProperties.setFillThreshold2(this.fillThreshold2.booleanValue());
        chartGraphProperties.setThresholdLineStyle(this.thresholdLineStyle.intValue());
        chartGraphProperties.setThresholdFillTransparency((float)this.fillTransparent.intValue() / 100.0f);
        chartGraphProperties.setShowMeanLine(this.showMeanLine.booleanValue());
        chartGraphProperties.setMeanLineColor(this.meanLineColor.get());
        chartGraphProperties.setMeanLineNodeStyle(this.meanLineNodeStyle.intValue());
        chartGraphProperties.setMeanLineType(this.meanLineType.intValue());
        chartGraphProperties.setPieExplodeDistance(this.pieExplodeDistance.intValue());
        chartGraphProperties.setPieGap(this.spiGap.intValue());
        chartGraphProperties.setValueLabelType(this.valueLabelType.intValue());
        chartGraphProperties.setSuppressZeroLabel(this.suppressZeroLabel.booleanValue());
        chartGraphProperties.setShowPieName(this.showPieName.booleanValue());
        chartGraphProperties.setUse3DEffect(this.use3DEffect.booleanValue());
        chartGraphProperties.setRadiusRange((float)this.radiusRange.get() / 100.0f);
        return chartCoordinatePaperProperties;
    }

    public void setChartCoordinatePaperProperties(ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.topMargin.set((int)chartCoordinatePaperProperties.getTopMargin());
        this.leftMargin.set((int)chartCoordinatePaperProperties.getLeftMargin());
        this.rightMargin.set((int)chartCoordinatePaperProperties.getRightMargin());
        this.bottomMargin.set((int)chartCoordinatePaperProperties.getBottomMargin());
        this.background.setChartBackground(chartCoordinatePaperProperties.getBackground());
        this.scaleX.set(chartCoordinatePaperProperties.getScaleX() * 100.0f);
        this.scaleY.set(chartCoordinatePaperProperties.getScaleY() * 100.0f);
        this.scaleZ.set(chartCoordinatePaperProperties.getScaleZ() * 100.0f);
        this.angleX.set(chartCoordinatePaperProperties.getAngleX());
        this.angleY.set(chartCoordinatePaperProperties.getAngleY());
        this.angleZ.set(chartCoordinatePaperProperties.getAngleZ());
        this.rotationMatrix.set(JetChartPropertyValues.mapRotationMatrixList(chartCoordinatePaperProperties.getRotationMatrix()));
        this.graphPosition.set((String)JetChartPropertyValues.GRAPH_POSITION_INTEGERS.get(new Integer(chartCoordinatePaperProperties.getGraphPosition())));
        this.reversePaintingOrder.set(chartCoordinatePaperProperties.isReversePaintingOrder());
        this.perspective.set(chartCoordinatePaperProperties.getPerspective());
        this.interactive.set(chartCoordinatePaperProperties.isInteractive());
        this.valueLabelPositionList.set(JetChartPropertyValues.mapValueLabelPositionList(chartCoordinatePaperProperties.getValueLabelPositionList()));
        this.hintTextStyle.setChartTextStyle(chartCoordinatePaperProperties.getHintTextStyle());
        this.showTips.set(chartCoordinatePaperProperties.isShowTips());
        this.showCategoryAndSeries.set(chartCoordinatePaperProperties.isShowCategoryAndSeries());
        this.shadowContents.set(chartCoordinatePaperProperties.isShadowContents());
        this.showWall.set(chartCoordinatePaperProperties.isShowWall());
        this.wallProperties.setWallProperties(chartCoordinatePaperProperties.getWallProperties());
        this.showFloor.set(chartCoordinatePaperProperties.isShowFloor());
        this.floorProperties.setWallProperties(chartCoordinatePaperProperties.getFloorProperties());
        this.showAxisX.set(chartCoordinatePaperProperties.isShowAxisX());
        this.axisX.setChartAxisProperties(chartCoordinatePaperProperties.getAxisXProperties());
        this.showAxisY.set(chartCoordinatePaperProperties.isShowAxisY());
        this.axisY.setChartAxisProperties(chartCoordinatePaperProperties.getAxisYProperties());
        this.showAxisY2.set(chartCoordinatePaperProperties.isShowAxisY2());
        this.axisY2.setChartAxisProperties(chartCoordinatePaperProperties.getAxisY2Properties());
        this.showAxisZ.set(chartCoordinatePaperProperties.isShowAxisZ());
        this.axisZ.setChartAxisProperties(chartCoordinatePaperProperties.getAxisZProperties());
        ChartGraphProperties chartGraphProperties = chartCoordinatePaperProperties.getGraphProperties();
        this.contour.set(chartGraphProperties.isContour());
        this.contourPen.setChartPenStyle(chartGraphProperties.getContourPen());
        this.useDropline.set(chartGraphProperties.isUseDropline());
        this.barWidth.set((int)(chartGraphProperties.getBarWidth() * 100.0f));
        this.barDepth.set((int)chartGraphProperties.getDepth());
        this.useDepth.set(chartGraphProperties.isUseDepth());
        this.barDepthDirection.set(chartGraphProperties.getDepthDirection());
        this.varyColorByValues.set(chartGraphProperties.isVaryColorbyValues());
        this.barGap.set((int)(chartGraphProperties.getBarGap() * 100.0f));
        this.lineThickness.set((int)chartGraphProperties.getLineThickness());
        this.areaPatternList.set(JetChartPropertyValues.mapPatternList(chartGraphProperties.getAreaPatternList()));
        this.lineNodeStyle.set((String)JetChartPropertyValues.LINENODE_STYLE_INTEGERS.get(new Integer(chartGraphProperties.getLineNodeStyle())));
        this.lineNodeWidth.set(chartGraphProperties.getLineNodeWidth());
        this.lineNodeHeight.set(chartGraphProperties.getLineNodeHeight());
        this.radarIsFill.set(chartGraphProperties.isRadarIsFill());
        this.radarFillTransparence.set(chartGraphProperties.getRadarFillTransparence() * 100.0f);
        this.radarIsShowColumnName.set(chartGraphProperties.isRadarIsShowColumnName());
        this.radarArrowStyle.set((String)JetChartPropertyValues.ARROW_STYLE_INTEGERS.get(new Integer(chartGraphProperties.getRadarArrowStyle())));
        this.stockUpBarColor.set(chartGraphProperties.getStockUpBarColor());
        this.stockDownBarColor.set(chartGraphProperties.getStockDownBarColor());
        this.stockLineColor.set(chartGraphProperties.getStockLineColor());
        this.gaugeNormalValueMin.set(chartGraphProperties.getGaugeNormalValueMin());
        this.gaugeNormalValueMax.set(chartGraphProperties.getGaugeNormalValueMax());
        this.gaugeAlertValueMin.set(chartGraphProperties.getGaugeAlertValueMin());
        this.gaugeAlertValueMax.set(chartGraphProperties.getGaugeAlertValueMax());
        this.gaugeErrorValueMin.set(chartGraphProperties.getGaugeErrorValueMin());
        this.gaugeErrorValueMax.set(chartGraphProperties.getGaugeErrorValueMax());
        this.gaugeNormalColor.set(chartGraphProperties.getGaugeNormalColor());
        this.gaugeAlertColor.set(chartGraphProperties.getGaugeAlertColor());
        this.gaugeErrorColor.set(chartGraphProperties.getGaugeErrorColor());
        this.gaugeDialStartAngle.set(chartGraphProperties.getGaugeDialStartAngle());
        this.gaugeDialStopAngle.set(chartGraphProperties.getGaugeDialStopAngle());
        this.gaugeDialLineStyle.set((String)JetChartPropertyValues.GAUGE_DIAL_LINESTYLE_INTEGERS.get(new Integer(chartGraphProperties.getGaugeDialLineStyle())));
        this.gaugeDialLineArrowStyle.set((String)JetChartPropertyValues.ARROW_STYLE_INTEGERS.get(new Integer(chartGraphProperties.getGaugeDialLineArrowStyle())));
        this.gaugeDialCurveIsFill.set(chartGraphProperties.isGaugeDialCurveIsFill());
        this.gaugeDialOuterInnerGap.set((int)chartGraphProperties.getGaugeDialOuterInnerGap());
        this.gaugeDialCurveStyle.set((String)JetChartPropertyValues.GAUGE_DIAL_CURVESTYLE_INTEGERS.get(new Integer(chartGraphProperties.getGaugeDialCurveStyle())));
        this.radiusRange.set((int)(chartGraphProperties.getRadiusRange() * 100.0f));
        this.horizonMargin.set(chartGraphProperties.getHorizonalMargin());
        this.verticalMargin.set(chartGraphProperties.getVerticalMargin());
        this.gaugeBarPen.setChartPenStyle(chartGraphProperties.getGaugeBarPen());
        this.gaugeBarLayout.set((String)JetChartPropertyValues.GAUGE_BAR_LAYOUT_INTEGERS.get(new Integer(chartGraphProperties.getGaugeBarLayout())));
        this.showThresholdLine.set(chartGraphProperties.isShowThresholdLine());
        this.thresholdValue.set(chartGraphProperties.getThresholdValue());
        this.thresholdLineColor.set(chartGraphProperties.getThresholdLineColor());
        this.fillThreshold.set(chartGraphProperties.isFillThreshold());
        this.showThresholdLine2.set(chartGraphProperties.isShowThresholdLine2());
        this.thresholdValue2.set(chartGraphProperties.getThresholdValue2());
        this.thresholdLineColor2.set(chartGraphProperties.getThresholdLineColor2());
        this.fillThreshold2.set(chartGraphProperties.isFillThreshold2());
        this.thresholdLineStyle.set((String)JetChartPropertyValues.THRESHOLDLINE_STYLE_INTEGERS.get(new Integer(chartGraphProperties.getThresholdLineStyle())));
        this.fillTransparent.set((int)(chartGraphProperties.getThresholdFillTransparency() * 100.0f));
        this.showMeanLine.set(chartGraphProperties.isShowMeanLine());
        this.meanLineColor.set(chartGraphProperties.getMeanLineColor());
        this.meanLineNodeStyle.set((String)JetChartPropertyValues.LINENODE_STYLE_INTEGERS.get(new Integer(chartGraphProperties.getMeanLineNodeStyle())));
        this.meanLineType.set((String)JetChartPropertyValues.MEANLINE_TYPE_INTEGERS.get(new Integer(chartGraphProperties.getMeanLineType())));
        this.pieExplodeDistance.set((int)chartGraphProperties.getPieExplodeDistance());
        this.spiGap.set((int)chartGraphProperties.getPieGap());
        this.valueLabelType.set((String)JetChartPropertyValues.VALUELABEL_TYPE_INTEGERS.get(new Integer(chartGraphProperties.getValueLabelType())));
        this.use3DEffect.set(chartGraphProperties.isUse3DEffect());
        this.suppressZeroLabel.set(chartGraphProperties.isSuppressZeroLabel());
        this.showPieName.set(chartGraphProperties.isShowPieName());
        JetRptChartPlatform.applyViewLogic(this);
    }

    public double[] getMinMax() {
        double[] dArray = new double[]{this.axisY.minValue.doubleValue(), this.axisY.maxValue.doubleValue(), this.axisY2.minValue.doubleValue(), this.axisY2.maxValue.doubleValue(), this.axisX.minValue.doubleValue(), this.axisX.maxValue.doubleValue()};
        return dArray;
    }

    public int getObjectType() {
        return 72;
    }

    public String getInstancePrefix() {
        return "ChartPaperObject";
    }

    public void resetDefault(JetRptChartPlatform jetRptChartPlatform) {
        ChartDefinition chartDefinition = jetRptChartPlatform.getChartDefinition();
        if (chartDefinition.is3DEffect()) {
            this.axisPen();
        } else {
            ChartDataSetInfo[] chartDataSetInfoArray = chartDefinition.getChartDataSetInfos();
            int n = chartDataSetInfoArray.length;
            int[] nArray = new int[n];
            this.valueLabelPositionList.set(JetChartPropertyValues.mapValueLabelPositionList(nArray));
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                int n3 = chartDataSetInfoArray[n2].getChartType();
                int n4 = ChartTypeInfo.getPrimType(n3);
                if (n4 != 10) {
                    bl = false;
                }
                switch (n4) {
                    case 6: {
                        this.angleZ();
                        break;
                    }
                    case 4: {
                        this.applyViewLogic();
                        break;
                    }
                    case 5: {
                        this.angleY();
                    }
                }
                ++n2;
            }
            if (bl) {
                this.areaPatternList(jetRptChartPlatform);
            }
        }
    }

    private void angleY() {
        this.axisX.labelTextStyle.rotation.set(0);
    }

    private void angleZ() {
        this.scaleX.set(90);
        this.scaleY.set(90);
        this.scaleZ.set(90);
        this.axisX.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisX.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY.showGrid.set(true);
        this.axisY.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY.labelAxisGap.setUnitValue(JRObjectTemplate.convertSize(5));
        this.axisY2.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisY2.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisZ.axisPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisZ.tickMarkPen.thickness.setUnitValue(JRObjectTemplate.convertSize(1));
        this.axisX.labelTextStyle.rotation.set(0);
    }

    private void applyViewLogic() {
        int[] nArray = new int[]{49};
        this.valueLabelPositionList.set(JetChartPropertyValues.mapValueLabelPositionList(nArray));
        this.angleY.set(45);
        this.axisX.labelTextStyle.rotation.set(0);
    }

    private void areaPatternList(JetRptChartPlatform jetRptChartPlatform) {
        this.lineThickness.setUnitValue(JRObjectTemplate.convertSize(2));
        this.x.setUnitValue(JRObjectTemplate.convertSize(10));
        this.y.setUnitValue(JRObjectTemplate.convertSize(30));
        this.width.setUnitValue(JRObjectTemplate.convertSize(480));
        this.height.setUnitValue(JRObjectTemplate.convertSize(275));
    }

    private void axisPen() {
        this.scaleX.set(90);
        this.scaleY.set(90);
        this.scaleZ.set(90);
        this.barWidth.set(60);
        this.rotate.set(false);
    }

    public void setEditable() {
        super.setEditable();
        this.x.setUnitValue(JRObjectTemplate.convertSize(10));
        this.y.setUnitValue(JRObjectTemplate.convertSize(30));
        this.width.setUnitValue(JRObjectTemplate.convertSize(375));
        this.height.setUnitValue(JRObjectTemplate.convertSize(285));
    }

    public HashMap getIndecialMap() {
        return CHART_PATTERN_LIST_EDITOR;
    }

    public HashVector getPropGrpsDesc() {
        return GAUGE_BAR_LAYOUT_INTEGERS;
    }

    public static boolean isCanUseDepth(ChartDefinition chartDefinition) {
        ChartRenderInfo chartRenderInfo = new ChartRenderInfo();
        chartDefinition.getCoordinateInfo(chartRenderInfo);
        return chartRenderInfo.primLayer == null || chartRenderInfo.secLayer == null || (chartRenderInfo.primLayer.getCoordinateType() != 2 || chartRenderInfo.secLayer.getCoordinateType() == 2) && (chartRenderInfo.primLayer.getCoordinateType() == 2 || chartRenderInfo.secLayer.getCoordinateType() != 2);
    }

    public static boolean isPie(ChartDefinition chartDefinition) {
        ChartRenderInfo chartRenderInfo = new ChartRenderInfo();
        chartDefinition.getCoordinateInfo(chartRenderInfo);
        return chartRenderInfo.primLayer != null && chartRenderInfo.primLayer.getCoordinateType() == 0;
    }

    static {
        CHART_PATTERN_LIST_EDITOR.put("GaugeNormalColor", new Integer(0));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternTransparency", new Integer(1));
        CHART_PATTERN_LIST_EDITOR.put("MeanLineType", new Integer(2));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelEveryNTickMarks", new Integer(3));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternColor", new Integer(4));
        CHART_PATTERN_LIST_EDITOR.put("AxisXShowTickMarkLabels", new Integer(5));
        CHART_PATTERN_LIST_EDITOR.put("Perspective", new Integer(6));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientStartColor", new Integer(7));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternImageLayout", new Integer(8));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternImageY", new Integer(9));
        CHART_PATTERN_LIST_EDITOR.put("border-top-color", new Integer(10));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternImageX", new Integer(11));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2ShowGrid", new Integer(12));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternTextureBackColor", new Integer(13));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenVariabledDash", new Integer(14));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelAxisGap", new Integer(15));
        CHART_PATTERN_LIST_EDITOR.put("border-bottom-color", new Integer(16));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternType", new Integer(17));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenVariabledDash", new Integer(18));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextShearing", new Integer(19));
        CHART_PATTERN_LIST_EDITOR.put("position", new Integer(20));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextSpecialEffect2", new Integer(21));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextSpecialEffect1", new Integer(22));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextShearing", new Integer(23));
        CHART_PATTERN_LIST_EDITOR.put("HintTextFontName", new Integer(24));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelStartValue", new Integer(25));
        CHART_PATTERN_LIST_EDITOR.put("RowIndex", new Integer(26));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternImageHeight", new Integer(27));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelStartValue", new Integer(28));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenVariabledDash", new Integer(29));
        CHART_PATTERN_LIST_EDITOR.put("AxisYNumOfTickMarks", new Integer(30));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenVariabledDash", new Integer(31));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenEndCaps", new Integer(32));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenTransparency", new Integer(33));
        CHART_PATTERN_LIST_EDITOR.put("RightLine", new Integer(34));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenThickness", new Integer(35));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientStartColor", new Integer(36));
        CHART_PATTERN_LIST_EDITOR.put("HintTextShearing", new Integer(37));
        CHART_PATTERN_LIST_EDITOR.put("LeftMargin", new Integer(38));
        CHART_PATTERN_LIST_EDITOR.put("FillThreshold", new Integer(39));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientStyle", new Integer(40));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientStyle", new Integer(41));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternTextureStyle", new Integer(42));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenColor", new Integer(43));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientEndY", new Integer(44));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientEndX", new Integer(45));
        CHART_PATTERN_LIST_EDITOR.put("TopLine", new Integer(46));
        CHART_PATTERN_LIST_EDITOR.put("ShowAxisZ", new Integer(47));
        CHART_PATTERN_LIST_EDITOR.put("ShowAxisY", new Integer(48));
        CHART_PATTERN_LIST_EDITOR.put("dataSet", new Integer(49));
        CHART_PATTERN_LIST_EDITOR.put("ShowAxisX", new Integer(50));
        CHART_PATTERN_LIST_EDITOR.put("ChildStyle", new Integer(51));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenTransparency", new Integer(52));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternType", new Integer(53));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternTextureStyle", new Integer(54));
        CHART_PATTERN_LIST_EDITOR.put("RadarIsShowColumnName", new Integer(55));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenTransparency", new Integer(56));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternTextureBackColor", new Integer(57));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenTransparency", new Integer(58));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelAxisGap", new Integer(59));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternTextureForeColor", new Integer(60));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextRotation", new Integer(61));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenTransparency", new Integer(62));
        CHART_PATTERN_LIST_EDITOR.put("RadarIsFill", new Integer(63));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelEveryNTickMarks", new Integer(64));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenTransparency", new Integer(65));
        CHART_PATTERN_LIST_EDITOR.put("Use3DEffect", new Integer(66));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternImageWidth", new Integer(67));
        CHART_PATTERN_LIST_EDITOR.put("BottomLine", new Integer(68));
        CHART_PATTERN_LIST_EDITOR.put("Name_", new Integer(69));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenThickness", new Integer(70));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenEndCaps", new Integer(71));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenThickness", new Integer(72));
        CHART_PATTERN_LIST_EDITOR.put("ShowMeanLine", new Integer(73));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenVariabledDash", new Integer(74));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternImageLayout", new Integer(75));
        CHART_PATTERN_LIST_EDITOR.put("LineNodeStyle", new Integer(76));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenStyle", new Integer(77));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenEndCaps", new Integer(78));
        CHART_PATTERN_LIST_EDITOR.put("RadarFillTransparence", new Integer(79));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientEndColor", new Integer(80));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternType", new Integer(81));
        CHART_PATTERN_LIST_EDITOR.put("AxisXMaxValue", new Integer(82));
        CHART_PATTERN_LIST_EDITOR.put("AngleZ", new Integer(83));
        CHART_PATTERN_LIST_EDITOR.put("AngleY", new Integer(84));
        CHART_PATTERN_LIST_EDITOR.put("AngleX", new Integer(85));
        CHART_PATTERN_LIST_EDITOR.put("GaugeErrorValueMax", new Integer(86));
        CHART_PATTERN_LIST_EDITOR.put("RTFID", new Integer(87));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenLineJoint", new Integer(88));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenStyle", new Integer(89));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientStyle", new Integer(90));
        CHART_PATTERN_LIST_EDITOR.put("DisplayName", new Integer(91));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenThickness", new Integer(92));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenThickness", new Integer(93));
        CHART_PATTERN_LIST_EDITOR.put("HintTextWordWrap", new Integer(94));
        CHART_PATTERN_LIST_EDITOR.put("ExportToXLS", new Integer(95));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenLineJoint", new Integer(96));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenStyle", new Integer(97));
        CHART_PATTERN_LIST_EDITOR.put("Width", new Integer(98));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenTransparency", new Integer(99));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarLayout", new Integer(100));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialStartAngle", new Integer(101));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenOutlined", new Integer(102));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenOutlined", new Integer(103));
        CHART_PATTERN_LIST_EDITOR.put("ThresholdLineColor2", new Integer(104));
        CHART_PATTERN_LIST_EDITOR.put("ColumnIndex", new Integer(105));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenThickness", new Integer(106));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkType", new Integer(107));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelAxisGap", new Integer(108));
        CHART_PATTERN_LIST_EDITOR.put("class", new Integer(109));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternTextureBackColor", new Integer(110));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenStyle", new Integer(111));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientStartColor", new Integer(112));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkLength", new Integer(113));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenColor", new Integer(114));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientStartColor", new Integer(115));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternTextureForeColor", new Integer(116));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextFontStyle", new Integer(117));
        CHART_PATTERN_LIST_EDITOR.put("ShadowColor", new Integer(118));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextRotation", new Integer(119));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextRotation", new Integer(120));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextFontName", new Integer(121));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternImageY", new Integer(122));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternImageX", new Integer(123));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternTextureBackColor", new Integer(124));
        CHART_PATTERN_LIST_EDITOR.put("AnchorDispValue", new Integer(125));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientEndY", new Integer(126));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenTransparency", new Integer(127));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientEndX", new Integer(128));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientStartY", new Integer(129));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientStartX", new Integer(130));
        CHART_PATTERN_LIST_EDITOR.put("ThresholdLineStyle", new Integer(131));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialLineArrowStyle", new Integer(132));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextShearing", new Integer(133));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientEndY", new Integer(134));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientEndX", new Integer(135));
        CHART_PATTERN_LIST_EDITOR.put("AxisZNumOfLabels", new Integer(136));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenColor", new Integer(137));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextUnderline", new Integer(138));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenThickness", new Integer(139));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenStyle", new Integer(140));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternColor", new Integer(141));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenStyle", new Integer(142));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenThickness", new Integer(143));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenVariabledDash", new Integer(144));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenThickness", new Integer(145));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenThickness", new Integer(146));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenOutlined", new Integer(147));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternType", new Integer(148));
        CHART_PATTERN_LIST_EDITOR.put("border-right-width", new Integer(149));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientEndColor", new Integer(150));
        CHART_PATTERN_LIST_EDITOR.put("TOCAnchor", new Integer(151));
        CHART_PATTERN_LIST_EDITOR.put("ShowFloor", new Integer(152));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundTop", new Integer(153));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenLineJoint", new Integer(154));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenVariabledDash", new Integer(155));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkLength", new Integer(156));
        CHART_PATTERN_LIST_EDITOR.put("ReversePaintingOrder", new Integer(157));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternTransparency", new Integer(158));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenLineJoint", new Integer(159));
        CHART_PATTERN_LIST_EDITOR.put("SuppressZeroLabel", new Integer(160));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenThickness", new Integer(161));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenOutlined", new Integer(162));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenThickness", new Integer(163));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenEndCaps", new Integer(164));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternTextureStyle", new Integer(165));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenColor", new Integer(166));
        CHART_PATTERN_LIST_EDITOR.put("UseDropline", new Integer(167));
        CHART_PATTERN_LIST_EDITOR.put("Interactive", new Integer(168));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenVariabledDash", new Integer(169));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenThickness", new Integer(170));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundLeft", new Integer(171));
        CHART_PATTERN_LIST_EDITOR.put("ShowPieName", new Integer(172));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenOutlined", new Integer(173));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderStyle", new Integer(174));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenStyle", new Integer(175));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenEndCaps", new Integer(176));
        CHART_PATTERN_LIST_EDITOR.put("padding-top", new Integer(177));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenOutlined", new Integer(178));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenTransparency", new Integer(179));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenOutlined", new Integer(180));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenEndCaps", new Integer(181));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenStyle", new Integer(182));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextWordWrap", new Integer(183));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternTextureStyle", new Integer(184));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenLineJoint", new Integer(185));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientStyle", new Integer(186));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenOutlined", new Integer(187));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternColor", new Integer(188));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelAxisGap", new Integer(189));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenTransparency", new Integer(190));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPlacement", new Integer(191));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenEndCaps", new Integer(192));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternImageY", new Integer(193));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternImageX", new Integer(194));
        CHART_PATTERN_LIST_EDITOR.put("Shadow", new Integer(195));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2NumOfLabels", new Integer(196));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternColor", new Integer(197));
        CHART_PATTERN_LIST_EDITOR.put("RunTimeInstName", new Integer(198));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenColor", new Integer(199));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenVariabledDash", new Integer(200));
        CHART_PATTERN_LIST_EDITOR.put("ExportToCSV", new Integer(201));
        CHART_PATTERN_LIST_EDITOR.put("AxisXShowGrid", new Integer(202));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkLength", new Integer(203));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenColor", new Integer(204));
        CHART_PATTERN_LIST_EDITOR.put("PieGap", new Integer(205));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternTextureBackColor", new Integer(206));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2MinorTickMarkLength", new Integer(207));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternType", new Integer(208));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenVariabledDash", new Integer(209));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientEndColor", new Integer(210));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternType", new Integer(211));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2MaxValue", new Integer(212));
        CHART_PATTERN_LIST_EDITOR.put("ExternalCSSClassValue", new Integer(213));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientStartY", new Integer(214));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientStartX", new Integer(215));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternImageWidth", new Integer(216));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenLineJoint", new Integer(217));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenEndCaps", new Integer(218));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientStartColor", new Integer(219));
        CHART_PATTERN_LIST_EDITOR.put("border-right-color", new Integer(220));
        CHART_PATTERN_LIST_EDITOR.put("TopMargin", new Integer(221));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2IsBestEffort", new Integer(222));
        CHART_PATTERN_LIST_EDITOR.put("ShowThresholdLine2", new Integer(223));
        CHART_PATTERN_LIST_EDITOR.put("Height", new Integer(224));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenColor", new Integer(225));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelEveryNTickMarks", new Integer(226));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenVariabledDash", new Integer(227));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenOutlined", new Integer(228));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextFontName", new Integer(229));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientStartY", new Integer(230));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenVariabledDash", new Integer(231));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientStartX", new Integer(232));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenStyle", new Integer(233));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenOutlined", new Integer(234));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenLineJoint", new Integer(235));
        CHART_PATTERN_LIST_EDITOR.put("HintTextUnderline", new Integer(236));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenEndCaps", new Integer(237));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternTransparency", new Integer(238));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenLineJoint", new Integer(239));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenTransparency", new Integer(240));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialOuterInnerGap", new Integer(241));
        CHART_PATTERN_LIST_EDITOR.put("UseDepth", new Integer(242));
        CHART_PATTERN_LIST_EDITOR.put("ThresholdValue", new Integer(243));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientEndY", new Integer(244));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientEndX", new Integer(245));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternTransparency", new Integer(246));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternTransparency", new Integer(247));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternImageLayout", new Integer(248));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientEndColor", new Integer(249));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientEndColor", new Integer(250));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternColor", new Integer(251));
        CHART_PATTERN_LIST_EDITOR.put("RadiusRange", new Integer(252));
        CHART_PATTERN_LIST_EDITOR.put("HintTextFontSize", new Integer(253));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextStrikethrough", new Integer(254));
        CHART_PATTERN_LIST_EDITOR.put("GaugeNormalValueMin", new Integer(255));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternTextureForeColor", new Integer(256));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenOutlined", new Integer(257));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenLineJoint", new Integer(258));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenVariabledDash", new Integer(259));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenOutlined", new Integer(260));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientEndY", new Integer(261));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientEndX", new Integer(262));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextStrikethrough", new Integer(263));
        CHART_PATTERN_LIST_EDITOR.put("dataInherit", new Integer(264));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenColor", new Integer(265));
        CHART_PATTERN_LIST_EDITOR.put("AxisXUseLabelStartValue", new Integer(266));
        CHART_PATTERN_LIST_EDITOR.put("AxisYNumOfLabels", new Integer(267));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenEndCaps", new Integer(268));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenTransparency", new Integer(269));
        CHART_PATTERN_LIST_EDITOR.put("padding-left", new Integer(270));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenOutlined", new Integer(271));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternTextureBackColor", new Integer(272));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenVariabledDash", new Integer(273));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenVariabledDash", new Integer(274));
        CHART_PATTERN_LIST_EDITOR.put("AxisYMinorTickMarkLength", new Integer(275));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenLineJoint", new Integer(276));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkType", new Integer(277));
        CHART_PATTERN_LIST_EDITOR.put("AxisXIncrement", new Integer(278));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundRight", new Integer(279));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternColor", new Integer(280));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextFontName", new Integer(281));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextFontStyle", new Integer(282));
        CHART_PATTERN_LIST_EDITOR.put("BorderWidth", new Integer(283));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextFontName", new Integer(284));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenVariabledDash", new Integer(285));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenColor", new Integer(286));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextWordWrap", new Integer(287));
        CHART_PATTERN_LIST_EDITOR.put("refMode", new Integer(288));
        CHART_PATTERN_LIST_EDITOR.put("StyleName", new Integer(289));
        CHART_PATTERN_LIST_EDITOR.put("AxisYMaxValue", new Integer(290));
        CHART_PATTERN_LIST_EDITOR.put("UDOName", new Integer(291));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternType", new Integer(292));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternTransparency", new Integer(293));
        CHART_PATTERN_LIST_EDITOR.put("ShowTips", new Integer(294));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenStyle", new Integer(295));
        CHART_PATTERN_LIST_EDITOR.put("GraphPosition", new Integer(296));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelEveryNTickMarks", new Integer(297));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenOutlined", new Integer(298));
        CHART_PATTERN_LIST_EDITOR.put("AxisZShowGrid", new Integer(299));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2ShowTickMarkLabels", new Integer(300));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenThickness", new Integer(301));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenColor", new Integer(302));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2Increment", new Integer(303));
        CHART_PATTERN_LIST_EDITOR.put("ShowWall", new Integer(304));
        CHART_PATTERN_LIST_EDITOR.put("AxisZIsBestEffort", new Integer(305));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenStyle", new Integer(306));
        CHART_PATTERN_LIST_EDITOR.put("ValueLabelType", new Integer(307));
        CHART_PATTERN_LIST_EDITOR.put("BarDepth", new Integer(308));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientStyle", new Integer(309));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternTextureForeColor", new Integer(310));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenOutlined", new Integer(311));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternTextureStyle", new Integer(312));
        CHART_PATTERN_LIST_EDITOR.put("HintTextSpecialEffect2", new Integer(313));
        CHART_PATTERN_LIST_EDITOR.put("HintTextSpecialEffect1", new Integer(314));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternTextureBackColor", new Integer(315));
        CHART_PATTERN_LIST_EDITOR.put("FillTransparent", new Integer(316));
        CHART_PATTERN_LIST_EDITOR.put("AxisXMinValue", new Integer(317));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientStartY", new Integer(318));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternImageFile", new Integer(319));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientStartX", new Integer(320));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2NumOfTickMarks", new Integer(321));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenColor", new Integer(322));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenVariabledDash", new Integer(323));
        CHART_PATTERN_LIST_EDITOR.put("GaugeErrorColor", new Integer(324));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextWordWrap", new Integer(325));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientEndColor", new Integer(326));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenLineJoint", new Integer(327));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternImageFile", new Integer(328));
        CHART_PATTERN_LIST_EDITOR.put("Style", new Integer(329));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextWordWrap", new Integer(330));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextFontSize", new Integer(331));
        CHART_PATTERN_LIST_EDITOR.put("margin-left", new Integer(332));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenStyle", new Integer(333));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternColor", new Integer(334));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenVariabledDash", new Integer(335));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternTransparency", new Integer(336));
        CHART_PATTERN_LIST_EDITOR.put("GaugeNormalValueMax", new Integer(337));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenColor", new Integer(338));
        CHART_PATTERN_LIST_EDITOR.put("BorderColor", new Integer(339));
        CHART_PATTERN_LIST_EDITOR.put("Background", new Integer(340));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenLineJoint", new Integer(341));
        CHART_PATTERN_LIST_EDITOR.put("ThresholdValue2", new Integer(342));
        CHART_PATTERN_LIST_EDITOR.put("RotationMatrix", new Integer(343));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenColor", new Integer(344));
        CHART_PATTERN_LIST_EDITOR.put("AxisYIsBestEffort", new Integer(345));
        CHART_PATTERN_LIST_EDITOR.put("id", new Integer(346));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientStartY", new Integer(347));
        CHART_PATTERN_LIST_EDITOR.put("margin-top", new Integer(348));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientStartX", new Integer(349));
        CHART_PATTERN_LIST_EDITOR.put("display", new Integer(350));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternTransparency", new Integer(351));
        CHART_PATTERN_LIST_EDITOR.put("StockUpBarColor", new Integer(352));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternImageWidth", new Integer(353));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternTextureBackColor", new Integer(354));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialLineStyle", new Integer(355));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternTextureStyle", new Integer(356));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBorderPenThickness", new Integer(357));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenColor", new Integer(358));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenStyle", new Integer(359));
        CHART_PATTERN_LIST_EDITOR.put("ValueLabelPositionList", new Integer(360));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenStyle", new Integer(361));
        CHART_PATTERN_LIST_EDITOR.put("HintTextFontStyle", new Integer(362));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialCurveIsFill", new Integer(363));
        CHART_PATTERN_LIST_EDITOR.put("ObjectIndex", new Integer(364));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenVariabledDash", new Integer(365));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternImageHeight", new Integer(366));
        CHART_PATTERN_LIST_EDITOR.put("Suppressed", new Integer(367));
        CHART_PATTERN_LIST_EDITOR.put("VerticalMargin", new Integer(368));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternTextureStyle", new Integer(369));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternTextureForeColor", new Integer(370));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundBottom", new Integer(371));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextSpecialEffect2", new Integer(372));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextSpecialEffect1", new Integer(373));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternType", new Integer(374));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternTextureStyle", new Integer(375));
        CHART_PATTERN_LIST_EDITOR.put("AxisYUseLabelStartValue", new Integer(376));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenThickness", new Integer(377));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenTransparency", new Integer(378));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientStyle", new Integer(379));
        CHART_PATTERN_LIST_EDITOR.put("RightMargin", new Integer(380));
        CHART_PATTERN_LIST_EDITOR.put("AxisXNumOfLabels", new Integer(381));
        CHART_PATTERN_LIST_EDITOR.put("RecordLocation", new Integer(382));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenLineJoint", new Integer(383));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternTextureStyle", new Integer(384));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenTransparency", new Integer(385));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenTransparency", new Integer(386));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientEndY", new Integer(387));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenOutlined", new Integer(388));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientEndX", new Integer(389));
        CHART_PATTERN_LIST_EDITOR.put("LineNodeWidth", new Integer(390));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenThickness", new Integer(391));
        CHART_PATTERN_LIST_EDITOR.put("AxisYShowGrid", new Integer(392));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenStyle", new Integer(393));
        CHART_PATTERN_LIST_EDITOR.put("AxisXIsBestEffort", new Integer(394));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenTransparency", new Integer(395));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternGradientEndColor", new Integer(396));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternColor", new Integer(397));
        CHART_PATTERN_LIST_EDITOR.put("AxisYMinorTickMarkType", new Integer(398));
        CHART_PATTERN_LIST_EDITOR.put("UDORenderName", new Integer(399));
        CHART_PATTERN_LIST_EDITOR.put("GaugeAlertValueMin", new Integer(400));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientStartColor", new Integer(401));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextUnderline", new Integer(402));
        CHART_PATTERN_LIST_EDITOR.put("ShowThresholdLine", new Integer(403));
        CHART_PATTERN_LIST_EDITOR.put("margin-right", new Integer(404));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextUnderline", new Integer(405));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkType", new Integer(406));
        CHART_PATTERN_LIST_EDITOR.put("Contour", new Integer(407));
        CHART_PATTERN_LIST_EDITOR.put("LineNodeHeight", new Integer(408));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenLineJoint", new Integer(409));
        CHART_PATTERN_LIST_EDITOR.put("HintTextStrikethrough", new Integer(410));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenTransparency", new Integer(411));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextSpecialEffect2", new Integer(412));
        CHART_PATTERN_LIST_EDITOR.put("Alignment", new Integer(413));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextSpecialEffect1", new Integer(414));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternTextureForeColor", new Integer(415));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternTextureForeColor", new Integer(416));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenVariabledDash", new Integer(417));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientStyle", new Integer(418));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenEndCaps", new Integer(419));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenEndCaps", new Integer(420));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenThickness", new Integer(421));
        CHART_PATTERN_LIST_EDITOR.put("padding-bottom", new Integer(422));
        CHART_PATTERN_LIST_EDITOR.put("z-order", new Integer(423));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextStrikethrough", new Integer(424));
        CHART_PATTERN_LIST_EDITOR.put("border-left-width", new Integer(425));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPlacement", new Integer(426));
        CHART_PATTERN_LIST_EDITOR.put("UDOResultName", new Integer(427));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenOutlined", new Integer(428));
        CHART_PATTERN_LIST_EDITOR.put("StockDownBarColor", new Integer(429));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenEndCaps", new Integer(430));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenTransparency", new Integer(431));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenStyle", new Integer(432));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenLineJoint", new Integer(433));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelStartValue", new Integer(434));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenLineJoint", new Integer(435));
        CHART_PATTERN_LIST_EDITOR.put("WebStyleName", new Integer(436));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternImageHeight", new Integer(437));
        CHART_PATTERN_LIST_EDITOR.put("HintTextRotation", new Integer(438));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPlacement", new Integer(439));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextFontSize", new Integer(440));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternGradientStartColor", new Integer(441));
        CHART_PATTERN_LIST_EDITOR.put("AxisYShowTickMarkLabels", new Integer(442));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkLength", new Integer(443));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientEndY", new Integer(444));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientEndX", new Integer(445));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientStartColor", new Integer(446));
        CHART_PATTERN_LIST_EDITOR.put("LineThickness", new Integer(447));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternColor", new Integer(448));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2MinValue", new Integer(449));
        CHART_PATTERN_LIST_EDITOR.put("VaryColorByValues", new Integer(450));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenOutlined", new Integer(451));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternTextureBackColor", new Integer(452));
        CHART_PATTERN_LIST_EDITOR.put("RotationMode", new Integer(453));
        CHART_PATTERN_LIST_EDITOR.put("ExportToDHTML", new Integer(454));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenLineJoint", new Integer(455));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientEndY", new Integer(456));
        CHART_PATTERN_LIST_EDITOR.put("StockLineColor", new Integer(457));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientEndX", new Integer(458));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenStyle", new Integer(459));
        CHART_PATTERN_LIST_EDITOR.put("ContourPenOutlined", new Integer(460));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkType", new Integer(461));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenEndCaps", new Integer(462));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternImageFile", new Integer(463));
        CHART_PATTERN_LIST_EDITOR.put("BarGap", new Integer(464));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientEndY", new Integer(465));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientEndX", new Integer(466));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenTransparency", new Integer(467));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2TickMarkPenEndCaps", new Integer(468));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenEndCaps", new Integer(469));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientStyle", new Integer(470));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientEndColor", new Integer(471));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenEndCaps", new Integer(472));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenColor", new Integer(473));
        CHART_PATTERN_LIST_EDITOR.put("RadarArrowStyle", new Integer(474));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientEndY", new Integer(475));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientEndX", new Integer(476));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientStartY", new Integer(477));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenOutlined", new Integer(478));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientStartX", new Integer(479));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenColor", new Integer(480));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternTextureForeColor", new Integer(481));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenLineJoint", new Integer(482));
        CHART_PATTERN_LIST_EDITOR.put("HorizontalMargin", new Integer(483));
        CHART_PATTERN_LIST_EDITOR.put("FloorBorderPenEndCaps", new Integer(484));
        CHART_PATTERN_LIST_EDITOR.put("SuppressedIfNoRecords", new Integer(485));
        CHART_PATTERN_LIST_EDITOR.put("AxisYGridPenStyle", new Integer(486));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenColor", new Integer(487));
        CHART_PATTERN_LIST_EDITOR.put("LeftLine", new Integer(488));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenLineJoint", new Integer(489));
        CHART_PATTERN_LIST_EDITOR.put("clear", new Integer(490));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternTextureForeColor", new Integer(491));
        CHART_PATTERN_LIST_EDITOR.put("padding-right", new Integer(492));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialCurveStyle", new Integer(493));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenThickness", new Integer(494));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenVariabledDash", new Integer(495));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientStartY", new Integer(496));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextFontSize", new Integer(497));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientStartX", new Integer(498));
        CHART_PATTERN_LIST_EDITOR.put("GaugeBarPenLineJoint", new Integer(499));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextFontSize", new Integer(500));
        CHART_PATTERN_LIST_EDITOR.put("border-left-color", new Integer(501));
        CHART_PATTERN_LIST_EDITOR.put("WebStyleGroup", new Integer(502));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenTransparency", new Integer(503));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPatternType", new Integer(504));
        CHART_PATTERN_LIST_EDITOR.put("FillThreshold2", new Integer(505));
        CHART_PATTERN_LIST_EDITOR.put("AxisZTickMarkPenColor", new Integer(506));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientStartY", new Integer(507));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextStrikethrough", new Integer(508));
        CHART_PATTERN_LIST_EDITOR.put("GaugeAlertValueMax", new Integer(509));
        CHART_PATTERN_LIST_EDITOR.put("FloorFillPatternGradientStartX", new Integer(510));
        CHART_PATTERN_LIST_EDITOR.put("BarDepthDirection", new Integer(511));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenEndCaps", new Integer(512));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenEndCaps", new Integer(513));
        CHART_PATTERN_LIST_EDITOR.put("AxisXTickMarkPenStyle", new Integer(514));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextSpecialEffect2", new Integer(515));
        CHART_PATTERN_LIST_EDITOR.put("AxisXMinorTickMarkType", new Integer(516));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextSpecialEffect1", new Integer(517));
        CHART_PATTERN_LIST_EDITOR.put("float", new Integer(518));
        CHART_PATTERN_LIST_EDITOR.put("margin-bottom", new Integer(519));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenLineJoint", new Integer(520));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientStyle", new Integer(521));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextPenLineJoint", new Integer(522));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenTransparency", new Integer(523));
        CHART_PATTERN_LIST_EDITOR.put("MeanLineColor", new Integer(524));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2PenEndCaps", new Integer(525));
        CHART_PATTERN_LIST_EDITOR.put("border-top-width", new Integer(526));
        CHART_PATTERN_LIST_EDITOR.put("BarWidth", new Integer(527));
        CHART_PATTERN_LIST_EDITOR.put("ThresholdLineColor", new Integer(528));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2Placement", new Integer(529));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternTextureBackColor", new Integer(530));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenTransparency", new Integer(531));
        CHART_PATTERN_LIST_EDITOR.put("border-bottom-width", new Integer(532));
        CHART_PATTERN_LIST_EDITOR.put("AxisXGridPenStyle", new Integer(533));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenOutlined", new Integer(534));
        CHART_PATTERN_LIST_EDITOR.put("BottomMargin", new Integer(535));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPenColor", new Integer(536));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextRotation", new Integer(537));
        CHART_PATTERN_LIST_EDITOR.put("AxisYIncrement", new Integer(538));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenColor", new Integer(539));
        CHART_PATTERN_LIST_EDITOR.put("AxisYMinValue", new Integer(540));
        CHART_PATTERN_LIST_EDITOR.put("AxisXPenStyle", new Integer(541));
        CHART_PATTERN_LIST_EDITOR.put("Y", new Integer(542));
        CHART_PATTERN_LIST_EDITOR.put("MeanLineNodeStyle", new Integer(543));
        CHART_PATTERN_LIST_EDITOR.put("X", new Integer(544));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextShearing", new Integer(545));
        CHART_PATTERN_LIST_EDITOR.put("GaugeAlertColor", new Integer(546));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPatternColor", new Integer(547));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternTextureStyle", new Integer(548));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextUnderline", new Integer(549));
        CHART_PATTERN_LIST_EDITOR.put("WallFillPatternGradientStartColor", new Integer(550));
        CHART_PATTERN_LIST_EDITOR.put("AxisZMinorTickMarkLength", new Integer(551));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextPenOutlined", new Integer(552));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPenStyle", new Integer(553));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternGradientStyle", new Integer(554));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2GridPenVariabledDash", new Integer(555));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientStartY", new Integer(556));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternGradientStartX", new Integer(557));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2UseLabelStartValue", new Integer(558));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelTextFontStyle", new Integer(559));
        CHART_PATTERN_LIST_EDITOR.put("ShadowContents", new Integer(560));
        CHART_PATTERN_LIST_EDITOR.put("ShowAxisY2", new Integer(561));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPenThickness", new Integer(562));
        CHART_PATTERN_LIST_EDITOR.put("GaugeErrorValueMin", new Integer(563));
        CHART_PATTERN_LIST_EDITOR.put("Invisible", new Integer(564));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelTextFontStyle", new Integer(565));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternGradientEndColor", new Integer(566));
        CHART_PATTERN_LIST_EDITOR.put("GaugeDialStopAngle", new Integer(567));
        CHART_PATTERN_LIST_EDITOR.put("AxisYPenColor", new Integer(568));
        CHART_PATTERN_LIST_EDITOR.put("ScaleZ", new Integer(569));
        CHART_PATTERN_LIST_EDITOR.put("ScaleY", new Integer(570));
        CHART_PATTERN_LIST_EDITOR.put("ScaleX", new Integer(571));
        CHART_PATTERN_LIST_EDITOR.put("WallBorderPenEndCaps", new Integer(572));
        CHART_PATTERN_LIST_EDITOR.put("FloorBoundFillPatternTextureForeColor", new Integer(573));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternTransparency", new Integer(574));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2MinorTickMarkType", new Integer(575));
        CHART_PATTERN_LIST_EDITOR.put("AxisZPenThickness", new Integer(576));
        CHART_PATTERN_LIST_EDITOR.put("AxisZMinorTickMarkType", new Integer(577));
        CHART_PATTERN_LIST_EDITOR.put("AxisXNumOfTickMarks", new Integer(578));
        CHART_PATTERN_LIST_EDITOR.put("AxisXMinorTickMarkLength", new Integer(579));
        CHART_PATTERN_LIST_EDITOR.put("AxisYTickMarkPenColor", new Integer(580));
        CHART_PATTERN_LIST_EDITOR.put("HintTextPatternTransparency", new Integer(581));
        CHART_PATTERN_LIST_EDITOR.put("SectionExplodeGap", new Integer(582));
        CHART_PATTERN_LIST_EDITOR.put("AxisZGridPenThickness", new Integer(583));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelTextPatternGradientStartColor", new Integer(584));
        CHART_PATTERN_LIST_EDITOR.put("AxisZShowTickMarkLabels", new Integer(585));
        CHART_PATTERN_LIST_EDITOR.put("PaperBackgroundFillPatternGradientEndColor", new Integer(586));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelTextPatternType", new Integer(587));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientStartY", new Integer(588));
        CHART_PATTERN_LIST_EDITOR.put("WallBoundFillPatternGradientStartX", new Integer(589));
        CHART_PATTERN_LIST_EDITOR.put("Lang", new Integer(590));
        CHART_PATTERN_LIST_EDITOR.put("ExternalStyle", new Integer(591));
        CHART_PATTERN_LIST_EDITOR.put("ExternalID", new Integer(592));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelFontAutomaticOrientation", new Integer(593));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelFontAutomaticOrientation", new Integer(594));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelFontAutomaticOrientation", new Integer(595));
        CHART_PATTERN_LIST_EDITOR.put("AxisZLabelFontAutomaticOrientation", new Integer(596));
        CHART_PATTERN_LIST_EDITOR.put("AxisXShowLabelTips", new Integer(597));
        CHART_PATTERN_LIST_EDITOR.put("AxisYShowLabelTips", new Integer(598));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2ShowLabelTips", new Integer(599));
        CHART_PATTERN_LIST_EDITOR.put("AxisZShowLabelTips", new Integer(600));
        CHART_PATTERN_LIST_EDITOR.put("ShowCategoryAndSeries", new Integer(601));
        CHART_PATTERN_LIST_EDITOR.put("AreaPatternList", new Integer(602));
        CHART_PATTERN_LIST_EDITOR.put("AxisXLabelPosition", new Integer(603));
        CHART_PATTERN_LIST_EDITOR.put("AxisYLabelPosition", new Integer(604));
        CHART_PATTERN_LIST_EDITOR.put("AxisY2LabelPosition", new Integer(605));
        GAUGE_BAR_LAYOUT_INTEGERS = new HashVector(6);
        String string = null;
        Vector<String> vector = null;
        string = "Geometry";
        vector = new Vector<String>(4);
        vector.add("X");
        vector.add("Y");
        vector.add("Width");
        vector.add("Height");
        GAUGE_BAR_LAYOUT_INTEGERS.put(string, vector);
        string = "Color";
        vector = new Vector(1);
        vector.add("Background");
        GAUGE_BAR_LAYOUT_INTEGERS.put(string, vector);
        string = "CSS";
        vector = new Vector(3);
        vector.add("Style");
        vector.add("class");
        vector.add("ExternalCSSClassValue");
        GAUGE_BAR_LAYOUT_INTEGERS.put(string, vector);
        string = "Others";
        vector = new Vector(8);
        vector.add("position");
        vector.add("ExportToDHTML");
        vector.add("Invisible");
        vector.add("Suppressed");
        vector.add("SuppressedIfNoRecords");
        vector.add("RecordLocation");
        vector.add("ExportToCSV");
        vector.add("ExportToXLS");
        GAUGE_BAR_LAYOUT_INTEGERS.put(string, vector);
        string = "Excel";
        vector = new Vector(2);
        vector.add("ColumnIndex");
        vector.add("RowIndex");
        GAUGE_BAR_LAYOUT_INTEGERS.put(string, vector);
        string = "Border";
        vector = new Vector(6);
        vector.add("BorderWidth");
        vector.add("TopLine");
        vector.add("BottomLine");
        vector.add("LeftLine");
        vector.add("RightLine");
        vector.add("BorderColor");
        GAUGE_BAR_LAYOUT_INTEGERS.put(string, vector);
    }
}

