/*
 * Decompiled with CFR 0.152.
 */
package jet.report.tabular;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetUnitNumber;
import jet.report.JetRptDataContainer;
import jet.report.tabular.JetRptColumnGroupSet;
import jet.report.tabular.JetRptGridColumn;
import jet.report.tabular.JetRptGridRow;
import jet.report.tabular.JetRptRowGroupSet;
import jet.report.tabular.JetRptTabularCell;
import jet.report.tabular.JetRptTabularColumns;
import jet.report.tabular.JetRptTabularRows;
import jet.reportLogic.objectLogic.tabularLogic.Columns;
import jet.reportLogic.objectLogic.tabularLogic.GridCell;
import jet.reportLogic.objectLogic.tabularLogic.GridColumn;
import jet.reportLogic.objectLogic.tabularLogic.GridRow;
import jet.reportLogic.objectLogic.tabularLogic.Rows;
import jet.reportLogic.objectLogic.tabularLogic.Tabular;
import jet.reportLogic.objectLogic.tabularLogic.TabularCell;
import jet.reportLogic.objectLogic.tabularLogic.TabularTree;
import jet.util.HashVector;
import jet.util.IntVector;

public class JetRptTabular
extends JetRptDataContainer {
    public static final int VBORDERSPACING = 0;
    public static final int HBORDERSPACING = 1;
    private Tabular QOIV = null;
    public JetNumber columnNumber;
    public JetNumber rowNumber;
    public JetBoolean verticalAutoSize;
    public JetBoolean horizontalAutoSize;
    public JetBoolean horizontal;
    public JetBoolean borderCollapse;
    public JetUnitNumber vBorderSpacing;
    public JetUnitNumber hBorderSpacing;
    private static final HashMap Z = new HashMap(73);
    private static final HashVector add;

    public JetRptTabular() {
        this.Z();
        this.setObjectType(46);
    }

    public void setEditable() {
        super.setEditable();
    }

    public void afterInit() {
        this.QOIV = this.parseTabularFrame();
        super.afterInit();
    }

    public int[] getBorderSpacing() {
        int[] nArray = new int[]{this.vBorderSpacing.getUnit(), this.hBorderSpacing.getUnit()};
        return nArray;
    }

    public void setBorderSpacing(int n, int n2) {
        this.vBorderSpacing.setUnitValue(n);
        this.hBorderSpacing.setUnitValue(n2);
    }

    public Tabular parseTabularFrame() {
        this.QOIV = new Tabular();
        this.QOIV.setBottomBorder(this.bottomBorderWidth.getUnit());
        this.QOIV.setTopBorder(this.topBorderWidth.getUnit());
        this.QOIV.setLeftBorder(this.leftBorderWidth.getUnit());
        this.QOIV.setRightBorder(this.rightBorderWidth.getUnit());
        int[] nArray = this.getBorderSpacing();
        Rows rows = this.QOIV.getRows();
        rows.vCellSpacing = nArray[0];
        JetRptTabularRows jetRptTabularRows = this.getTabularRows();
        Vector vector = jetRptTabularRows.getRptGridRows();
        int n = 0;
        while (n < vector.size()) {
            rows.add(new GridRow(((JetRptGridRow)vector.elementAt((int)n)).rowHeight.get()));
            ++n;
        }
        Columns columns = this.QOIV.getColumns();
        columns.hCellSpacing = nArray[1];
        JetRptTabularColumns jetRptTabularColumns = this.getTabularColumns();
        Vector vector2 = jetRptTabularColumns.getRptGridColumns();
        int n2 = 0;
        while (n2 < vector2.size()) {
            columns.add(new GridColumn(((JetRptGridColumn)vector2.elementAt((int)n2)).columnWidth.get()));
            ++n2;
        }
        JetRptTabularCell[] jetRptTabularCellArray = this.getTabularCells();
        int n3 = 0;
        while (n3 < jetRptTabularCellArray.length) {
            TabularCell tabularCell = new TabularCell(jetRptTabularCellArray[n3].getTabularCellId());
            this.QOIV.markAddress(tabularCell.getAddress());
            GridCell[] gridCellArray = this.getCells(jetRptTabularCellArray[n3]);
            int n4 = 0;
            while (n4 < gridCellArray.length) {
                tabularCell.addGridCell(gridCellArray[n4]);
                ++n4;
            }
            tabularCell.setSons(jetRptTabularCellArray[n3].getChildren());
            this.QOIV.addTabularCell(tabularCell);
            ++n3;
        }
        return this.QOIV;
    }

    public JetRptTabularRows getTabularRows() {
        JetRptTabularRows jetRptTabularRows = null;
        Vector vector = this.getChildren();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (vector.elementAt(n) instanceof JetRptTabularRows) {
                    jetRptTabularRows = (JetRptTabularRows)vector.elementAt(n);
                    break;
                }
                ++n;
            }
        }
        return jetRptTabularRows;
    }

    public JetRptTabularColumns getTabularColumns() {
        JetRptTabularColumns jetRptTabularColumns = null;
        Vector vector = this.getChildren();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (vector.elementAt(n) instanceof JetRptTabularColumns) {
                    jetRptTabularColumns = (JetRptTabularColumns)vector.elementAt(n);
                    break;
                }
                ++n;
            }
        }
        return jetRptTabularColumns;
    }

    public JetRptTabularCell[] getTabularCells() {
        Vector vector = this.getChildren();
        Vector vector2 = new Vector();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof JetRptTabularCell) {
                vector2.add(vector.elementAt(n));
            }
            ++n;
        }
        JetRptTabularCell[] jetRptTabularCellArray = new JetRptTabularCell[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            jetRptTabularCellArray[n2] = (JetRptTabularCell)vector2.elementAt(n2);
            ++n2;
        }
        return jetRptTabularCellArray;
    }

    public IntVector getIntIDTabularCells() {
        Vector vector = this.getChildren();
        IntVector intVector = new IntVector();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof JetRptTabularCell) {
                intVector.addElement(((JetRptTabularCell)vector.elementAt(n)).getTabularCellId());
            }
            ++n;
        }
        return intVector;
    }

    public JetRptRowGroupSet getRowGroupSet() {
        Vector vector = this.getChildren();
        JetRptRowGroupSet jetRptRowGroupSet = null;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof JetRptRowGroupSet) {
                jetRptRowGroupSet = (JetRptRowGroupSet)vector.elementAt(n);
                break;
            }
            ++n;
        }
        return jetRptRowGroupSet;
    }

    public JetRptColumnGroupSet getColumnGroupSet() {
        Vector vector = this.getChildren();
        JetRptColumnGroupSet jetRptColumnGroupSet = null;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof JetRptColumnGroupSet) {
                jetRptColumnGroupSet = (JetRptColumnGroupSet)vector.elementAt(n);
                break;
            }
            ++n;
        }
        return jetRptColumnGroupSet;
    }

    public Vector getColumnGroups() {
        return this.getColumnGroupSet().getChildren();
    }

    public Vector getRowGroups() {
        return this.getRowGroupSet().getChildren();
    }

    public Vector getTabularTree() {
        Vector<IntVector> vector = new Vector<IntVector>();
        TabularTree tabularTree = this.QOIV().generateTtree();
        int n = 0;
        while (n < tabularTree.getRowSize()) {
            IntVector intVector = tabularTree.getRow(n);
            vector.add(intVector);
            ++n;
        }
        return vector;
    }

    public String getRptCellInstName(int n) {
        return this.getInstName() + "@TCell" + n;
    }

    public JetRptTabularCell getTabularCell(String string) {
        Vector vector = this.getChildren();
        JetRptTabularCell jetRptTabularCell = null;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof JetRptTabularCell && (jetRptTabularCell = (JetRptTabularCell)vector.elementAt(n)).getInstName().equals(string)) break;
            ++n;
        }
        return jetRptTabularCell;
    }

    public JetRptTabularCell getTabularCell(int n) {
        Vector vector = this.getChildren();
        JetRptTabularCell jetRptTabularCell = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof JetRptTabularCell) {
                jetRptTabularCell = (JetRptTabularCell)vector.elementAt(n2);
                if (jetRptTabularCell.cellId.get() == n) break;
            }
            ++n2;
        }
        return jetRptTabularCell;
    }

    public int getAmountOfTabularCells() {
        return this.QOIV().getTabularCellAmount();
    }

    public GridCell[] getCells(JetRptTabularCell jetRptTabularCell) {
        int n = jetRptTabularCell.startX.get();
        int n2 = jetRptTabularCell.startY.get();
        int n3 = jetRptTabularCell.gridWidth.get();
        int n4 = jetRptTabularCell.gridHeight.get();
        GridCell[] gridCellArray = new GridCell[n3 * n4];
        int n5 = 0;
        int n6 = n;
        while (n6 < n + n3) {
            int n7 = n2;
            while (n7 < n2 + n4) {
                GridCell gridCell = new GridCell(n6, n7);
                gridCellArray[n5++] = gridCell;
                ++n7;
            }
            ++n6;
        }
        return gridCellArray;
    }

    private Tabular QOIV() {
        if (this.QOIV == null) {
            this.QOIV = this.parseTabularFrame();
        }
        return this.QOIV;
    }

    public void setTabularFrame(Tabular tabular) {
        this.QOIV = tabular;
    }

    public int getTabularHeight() {
        return this.QOIV().getTabulaHeight();
    }

    public int getTabularWidth() {
        return this.QOIV().getTabularWidth();
    }

    public int getTabularCellWidth(int n) {
        return this.QOIV().getTabularCellWidth(n);
    }

    public int getTabularCellHeight(int n) {
        return this.QOIV().getTabularCellHeight(n);
    }

    public int getTabualrCellHorizontalDistance(int n) {
        return this.QOIV().getTabualrCellHorizontalDistance(n);
    }

    public int getTabularCellVerticalDistance(int n) {
        return this.QOIV().getTabularCellVerticalDistance(n);
    }

    public int getGridCellHeightAt(int n) {
        return this.QOIV().getRows().getGridRowHeightAt(n);
    }

    public int getGridCellWidthAt(int n) {
        return this.QOIV().getColumns().getGridColumnWidthAt(n);
    }

    public String getInstancePrefix() {
        return "Tabular";
    }

    public HashMap getIndecialMap() {
        return Z;
    }

    private void Z() {
        this.columnNumber = new JetNumber(this, "columnNumber");
        this.rowNumber = new JetNumber(this, "rowNumber");
        this.verticalAutoSize = new JetBoolean(this, "VerticalAutoSize", true);
        this.horizontalAutoSize = new JetBoolean(this, "HorizontalAutoSize", false);
        this.horizontal = new JetBoolean(this, "Horizontal", false);
        this.borderCollapse = new JetBoolean(this, "border-collapse", false);
        this.vBorderSpacing = new JetUnitNumber(this, "VerticalBorderSpacing");
        this.hBorderSpacing = new JetUnitNumber(this, "HorizontalBorderSpacing");
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return add;
        }
        return null;
    }

    static {
        int n = 0;
        Z.put("border-bottom-width", new Integer(n++));
        Z.put("RTFID", new Integer(n++));
        Z.put("Suppressed", new Integer(n++));
        Z.put("SuppressedIfNoRecords", new Integer(n++));
        Z.put("ChildStyle", new Integer(n++));
        Z.put("AnchorDispValue", new Integer(n++));
        Z.put("padding-top", new Integer(n++));
        Z.put("UDORenderName", new Integer(n++));
        Z.put("ExportToXLS", new Integer(n++));
        Z.put("padding-bottom", new Integer(n++));
        Z.put("HorizontalBorderSpacing", new Integer(n++));
        Z.put("LeftLine", new Integer(n++));
        Z.put("ExportToCSV", new Integer(n++));
        Z.put("border-right-width", new Integer(n++));
        Z.put("DisplayName", new Integer(n++));
        Z.put("clear", new Integer(n++));
        Z.put("margin-right", new Integer(n++));
        Z.put("Width", new Integer(n++));
        Z.put("Shadow", new Integer(n++));
        Z.put("Horizontal", new Integer(n++));
        Z.put("Invisible", new Integer(n++));
        Z.put("BorderColor", new Integer(n++));
        Z.put("Background", new Integer(n++));
        Z.put("padding-left", new Integer(n++));
        Z.put("ObjectIndex", new Integer(n++));
        Z.put("columnNumber", new Integer(n++));
        Z.put("TopLine", new Integer(n++));
        Z.put("ShadowColor", new Integer(n++));
        Z.put("Y", new Integer(n++));
        Z.put("float", new Integer(n++));
        Z.put("X", new Integer(n++));
        Z.put("Alignment", new Integer(n++));
        Z.put("padding-right", new Integer(n++));
        Z.put("border-left-color", new Integer(n++));
        Z.put("border-top-color", new Integer(n++));
        Z.put("margin-top", new Integer(n++));
        Z.put("UDOName", new Integer(n++));
        Z.put("z-order", new Integer(n++));
        Z.put("BottomLine", new Integer(n++));
        Z.put("TOCAnchor", new Integer(n++));
        Z.put("refMode", new Integer(n++));
        Z.put("VerticalAutoSize", new Integer(n++));
        Z.put("margin-left", new Integer(n++));
        Z.put("Height", new Integer(n++));
        Z.put("BorderWidth", new Integer(n++));
        Z.put("margin-bottom", new Integer(n++));
        Z.put("rowNumber", new Integer(n++));
        Z.put("position", new Integer(n++));
        Z.put("border-left-width", new Integer(n++));
        Z.put("border-bottom-color", new Integer(n++));
        Z.put("Name_", new Integer(n++));
        Z.put("border-top-width", new Integer(n++));
        Z.put("ExternalCSSClassValue", new Integer(n++));
        Z.put("UDOResultName", new Integer(n++));
        Z.put("id", new Integer(n++));
        Z.put("Style", new Integer(n++));
        Z.put("RightLine", new Integer(n++));
        Z.put("RecordLocation", new Integer(n++));
        Z.put("WebStyleGroup", new Integer(n++));
        Z.put("HorizontalAutoSize", new Integer(n++));
        Z.put("dataInherit", new Integer(n++));
        Z.put("display", new Integer(n++));
        Z.put("border-right-color", new Integer(n++));
        Z.put("WebStyleName", new Integer(n++));
        Z.put("ColumnIndex", new Integer(n++));
        Z.put("RunTimeInstName", new Integer(n++));
        Z.put("VerticalBorderSpacing", new Integer(n++));
        Z.put("border-collapse", new Integer(n++));
        Z.put("StyleName", new Integer(n++));
        Z.put("dataSet", new Integer(n++));
        Z.put("class", new Integer(n++));
        Z.put("RowIndex", new Integer(n++));
        Z.put("ExportToDHTML", new Integer(n++));
        Z.put("Lang", new Integer(n++));
        Z.put("ExternalStyle", new Integer(n++));
        Z.put("ExternalID", new Integer(n++));
        add = new HashVector(6);
        String string = null;
        Vector<String> vector = null;
        string = "Geometry";
        vector = new Vector<String>(4);
        vector.add("X");
        vector.add("Y");
        vector.add("Width");
        vector.add("Height");
        add.put(string, vector);
        string = "Color";
        vector = new Vector(1);
        vector.add("Background");
        add.put(string, vector);
        string = "CSS";
        vector = new Vector(3);
        vector.add("Style");
        vector.add("class");
        vector.add("ExternalCSSClassValue");
        add.put(string, vector);
        string = "Others";
        vector = new Vector(8);
        vector.add("position");
        vector.add("ExportToDHTML");
        vector.add("Invisible");
        vector.add("Suppressed");
        vector.add("ExportToCSV");
        vector.add("ExportToXLS");
        vector.add("VerticalAutoSize");
        vector.add("HorizontalAutoSize");
        add.put(string, vector);
        string = "Excel";
        vector = new Vector(2);
        vector.add("ColumnIndex");
        vector.add("RowIndex");
        add.put(string, vector);
        string = "TOC";
        vector = new Vector(2);
        vector.add("TOCAnchor");
        vector.add("AnchorDispValue");
        add.put(string, vector);
    }
}

