/*
 * Decompiled with CFR 0.152.
 */
package jet.report.xls.chart;

import java.io.IOException;
import jet.report.xls.Biff;
import util.RandomAccessStream;

public class Chart3D
extends Biff {
    public static final short PERSPECTIVE = 1;
    public static final short CLUSTER = 2;
    public static final short AUTOSCALING = 4;
    public static final short WALLS = 32;
    short I;
    short QOIV;
    short output;
    short readShort;
    short writeShort;
    short Z;
    short C;

    public Chart3D() {
    }

    public Chart3D(short s, short s2, short s3, short s4, short s5, short s6, short s7) {
        this.I = s;
        this.QOIV = s2;
        this.output = s3;
        this.readShort = s4;
        this.writeShort = s5;
        this.Z = s6;
        this.C = s7;
        this.length = 14;
    }

    public final int opcode() {
        return 4154;
    }

    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        this.writeShort(randomAccessStream, this.I);
        this.writeShort(randomAccessStream, this.QOIV);
        this.writeShort(randomAccessStream, this.output);
        this.writeShort(randomAccessStream, this.readShort);
        this.writeShort(randomAccessStream, this.writeShort);
        this.writeShort(randomAccessStream, this.Z);
        this.writeShort(randomAccessStream, this.C);
        return this.length + 4;
    }

    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.I = this.readShort(randomAccessStream);
        this.QOIV = this.readShort(randomAccessStream);
        this.output = this.readShort(randomAccessStream);
        this.readShort = this.readShort(randomAccessStream);
        this.writeShort = this.readShort(randomAccessStream);
        this.Z = this.readShort(randomAccessStream);
        this.C = this.readShort(randomAccessStream);
    }

    public boolean isPerspective() {
        return (this.C & 1) == 1;
    }

    public void setPerspective(boolean bl) {
        this.C = (short)(bl ? this.C | 1 : this.C & 0xFFFFFFFE);
    }

    public boolean isCluster() {
        return (this.C & 2) == 2;
    }

    public void setCluster(boolean bl) {
        this.C = (short)(bl ? this.C | 2 : this.C & 0xFFFFFFFD);
    }

    public boolean isScaling() {
        return (this.C & 4) == 4;
    }

    public void setScaling(boolean bl) {
        this.C = (short)(bl ? this.C | 4 : this.C & 0xFFFFFFFB);
    }

    public boolean isWall() {
        return (this.C & 0x20) == 32;
    }

    public void setWall(boolean bl) {
        this.C = (short)(bl ? this.C | 0x20 : this.C & 0xFFFFFFDF);
    }
}

