/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.tabularLogic;

import java.util.ArrayList;
import jet.reportLogic.objectLogic.tabularLogic.GridColumn;
import jet.reportLogic.objectLogic.tabularLogic.Tabular;

public class Columns
extends ArrayList {
    public int hCellSpacing = 0;

    public Columns() {
    }

    public Columns(int n) {
        super(n);
        int n2 = 0;
        while (n2 < n) {
            this.add(new GridColumn());
            ++n2;
        }
    }

    public GridColumn getGridColumn(int n) {
        return (GridColumn)this.get(n);
    }

    public void setGridColumnWidthAt(int n, int n2) {
        this.getGridColumn(n).setWidth(n2);
    }

    public int getGridColumnWidthAt(int n) {
        return this.getGridColumn(n).getWidth();
    }

    public int getGridColumnWidthBetween(int n, int n2) {
        int n3 = 0;
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            int n4 = n;
            while (n4 <= n2) {
                n3 += this.getGridColumnWidthAt(n4);
                ++n4;
            }
            n3 += this.hCellSpacing * (n2 - n);
        }
        return n3;
    }

    public int getTotalWidth() {
        return this.getGridColumnWidthBetween(0, this.size() - 1) + this.hCellSpacing * 2;
    }

    public void deleteKeepTotalWidth(int n) {
        if (n >= -1 && n < this.size()) {
            GridColumn gridColumn = (GridColumn)this.remove(n);
            int n2 = this.size();
            if (n2 > 0) {
                int n3 = gridColumn.getWidth();
                this.resizeTotalWidth(n3 + this.hCellSpacing);
            }
        }
    }

    public void addKeepTotalWidth(int n, int n2) {
        if (n >= -1 && n <= this.size()) {
            if (n == -1) {
                this.add(new GridColumn(n2));
            } else {
                this.add(n, new GridColumn(n2));
            }
            this.resizeTotalWidth(-(n2 + this.hCellSpacing));
        }
    }

    public void resizeTotalWidth(int n) {
        this.resizeWidthBetween(0, this.size() - 1, n);
    }

    public void resizeWidthBetween(int n, int n2, int n3) {
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            int n4 = n2 - n + 1;
            int n5 = 0;
            if (n3 > 0) {
                block0: while (n3 >= Tabular.SCALE) {
                    int n6 = n;
                    while (n6 <= n2) {
                        n5 = this.getGridColumnWidthAt(n6) + Tabular.SCALE;
                        this.setGridColumnWidthAt(n6, n5);
                        if ((n3 -= Tabular.SCALE) < Tabular.SCALE) continue block0;
                        ++n6;
                    }
                }
            } else if (n3 < 0) {
                block2: while (n3 <= -Tabular.SCALE) {
                    int n7 = n;
                    while (n7 <= n2) {
                        n5 = this.getGridColumnWidthAt(n7) - Tabular.SCALE;
                        if (n5 < Tabular.DefaultMinGridCellLength) {
                            n5 = Tabular.DefaultMinGridCellLength;
                        }
                        this.setGridColumnWidthAt(n7, n5);
                        if ((n3 += Tabular.SCALE) > -Tabular.SCALE) continue block2;
                        ++n7;
                    }
                }
            }
            this.setGridColumnWidthAt(this.size() - 1, this.getGridColumnWidthAt(this.size() - 1) + n3);
        }
    }
}

