/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.report.JetRptReportBody;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSubReport;
import jet.report.tabular.JetRptTabular;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.engine.infocenter.SubReportInfo;
import jet.rptservice.engine.infocenter.SubRptShareInfo;
import jet.rptservice.engine.infocenter.SubRptShareInfoSet;

public class SubRptShareTool {
    public void initSubRptShareInfo(JetRptReport jetRptReport, ReportViewCenter reportViewCenter) {
        SubRptShareInfoSet subRptShareInfoSet = this.QOIV(jetRptReport, reportViewCenter);
        if (subRptShareInfoSet == null) {
            return;
        }
        SubRptShareInfo[] subRptShareInfoArray = subRptShareInfoSet.getAllSubRptShareInfos();
        int n = 0;
        while (n < subRptShareInfoArray.length) {
            int n2 = subRptShareInfoArray[n].getSubRptKey();
            SubReportInfo subReportInfo = reportViewCenter.getSubRptInfo(n2);
            subReportInfo.setShare(true);
            ++n;
        }
    }

    private SubRptShareInfoSet QOIV(JetRptReport jetRptReport, ReportViewCenter reportViewCenter) {
        JetRptReportBody jetRptReportBody = this.getChildren(jetRptReport);
        if (jetRptReportBody == null) {
            return null;
        }
        List list = this.addSubRptShareInfo(jetRptReportBody, reportViewCenter);
        SubRptShareInfoSet subRptShareInfoSet = this.getReportView(list);
        subRptShareInfoSet.removePseudShareInfos();
        return subRptShareInfoSet;
    }

    private SubRptShareInfoSet add(JetContainable jetContainable, ReportViewCenter reportViewCenter) {
        if (jetContainable instanceof JetRptSectionObject) {
            JetRptSectionObject jetRptSectionObject = (JetRptSectionObject)jetContainable;
            return this.booleanValue(jetRptSectionObject, reportViewCenter);
        }
        if (jetContainable instanceof JetRptSubReport) {
            JetRptSubReport jetRptSubReport = (JetRptSubReport)jetContainable;
            int n = jetRptSubReport.hashCode();
            SubReportInfo subReportInfo = reportViewCenter.getSubRptInfo(n);
            if (subReportInfo == null) {
                return new SubRptShareInfoSet();
            }
            String string = subReportInfo.getSubRptSetName();
            String string2 = subReportInfo.getSubRptName();
            SubRptShareInfo subRptShareInfo = new SubRptShareInfo(n, string, string2);
            SubRptShareInfoSet subRptShareInfoSet = this.get(jetRptSubReport, reportViewCenter);
            subRptShareInfoSet.addSubRptShareInfo(subRptShareInfo);
            return subRptShareInfoSet;
        }
        if (jetContainable instanceof JetRptTabular) {
            return new SubRptShareInfoSet();
        }
        List list = this.addSubRptShareInfo(jetContainable, reportViewCenter);
        SubRptShareInfoSet subRptShareInfoSet = this.getReportView(list);
        subRptShareInfoSet.removePseudShareInfos();
        return subRptShareInfoSet;
    }

    private List addSubRptShareInfo(JetContainable jetContainable, ReportViewCenter reportViewCenter) {
        Vector vector = jetContainable.getChildren();
        int n = vector == null ? 0 : vector.size();
        ArrayList<SubRptShareInfoSet> arrayList = new ArrayList<SubRptShareInfoSet>();
        int n2 = 0;
        while (n2 < n) {
            JetContainable jetContainable2;
            SubRptShareInfoSet subRptShareInfoSet;
            Object e = vector.get(n2);
            if (e instanceof JetContainable && !(subRptShareInfoSet = this.add(jetContainable2 = (JetContainable)e, reportViewCenter)).isEmpty()) {
                arrayList.add(subRptShareInfoSet);
            }
            ++n2;
        }
        return arrayList;
    }

    private SubRptShareInfoSet booleanValue(JetRptSectionObject jetRptSectionObject, ReportViewCenter reportViewCenter) {
        Object object;
        Vector vector = jetRptSectionObject.getSections();
        ArrayList<SubRptShareInfoSet> arrayList = new ArrayList<SubRptShareInfoSet>();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        while (n2 < n) {
            object = (JetRptSection)vector.get(n2);
            SubRptShareInfoSet subRptShareInfoSet = null;
            if (!(object == null || ((JetRptSection)object).underlay.isChangeByOther() || ((JetRptSection)object).underlay.booleanValue() || (subRptShareInfoSet = this.add((JetContainable)object, reportViewCenter)) == null || subRptShareInfoSet.isEmpty())) {
                arrayList.add(subRptShareInfoSet);
            }
            ++n2;
        }
        object = this.getRptSet(arrayList);
        return object;
    }

    private SubRptShareInfoSet get(JetRptSubReport jetRptSubReport, ReportViewCenter reportViewCenter) {
        JetRptReport jetRptReport = this.getAllSubRptShareInfos(jetRptSubReport, reportViewCenter);
        return this.QOIV(jetRptReport, reportViewCenter);
    }

    private JetRptReport getAllSubRptShareInfos(JetRptSubReport jetRptSubReport, ReportViewCenter reportViewCenter) {
        int n = jetRptSubReport.hashCode();
        SubReportInfo subReportInfo = reportViewCenter.getSubRptInfo(n);
        JetRptReportSet jetRptReportSet = subReportInfo.getRptSet();
        String string = subReportInfo.getSubRptName();
        String string2 = subReportInfo.getSubRptViewName();
        return jetRptReportSet.getReportView(string, string2);
    }

    private JetRptReportBody getChildren(JetRptReport jetRptReport) {
        Vector vector = jetRptReport.getChildren();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.get(n);
            if (e instanceof JetRptReportBody) {
                return (JetRptReportBody)e;
            }
            ++n;
        }
        return null;
    }

    private SubRptShareInfoSet getReportView(List list) {
        if (list.isEmpty()) {
            return new SubRptShareInfoSet();
        }
        SubRptShareInfoSet subRptShareInfoSet = (SubRptShareInfoSet)list.get(0);
        int n = 1;
        while (n < list.size()) {
            SubRptShareInfoSet subRptShareInfoSet2 = (SubRptShareInfoSet)list.get(n);
            subRptShareInfoSet = subRptShareInfoSet.uniteInABand(subRptShareInfoSet2);
            ++n;
        }
        return subRptShareInfoSet;
    }

    private SubRptShareInfoSet getRptSet(List list) {
        if (list.isEmpty()) {
            return new SubRptShareInfoSet();
        }
        SubRptShareInfoSet subRptShareInfoSet = (SubRptShareInfoSet)list.get(0);
        int n = 1;
        while (n < list.size()) {
            SubRptShareInfoSet subRptShareInfoSet2 = (SubRptShareInfoSet)list.get(n);
            subRptShareInfoSet = subRptShareInfoSet.unitAmongBands(subRptShareInfoSet2);
            ++n;
        }
        return subRptShareInfoSet;
    }
}

