/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import jet.textobj.CharsObj;
import jet.textobj.DLLBufable;
import jet.textobj.FieldDest;
import jet.textobj.Obj;
import jet.textobj.ObjTmpl;
import jet.textobj.ParObj;
import jet.textobj.RtfDest;
import jet.textobj.TextObj;
import jet.util.Assertion;
import jet.util.CharBuf;

public class ChrObj
extends TextObj {
    public int getTextSize() {
        Obj obj = (Obj)this.getHead();
        if (obj == null) {
            return 0;
        }
        if (obj.isObj("pict")) {
            return 1;
        }
        if (obj.isObj("field")) {
            return 1;
        }
        if (obj.isObj("chars")) {
            return ((CharsObj)obj).getTextSize();
        }
        throw new Assertion("unknown obj type:" + obj.getName());
    }

    public Obj deepClone(DLLBufable dLLBufable, boolean bl) {
        FieldDest fieldDest = this.getFldOwner();
        RtfDest rtfDest = null;
        if (dLLBufable == null || fieldDest == null || (rtfDest = ((Obj)((Object)dLLBufable)).I()) == null) {
            return super.deepClone(dLLBufable, bl);
        }
        FieldDest fieldDest2 = (FieldDest)fieldDest.deepClone(dLLBufable, bl);
        rtfDest.addFieldDest(fieldDest2);
        fieldDest2.setField(fieldDest2.getField());
        fieldDest2.insertTextToRtf((ParObj)dLLBufable, dLLBufable.size());
        return fieldDest2.getShowing();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.getOwner() != null) {
            stringBuffer.append(",ow:" + this.getOwner());
        }
        if (this.getFldOwner() != null) {
            stringBuffer.append(",fldow:" + this.getFldOwner());
        }
        return stringBuffer.toString();
    }

    public CharBuf getText() {
        Obj obj = (Obj)this.getHead();
        if (obj.isObj("chars")) {
            return ((CharsObj)obj).getText();
        }
        return new CharBuf();
    }

    public ChrObj split(int n) {
        if (!(this.getHead() instanceof CharsObj)) {
            return null;
        }
        CharsObj charsObj = (CharsObj)this.getHead();
        if (n == 0) {
            return null;
        }
        if (n == charsObj.getTextSize()) {
            return null;
        }
        CharsObj charsObj2 = charsObj.split(n);
        ChrObj chrObj = (ChrObj)this.shallowClone();
        chrObj.add(charsObj2);
        if (this.G != null) {
            ((DLLBufable)((Object)this.G)).append(chrObj, this);
        }
        return chrObj;
    }

    public static final ChrObj newChrObj(Obj obj, CharBuf charBuf) {
        ChrObj chrObj = null;
        chrObj = (ChrObj)ObjTmpl.makeInst("chr");
        if (obj != null) {
            chrObj.setObjValue("chrfmt", obj.deepClone());
        }
        chrObj.add(CharsObj.newCharsObj(charBuf));
        return chrObj;
    }

    public void toRTF(DataOutputStream dataOutputStream) throws IOException {
        if (this.getFldOwner() != null) {
            FieldDest fieldDest = this.getFldOwner();
            fieldDest.mergeToDest();
            fieldDest.toRTF(dataOutputStream);
            return;
        }
        dataOutputStream.write(123);
        this.I(dataOutputStream);
        this.Z(dataOutputStream);
        dataOutputStream.write(125);
    }

    public void writeHTML(PrintWriter printWriter) {
        Object object;
        int n;
        int n2 = 0;
        if (this.hasValue("chrfmt.ul") && this.getBooleanValue("chrfmt.ul")) {
            n2 |= 1;
            printWriter.print("<U>");
        }
        if (this.hasValue("chrfmt.strike") && this.getBooleanValue("chrfmt.strike")) {
            n2 |= 2;
            printWriter.print("<STRIKE>");
        }
        if (this.hasValue("chrfmt.b") && this.getBooleanValue("chrfmt.b")) {
            n2 |= 4;
            printWriter.print("<B>");
        }
        if (this.hasValue("chrfmt.i") && this.getBooleanValue("chrfmt.i")) {
            n2 |= 8;
            printWriter.print("<I>");
        }
        String string = "";
        if (this.hasValue("chrfmt.f")) {
            n = this.getIntValue("chrfmt.f");
            object = RtfDest.I.Z.names();
            while (object.hasMoreElements()) {
                Obj obj = (Obj)object.nextElement();
                int n3 = obj.getIntValue("f");
                if (n3 != n) continue;
                String string2 = obj.getCharsValue("fontname").toString();
                int n4 = string2.indexOf(59);
                if (n4 >= 0) {
                    string2 = string2.substring(0, n4);
                }
                string = string + " FACE=\"" + string2 + '\"';
                n2 |= 0x10;
                break;
            }
        }
        if (this.hasValue("chrfmt.fs")) {
            n = this.getIntValue("chrfmt.fs") / 2;
            n = n > 32 ? 7 : (n > 24 ? 6 : (n > 18 ? 5 : (n > 16 ? 4 : (n > 14 ? 3 : (n > 10 ? 2 : 1)))));
            string = string + " SIZE=" + n;
            n2 |= 0x10;
        }
        if (this.hasValue("chrfmt.cf")) {
            n = this.getIntValue("chrfmt.cf");
            object = RtfDest.I.getColor(n);
            int n5 = ((Color)object).getRGB();
            String string3 = Integer.toHexString(n5).substring(2);
            string = string + " COLOR=" + string3;
            n2 |= 0x10;
        }
        if ((n2 & 0x10) != 0) {
            printWriter.print("<FONT");
            printWriter.print(string);
            printWriter.print(">");
        }
        super.writeHTML(printWriter);
        if ((n2 & 0x10) != 0) {
            printWriter.print("</FONT>");
        }
        if ((n2 & 8) != 0) {
            printWriter.print("</I>");
        }
        if ((n2 & 4) != 0) {
            printWriter.print("</B>");
        }
        if ((n2 & 2) != 0) {
            printWriter.print("</STRIKE>");
        }
        if ((n2 & 1) != 0) {
            printWriter.print("</U>");
        }
    }
}

