/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDBFakeNode;
import jet.universe.JetUDocNode;
import jet.universe.JetUFolderTree;
import jet.universe.JetUTableView;
import jet.universe.JetUTree;
import jet.universe.exception.DocException;
import jet.util.WildcardMatcher;

public class JetUDBFolder
extends JetUTree
implements JetUDocNode {
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_VIEW = 1;
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    public JetEnumeration folderType = new JetEnumeration(this, "FolderType", 37);
    transient ObjectInfo QOIV = null;
    private static JRLogger add;
    private static final HashMap addElement;
    static Class class$jet$universe$JetUDBFolder;
    static final boolean $assertionsDisabled;

    public JetUDBFolder() {
        this.initialize();
    }

    public JetUDBFolder(String string, String string2) {
        this.initialize();
        this.setName(string);
        this.setDesc(string2);
    }

    protected void initialize() {
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetUDBFolder || jetObject instanceof JetUDBFakeNode)) {
            throw new AssertionError((Object)"Invalid child of JetUDBFolder! ");
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String string) {
        this.name.set(string);
    }

    public String getDesc() {
        return this.desc.get();
    }

    public void setDesc(String string) {
        this.desc.set(string);
    }

    public int getType() {
        return this.folderType.intValue();
    }

    public void setType(int n) {
        switch (n) {
            case 0: {
                this.folderType.set(new Integer(0));
                break;
            }
            case 1: {
                this.folderType.set(new Integer(1));
                break;
            }
            default: {
                this.folderType.set(new Integer(n));
            }
        }
    }

    public JetUFolderTree getFolderTree() {
        JetUDocNode jetUDocNode = (JetUDocNode)((Object)this.getParent());
        while (jetUDocNode != null) {
            if (jetUDocNode instanceof JetUFolderTree) {
                return ((JetUFolderTree)jetUDocNode).getFolderTree();
            }
            jetUDocNode = (JetUDocNode)((Object)jetUDocNode.getParent());
        }
        return null;
    }

    public boolean isRootFolder() {
        JetUDocNode jetUDocNode = (JetUDocNode)((Object)this.getParent());
        return jetUDocNode instanceof JetUFolderTree;
    }

    public boolean IsFolderExistByLocator(String string) {
        if (!$assertionsDisabled && string.equals("")) {
            throw new AssertionError((Object)"The Locator can not be empty");
        }
        JetUDBFolder jetUDBFolder = this.getFolderByLocator(string);
        return jetUDBFolder != null;
    }

    public boolean IsFakeNameExistAll(String string) {
        JetUDBFakeNode jetUDBFakeNode = null;
        Vector vector = new Vector();
        vector = this.getAllDBFakeNodes();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetUDBFakeNode = (JetUDBFakeNode)vector.elementAt(n2);
            if (string.equalsIgnoreCase(jetUDBFakeNode.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean IsFolderNameExist(String string) {
        JetUDBFolder jetUDBFolder = this.getFolderByName(string);
        return jetUDBFolder != null;
    }

    protected String getPath() {
        String string = "";
        JetObject jetObject = null;
        jetObject = (JetObject)((Object)this.getParent());
        if (jetObject instanceof JetUDBFolder) {
            string = ((JetUDBFolder)jetObject).getLocator();
        }
        return string;
    }

    public String getLocator() {
        String string = this.getPath();
        if (string.equals("")) {
            return "/";
        }
        if (string.equals("/")) {
            return string + this.getName();
        }
        return string + "/" + this.getName();
    }

    public JetUDBFolder getRootFolder() {
        JetUDBFolder jetUDBFolder = this;
        JetUTree jetUTree = (JetUTree)this.getParent();
        while (jetUTree instanceof JetUDBFolder) {
            jetUDBFolder = (JetUDBFolder)jetUTree;
            jetUTree = (JetUTree)jetUTree.getParent();
        }
        return jetUDBFolder;
    }

    public JetUDBFolder addFolder(String string, String string2) {
        JetUDBFolder jetUDBFolder = new JetUDBFolder(string, string2);
        return this.addFolder(jetUDBFolder);
    }

    public JetUDBFolder addFolder(String string) throws DocException {
        if (!string.startsWith("/")) {
            throw new DocException(1, string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        JetUDBFolder jetUDBFolder = this.getRootFolder();
        String string2 = "";
        Object var5_5 = null;
        JetUDocNode jetUDocNode = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            jetUDocNode = jetUDBFolder.getChildByName(string2);
            if (jetUDocNode != null && jetUDocNode instanceof JetUDBFakeNode) {
                throw new DocException(1, string);
            }
            jetUDBFolder = jetUDocNode == null ? jetUDBFolder.addFolder(string2, "") : (JetUDBFolder)jetUDocNode;
        }
        return jetUDBFolder;
    }

    protected JetUDocNode getChildByName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            if (jetUDocNode.getName().equalsIgnoreCase(string)) {
                return jetUDocNode;
            }
            ++n2;
        }
        return null;
    }

    public JetUDBFolder addFolder(JetUDBFolder jetUDBFolder) {
        this.add(jetUDBFolder);
        return jetUDBFolder;
    }

    public JetUDBFolder getFolderByName(String string) {
        JetUDocNode jetUDocNode = this.getChildByName(string);
        return jetUDocNode != null && jetUDocNode instanceof JetUDBFolder ? (JetUDBFolder)jetUDocNode : null;
    }

    public int getChildrenSize() {
        Vector vector = this.getAllChildren();
        return vector.size();
    }

    public JetUDBFakeNode addDBFakeNode(JetUTableView jetUTableView) {
        JetUDBFakeNode jetUDBFakeNode = new JetUDBFakeNode(jetUTableView.getResourceName(), jetUTableView.getDesc());
        return (JetUDBFakeNode)this.add(jetUDBFakeNode);
    }

    public boolean delete(boolean bl) {
        JetUTree jetUTree = (JetUTree)this.getParent();
        if (jetUTree instanceof JetUDBFolder) {
            ((JetUDBFolder)jetUTree).removeSubNode(this);
            ((JetUDBFolder)jetUTree).remove(this);
            return true;
        }
        return false;
    }

    public JetUDocNode removeFakeNode(JetUDBFakeNode jetUDBFakeNode) throws SecurityException {
        return (JetUDocNode)((Object)this.remove(jetUDBFakeNode));
    }

    public void removeSubNode(JetUDocNode jetUDocNode) {
        if (jetUDocNode instanceof JetUDBFakeNode) {
            this.removeFakeNode((JetUDBFakeNode)jetUDocNode);
        } else if (jetUDocNode instanceof JetUDBFolder) {
            Vector vector = ((JetUDBFolder)jetUDocNode).getChildren();
            int n = vector.size();
            JetUDocNode jetUDocNode2 = null;
            int n2 = 0;
            while (n2 < n) {
                jetUDocNode2 = (JetUDocNode)vector.elementAt(n2);
                ((JetUDBFolder)jetUDocNode).removeSubNode(jetUDocNode2);
                ++n2;
            }
        }
    }

    public boolean containsReports() {
        return false;
    }

    public boolean containsFakeNodes() {
        return this.getAllDBFakeNodes().size() > 0;
    }

    public Vector getAllDBFakeNodes() {
        Vector vector = new Vector();
        Vector vector2 = this.getChildren();
        if (vector2 != null) {
            this.getDBFakeNodes(vector2, vector);
        }
        return vector;
    }

    public Vector getAllChildren() {
        Vector vector = new Vector();
        Vector vector2 = this.getChildren();
        if (vector2 != null) {
            this.getAllChildren(vector2, vector);
        }
        return vector;
    }

    protected void getAllChildren(Vector vector, Vector vector2) {
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            vector2.addElement(jetUDocNode);
            if (jetUDocNode instanceof JetUDBFolder) {
                this.getAllChildren(((JetUDBFolder)jetUDocNode).getChildren(), vector2);
            }
            ++n2;
        }
    }

    public JetUDocNode getChildByLocator(String string) {
        if (!$assertionsDisabled && string.equals("")) {
            throw new AssertionError((Object)"The Locator can not be empty");
        }
        JetUDBFolder jetUDBFolder = this.getRootFolder();
        if (string.equals("/")) {
            return jetUDBFolder;
        }
        if (string.startsWith("/")) {
            return jetUDBFolder.getChildByRelativeLocator(string.substring("/".length()));
        }
        return this.getChildByRelativeLocator(string);
    }

    public JetUDocNode getChildByRelativeLocator(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return this.getChildByName(string);
        }
        String string2 = string.substring(0, n);
        JetUDBFolder jetUDBFolder = this.getFolderByName(string2);
        if (jetUDBFolder != null) {
            return (JetUDBFolder)jetUDBFolder.getChildByRelativeLocator(string.substring(n + "/".length()));
        }
        return null;
    }

    public JetUDBFolder getFolderByLocator(String string) {
        if (!$assertionsDisabled && string.equals("")) {
            throw new AssertionError((Object)"The Locator can not be empty");
        }
        JetUDBFolder jetUDBFolder = this.getRootFolder();
        if (string.equals("/")) {
            return jetUDBFolder;
        }
        if (string.startsWith("/")) {
            return jetUDBFolder.getFolderByRelativeLocator(string.substring("/".length()));
        }
        return this.getFolderByRelativeLocator(string);
    }

    public JetUDBFolder getFolderByRelativeLocator(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return this.getFolderByName(string);
        }
        String string2 = string.substring(0, n);
        JetUDBFolder jetUDBFolder = this.getFolderByName(string2);
        if (jetUDBFolder != null) {
            return jetUDBFolder.getFolderByRelativeLocator(string.substring(n + "/".length()));
        }
        return null;
    }

    public void getDBFakeNodes(Vector vector, Vector vector2) {
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            if (jetUDocNode instanceof JetUDBFakeNode) {
                vector2.addElement(jetUDocNode);
            } else if (jetUDocNode instanceof JetUDBFolder) {
                this.getDBFakeNodes(((JetUDBFolder)jetUDocNode).getChildren(), vector2);
            }
            ++n2;
        }
    }

    public Vector getItemsByName(String string) {
        Vector<JetUDocNode> vector = new Vector<JetUDocNode>();
        Vector vector2 = this.getAllChildren();
        int n = vector2.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector2.elementAt(n2);
            if (jetUDocNode.isMatch(string, true)) {
                vector.addElement(jetUDocNode);
            }
            ++n2;
        }
        return vector;
    }

    public JetUDBFakeNode getDBFokeNodeByName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            if (jetUDocNode instanceof JetUDBFakeNode && jetUDocNode.getName().equalsIgnoreCase(string)) {
                return (JetUDBFakeNode)jetUDocNode;
            }
            ++n2;
        }
        return null;
    }

    public JetUDBFakeNode getDBFakeNodeFromAllByName(String string) {
        Vector vector = this.getAllDBFakeNodes();
        int n = vector.size();
        JetUDocNode jetUDocNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUDocNode = (JetUDocNode)vector.elementAt(n2);
            if (jetUDocNode instanceof JetUDBFakeNode && jetUDocNode.getName().equalsIgnoreCase(string)) {
                return (JetUDBFakeNode)jetUDocNode;
            }
            ++n2;
        }
        return null;
    }

    public boolean isMatch(String string, boolean bl) {
        return WildcardMatcher.matchWildcard(this.getName(), string, bl);
    }

    protected void createObjectInfo() {
        this.QOIV = new ObjectInfo(this, null);
    }

    public ObjectInfo getObjectInfo() {
        if (this.QOIV == null) {
            this.createObjectInfo();
        }
        return this.QOIV;
    }

    public String toString() {
        return this.getLocator();
    }

    public String getInstancePrefix() {
        return "DBFolder";
    }

    public HashMap getIndecialMap() {
        return addElement;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUDBFolder == null ? (class$jet$universe$JetUDBFolder = JetUDBFolder.class$("jet.universe.JetUDBFolder")) : class$jet$universe$JetUDBFolder).desiredAssertionStatus();
        add = JRLogger.getLogger((class$jet$universe$JetUDBFolder == null ? (class$jet$universe$JetUDBFolder = JetUDBFolder.class$("jet.universe.JetUDBFolder")) : class$jet$universe$JetUDBFolder).getName());
        addElement = new HashMap(3);
        addElement.put("Description", new Integer(0));
        addElement.put("Name", new Integer(1));
        addElement.put("FolderType", new Integer(2));
    }
}

