/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.dsdriver;

import java.util.StringTokenizer;
import java.util.Vector;
import jet.log.JRLogger;
import jet.universe.dsdriver.UDSDriverFormatException;

public class UDSDriver {
    public static final char driverDelimiter = '=';
    public static final String schemeDelimiter = ":/";
    public static final String strParameterDelimiter = ";";
    public static final char pathPrefix = '/';
    public static final String strPackageDelimiter = ".";
    public static final String strJRQueryScheme = "jrquery";
    public static final String strDefaultDriverName = "CatalogQuery";
    String QOIV;
    String addElement;
    String append;
    String[] buildDriver = new String[0];
    boolean I = false;
    private static JRLogger buildParamsString;
    static Class class$jet$universe$dsdriver$UDSDriver;
    static final boolean $assertionsDisabled;

    public UDSDriver() {
    }

    public UDSDriver(String string) throws UDSDriverFormatException {
        this.setDriver(string);
    }

    public UDSDriver(String string, String string2) throws UDSDriverFormatException {
        this.setURL(string2);
        this.setDriverName(string);
    }

    public UDSDriver(String string, String string2, String string3, String[] stringArray) {
        this.setDriverName(string);
        this.addElement = string2;
        this.append = string3;
        this.buildDriver = stringArray;
    }

    protected void parseDriver(String string) throws UDSDriverFormatException {
        int n = string.indexOf(61);
        if (n < 0) {
            this.QOIV = "";
            this.setURL(string);
        } else {
            this.QOIV = string.substring(0, n);
            this.setURL(string.substring(n + 1, string.length()));
        }
    }

    public String buildDriver() {
        return this.getDriverName() + '=' + this.getURL();
    }

    public void setDriver(String string) throws UDSDriverFormatException {
        if (string.equals(strDefaultDriverName)) {
            this.QOIV = strDefaultDriverName;
            this.addElement = strJRQueryScheme;
            this.I = true;
        } else {
            this.parseDriver(string);
        }
    }

    public String getDriver() {
        if (this.I) {
            return strDefaultDriverName;
        }
        return this.buildDriver();
    }

    public void setURL(String string) throws UDSDriverFormatException {
        this.parseURL(string);
    }

    public String getURL() {
        return this.buildURL();
    }

    protected void parseURL(String string) throws UDSDriverFormatException {
        int n = string.indexOf(schemeDelimiter);
        if (n < 0) {
            throw new UDSDriverFormatException(0, "");
        }
        this.addElement = string.substring(0, n);
        String string2 = null;
        int n2 = string.indexOf(strParameterDelimiter, n + schemeDelimiter.length());
        if (n2 < 0) {
            this.append = string.substring(n + schemeDelimiter.length(), string.length());
        } else {
            this.append = string.substring(n + schemeDelimiter.length(), n2);
            string2 = string.substring(n2 + 1, string.length());
        }
        if (this.append == null || this.append.length() == 0) {
            throw new UDSDriverFormatException(2, "");
        }
        if (!UDSDriver.isValidClassName(this.append)) {
            throw new UDSDriverFormatException(1, this.append);
        }
        if (string2 != null && string2.length() != 0) {
            this.setParamsString(string2);
        }
    }

    public static boolean isValidClassName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, strPackageDelimiter);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (UDSDriver.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifier(String string) {
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected String buildURL() {
        String string = "";
        if (this.addElement != null && this.addElement.length() != 0) {
            string = string + this.addElement;
            if (this.append != null && this.append.length() != 0) {
                string = string + schemeDelimiter + this.append;
                String string2 = this.getParamsString();
                if (string2 != null && string2.length() != 0) {
                    string = string + strParameterDelimiter + string2;
                }
            }
        }
        return string;
    }

    public void setDriverName(String string) {
        if (!$assertionsDisabled && string.indexOf(61) >= 0) {
            throw new AssertionError((Object)"Driver name shouldn't contains equal sign");
        }
        this.QOIV = string;
    }

    public String getDriverName() {
        return this.QOIV;
    }

    public void setScheme(String string) {
        this.addElement = string;
    }

    public String getScheme() {
        return this.addElement;
    }

    public void setClassName(String string) {
        this.append = string;
    }

    public String getClassName() {
        return this.append;
    }

    public void setParams(String[] stringArray) {
        this.buildDriver = stringArray;
    }

    public String[] getParams() {
        return this.buildDriver;
    }

    public void setParamsString(String string) {
        this.parseParamsString(string);
    }

    public String getParamsString() {
        return this.buildParamsString();
    }

    protected void parseParamsString(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, strParameterDelimiter);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            int n = vector.size();
            this.buildDriver = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.buildDriver[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
    }

    protected String buildParamsString() {
        String string = "";
        int n = this.buildDriver.length;
        int n2 = 0;
        while (n2 < n) {
            string = string + this.buildDriver[n2];
            if (n2 + 1 < n) {
                string = string + strParameterDelimiter;
            }
            ++n2;
        }
        return string;
    }

    public boolean isDefaultDriver() {
        return this.I;
    }

    public String toString() {
        String string = "";
        if (this.buildDriver != null) {
            int n = this.buildDriver.length;
            int n2 = 0;
            while (n2 < n) {
                string = string + this.buildDriver[n2];
                if (n + 1 < n) {
                    string = string + strParameterDelimiter;
                }
                ++n2;
            }
        }
        return "UDSDriver[DriverName=" + this.QOIV + "," + "Scheme=" + this.addElement + "," + "ClassName=" + this.append + "," + "Params=" + string + "]";
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$dsdriver$UDSDriver == null ? (class$jet$universe$dsdriver$UDSDriver = UDSDriver.class$("jet.universe.dsdriver.UDSDriver")) : class$jet$universe$dsdriver$UDSDriver).desiredAssertionStatus();
        buildParamsString = JRLogger.getLogger((class$jet$universe$dsdriver$UDSDriver == null ? (class$jet$universe$dsdriver$UDSDriver = UDSDriver.class$("jet.universe.dsdriver.UDSDriver")) : class$jet$universe$dsdriver$UDSDriver).getName());
    }
}

