/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools;

import java.util.Vector;
import jet.formula.ParamDesc;
import jet.rptservice.util.Tools;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;

public class UniverseTools {
    public static Vector getFieldResourceNames(JetUUniverse jetUUniverse, String string, String string2) {
        Vector vector = null;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable instanceof JetUFileQuery) {
            vector = UniverseTools.QOIV((JetUFileQuery)jetUQueriable);
        } else if (!(jetUQueriable instanceof JetUHierDataSource)) {
            if (jetUQueriable instanceof JetUProcedure) {
                vector = UniverseTools.addElement((JetUProcedure)jetUQueriable);
            } else if (jetUQueriable instanceof JetUQuery) {
                vector = UniverseTools.append((JetUQuery)jetUQueriable);
            } else if (jetUQueriable instanceof JetUUserDataSource) {
                vector = UniverseTools.canSummary((JetUUserDataSource)jetUQueriable);
            } else {
                System.out.println("Invalid query class: " + jetUQueriable);
            }
        }
        return vector;
    }

    private static Vector QOIV(JetUFileQuery jetUFileQuery) {
        Vector vector = jetUFileQuery.getFields();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                JetUFileQueryField jetUFileQueryField = (JetUFileQueryField)vector.elementAt(n);
                vector2.addElement(jetUFileQueryField.getResourceNameInUpperCase());
                ++n;
            }
        }
        return vector2;
    }

    private static Vector addElement(JetUProcedure jetUProcedure) {
        Vector vector = jetUProcedure.getFields();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                JetUProcField jetUProcField = (JetUProcField)vector.elementAt(n);
                vector2.addElement(jetUProcField.getResourceNameInUpperCase());
                ++n;
            }
        }
        return vector2;
    }

    private static Vector append(JetUQuery jetUQuery) {
        Vector vector = jetUQuery.getDBFields();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                JetUQueryField jetUQueryField = (JetUQueryField)vector.elementAt(n);
                vector2.addElement(jetUQueryField.getResourceNameInUpperCase());
                ++n;
            }
        }
        return vector2;
    }

    private static Vector canSummary(JetUUserDataSource jetUUserDataSource) {
        Vector vector = jetUUserDataSource.getFields();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Object e = vector.elementAt(n);
                JetUUDSField jetUUDSField = (JetUUDSField)vector.elementAt(n);
                vector2.addElement(jetUUDSField.getResourceNameInUpperCase());
                ++n;
            }
        }
        return vector2;
    }

    public static ParamDesc getParamDesc(String string, JetUUniverse jetUUniverse) {
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getAnyResourceByName(string);
        if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUParameter)) {
            return null;
        }
        ParamDesc paramDesc = ((JetUParameter)jetUResourceEntity).getParamDesc();
        UniverseTools.elementAt(paramDesc);
        return paramDesc;
    }

    public static ParamDesc getParamDesc(String string, JetUUniverse jetUUniverse, String string2) {
        JetUParameter jetUParameter = jetUUniverse.getDatabase(string2).getParameterByResourceName(string);
        if (jetUParameter == null || !(jetUParameter instanceof JetUParameter)) {
            return null;
        }
        ParamDesc paramDesc = jetUParameter.getParamDesc();
        UniverseTools.elementAt(paramDesc);
        return paramDesc;
    }

    private static void elementAt(ParamDesc paramDesc) {
        String string;
        if (paramDesc != null && (string = paramDesc.getColumn()) != null && string.length() > 0) {
            paramDesc.setBeColumn(4);
        }
    }

    private static Vector getAnyResourceByName(JetUUniverse jetUUniverse, String string, String string2) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = jetUUniverse.getAvailableResourceEntitys(string, string2);
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector2.elementAt(n2);
            if (jetUResourceEntity instanceof JetUDBField) {
                vector.addElement(jetUResourceEntity.getResourceName());
            } else if (jetUResourceEntity instanceof JetUFmlQueryField) {
                vector.addElement(jetUResourceEntity.getResourceName());
            } else if (jetUResourceEntity instanceof JetUFormula && ((JetUFormula)jetUResourceEntity).canSummary()) {
                vector.addElement(jetUResourceEntity.getResourceName());
            }
            ++n2;
        }
        return vector;
    }

    public static Vector getAvlGroupFields(JetUUniverse jetUUniverse, String string) {
        Vector vector = new Vector();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        Vector vector2 = jetUDatabase.getQueriables();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                JetUQueriable jetUQueriable = (JetUQueriable)vector2.elementAt(n);
                String string2 = jetUQueriable.getResourceName();
                Vector vector3 = UniverseTools.getAnyResourceByName(jetUUniverse, string, string2);
                if (vector3 != null) {
                    Tools.merge(vector, vector3);
                }
                ++n;
            }
        }
        return vector;
    }
}

