/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Vector;
import jet.util.RandomInputOutputable;

public class RandomByteArrayInputOutput
implements RandomInputOutputable {
    public static final int CACHE_SIZE = 40960;
    Vector QOIV;
    long addElement = 0L;
    byte[] append = new byte[40960];
    long arraycopy = 0L;
    int charAt = 0;

    public RandomByteArrayInputOutput() {
        this.QOIV = new Vector();
        this.QOIV.addElement(new byte[0]);
    }

    public int read() throws IOException {
        int n;
        int n2;
        if (this.addElement >= this.arraycopy && this.addElement < this.arraycopy + (long)this.charAt) {
            ++this.addElement;
            return this.append[(int)(this.arraycopy - this.addElement)];
        }
        if (this.charAt != 0) {
            throw new Error();
        }
        if (this.addElement >= Integer.MAX_VALUE) {
            n2 = (int)(this.addElement / Integer.MAX_VALUE);
            n = (int)(this.addElement % Integer.MAX_VALUE);
        } else {
            n2 = 0;
            n = (int)this.addElement;
        }
        byte[] byArray = (byte[])this.QOIV.elementAt(n2);
        ++this.addElement;
        return byArray[n] & 0xFF;
    }

    private int QOIV(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.addElement >= this.arraycopy && this.addElement + (long)n2 < this.arraycopy + (long)this.charAt) {
            this.addElement += (long)n2;
            System.arraycopy(this.append, (int)(this.addElement - this.arraycopy), byArray, n, n2);
            return n2;
        }
        if (this.charAt != 0) {
            throw new Error();
        }
        if (this.addElement >= Integer.MAX_VALUE) {
            n4 = (int)(this.addElement / Integer.MAX_VALUE);
            n3 = (int)(this.addElement % Integer.MAX_VALUE);
        } else {
            n4 = 0;
            n3 = (int)this.addElement;
        }
        byte[] byArray2 = (byte[])this.QOIV.elementAt(n4);
        if (n2 > Integer.MAX_VALUE - n3 && n4 + 1 < this.QOIV.size()) {
            System.arraycopy(byArray2, n3, byArray, n, Integer.MAX_VALUE - n3);
            byArray2 = (byte[])this.QOIV.elementAt(n4 + 1);
            n2 = n2 > Integer.MAX_VALUE - n3 + byArray2.length - n3 ? Integer.MAX_VALUE - n3 + byArray2.length - n3 : n2;
            System.arraycopy(byArray2, 0, byArray, n + Integer.MAX_VALUE - n3, n2 - (Integer.MAX_VALUE - n3));
        } else {
            n2 = n2 > byArray2.length - n3 ? byArray2.length - n3 : n2;
            System.arraycopy(byArray2, n3, byArray, n, n2);
        }
        this.addElement += (long)n2;
        return n2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.QOIV(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.QOIV(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        long l;
        if (n <= 0) {
            return 0;
        }
        long l2 = this.getPosition();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.length())) {
            l3 = l;
        }
        this.seek(l3);
        return (int)(l3 - l2);
    }

    public void write(int n) throws IOException {
        if (this.charAt == 0) {
            this.arraycopy = this.addElement;
        }
        if (this.charAt < this.append.length) {
            this.append[this.charAt++] = (byte)n;
            return;
        }
        this.append();
        this.write(n);
    }

    private void addElement(byte[] byArray, int n, int n2) throws IOException {
        if (this.charAt == 0) {
            this.arraycopy = this.addElement;
        }
        if (this.append.length - this.charAt > n2) {
            System.arraycopy(byArray, n, this.append, this.charAt, n2);
            this.charAt += n2;
            return;
        }
        this.append();
        if (n2 > this.append.length) {
            this.arraycopy(byArray, n, n2);
        } else {
            this.addElement(byArray, n, n2);
        }
    }

    private final void append() throws IOException {
        this.arraycopy(this.append, 0, this.charAt);
        this.charAt = 0;
    }

    private final void arraycopy(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        int n3;
        int n4;
        if (this.addElement >= Integer.MAX_VALUE) {
            n4 = (int)(this.addElement / Integer.MAX_VALUE);
            n3 = (int)(this.addElement % Integer.MAX_VALUE);
        } else {
            n4 = 0;
            n3 = (int)this.addElement;
        }
        if (n4 > this.QOIV.size()) {
            this.QOIV.addElement(new byte[0]);
        }
        if ((byArray2 = (byte[])this.QOIV.elementAt(n4)).length <= n3) {
            int n5 = n3 + n2;
            byte[] byArray3 = new byte[n5 < 0 ? Integer.MAX_VALUE : n5];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            this.QOIV.setElementAt(byArray3, n4);
            byArray2 = byArray3;
            if (n5 < 0 && ++n4 > this.QOIV.size()) {
                byArray3 = new byte[n2 - (Integer.MAX_VALUE - n3)];
                this.QOIV.addElement(byArray3);
                System.arraycopy(byArray, Integer.MAX_VALUE - n3, byArray3, 0, byArray3.length);
            }
        }
        System.arraycopy(byArray, n, byArray2, n3, byArray2.length - n3 > n2 ? n2 : byArray2.length - n3);
        this.addElement += (long)n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.addElement(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.addElement(byArray, n, n2);
    }

    public void seek(long l) throws IOException {
        long l2;
        if (this.charAt != 0) {
            this.append();
        }
        if (l >= (l2 = this.length())) {
            int n;
            int n2;
            if (l >= Integer.MAX_VALUE) {
                n2 = (int)(l / Integer.MAX_VALUE);
                n = (int)(l % Integer.MAX_VALUE);
            } else {
                n2 = 0;
                n = (int)l;
            }
            if (n2 > this.QOIV.size()) {
                byte[] byArray = (byte[])this.QOIV.lastElement();
                if (byArray.length < Integer.MAX_VALUE) {
                    byte[] byArray2 = new byte[Integer.MAX_VALUE];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    this.QOIV.removeElement(byArray);
                    this.QOIV.addElement(byArray2);
                }
                int n3 = 0;
                while (n3 < n2 - this.QOIV.size() - 1) {
                    this.QOIV.addElement(new byte[Integer.MAX_VALUE]);
                    ++n3;
                }
                this.QOIV.addElement(new byte[n + 1]);
            }
        }
        this.addElement = l;
    }

    public long length() throws IOException {
        return (long)(this.QOIV.size() - 1) * Integer.MAX_VALUE + (long)((byte[])this.QOIV.lastElement()).length + (long)this.charAt;
    }

    public void close() throws IOException {
        this.QOIV.removeAllElements();
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    break;
                }
                case 13: {
                    bl = true;
                    long l = this.getPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        this.addElement(byArray, 0, n);
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            byArray[n4++] = (byte)(cArray[n3] >>> 8);
            byArray[n4++] = (byte)(cArray[n3] >>> 0);
            ++n3;
        }
        this.addElement(byArray, 0, n2);
    }

    public final void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            n3 = n >= 1 && n <= 127 ? ++n3 : (n > 2047 ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 >>> 0 & 0xFF);
        n = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
            ++n;
        }
    }

    public long getPosition() {
        if (this.charAt != 0) {
            return this.arraycopy + (long)this.charAt;
        }
        return this.addElement;
    }

    public void saveTo(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        int n = 0;
        while (n < this.QOIV.size()) {
            byte[] byArray = (byte[])this.QOIV.elementAt(n);
            fileOutputStream.write(byArray);
            ++n;
        }
        fileOutputStream.close();
    }
}

