/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.gui;

import java.sql.Connection;
import java.sql.SQLException;
import toolkit.db.DbTools;
import toolkit.db.gui.ConnectionsBroker;

public class JdbcDatabase {
    public static int JDBC_ODBC_BRIDGE = 0;
    public static int JDBC = 1;
    private String QOIV = null;
    public String sDsn = null;
    private String append = null;
    private String close = null;
    private String freeConnection = null;
    private String getConnection = null;
    private int length = 0;
    private int printSQLExceptionMessage = 1;
    private Connection setConnectionInfo;
    private Connection setUrl = null;
    private boolean startsWith = false;
    public int protocol = JDBC_ODBC_BRIDGE;
    private String substring = null;
    public boolean isEmpty = false;
    private boolean toLowerCase;

    public JdbcDatabase() {
        this.isEmpty = true;
    }

    public JdbcDatabase(String string, String string2, String string3, String string4) {
        this.setConnectionInfo(string, string2, string3, string4, 0, 1);
    }

    public JdbcDatabase(String string, String string2, String string3, String string4, int n, int n2) {
        this.setConnectionInfo(string, string2, string3, string4, n, n2);
    }

    public JdbcDatabase(String string, String string2, String string3, String string4, int n, int n2, String string5) {
        this.setConnectionInfo(string, string2, string3, string4, n, n2, string5);
    }

    public JdbcDatabase(Connection connection) {
        this.setUrl = connection;
    }

    public void setConnectionInfo(String string, String string2, String string3, String string4, int n, int n2) {
        this.setConnectionInfo(string, string2, string3, string4, n, n2, null);
    }

    public void setConnectionInfo(String string, String string2, String string3, String string4, int n, int n2, String string5) {
        this.append = string2;
        this.close = string3;
        this.getConnection = string4;
        this.length = n;
        this.printSQLExceptionMessage = n2;
        this.freeConnection = string5;
        this.setUrl(string);
    }

    public void setUrl(String string) {
        this.QOIV = string;
        this.sDsn = null;
        if (string != null) {
            this.sDsn = string.trim();
            if (this.sDsn.length() != 0) {
                if (this.sDsn.toLowerCase().startsWith("jdbc:odbc:") && (this.getConnection == null || this.getConnection.trim().length() == 0)) {
                    this.sDsn = this.sDsn.substring(10);
                    this.protocol = JDBC_ODBC_BRIDGE;
                } else {
                    this.protocol = JDBC;
                }
            } else {
                this.sDsn = null;
                this.protocol = JDBC;
            }
        }
    }

    public String getUrl() {
        return this.QOIV;
    }

    public void setUid(String string) {
        this.append = string;
    }

    public String getUid() {
        return this.append;
    }

    public void setPswd(String string) {
        this.close = string;
    }

    public String getPswd() {
        return this.close;
    }

    public void setJdbcDriver(String string) {
        this.getConnection = string;
    }

    public String getJdbcDriver() {
        return this.getConnection;
    }

    public void setDbCatalog(String string) {
        this.freeConnection = string;
    }

    public void setIsolationLevel(int n) {
        this.length = n;
    }

    public int getIsolationLevel() {
        return this.length;
    }

    public void setReadOnly(int n) {
        this.printSQLExceptionMessage = n;
    }

    public int getReadOnly() {
        return this.printSQLExceptionMessage;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public boolean connect() throws SQLException, ClassNotFoundException {
        if (this.setUrl != null) {
            return true;
        }
        this.startsWith = false;
        Connection connection = null;
        try {
            connection = ConnectionsBroker.getConnection(this.QOIV, this.append, this.close, this.getConnection, this.length, this.printSQLExceptionMessage, this.freeConnection);
            if (connection != null) {
                this.startsWith = true;
                if (this.setConnectionInfo != null) {
                    Connection connection2 = this.setConnectionInfo;
                    this.setConnectionInfo = connection;
                    ConnectionsBroker.freeConnection(connection2);
                } else {
                    this.setConnectionInfo = connection;
                }
            }
        }
        catch (SQLException sQLException) {
            this.setConnectionInfo = null;
            throw sQLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setConnectionInfo = null;
            throw classNotFoundException;
        }
        return this.startsWith;
    }

    public void disconnect() throws SQLException {
        if (this.setUrl != null) {
            if (this.toLowerCase) {
                this.setUrl.close();
            }
            return;
        }
        Connection connection = this.setConnectionInfo;
        this.setConnectionInfo = null;
        try {
            if (connection != null) {
                ConnectionsBroker.freeConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            this.setConnectionInfo = connection;
            this.startsWith = false;
            this.substring = "";
            DbTools.printSQLExceptionMessage(sQLException);
            throw sQLException;
        }
    }

    public boolean isSuccessful() {
        return this.startsWith;
    }

    public Connection getConnection() {
        if (this.setUrl != null) {
            return this.setUrl;
        }
        return this.setConnectionInfo;
    }

    public String toString() {
        String string = "URL : " + this.QOIV + "\n" + "JdbcDriver : " + this.getConnection + "\n" + "TansactionIsolationLevel : " + this.length + "\n" + "ReadOnly : " + this.printSQLExceptionMessage + "\n";
        return string;
    }

    public String getErrorString() {
        if (this.substring == null) {
            return "";
        }
        return this.substring;
    }

    public void setNeedCloseSettingConnection(boolean bl) {
        this.toLowerCase = bl;
    }

    public boolean needCloseSettingConnection() {
        return this.toLowerCase;
    }
}

