/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceAwareObject;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Semaphore;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.AsyncCall;
import com.hazelcast.impl.AtomicNumberImpl;
import com.hazelcast.impl.BaseCollection;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.BlockingQueueManager;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.CollectionProxy;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.ExecutorServiceProxy;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.IGetAwareProxy;
import com.hazelcast.impl.LifecycleServiceImpl;
import com.hazelcast.impl.ListProxyImpl;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.LocalMapStatsImpl;
import com.hazelcast.impl.LocalQueueStatsImpl;
import com.hazelcast.impl.LocalTopicStatsImpl;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MapOperationsCounter;
import com.hazelcast.impl.MultiMapProxy;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.QueueOperationsCounter;
import com.hazelcast.impl.SemaphoreImpl;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TopicManager;
import com.hazelcast.impl.TopicOperationsCounter;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.TransactionFactory;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.impl.concurrentmap.AddMapIndex;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryImpl
implements HazelcastInstance {
    static final ConcurrentMap<String, FactoryImpl> factories = new ConcurrentHashMap<String, FactoryImpl>(5);
    static final Object factoryLock = new Object();
    static final String ATOMIC_NUMBER_MAP_NAME = "c:hz_AtomicNumber";
    static final String SEMAPHORE_MAP_NAME = "c:hz_SEMAPHORE";
    private static int nextFactoryId = 0;
    final ConcurrentMap<String, HazelcastInstanceAwareInstance> proxiesByName = new ConcurrentHashMap<String, HazelcastInstanceAwareInstance>(1000);
    final ConcurrentMap<ProxyKey, HazelcastInstanceAwareInstance> proxies = new ConcurrentHashMap<ProxyKey, HazelcastInstanceAwareInstance>(1000);
    final MProxy locksMapProxy;
    final MProxy idGeneratorMapProxy;
    final MProxy globalProxies;
    final ConcurrentMap<String, ExecutorServiceProxy> executorServiceProxies = new ConcurrentHashMap<String, ExecutorServiceProxy>(2);
    final CopyOnWriteArrayList<InstanceListener> lsInstanceListeners = new CopyOnWriteArrayList();
    final String name;
    final TransactionFactory transactionFactory;
    final HazelcastInstanceProxy hazelcastInstanceProxy;
    final ManagementService managementService;
    final ILogger logger;
    final LifecycleServiceImpl lifecycleService;
    final ManagementCenterService managementCenterService;
    public final Node node;
    volatile boolean restarted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstanceProxy newHazelcastInstanceProxy(Config config) {
        FactoryImpl factory = null;
        try {
            Object object = factoryLock;
            synchronized (object) {
                String name;
                FactoryImpl old;
                if (config == null) {
                    config = new XmlConfigBuilder().build();
                }
                if ((old = factories.put(name = "_hzInstance_" + nextFactoryId++ + "_" + config.getGroupConfig().getName(), factory = new FactoryImpl(name, config))) != null) {
                    factory.logger.log(Level.SEVERE, "HazelcastInstance with [" + name + "] already exist!");
                    throw new RuntimeException();
                }
            }
            boolean firstMember = factory.node.getClusterImpl().getMembers().iterator().next().localMember();
            int initialWaitSeconds = factory.node.groupProperties.INITIAL_WAIT_SECONDS.getInteger();
            if (initialWaitSeconds > 0) {
                try {
                    Thread.sleep(initialWaitSeconds * 1000);
                    if (firstMember) {
                        final ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
                        concurrentMapManager.enqueueAndReturn(new Processable(){

                            public void process() {
                                concurrentMapManager.partitionManager.quickBlockRearrangement();
                            }
                        });
                    } else {
                        Thread.sleep(4000L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            int initialMinClusterSize = factory.node.groupProperties.INITIAL_MIN_CLUSTER_SIZE.getInteger();
            while (factory.node.getClusterImpl().getMembers().size() < initialMinClusterSize) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            if (initialMinClusterSize > 0) {
                if (firstMember) {
                    final ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
                    concurrentMapManager.enqueueAndReturn(new Processable(){

                        public void process() {
                            concurrentMapManager.partitionManager.quickBlockRearrangement();
                        }
                    });
                } else {
                    Thread.sleep(4000L);
                }
                factory.logger.log(Level.INFO, "HazelcastInstance starting after waiting for cluster size of " + initialMinClusterSize);
            }
            factory.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
            return factory.hazelcastInstanceProxy;
        }
        catch (Throwable t) {
            if (factory != null) {
                factory.logger.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new RuntimeException(t);
        }
    }

    public HazelcastInstanceProxy getHazelcastInstanceProxy() {
        return this.hazelcastInstanceProxy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        Object object = factoryLock;
        synchronized (object) {
            Collection colFactories = factories.values();
            for (FactoryImpl factory : colFactories) {
                factory.shutdown();
            }
            factories.clear();
            FactoryImpl.shutdownManagementService();
            ThreadContext.shutdownAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(HazelcastInstanceProxy hazelcastInstanceProxy) {
        Object object = factoryLock;
        synchronized (object) {
            FactoryImpl factory = hazelcastInstanceProxy.getFactory();
            try {
                factory.managementService.unregister();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            factory.proxies.clear();
            if (factory.managementCenterService != null) {
                factory.managementCenterService.shutdown();
            }
            for (ExecutorServiceProxy esp : factory.executorServiceProxies.values()) {
                esp.shutdown();
            }
            factory.node.shutdown();
            factories.remove(factory.getName());
            if (factories.size() == 0) {
                FactoryImpl.shutdownManagementService();
            }
        }
    }

    private static void shutdownManagementService() {
        try {
            ManagementService.shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public FactoryImpl(String name, Config config) {
        this.name = name;
        this.node = new Node(this, config);
        this.globalProxies = new MProxyImpl("c:__hz_Proxies", this);
        this.logger = this.node.getLogger(FactoryImpl.class.getName());
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.transactionFactory = new TransactionFactory(this);
        this.hazelcastInstanceProxy = new HazelcastInstanceProxy(this);
        this.locksMapProxy = new MProxyImpl("c:__hz_Locks", this);
        this.idGeneratorMapProxy = new MProxyImpl("c:__hz_IdGenerator", this);
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
        this.node.start();
        this.globalProxies.addEntryListener(new EntryListener(){

            public void entryAdded(EntryEvent event) {
                if (FactoryImpl.this.node.localMember.equals(event.getMember())) {
                    return;
                }
                final ProxyKey proxyKey = (ProxyKey)event.getKey();
                if (!FactoryImpl.this.proxies.containsKey(proxyKey)) {
                    FactoryImpl.this.logger.log(Level.FINEST, "Instance created " + proxyKey);
                    FactoryImpl.this.node.clusterService.enqueueAndReturn(new Processable(){

                        public void process() {
                            FactoryImpl.this.createProxy(proxyKey);
                        }
                    });
                }
            }

            public void entryRemoved(EntryEvent event) {
                if (FactoryImpl.this.node.localMember.equals(event.getMember())) {
                    return;
                }
                final ProxyKey proxyKey = (ProxyKey)event.getKey();
                FactoryImpl.this.logger.log(Level.FINEST, "Instance removed " + proxyKey);
                FactoryImpl.this.node.clusterService.enqueueAndReturn(new Processable(){

                    public void process() {
                        FactoryImpl.this.destroyProxy(proxyKey);
                    }
                });
            }

            public void entryUpdated(EntryEvent event) {
                FactoryImpl.this.logger.log(Level.FINEST, "Instance updated " + event.getKey());
            }

            public void entryEvicted(EntryEvent event) {
                FactoryImpl.this.logger.log(Level.FINEST, "Instance evicted " + event.getKey());
            }
        }, false);
        if (this.node.getClusterImpl().getMembers().size() > 1) {
            Set proxyKeys = this.globalProxies.allKeys();
            for (final ProxyKey proxyKey : proxyKeys) {
                if (this.proxies.containsKey(proxyKey)) continue;
                this.node.clusterService.enqueueAndReturn(new Processable(){

                    public void process() {
                        FactoryImpl.this.createProxy(proxyKey);
                    }
                });
            }
        }
        this.managementService = new ManagementService(this);
        this.managementService.register();
        ManagementCenterService managementCenterServiceTmp = null;
        if (this.node.groupProperties.MANCENTER_ENABLED.getBoolean()) {
            try {
                managementCenterServiceTmp = new ManagementCenterService(this);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.managementCenterService = managementCenterServiceTmp;
    }

    public Set<String> getLongInstanceNames() {
        return this.proxiesByName.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactoryImpl factory = (FactoryImpl)o;
        return this.name.equals(factory.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "HazelcastInstance {name='" + this.name + "'}";
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public Collection<Instance> getInstances() {
        return new ArrayList<Instance>(this.proxies.values());
    }

    public Collection<HazelcastInstanceAwareInstance> getProxies() {
        this.initialChecks();
        return this.proxies.values();
    }

    @Override
    public ExecutorService getExecutorService() {
        this.initialChecks();
        return this.getExecutorService("default");
    }

    @Override
    public ExecutorService getExecutorService(String name) {
        ExecutorServiceProxy old;
        if (name == null) {
            throw new IllegalArgumentException("ExecutorService name cannot be null");
        }
        this.initialChecks();
        name = "x:" + name;
        ExecutorServiceProxy executorServiceProxy = (ExecutorServiceProxy)this.executorServiceProxies.get(name);
        if (executorServiceProxy == null && (old = this.executorServiceProxies.putIfAbsent(name, executorServiceProxy = new ExecutorServiceProxy(this.node, name))) != null) {
            executorServiceProxy = old;
        }
        return executorServiceProxy;
    }

    @Override
    public ClusterImpl getCluster() {
        this.initialChecks();
        return this.node.getClusterImpl();
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getOrCreateProxyByName("i:" + name);
    }

    @Override
    public AtomicNumber getAtomicNumber(String name) {
        return (AtomicNumber)this.getOrCreateProxyByName("a:" + name);
    }

    @Override
    public Semaphore getSemaphore(String name) {
        Semaphore semaphore = (Semaphore)this.getOrCreateProxyByName("smp:" + name);
        return semaphore;
    }

    @Override
    public Transaction getTransaction() {
        this.initialChecks();
        ThreadContext threadContext = ThreadContext.get();
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        if (txn == null) {
            txn = this.transactionFactory.newTransaction();
            threadContext.getCallContext().setTransaction(txn);
        }
        return txn;
    }

    @Override
    public PartitionService getPartitionService() {
        return this.node.concurrentMapManager.partitionManager.partitionServiceImpl;
    }

    @Override
    public LoggingService getLoggingService() {
        return this.node.loggingService;
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public void restart() {
        this.lifecycleService.restart();
    }

    @Override
    public void shutdown() {
        this.lifecycleService.shutdown();
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getOrCreateProxyByName("c:" + name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getOrCreateProxyByName("q:" + name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getOrCreateProxyByName("t:" + name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getOrCreateProxyByName("m:s:" + name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getOrCreateProxyByName("l:" + name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getOrCreateProxyByName("m:u:" + name);
    }

    @Override
    public ILock getLock(Object key) {
        return (ILock)this.getOrCreateProxy(new ProxyKey("lock", key));
    }

    public Object getOrCreateProxyByName(String name) {
        Object proxy = this.proxiesByName.get(name);
        if (proxy == null) {
            proxy = this.getOrCreateProxy(new ProxyKey(name, null));
        }
        this.checkInitialization(proxy);
        return proxy;
    }

    public Object getOrCreateProxy(ProxyKey proxyKey) {
        this.initialChecks();
        Object proxy = this.proxies.get(proxyKey);
        if (proxy == null) {
            proxy = this.createInstanceClusterWide(proxyKey);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialization(Object proxy) {
        MProxy mProxy;
        CMap cmap;
        if (proxy instanceof MProxy && !(cmap = this.node.concurrentMapManager.getMap((mProxy = (MProxy)proxy).getLongName())).isMapForQueue() && !cmap.initialized) {
            Object object = cmap.getInitLock();
            synchronized (object) {
                block10: {
                    if (!cmap.initialized && cmap.loader != null) {
                        try {
                            Set keys;
                            if (this.getAtomicNumber(this.name).compareAndSet(0L, 1L)) {
                                ExecutorService es = this.getExecutorService();
                                MultiTask<Boolean> task = new MultiTask<Boolean>(new InitializeMap(mProxy.getName()), this.getCluster().getMembers());
                                es.execute(task);
                            }
                            if ((keys = cmap.loader.loadAllKeys()) != null) {
                                int count = 0;
                                PartitionService partitionService = this.getPartitionService();
                                HashSet ownedKeys = new HashSet();
                                for (Object key : keys) {
                                    if (!partitionService.getPartition(key).getOwner().localMember()) continue;
                                    ownedKeys.add(key);
                                    ++count;
                                    if (ownedKeys.size() < this.node.groupProperties.MAP_LOAD_CHUNK_SIZE.getInteger()) continue;
                                    this.loadKeys(mProxy, cmap, ownedKeys);
                                    ownedKeys.clear();
                                }
                                this.loadKeys(mProxy, cmap, ownedKeys);
                                this.logger.log(Level.INFO, this.node.address + "[" + mProxy.getName() + "] loaded " + count);
                            }
                        }
                        catch (Throwable e) {
                            if (!this.node.isActive()) break block10;
                            this.logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
                cmap.initialized = true;
            }
        }
    }

    private void loadKeys(MProxy mProxy, CMap cmap, Set keys) {
        Map map;
        if (keys.size() > 0 && (map = cmap.loader.loadAll(keys)) != null && map.size() > 0) {
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                mProxy.putTransient(entry.getKey(), entry.getValue(), 0L, null);
            }
        }
    }

    public void initialChecks() {
        while (this.node.isActive() && this.lifecycleService.paused.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (!this.node.isActive()) {
            throw new IllegalStateException("Hazelcast Instance is not active!");
        }
    }

    public void destroyProxy(ProxyKey proxyKey) {
        this.proxiesByName.remove(proxyKey.name);
        Instance proxy = (Instance)this.proxies.remove(proxyKey);
        if (proxy != null) {
            String name = proxyKey.name;
            if (name.startsWith("q:")) {
                this.node.blockingQueueManager.destroy(name);
            } else if (name.startsWith("c:")) {
                this.node.concurrentMapManager.destroy(name);
            } else if (name.startsWith("m:")) {
                this.node.concurrentMapManager.destroy(name);
            } else if (name.startsWith("t:")) {
                this.node.topicManager.destroy(name);
            }
            this.fireInstanceDestroyEvent(proxy);
        }
    }

    public Object createProxy(ProxyKey proxyKey) {
        this.node.clusterManager.checkServiceThread();
        boolean created = false;
        HazelcastInstanceAwareInstance proxy = (HazelcastInstanceAwareInstance)this.proxies.get(proxyKey);
        if (proxy == null) {
            created = true;
            String name = proxyKey.name;
            if (name.startsWith("q:")) {
                proxy = new QProxyImpl(name, this);
            } else if (name.startsWith("t:")) {
                proxy = new TopicProxyImpl(name, this);
            } else if (name.startsWith("c:")) {
                proxy = new MProxyImpl(name, this);
                this.node.concurrentMapManager.getOrCreateMap(name);
            } else if (name.startsWith("l:")) {
                proxy = new ListProxyImpl(name, this);
            } else if (name.startsWith("m:")) {
                proxy = BaseManager.getInstanceType(name) == Instance.InstanceType.MULTIMAP ? new MultiMapProxyImpl(name, this) : new CollectionProxyImpl(name, this);
            } else if (name.startsWith("a:")) {
                proxy = new AtomicNumberImpl(name, this);
            } else if (name.startsWith("i:")) {
                proxy = new IdGeneratorProxy(name, this);
            } else if (name.equals("lock")) {
                proxy = new LockProxy(this, proxyKey.key);
            } else if (name.startsWith("smp:")) {
                proxy = new SemaphoreImpl(name, this);
            }
            HazelcastInstanceAwareInstance anotherProxy = this.proxies.putIfAbsent(proxyKey, proxy);
            if (anotherProxy != null) {
                created = false;
                proxy = anotherProxy;
            }
            if (proxyKey.key == null) {
                this.proxiesByName.put(proxyKey.name, proxy);
            }
        }
        if (created) {
            this.fireInstanceCreateEvent(proxy);
        }
        return proxy;
    }

    @Override
    public void addInstanceListener(InstanceListener instanceListener) {
        this.lsInstanceListeners.add(instanceListener);
    }

    @Override
    public void removeInstanceListener(InstanceListener instanceListener) {
        this.lsInstanceListeners.remove(instanceListener);
    }

    void fireInstanceCreateEvent(Instance instance) {
        if (this.lsInstanceListeners.size() > 0) {
            final InstanceEvent instanceEvent = new InstanceEvent(InstanceEvent.InstanceEventType.CREATED, instance);
            for (final InstanceListener instanceListener : this.lsInstanceListeners) {
                this.node.executorManager.executeLocally(new Runnable(){

                    public void run() {
                        instanceListener.instanceCreated(instanceEvent);
                    }
                });
            }
        }
    }

    void fireInstanceDestroyEvent(Instance instance) {
        if (this.lsInstanceListeners.size() > 0) {
            final InstanceEvent instanceEvent = new InstanceEvent(InstanceEvent.InstanceEventType.DESTROYED, instance);
            for (final InstanceListener instanceListener : this.lsInstanceListeners) {
                this.node.executorManager.executeLocally(new Runnable(){

                    public void run() {
                        instanceListener.instanceDestroyed(instanceEvent);
                    }
                });
            }
        }
    }

    Object createInstanceClusterWide(final ProxyKey proxyKey) {
        final BlockingQueue result = ResponseQueueFactory.newResponseQueue();
        this.node.clusterService.enqueueAndReturn(new Processable(){

            public void process() {
                try {
                    result.put(FactoryImpl.this.createProxy(proxyKey));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        Object proxy = null;
        try {
            proxy = result.take();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.globalProxies.put(proxyKey, Constants.IO.EMPTY_DATA);
        return proxy;
    }

    void destroyInstanceClusterWide(String name, Object key) {
        final ProxyKey proxyKey = new ProxyKey(name, key);
        if (this.proxies.containsKey(proxyKey)) {
            if (name.equals("lock")) {
                this.locksMapProxy.remove(key);
            } else if (name.startsWith("i:")) {
                this.idGeneratorMapProxy.remove(name);
            }
            this.globalProxies.remove(proxyKey);
            this.node.clusterService.enqueueAndWait(new Processable(){

                public void process() {
                    try {
                        FactoryImpl.this.destroyProxy(proxyKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 5);
        } else {
            this.logger.log(Level.WARNING, "Destroying unknown instance name: " + name);
        }
    }

    private static void check(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException(obj.getClass().getName() + " is not Serializable.");
        }
    }

    public static class IdGeneratorProxy
    extends FactoryAwareNamedProxy
    implements IdGenerator,
    DataSerializable {
        private transient IdGenerator base = null;

        public IdGeneratorProxy() {
        }

        public IdGeneratorProxy(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.base = new IdGeneratorBase();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (IdGenerator)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "IdGenerator [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdGeneratorProxy that = (IdGeneratorProxy)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public long newId() {
            this.ensure();
            return this.base.newId();
        }

        private class IdGeneratorBase
        implements IdGenerator {
            private static final long MILLION = 1000000L;
            final AtomicLong million = new AtomicLong(-1L);
            final AtomicLong currentId = new AtomicLong(2000000L);

            private IdGeneratorBase() {
            }

            public String getName() {
                return IdGeneratorProxy.this.name.substring("i:".length());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long newId() {
                long idAddition = this.currentId.incrementAndGet();
                if (idAddition >= 1000000L) {
                    IdGeneratorBase idGeneratorBase = this;
                    synchronized (idGeneratorBase) {
                        try {
                            idAddition = this.currentId.get();
                            if (idAddition >= 1000000L) {
                                Long idMillion = this.getNewMillion();
                                long newMillion = idMillion * 1000000L;
                                this.million.set(newMillion);
                                this.currentId.set(0L);
                            }
                            return this.newId();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                long millionNow = this.million.get();
                return millionNow + idAddition;
            }

            private Long getNewMillion() {
                return IdGeneratorProxy.this.factory.getAtomicNumber("__idGen" + IdGeneratorProxy.this.name).incrementAndGet() - 1L;
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.ID_GENERATOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void destroy() {
                this.currentId.set(2000000L);
                IdGeneratorBase idGeneratorBase = this;
                synchronized (idGeneratorBase) {
                    IdGeneratorProxy.this.factory.destroyInstanceClusterWide(IdGeneratorProxy.this.name, null);
                    IdGeneratorProxy.this.factory.getAtomicNumber("__idGen" + IdGeneratorProxy.this.name).destroy();
                    this.currentId.set(2000000L);
                    this.million.set(-1L);
                }
            }

            public Object getId() {
                return IdGeneratorProxy.this.name;
            }
        }
    }

    public static class MProxyImpl
    extends FactoryAwareNamedProxy
    implements MProxy,
    DataSerializable {
        private transient MProxy mproxyReal = null;
        private transient ConcurrentMapManager concurrentMapManager = null;
        private transient ListenerManager listenerManager = null;
        private volatile transient MProxy dynamicProxy;

        public MProxyImpl() {
        }

        MProxyImpl(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.mproxyReal = new MProxyReal();
        }

        public MapOperationsCounter getMapOperationCounter() {
            return this.mproxyReal.getMapOperationCounter();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            super.setHazelcastInstance(hazelcastInstance);
            this.concurrentMapManager = this.factory.node.concurrentMapManager;
            this.listenerManager = this.factory.node.listenerManager;
            ClassLoader cl = MProxy.class.getClassLoader();
            this.dynamicProxy = (MProxy)Proxy.newProxyInstance(cl, new Class[]{MProxy.class}, (InvocationHandler)new DynamicInvoker());
        }

        private void beforeCall() {
            ThreadContext.get().setCurrentFactory(this.factory);
            this.factory.initialChecks();
            if (this.mproxyReal == null) {
                this.mproxyReal = (MProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        private void afterCall() {
        }

        public Object get(Object key) {
            this.beforeCall();
            try {
                Object v = this.mproxyReal.get(key);
                return v;
            }
            catch (Throwable e) {
                if (this.factory.restarted) {
                    Object object = this.get(key);
                    return object;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public Object put(Object key, Object value) {
            return this.put(key, value, 0L, TimeUnit.SECONDS);
        }

        public Future getAsync(Object key) {
            final MProxyImpl mProxy = this;
            final Data dataKey = IOUtil.toData(key);
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    this.setResult(mProxy.get(dataKey));
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        public Future putAsync(Object key, Object value) {
            final MProxyImpl mProxy = this;
            final Data dataKey = IOUtil.toData(key);
            final Data dataValue = IOUtil.toData(value);
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    this.setResult(mProxy.put(dataKey, dataValue));
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        public Future removeAsync(Object key) {
            final MProxyImpl mProxy = this;
            final Data dataKey = IOUtil.toData(key);
            AsyncCall call = new AsyncCall(){

                protected void call() {
                    this.setResult(mProxy.remove(dataKey));
                }
            };
            this.factory.node.executorManager.executeAsync(call);
            return call;
        }

        public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
            this.beforeCall();
            try {
                Object object = this.mproxyReal.put(key, value, ttl, timeunit);
                return object;
            }
            catch (Throwable e) {
                if (this.factory.restarted) {
                    Object object = this.put(key, value);
                    return object;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public Object remove(Object key) {
            this.beforeCall();
            try {
                Object v = this.mproxyReal.remove(key);
                return v;
            }
            catch (Throwable e) {
                if (this.factory.restarted) {
                    Object object = this.remove(key);
                    return object;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public Object tryRemove(Object key, long time, TimeUnit timeunit) throws TimeoutException {
            this.beforeCall();
            try {
                Object object = this.mproxyReal.tryRemove(key, time, timeunit);
                return object;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof TimeoutException) {
                    throw (TimeoutException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.afterCall();
            }
        }

        public void putAndUnlock(Object key, Object value) {
            this.dynamicProxy.putAndUnlock(key, value);
        }

        public Object tryLockAndGet(Object key, long time, TimeUnit timeunit) throws TimeoutException {
            return this.dynamicProxy.tryLockAndGet(key, time, timeunit);
        }

        public Map getAll(Set keys) {
            return this.dynamicProxy.getAll(keys);
        }

        public void flush() {
            this.dynamicProxy.flush();
        }

        public void putTransient(Object key, Object value, long time, TimeUnit timeunit) {
            this.dynamicProxy.putTransient(key, value, time, timeunit);
        }

        public boolean tryPut(Object key, Object value, long time, TimeUnit timeunit) {
            return this.dynamicProxy.tryPut(key, value, time, timeunit);
        }

        public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
            return this.dynamicProxy.putIfAbsent(key, value, ttl, timeunit);
        }

        public Object putIfAbsent(Object key, Object value) {
            return this.dynamicProxy.putIfAbsent(key, value);
        }

        public LocalMapStats getLocalMapStats() {
            return this.dynamicProxy.getLocalMapStats();
        }

        public void addIndex(String attribute, boolean ordered) {
            this.dynamicProxy.addIndex(attribute, ordered);
        }

        public void addIndex(Expression expression, boolean ordered) {
            this.dynamicProxy.addIndex(expression, ordered);
        }

        public Object getId() {
            return this.dynamicProxy.getId();
        }

        public String toString() {
            return "Map [" + this.getName() + "] " + this.factory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MProxyImpl mProxy = (MProxyImpl)o;
            return this.name.equals(mProxy.name);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void destroy() {
            this.dynamicProxy.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            return this.dynamicProxy.getInstanceType();
        }

        public boolean removeKey(Object key) {
            return this.dynamicProxy.removeKey(key);
        }

        public int size() {
            return this.dynamicProxy.size();
        }

        public boolean isEmpty() {
            return this.dynamicProxy.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.dynamicProxy.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.dynamicProxy.containsValue(value);
        }

        public MapEntry getMapEntry(Object key) {
            return this.dynamicProxy.getMapEntry(key);
        }

        public void putAll(Map t) {
            this.dynamicProxy.putAll(t);
        }

        public void clear() {
            this.dynamicProxy.clear();
        }

        public int valueCount(Object key) {
            return this.dynamicProxy.valueCount(key);
        }

        public Set allKeys() {
            return this.dynamicProxy.allKeys();
        }

        public Set localKeySet() {
            return this.dynamicProxy.localKeySet();
        }

        public Set localKeySet(Predicate predicate) {
            return this.dynamicProxy.localKeySet(predicate);
        }

        public Set keySet() {
            return this.dynamicProxy.keySet();
        }

        public Collection values() {
            return this.dynamicProxy.values();
        }

        public Set entrySet() {
            return this.dynamicProxy.entrySet();
        }

        public Set keySet(Predicate predicate) {
            return this.dynamicProxy.keySet(predicate);
        }

        public Collection values(Predicate predicate) {
            return this.dynamicProxy.values(predicate);
        }

        public Set entrySet(Predicate predicate) {
            return this.dynamicProxy.entrySet(predicate);
        }

        public boolean remove(Object key, Object value) {
            return this.dynamicProxy.remove(key, value);
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            return this.dynamicProxy.replace(key, oldValue, newValue);
        }

        public Object replace(Object key, Object value) {
            return this.dynamicProxy.replace(key, value);
        }

        public String getName() {
            return this.name.substring("c:".length());
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            return this.dynamicProxy.lockMap(time, timeunit);
        }

        public void unlockMap() {
            this.dynamicProxy.unlockMap();
        }

        public void lock(Object key) {
            this.dynamicProxy.lock(key);
        }

        public boolean tryLock(Object key) {
            return this.dynamicProxy.tryLock(key);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            return this.dynamicProxy.tryLock(key, time, timeunit);
        }

        public void unlock(Object key) {
            this.dynamicProxy.unlock(key);
        }

        public String getLongName() {
            return this.dynamicProxy.getLongName();
        }

        public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
            this.dynamicProxy.addGenericListener(listener, key, includeValue, instanceType);
        }

        public void removeGenericListener(Object listener, Object key) {
            this.dynamicProxy.removeGenericListener(listener, key);
        }

        public void addLocalEntryListener(EntryListener entryListener) {
            this.dynamicProxy.addLocalEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener listener, boolean includeValue) {
            this.dynamicProxy.addEntryListener(listener, includeValue);
        }

        public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
            this.dynamicProxy.addEntryListener(listener, key, includeValue);
        }

        public void removeEntryListener(EntryListener listener) {
            this.dynamicProxy.removeEntryListener(listener);
        }

        public void removeEntryListener(EntryListener listener, Object key) {
            this.dynamicProxy.removeEntryListener(listener, key);
        }

        public boolean containsEntry(Object key, Object value) {
            return this.dynamicProxy.containsEntry(key, value);
        }

        public boolean putMulti(Object key, Object value) {
            return this.dynamicProxy.putMulti(key, value);
        }

        public boolean removeMulti(Object key, Object value) {
            return this.dynamicProxy.removeMulti(key, value);
        }

        public boolean add(Object value) {
            return this.dynamicProxy.add(value);
        }

        public boolean evict(Object key) {
            return this.dynamicProxy.evict(key);
        }

        private class MProxyReal
        implements MProxy {
            private final transient MapOperationsCounter mapOperationCounter = new MapOperationsCounter();

            public String toString() {
                return "Map [" + this.getName() + "]";
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.MAP;
            }

            public Object getId() {
                return MProxyImpl.this.name;
            }

            public boolean equals(Object o) {
                return MProxyImpl.this.equals(o);
            }

            public int hashCode() {
                return MProxyImpl.this.hashCode();
            }

            public String getLongName() {
                return MProxyImpl.this.name;
            }

            public String getName() {
                return MProxyImpl.this.name.substring("c:".length());
            }

            public void addIndex(String attribute, boolean ordered) {
                this.addIndex((Expression)Predicates.get(attribute), ordered);
            }

            public void addIndex(final Expression expression, final boolean ordered) {
                final CountDownLatch latch = new CountDownLatch(1);
                MProxyImpl.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                    public void process() {
                        AddMapIndex addMapIndexProcess = new AddMapIndex(MProxyImpl.this.name, expression, ordered);
                        MProxyImpl.this.concurrentMapManager.sendProcessableToAll(addMapIndexProcess, true);
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }

            public void flush() {
                MProxyImpl.this.concurrentMapManager.flush(MProxyImpl.this.name);
            }

            public MapEntry getMapEntry(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MGetMapEntry mgetMapEntry = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MGetMapEntry();
                MapEntry mapEntry = mgetMapEntry.get(MProxyImpl.this.name, key);
                this.mapOperationCounter.incrementGets(System.currentTimeMillis() - begin);
                return mapEntry;
            }

            public boolean putMulti(Object key, Object value) {
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPutMulti mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPutMulti();
                return mput.put(MProxyImpl.this.name, key, value);
            }

            public Object put(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                Object result = mput.put(MProxyImpl.this.name, key, value, -1L, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public Map getAll(Set keys) {
                if (keys == null) {
                    throw new NullPointerException();
                }
                return MProxyImpl.this.concurrentMapManager.getAll(MProxyImpl.this.name, keys);
            }

            public Future getAsync(Object key) {
                throw new UnsupportedOperationException();
            }

            public Future putAsync(Object key, Object value) {
                throw new UnsupportedOperationException();
            }

            public Future removeAsync(Object key) {
                throw new UnsupportedOperationException();
            }

            public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
                if (ttl < 0L) {
                    throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
                }
                ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
                return this.put(key, value, -1L, ttl);
            }

            public void putTransient(Object key, Object value, long ttl, TimeUnit timeunit) {
                if (ttl < 0L) {
                    throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
                }
                ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
                MProxyImpl.this.concurrentMapManager.putTransient(MProxyImpl.this.name, key, value, -1L, ttl);
            }

            public Object put(Object key, Object value, long timeout, long ttl) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                Object result = mput.put(MProxyImpl.this.name, key, value, timeout, ttl);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public boolean tryPut(Object key, Object value, long timeout, TimeUnit timeunit) {
                long begin = System.currentTimeMillis();
                if (timeout < 0L) {
                    throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
                }
                timeout = timeout == 0L ? -1L : Util.toMillis(timeout, timeunit);
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
                Boolean result = mput.tryPut(MProxyImpl.this.name, key, value, timeout, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public Object tryLockAndGet(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
                long begin = System.currentTimeMillis();
                if (timeout < 0L) {
                    throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
                }
                timeout = Util.toMillis(timeout, timeunit);
                FactoryImpl.check(key);
                Object result = MProxyImpl.this.concurrentMapManager.tryLockAndGet(MProxyImpl.this.name, key, timeout);
                this.mapOperationCounter.incrementGets(System.currentTimeMillis() - begin);
                return result;
            }

            public void putAndUnlock(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                MProxyImpl.this.concurrentMapManager.putAndUnlock(MProxyImpl.this.name, key, value);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
            }

            public Object putIfAbsent(Object key, Object value) {
                return this.putIfAbsent(key, value, -1L, -1L);
            }

            public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
                if (ttl < 0L) {
                    throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
                }
                ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
                return this.putIfAbsent(key, value, -1L, timeunit.toMillis(ttl));
            }

            public Object putIfAbsent(Object key, Object value, long timeout, long ttl) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
                Object result = mput.putIfAbsent(MProxyImpl.this.name, key, value, timeout, ttl);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public Object get(Object key) {
                FactoryImpl.check(key);
                long begin = System.currentTimeMillis();
                ConcurrentMapManager.MGet mget = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMGet();
                Object result = mget.get(MProxyImpl.this.name, key, -1L);
                if (result == null && MProxyImpl.this.name.contains("testConcurrentLockPrimitive")) {
                    boolean isClient = ThreadContext.get().isClient();
                    Transaction txn = ThreadContext.get().getTransaction();
                    throw new RuntimeException(result + " testConcurrentLockPrimitive returns null " + isClient + "  " + txn);
                }
                this.mapOperationCounter.incrementGets(System.currentTimeMillis() - begin);
                return result;
            }

            public Object remove(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
                Object result = mremove.remove(MProxyImpl.this.name, key, -1L);
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public Object tryRemove(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
                Object result = mremove.tryRemove(MProxyImpl.this.name, key, Util.toMillis(timeout, timeunit));
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public int size() {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MSize msize = concurrentMapManager.new ConcurrentMapManager.MSize(MProxyImpl.this.name);
                return msize.getSize();
            }

            public int valueCount(Object key) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MValueCount mcount = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MValueCount();
                int count = ((Number)mcount.count(MProxyImpl.this.name, key, -1L)).intValue();
                return count;
            }

            public boolean removeMulti(Object key, Object value) {
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MRemoveMulti mremove = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti();
                return mremove.remove(MProxyImpl.this.name, key, value);
            }

            public boolean remove(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MRemove mremove = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemove();
                boolean result = mremove.removeIfSame(MProxyImpl.this.name, key, value, -1L) != null;
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public Object replace(Object key, Object value) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
                Object result = mput.replace(MProxyImpl.this.name, key, value, -1L, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public boolean replace(Object key, Object oldValue, Object newValue) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                FactoryImpl.check(oldValue);
                FactoryImpl.check(newValue);
                ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
                Boolean result = mput.replace(MProxyImpl.this.name, key, oldValue, newValue, -1L);
                this.mapOperationCounter.incrementPuts(System.currentTimeMillis() - begin);
                return result;
            }

            public boolean lockMap(long time, TimeUnit timeunit) {
                if (((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.tryLock("map_lock_" + MProxyImpl.this.name, time, timeunit)) {
                    ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                    concurrentMapManager.getClass();
                    ConcurrentMapManager.MLockMap mLockMap = concurrentMapManager.new ConcurrentMapManager.MLockMap(MProxyImpl.this.name, true);
                    mLockMap.call();
                    return true;
                }
                return false;
            }

            public void unlockMap() {
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MLockMap mLockMap = concurrentMapManager.new ConcurrentMapManager.MLockMap(MProxyImpl.this.name, false);
                mLockMap.call();
                ((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.unlock("map_lock_" + MProxyImpl.this.name);
            }

            public void lock(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                mlock.lock(MProxyImpl.this.name, key, -1L);
            }

            public boolean tryLock(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                return mlock.lock(MProxyImpl.this.name, key, 0L);
            }

            public boolean tryLock(Object key, long time, TimeUnit timeunit) {
                FactoryImpl.check(key);
                if (time < 0L) {
                    throw new IllegalArgumentException("Time cannot be negative. time = " + time);
                }
                this.mapOperationCounter.incrementOtherOperations();
                long timeoutMillis = timeunit.toMillis(time);
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                return mlock.lock(MProxyImpl.this.name, key, timeoutMillis < 0L || timeoutMillis == Long.MAX_VALUE ? -1L : timeoutMillis);
            }

            public void unlock(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
                mlock.unlock(MProxyImpl.this.name, key, 0L);
            }

            public LocalMapStats getLocalMapStats() {
                this.mapOperationCounter.incrementOtherOperations();
                LocalMapStatsImpl localMapStats = MProxyImpl.this.concurrentMapManager.getLocalMapStats(MProxyImpl.this.name);
                localMapStats.setOperationStats(this.mapOperationCounter.getPublishedStats());
                return localMapStats;
            }

            public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                MProxyImpl.this.listenerManager.addListener(MProxyImpl.this.name, listener, key, includeValue, instanceType);
            }

            public void removeGenericListener(Object listener, Object key) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                MProxyImpl.this.listenerManager.removeListener(MProxyImpl.this.name, listener, key);
            }

            public void addLocalEntryListener(EntryListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                MProxyImpl.this.listenerManager.addLocalListener(MProxyImpl.this.name, listener, this.getInstanceType());
            }

            public void addEntryListener(EntryListener listener, boolean includeValue) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                this.addGenericListener(listener, null, includeValue, this.getInstanceType());
            }

            public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                FactoryImpl.check(key);
                this.addGenericListener(listener, key, includeValue, this.getInstanceType());
            }

            public void removeEntryListener(EntryListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                this.removeGenericListener(listener, null);
            }

            public void removeEntryListener(EntryListener listener, Object key) {
                if (listener == null) {
                    throw new IllegalArgumentException("Listener cannot be null");
                }
                FactoryImpl.check(key);
                this.removeGenericListener(listener, key);
            }

            public boolean containsEntry(Object key, Object value) {
                FactoryImpl.check(key);
                FactoryImpl.check(value);
                this.mapOperationCounter.incrementOtherOperations();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.has(MProxyImpl.this.name, key)) {
                    Object v = txn.get(MProxyImpl.this.name, key);
                    return v != null;
                }
                ConcurrentMapManager.MContainsKey mContainsKey = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MContainsKey();
                return mContainsKey.containsEntry(MProxyImpl.this.name, key, value);
            }

            public boolean containsKey(Object key) {
                FactoryImpl.check(key);
                this.mapOperationCounter.incrementOtherOperations();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.has(MProxyImpl.this.name, key)) {
                    Object value = txn.get(MProxyImpl.this.name, key);
                    return value != null;
                }
                ConcurrentMapManager.MContainsKey mContainsKey = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MContainsKey();
                return mContainsKey.containsKey(MProxyImpl.this.name, key);
            }

            public boolean containsValue(Object value) {
                FactoryImpl.check(value);
                this.mapOperationCounter.incrementOtherOperations();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.containsValue(MProxyImpl.this.name, value)) {
                    return true;
                }
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MContainsValue mContainsValue = concurrentMapManager.new ConcurrentMapManager.MContainsValue(MProxyImpl.this.name, value);
                return (Boolean)mContainsValue.call();
            }

            public boolean isEmpty() {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MEmpty mempty = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MEmpty();
                return mempty.isEmpty(MProxyImpl.this.name);
            }

            public void putAll(Map map) {
                Set entries = map.entrySet();
                TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
                if (txn != null && txn.getStatus() == 1) {
                    for (Map.Entry entry : entries) {
                        this.put(entry.getKey(), entry.getValue());
                    }
                } else {
                    MProxyImpl.this.concurrentMapManager.doPutAll(MProxyImpl.this.name, map);
                }
            }

            public boolean add(Object value) {
                FactoryImpl.check(value);
                ConcurrentMapManager.MAdd madd = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MAdd();
                MProxyImpl.this.concurrentMapManager;
                Instance.InstanceType type = ConcurrentMapManager.getInstanceType(MProxyImpl.this.name);
                if (type == Instance.InstanceType.LIST) {
                    return madd.addToList(MProxyImpl.this.name, value);
                }
                return madd.addToSet(MProxyImpl.this.name, value);
            }

            public boolean removeKey(Object key) {
                long begin = System.currentTimeMillis();
                FactoryImpl.check(key);
                ConcurrentMapManager.MRemoveItem mRemoveItem = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemoveItem();
                boolean result = mRemoveItem.removeItem(MProxyImpl.this.name, key);
                this.mapOperationCounter.incrementRemoves(System.currentTimeMillis() - begin);
                return result;
            }

            public void clear() {
                Set keys = this.keySet();
                for (Object key : keys) {
                    this.removeKey(key);
                }
            }

            public Set localKeySet() {
                return this.localKeySet(null);
            }

            public Set localKeySet(Predicate predicate) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MIterateLocal miterate = concurrentMapManager.new ConcurrentMapManager.MIterateLocal(MProxyImpl.this.name, predicate);
                return miterate.iterate();
            }

            public Set entrySet(Predicate predicate) {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, predicate);
            }

            public Set keySet(Predicate predicate) {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, predicate);
            }

            public Collection values(Predicate predicate) {
                return this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, predicate);
            }

            public Set entrySet() {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, null);
            }

            public Set keySet() {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null);
            }

            public Set allKeys() {
                return (Set)this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL, null);
            }

            public MapOperationsCounter getMapOperationCounter() {
                return this.mapOperationCounter;
            }

            public Collection values() {
                return this.iterate(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, null);
            }

            private Collection iterate(ClusterOperation iteratorType, Predicate predicate) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MIterate miterate = concurrentMapManager.new ConcurrentMapManager.MIterate(iteratorType, MProxyImpl.this.name, predicate);
                return (Collection)miterate.call();
            }

            public void destroy() {
                MProxyImpl.this.factory.destroyInstanceClusterWide(MProxyImpl.this.name, null);
            }

            public boolean evict(Object key) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager.MEvict mevict = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMEvict();
                return mevict.evict(MProxyImpl.this.name, key);
            }
        }

        class DynamicInvoker
        implements InvocationHandler {
            DynamicInvoker() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MProxyImpl.this.beforeCall();
                try {
                    Object object = method.invoke((Object)MProxyImpl.this.mproxyReal, args);
                    return object;
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        throw ite.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    MProxyImpl.this.afterCall();
                }
            }
        }
    }

    public static class MultiMapProxyImpl
    extends FactoryAwareNamedProxy
    implements MultiMapProxy,
    DataSerializable,
    IGetAwareProxy {
        private transient MultiMapProxy base = null;

        public MultiMapProxyImpl() {
        }

        public MultiMapProxyImpl(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
            this.base = new MultiMapReal();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (MultiMapProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public MultiMapReal getBase() {
            return (MultiMapReal)this.base;
        }

        public MProxy getMProxy() {
            this.ensure();
            return this.base.getMProxy();
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "MultiMap [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiMapProxyImpl that = (MultiMapProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.factory.destroyInstanceClusterWide(this.name, null);
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public boolean put(Object key, Object value) {
            this.ensure();
            return this.base.put(key, value);
        }

        public Collection get(Object key) {
            this.ensure();
            return this.base.get(key);
        }

        public boolean remove(Object key, Object value) {
            this.ensure();
            return this.base.remove(key, value);
        }

        public Collection remove(Object key) {
            this.ensure();
            return this.base.remove(key);
        }

        public Set localKeySet() {
            this.ensure();
            return this.base.localKeySet();
        }

        public Set keySet() {
            this.ensure();
            return this.base.keySet();
        }

        public Collection values() {
            this.ensure();
            return this.base.values();
        }

        public Set entrySet() {
            this.ensure();
            return this.base.entrySet();
        }

        public boolean containsKey(Object key) {
            this.ensure();
            return this.base.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.ensure();
            return this.base.containsValue(value);
        }

        public boolean containsEntry(Object key, Object value) {
            this.ensure();
            return this.base.containsEntry(key, value);
        }

        public int size() {
            this.ensure();
            return this.base.size();
        }

        public void clear() {
            this.ensure();
            this.base.clear();
        }

        public int valueCount(Object key) {
            this.ensure();
            return this.base.valueCount(key);
        }

        public void addLocalEntryListener(EntryListener entryListener) {
            this.ensure();
            this.base.addLocalEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener entryListener, boolean includeValue) {
            this.ensure();
            this.base.addEntryListener(entryListener, includeValue);
        }

        public void removeEntryListener(EntryListener entryListener) {
            this.ensure();
            this.base.removeEntryListener(entryListener);
        }

        public void addEntryListener(EntryListener entryListener, Object key, boolean includeValue) {
            this.ensure();
            this.base.addEntryListener(entryListener, key, includeValue);
        }

        public void removeEntryListener(EntryListener entryListener, Object key) {
            this.ensure();
            this.base.removeEntryListener(entryListener, key);
        }

        public void lock(Object key) {
            this.ensure();
            this.base.lock(key);
        }

        public boolean tryLock(Object key) {
            this.ensure();
            return this.base.tryLock(key);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            this.ensure();
            return this.base.tryLock(key, time, timeunit);
        }

        public void unlock(Object key) {
            this.ensure();
            this.base.unlock(key);
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            this.ensure();
            return this.base.lockMap(time, timeunit);
        }

        public void unlockMap() {
            this.ensure();
            this.base.unlockMap();
        }

        class MultiMapReal
        implements MultiMapProxy,
        IGetAwareProxy {
            final MProxy mapProxy;

            private MultiMapReal() {
                this.mapProxy = new MProxyImpl(MultiMapProxyImpl.this.name, MultiMapProxyImpl.this.factory);
            }

            public MProxy getMProxy() {
                return this.mapProxy;
            }

            public String getName() {
                return MultiMapProxyImpl.this.name.substring("m:u:".length());
            }

            public void clear() {
                this.mapProxy.clear();
            }

            public boolean containsEntry(Object key, Object value) {
                return this.mapProxy.containsEntry(key, value);
            }

            public boolean containsKey(Object key) {
                return this.mapProxy.containsKey(key);
            }

            public boolean containsValue(Object value) {
                return this.mapProxy.containsValue(value);
            }

            public Collection get(Object key) {
                return (Collection)this.mapProxy.get(key);
            }

            public boolean put(Object key, Object value) {
                return this.mapProxy.putMulti(key, value);
            }

            public boolean remove(Object key, Object value) {
                return this.mapProxy.removeMulti(key, value);
            }

            public Collection remove(Object key) {
                return (Collection)this.mapProxy.remove(key);
            }

            public int size() {
                return this.mapProxy.size();
            }

            public Set localKeySet() {
                return this.mapProxy.localKeySet();
            }

            public Set keySet() {
                return this.mapProxy.keySet();
            }

            public Collection values() {
                return this.mapProxy.values();
            }

            public Set entrySet() {
                return this.mapProxy.entrySet();
            }

            public int valueCount(Object key) {
                return this.mapProxy.valueCount(key);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.MULTIMAP;
            }

            public void destroy() {
                this.mapProxy.destroy();
            }

            public Object getId() {
                return MultiMapProxyImpl.this.name;
            }

            public void addLocalEntryListener(EntryListener entryListener) {
                this.mapProxy.addLocalEntryListener(entryListener);
            }

            public void addEntryListener(EntryListener entryListener, boolean includeValue) {
                this.mapProxy.addEntryListener(entryListener, includeValue);
            }

            public void removeEntryListener(EntryListener entryListener) {
                this.mapProxy.removeEntryListener(entryListener);
            }

            public void addEntryListener(EntryListener entryListener, Object key, boolean includeValue) {
                this.mapProxy.addEntryListener(entryListener, key, includeValue);
            }

            public void removeEntryListener(EntryListener entryListener, Object key) {
                this.mapProxy.removeEntryListener(entryListener, key);
            }

            public void lock(Object key) {
                this.mapProxy.lock(key);
            }

            public boolean tryLock(Object key) {
                return this.mapProxy.tryLock(key);
            }

            public boolean tryLock(Object key, long time, TimeUnit timeunit) {
                return this.mapProxy.tryLock(key, time, timeunit);
            }

            public void unlock(Object key) {
                this.mapProxy.unlock(key);
            }

            public boolean lockMap(long time, TimeUnit timeunit) {
                return this.mapProxy.lockMap(time, timeunit);
            }

            public void unlockMap() {
                this.mapProxy.unlockMap();
            }
        }
    }

    public static class QProxyImpl
    extends AbstractQueue
    implements QProxy,
    HazelcastInstanceAwareInstance,
    DataSerializable {
        private transient QProxy qproxyReal = null;
        private transient FactoryImpl factory = null;
        private String name = null;
        private BlockingQueueManager blockingQueueManager = null;
        private ListenerManager listenerManager = null;

        public QProxyImpl() {
        }

        private QProxyImpl(String name, FactoryImpl factory) {
            this.name = name;
            this.qproxyReal = new QProxyReal();
            this.setHazelcastInstance(factory);
        }

        public FactoryImpl getFactory() {
            return this.factory;
        }

        public String getLongName() {
            this.ensure();
            return this.qproxyReal.getLongName();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
            this.blockingQueueManager = this.factory.node.blockingQueueManager;
            this.listenerManager = this.factory.node.listenerManager;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.qproxyReal == null) {
                this.qproxyReal = (QProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public Object getId() {
            this.ensure();
            return this.qproxyReal.getId();
        }

        public String toString() {
            return "Queue [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QProxyImpl qProxy = (QProxyImpl)o;
            return !(this.name == null ? qProxy.name != null : !this.name.equals(qProxy.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.writeData(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.readData(in);
        }

        public LocalQueueStats getLocalQueueStats() {
            this.ensure();
            return this.qproxyReal.getLocalQueueStats();
        }

        public Iterator iterator() {
            this.ensure();
            return this.qproxyReal.iterator();
        }

        public int size() {
            this.ensure();
            return this.qproxyReal.size();
        }

        public void addItemListener(ItemListener listener, boolean includeValue) {
            this.ensure();
            this.qproxyReal.addItemListener(listener, includeValue);
        }

        public void removeItemListener(ItemListener listener) {
            this.ensure();
            this.qproxyReal.removeItemListener(listener);
        }

        public String getName() {
            this.ensure();
            return this.qproxyReal.getName();
        }

        public int drainTo(Collection c) {
            this.ensure();
            return this.qproxyReal.drainTo(c);
        }

        public int drainTo(Collection c, int maxElements) {
            this.ensure();
            return this.qproxyReal.drainTo(c, maxElements);
        }

        public void destroy() {
            this.ensure();
            this.qproxyReal.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.qproxyReal.getInstanceType();
        }

        public boolean offer(Object o) {
            this.ensure();
            return this.qproxyReal.offer(o);
        }

        public boolean offer(Object obj, long timeout, TimeUnit unit) throws InterruptedException {
            this.ensure();
            return this.qproxyReal.offer(obj, timeout, unit);
        }

        public void put(Object obj) throws InterruptedException {
            this.ensure();
            this.qproxyReal.put(obj);
        }

        public Object poll() {
            this.ensure();
            return this.qproxyReal.poll();
        }

        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            this.ensure();
            return this.qproxyReal.poll(timeout, unit);
        }

        public Object take() throws InterruptedException {
            this.ensure();
            return this.qproxyReal.take();
        }

        public int remainingCapacity() {
            this.ensure();
            return this.qproxyReal.remainingCapacity();
        }

        public Object peek() {
            this.ensure();
            return this.qproxyReal.peek();
        }

        public QueueOperationsCounter getQueueOperationCounter() {
            return this.qproxyReal.getQueueOperationCounter();
        }

        private class QProxyReal
        extends AbstractQueue
        implements QProxy {
            private final QueueOperationsCounter operationsCounter = new QueueOperationsCounter();

            public LocalQueueStats getLocalQueueStats() {
                this.operationsCounter.incrementOtherOperations();
                LocalQueueStatsImpl localQueueStats = QProxyImpl.this.blockingQueueManager.getOrCreateBQ(QProxyImpl.this.name).getQueueStats();
                localQueueStats.setOperationStats(this.operationsCounter.getPublishedStats());
                return localQueueStats;
            }

            public String getLongName() {
                return QProxyImpl.this.name;
            }

            public boolean offer(Object obj) {
                FactoryImpl.check(obj);
                try {
                    return this.offer(obj, 0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignored) {
                    return false;
                }
            }

            public boolean offer(Object obj, long timeout, TimeUnit unit) throws InterruptedException {
                boolean result;
                FactoryImpl.check(obj);
                if (timeout < 0L) {
                    timeout = 0L;
                }
                if (!(result = QProxyImpl.this.blockingQueueManager.offer(QProxyImpl.this.name, obj, unit.toMillis(timeout)))) {
                    this.operationsCounter.incrementRejectedOffers();
                }
                this.operationsCounter.incrementOffers();
                return result;
            }

            public void put(Object obj) throws InterruptedException {
                FactoryImpl.check(obj);
                QProxyImpl.this.blockingQueueManager.offer(QProxyImpl.this.name, obj, -1L);
                this.operationsCounter.incrementOffers();
            }

            public Object peek() {
                this.operationsCounter.incrementOtherOperations();
                return QProxyImpl.this.blockingQueueManager.peek(QProxyImpl.this.name);
            }

            public Object poll() {
                try {
                    Object result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, 0L);
                    if (result == null) {
                        this.operationsCounter.incrementEmptyPolls();
                    }
                    this.operationsCounter.incrementPolls();
                    return result;
                }
                catch (InterruptedException e) {
                    return null;
                }
            }

            public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
                Object result;
                if (timeout < 0L) {
                    timeout = 0L;
                }
                if ((result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, unit.toMillis(timeout))) == null) {
                    this.operationsCounter.incrementEmptyPolls();
                }
                this.operationsCounter.incrementPolls();
                return result;
            }

            public Object take() throws InterruptedException {
                Object result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, -1L);
                if (result == null) {
                    this.operationsCounter.incrementEmptyPolls();
                }
                this.operationsCounter.incrementPolls();
                return result;
            }

            public int remainingCapacity() {
                this.operationsCounter.incrementOtherOperations();
                BlockingQueueManager.BQ q = QProxyImpl.this.blockingQueueManager.getOrCreateBQ(QProxyImpl.this.name);
                int maxSizePerJVM = q.getMaxSizePerJVM();
                if (maxSizePerJVM <= 0) {
                    return Integer.MAX_VALUE;
                }
                int size = this.size();
                int numberOfMembers = ((QProxyImpl)QProxyImpl.this).factory.node.getClusterImpl().getMembers().size();
                int totalCapacity = numberOfMembers * maxSizePerJVM;
                return totalCapacity - size;
            }

            public Iterator iterator() {
                this.operationsCounter.incrementOtherOperations();
                return QProxyImpl.this.blockingQueueManager.iterate(QProxyImpl.this.name);
            }

            public int size() {
                this.operationsCounter.incrementOtherOperations();
                return QProxyImpl.this.blockingQueueManager.size(QProxyImpl.this.name);
            }

            public void addItemListener(ItemListener listener, boolean includeValue) {
                QProxyImpl.this.blockingQueueManager.addItemListener(QProxyImpl.this.name, listener, includeValue);
            }

            public void removeItemListener(ItemListener listener) {
                QProxyImpl.this.blockingQueueManager.removeItemListener(QProxyImpl.this.name, listener);
            }

            public String getName() {
                return QProxyImpl.this.name.substring("q:".length());
            }

            public boolean remove(Object obj) {
                throw new UnsupportedOperationException();
            }

            public int drainTo(Collection c) {
                return this.drainTo(c, Integer.MAX_VALUE);
            }

            public int drainTo(Collection c, int maxElements) {
                QProxy q;
                if (c == null) {
                    throw new NullPointerException("drainTo null!");
                }
                if (maxElements < 0) {
                    throw new IllegalArgumentException("Negative maxElements:" + maxElements);
                }
                if (maxElements == 0) {
                    return 0;
                }
                if (c instanceof QProxy && (q = (QProxy)c).getName().equals(this.getName())) {
                    throw new IllegalArgumentException("Cannot drainTo self!");
                }
                this.operationsCounter.incrementOtherOperations();
                int added = 0;
                Object value = null;
                do {
                    if ((value = this.poll()) == null) continue;
                    if (!c.add(value)) {
                        throw new RuntimeException("drainTo is not able to add!");
                    }
                    ++added;
                } while (added < maxElements && value != null);
                return added;
            }

            public void destroy() {
                this.operationsCounter.incrementOtherOperations();
                QProxyImpl.this.factory.destroyInstanceClusterWide(QProxyImpl.this.name, null);
                QProxyImpl.this.factory.destroyInstanceClusterWide("c:" + QProxyImpl.this.name, null);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.QUEUE;
            }

            public Object getId() {
                return QProxyImpl.this.name;
            }

            public QueueOperationsCounter getQueueOperationCounter() {
                return this.operationsCounter;
            }
        }
    }

    public static class CollectionProxyImpl
    extends BaseCollection
    implements CollectionProxy,
    HazelcastInstanceAwareInstance,
    DataSerializable {
        String name = null;
        private transient CollectionProxy base = null;
        private transient FactoryImpl factory = null;

        public CollectionProxyImpl() {
        }

        public CollectionProxyImpl(String name, FactoryImpl factory) {
            this.name = name;
            this.factory = factory;
            this.base = new CollectionProxyReal();
        }

        public FactoryImpl getFactory() {
            return this.factory;
        }

        public CollectionProxy getBase() {
            return this.base;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (CollectionProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            this.ensure();
            if (this.getInstanceType() == Instance.InstanceType.SET) {
                return "Set [" + this.getName() + "]";
            }
            return "List [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionProxyImpl that = (CollectionProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public int size() {
            this.ensure();
            return this.base.size();
        }

        public boolean contains(Object o) {
            this.ensure();
            return this.base.contains(o);
        }

        public Iterator iterator() {
            this.ensure();
            return this.base.iterator();
        }

        public boolean add(Object o) {
            this.ensure();
            return this.base.add(o);
        }

        public boolean remove(Object o) {
            this.ensure();
            return this.base.remove(o);
        }

        public void clear() {
            this.ensure();
            this.base.clear();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public void destroy() {
            this.factory.destroyInstanceClusterWide(this.name, null);
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.writeData(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.readData(in);
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public void addItemListener(ItemListener itemListener, boolean includeValue) {
            this.ensure();
            this.base.addItemListener(itemListener, includeValue);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.ensure();
            this.base.removeItemListener(itemListener);
        }

        public boolean removeKey(Object key) {
            this.ensure();
            return this.base.removeKey(key);
        }

        class CollectionProxyReal
        extends BaseCollection
        implements CollectionProxy {
            final MProxy mapProxy;

            public CollectionProxyReal() {
                this.mapProxy = new MProxyImpl(CollectionProxyImpl.this.name, CollectionProxyImpl.this.factory);
            }

            public Object getId() {
                return CollectionProxyImpl.this.name;
            }

            public boolean equals(Object o) {
                return CollectionProxyImpl.this.equals(o);
            }

            public int hashCode() {
                return CollectionProxyImpl.this.hashCode();
            }

            public Instance.InstanceType getInstanceType() {
                return BaseManager.getInstanceType(CollectionProxyImpl.this.name);
            }

            public void addItemListener(ItemListener listener, boolean includeValue) {
                this.mapProxy.addGenericListener(listener, null, includeValue, this.getInstanceType());
            }

            public void removeItemListener(ItemListener listener) {
                this.mapProxy.removeGenericListener(listener, null);
            }

            public String getName() {
                return CollectionProxyImpl.this.name.substring("m:l:".length());
            }

            public boolean add(Object obj) {
                return this.mapProxy.add(obj);
            }

            public boolean remove(Object obj) {
                return this.mapProxy.removeKey(obj);
            }

            public boolean removeKey(Object obj) {
                return this.mapProxy.removeKey(obj);
            }

            public boolean contains(Object obj) {
                return this.mapProxy.containsKey(obj);
            }

            public Iterator iterator() {
                return this.mapProxy.keySet().iterator();
            }

            public int size() {
                return this.mapProxy.size();
            }

            public void destroy() {
                CollectionProxyImpl.this.factory.destroyInstanceClusterWide(CollectionProxyImpl.this.name, null);
            }
        }
    }

    public static class TopicProxyImpl
    extends FactoryAwareNamedProxy
    implements TopicProxy,
    DataSerializable {
        private transient TopicProxy base = null;
        private TopicManager topicManager = null;
        private ListenerManager listenerManager = null;

        public TopicProxyImpl() {
        }

        public TopicProxyImpl(String name, FactoryImpl factory) {
            this.set(name, factory);
            this.base = new TopicProxyReal();
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = (TopicProxy)this.factory.getOrCreateProxyByName(this.name);
            }
        }

        public void set(String name, FactoryImpl factory) {
            this.setName(name);
            this.setHazelcastInstance(factory);
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            super.setHazelcastInstance(hazelcastInstance);
            this.topicManager = this.factory.node.topicManager;
            this.listenerManager = this.factory.node.listenerManager;
        }

        public String getLongName() {
            return this.base.getLongName();
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        public String toString() {
            return "Topic [" + this.getName() + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicProxyImpl that = (TopicProxyImpl)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public void publish(Object msg) {
            this.ensure();
            this.base.publish(msg);
        }

        public void addMessageListener(MessageListener listener) {
            this.ensure();
            this.base.addMessageListener(listener);
        }

        public void removeMessageListener(MessageListener listener) {
            this.ensure();
            this.base.removeMessageListener(listener);
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return this.base.getInstanceType();
        }

        public String getName() {
            this.ensure();
            return this.base.getName();
        }

        public LocalTopicStats getLocalTopicStats() {
            this.ensure();
            return this.base.getLocalTopicStats();
        }

        public TopicOperationsCounter getTopicOperationCounter() {
            return this.base.getTopicOperationCounter();
        }

        class TopicProxyReal
        implements TopicProxy {
            TopicOperationsCounter topicOperationsCounter = new TopicOperationsCounter();

            TopicProxyReal() {
            }

            public void publish(Object msg) {
                FactoryImpl.check(msg);
                this.topicOperationsCounter.incrementPublishes();
                TopicProxyImpl.this.topicManager.doPublish(TopicProxyImpl.this.name, msg);
            }

            public void addMessageListener(MessageListener listener) {
                TopicProxyImpl.this.listenerManager.addListener(TopicProxyImpl.this.name, listener, null, true, this.getInstanceType());
            }

            public void removeMessageListener(MessageListener listener) {
                TopicProxyImpl.this.listenerManager.removeListener(TopicProxyImpl.this.name, listener, null);
            }

            public void destroy() {
                TopicProxyImpl.this.factory.destroyInstanceClusterWide(TopicProxyImpl.this.name, null);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.TOPIC;
            }

            public String getName() {
                return TopicProxyImpl.this.name.substring("t:".length());
            }

            public String getLongName() {
                return TopicProxyImpl.this.name;
            }

            public Object getId() {
                return TopicProxyImpl.this.name;
            }

            public LocalTopicStats getLocalTopicStats() {
                LocalTopicStatsImpl localTopicStats = TopicProxyImpl.this.topicManager.getTopicInstance(TopicProxyImpl.this.name).getTopicSats();
                localTopicStats.setOperationsStats(this.topicOperationsCounter.getPublishedStats());
                return localTopicStats;
            }

            public TopicOperationsCounter getTopicOperationCounter() {
                return this.topicOperationsCounter;
            }
        }
    }

    public static class ProxyKey
    extends SerializationHelper
    implements DataSerializable {
        String name;
        Object key;

        public ProxyKey() {
        }

        public ProxyKey(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
            boolean keyNull = this.key == null;
            out.writeBoolean(keyNull);
            if (!keyNull) {
                ProxyKey.writeObject(out, this.key);
            }
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
            boolean keyNull = in.readBoolean();
            if (!keyNull) {
                this.key = ProxyKey.readObject(in);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyKey proxyKey = (ProxyKey)o;
            if (this.name != null ? !this.name.equals(proxyKey.name) : proxyKey.name != null) {
                return false;
            }
            return !(this.key == null ? proxyKey.key != null : !this.key.equals(proxyKey.key));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ProxyKey {name='" + this.name + "', key=" + this.key + '}';
        }

        public String getName() {
            return this.name;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static class LockProxy
    extends SerializationHelper
    implements HazelcastInstanceAwareInstance,
    ILock,
    DataSerializable {
        private Object key = null;
        private transient ILock base = null;
        private transient FactoryImpl factory = null;

        public LockProxy() {
        }

        public LockProxy(HazelcastInstance hazelcastInstance, Object key) {
            this.key = key;
            this.setHazelcastInstance(hazelcastInstance);
            this.base = new LockProxyBase();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
        }

        private void ensure() {
            this.factory.initialChecks();
            if (this.base == null) {
                this.base = this.factory.getLock(this.key);
            }
        }

        public String toString() {
            return "ILock [" + this.key + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockProxy lockProxy = (LockProxy)o;
            return !(this.key == null ? lockProxy.key != null : !this.key.equals(lockProxy.key));
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        public void writeData(DataOutput out) throws IOException {
            LockProxy.writeObject(out, this.key);
        }

        public void readData(DataInput in) throws IOException {
            this.key = LockProxy.readObject(in);
            this.setHazelcastInstance(ThreadContext.get().getCurrentFactory());
        }

        public void lock() {
            this.ensure();
            this.base.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.ensure();
            this.base.lockInterruptibly();
        }

        public boolean tryLock() {
            this.ensure();
            return this.base.tryLock();
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            this.ensure();
            return this.base.tryLock(time, unit);
        }

        public void unlock() {
            this.ensure();
            this.base.unlock();
        }

        public Condition newCondition() {
            this.ensure();
            return this.base.newCondition();
        }

        public Instance.InstanceType getInstanceType() {
            this.ensure();
            return Instance.InstanceType.LOCK;
        }

        public void destroy() {
            this.ensure();
            this.base.destroy();
        }

        public Object getLockObject() {
            return this.key;
        }

        public Object getId() {
            this.ensure();
            return this.base.getId();
        }

        private class LockProxyBase
        implements ILock {
            private LockProxyBase() {
            }

            public void lock() {
                ((LockProxy)LockProxy.this).factory.locksMapProxy.lock(LockProxy.this.key);
            }

            public void lockInterruptibly() throws InterruptedException {
                throw new UnsupportedOperationException("lockInterruptibly is not implemented!");
            }

            public Condition newCondition() {
                return null;
            }

            public boolean tryLock() {
                return ((LockProxy)LockProxy.this).factory.locksMapProxy.tryLock(LockProxy.this.key);
            }

            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                try {
                    return ((LockProxy)LockProxy.this).factory.locksMapProxy.tryLock(LockProxy.this.key, time, unit);
                }
                catch (RuntimeInterruptedException e) {
                    throw new InterruptedException();
                }
            }

            public void unlock() {
                ((LockProxy)LockProxy.this).factory.locksMapProxy.unlock(LockProxy.this.key);
            }

            public void destroy() {
                LockProxy.this.factory.destroyInstanceClusterWide("lock", LockProxy.this.key);
            }

            public Instance.InstanceType getInstanceType() {
                return Instance.InstanceType.LOCK;
            }

            public Object getLockObject() {
                return LockProxy.this.key;
            }

            public Object getId() {
                return new ProxyKey("lock", LockProxy.this.key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializeMap
    implements Callable<Boolean>,
    DataSerializable,
    HazelcastInstanceAware {
        String name;
        private transient HazelcastInstance hazelcast = null;

        public InitializeMap(String name) {
            this.name = name;
        }

        public InitializeMap() {
        }

        @Override
        public Boolean call() throws Exception {
            this.hazelcast.getMap(this.name).getName();
            return Boolean.TRUE;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcast = hazelcastInstance;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HazelcastInstanceProxy
    extends HazelcastInstanceAwareObject
    implements HazelcastInstance {
        public HazelcastInstanceProxy() {
        }

        public HazelcastInstanceProxy(FactoryImpl factory) {
            this.hazelcastInstance = factory;
        }

        public FactoryImpl getFactory() {
            return (FactoryImpl)this.hazelcastInstance;
        }

        @Override
        public String getName() {
            return this.hazelcastInstance.getName();
        }

        @Override
        public void shutdown() {
            this.hazelcastInstance.shutdown();
        }

        @Override
        public void restart() {
            this.hazelcastInstance.restart();
        }

        @Override
        public Collection<Instance> getInstances() {
            return this.hazelcastInstance.getInstances();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.hazelcastInstance.getExecutorService();
        }

        @Override
        public ExecutorService getExecutorService(String name) {
            return this.hazelcastInstance.getExecutorService(name);
        }

        @Override
        public Cluster getCluster() {
            return this.hazelcastInstance.getCluster();
        }

        @Override
        public IdGenerator getIdGenerator(String name) {
            return this.hazelcastInstance.getIdGenerator(name);
        }

        @Override
        public AtomicNumber getAtomicNumber(String name) {
            return this.hazelcastInstance.getAtomicNumber(name);
        }

        @Override
        public Transaction getTransaction() {
            return this.hazelcastInstance.getTransaction();
        }

        @Override
        public <K, V> IMap<K, V> getMap(String name) {
            return this.hazelcastInstance.getMap(name);
        }

        @Override
        public <E> IQueue<E> getQueue(String name) {
            return this.hazelcastInstance.getQueue(name);
        }

        @Override
        public <E> ITopic<E> getTopic(String name) {
            return this.hazelcastInstance.getTopic(name);
        }

        @Override
        public <E> ISet<E> getSet(String name) {
            return this.hazelcastInstance.getSet(name);
        }

        @Override
        public <E> IList<E> getList(String name) {
            return this.hazelcastInstance.getList(name);
        }

        @Override
        public <K, V> MultiMap<K, V> getMultiMap(String name) {
            return this.hazelcastInstance.getMultiMap(name);
        }

        @Override
        public ILock getLock(Object key) {
            return this.hazelcastInstance.getLock(key);
        }

        @Override
        public Semaphore getSemaphore(String name) {
            return this.hazelcastInstance.getSemaphore(name);
        }

        @Override
        public void addInstanceListener(InstanceListener instanceListener) {
            this.hazelcastInstance.addInstanceListener(instanceListener);
        }

        @Override
        public void removeInstanceListener(InstanceListener instanceListener) {
            this.hazelcastInstance.removeInstanceListener(instanceListener);
        }

        @Override
        public Config getConfig() {
            return this.hazelcastInstance.getConfig();
        }

        @Override
        public PartitionService getPartitionService() {
            return this.hazelcastInstance.getPartitionService();
        }

        @Override
        public LoggingService getLoggingService() {
            return this.hazelcastInstance.getLoggingService();
        }

        @Override
        public LifecycleService getLifecycleService() {
            return this.hazelcastInstance.getLifecycleService();
        }
    }
}

