/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.MapOperationStatsImpl;
import com.hazelcast.monitor.LocalMapOperationStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapOperationsCounter {
    private static final LocalMapOperationStats empty = new MapOperationStatsImpl();
    private final OperationCounter puts = new OperationCounter();
    private final OperationCounter gets = new OperationCounter();
    private final OperationCounter removes = new OperationCounter();
    private final AtomicLong others = new AtomicLong();
    private final AtomicLong events = new AtomicLong();
    private final List<MapOperationsCounter> listOfSubStats = new ArrayList<MapOperationsCounter>();
    private final long interval;
    private final Object lock = new Object();
    private volatile LocalMapOperationStats published = null;
    private long startTime = this.now();
    private long endTime = Long.MAX_VALUE;

    public MapOperationsCounter() {
        this(5000L);
    }

    public MapOperationsCounter(long interval) {
        this.interval = interval;
    }

    private MapOperationsCounter getAndReset() {
        OperationCounter putsNow = this.puts.copyAndReset();
        OperationCounter getsNow = this.gets.copyAndReset();
        OperationCounter removesNow = this.removes.copyAndReset();
        long othersNow = this.others.getAndSet(0L);
        long eventsNow = this.events.getAndSet(0L);
        MapOperationsCounter newOne = new MapOperationsCounter();
        newOne.puts.set(putsNow);
        newOne.gets.set(getsNow);
        newOne.removes.set(removesNow);
        newOne.others.set(othersNow);
        newOne.events.set(eventsNow);
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalMapOperationStats getPublishedStats() {
        if (this.published == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.published == null) {
                    this.published = this.getThis();
                }
            }
        }
        if (this.published.getPeriodEnd() < this.now() - this.interval) {
            return empty;
        }
        return this.published;
    }

    public void incrementPuts(long elapsed) {
        this.puts.count(elapsed);
        this.publishSubResult();
    }

    public void incrementGets(long elapsed) {
        this.gets.count(elapsed);
        this.publishSubResult();
    }

    public void incrementRemoves(long elapsed) {
        this.removes.count(elapsed);
        this.publishSubResult();
    }

    public void incrementOtherOperations() {
        this.others.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedEvents() {
        this.events.incrementAndGet();
        this.publishSubResult();
    }

    long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishSubResult() {
        long subInterval = this.interval / 5L;
        if (this.now() - this.startTime > subInterval) {
            Object object = this.lock;
            synchronized (object) {
                if (this.now() - this.startTime >= subInterval) {
                    MapOperationsCounter copy = this.getAndReset();
                    if (this.listOfSubStats.size() == 5) {
                        this.listOfSubStats.remove(0);
                    }
                    this.listOfSubStats.add(copy);
                    this.published = this.aggregate(this.listOfSubStats);
                }
            }
        }
    }

    private LocalMapOperationStats aggregate(List<MapOperationsCounter> list) {
        MapOperationStatsImpl stats = new MapOperationStatsImpl();
        stats.periodStart = list.get((int)0).startTime;
        for (int i = 0; i < list.size(); ++i) {
            MapOperationsCounter sub = list.get(i);
            stats.gets.add(sub.gets.count.get(), sub.gets.totalLatency.get());
            stats.puts.add(sub.puts.count.get(), sub.puts.totalLatency.get());
            stats.removes.add(sub.removes.count.get(), sub.removes.totalLatency.get());
            stats.numberOfOtherOperations += sub.others.get();
            stats.numberOfEvents += sub.events.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    private LocalMapOperationStats getThis() {
        MapOperationStatsImpl stats = new MapOperationStatsImpl();
        stats.periodStart = this.startTime;
        MapOperationStatsImpl mapOperationStatsImpl = stats;
        mapOperationStatsImpl.getClass();
        stats.gets = new MapOperationStatsImpl.OperationStat(mapOperationStatsImpl, this.gets.count.get(), this.gets.totalLatency.get());
        MapOperationStatsImpl mapOperationStatsImpl2 = stats;
        mapOperationStatsImpl2.getClass();
        stats.puts = new MapOperationStatsImpl.OperationStat(mapOperationStatsImpl2, this.puts.count.get(), this.puts.totalLatency.get());
        MapOperationStatsImpl mapOperationStatsImpl3 = stats;
        mapOperationStatsImpl3.getClass();
        stats.removes = new MapOperationStatsImpl.OperationStat(mapOperationStatsImpl3, this.removes.count.get(), this.removes.totalLatency.get());
        stats.numberOfEvents = this.events.get();
        stats.periodEnd = this.now();
        return stats;
    }

    public String toString() {
        return "MapOperationsCounter{empty=" + empty + ", puts=" + this.puts + ", gets=" + this.gets + ", removes=" + this.removes + ", others=" + this.others + ", events=" + this.events + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", published=" + this.published + ", listOfSubStats=" + this.listOfSubStats + ", lock=" + this.lock + ", interval=" + this.interval + '}';
    }

    class OperationCounter {
        final AtomicLong count;
        final AtomicLong totalLatency;

        public OperationCounter() {
            this(0L, 0L);
        }

        public OperationCounter(long c, long l) {
            this.count = new AtomicLong(c);
            this.totalLatency = new AtomicLong(l);
        }

        public OperationCounter copyAndReset() {
            OperationCounter copy = new OperationCounter(this.count.get(), this.totalLatency.get());
            this.count.set(0L);
            this.totalLatency.set(0L);
            return copy;
        }

        public void set(OperationCounter now) {
            this.count.set(now.count.get());
            this.totalLatency.set(now.totalLatency.get());
        }

        public void count(long elapsed) {
            this.count.incrementAndGet();
            this.totalLatency.addAndGet(elapsed);
        }

        public String toString() {
            long count = this.count.get();
            return "OperationStat{count=" + count + ", averageLatency=" + (count == 0L ? 0L : this.totalLatency.get() / count) + '}';
        }
    }
}

