/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.offers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.InterfaceTypeMismatch;
import org.omg.CosTrading.RegisterPackage.InvalidObjectRef;
import org.omg.CosTrading.UnknownServiceType;

public class export {
    public static void main(String[] stringArray) {
        Property[] propertyArray;
        java.lang.Object object;
        if (stringArray.length < 1) {
            export.usage();
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.err.println("File " + stringArray[0] + " does not exist");
            export.usage();
        }
        if (!file.isFile()) {
            System.err.println(stringArray[0] + " is not a file");
            export.usage();
        }
        ORB oRB = ORB.init(stringArray, null);
        Register register = null;
        try {
            object = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            propertyArray = bufferedReader.readLine();
            ((InputStreamReader)object).close();
            Object object2 = oRB.string_to_object((String)propertyArray);
            if (object2 == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow(object2);
            register = lookup.register_if();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        try {
            object = new Random();
            for (int i = 0; i < 10; ++i) {
                propertyArray = i % 2 == 0 ? new Property[4] : new Property[3];
                int n = 0;
                propertyArray[n] = new Property();
                propertyArray[n].name = "name";
                propertyArray[n].value = oRB.create_any();
                propertyArray[n].value.insert_string("name #" + i);
                ++n;
                if (i % 2 == 0) {
                    propertyArray[n] = new Property();
                    propertyArray[n].name = "cost";
                    propertyArray[n].value = oRB.create_any();
                    propertyArray[n].value.insert_double(Math.abs(((Random)object).nextDouble()));
                    ++n;
                }
                propertyArray[n] = new Property();
                propertyArray[n].name = "version";
                propertyArray[n].value = oRB.create_any();
                propertyArray[n].value.insert_string("1.0" + i);
                propertyArray[++n] = new Property();
                propertyArray[n].name = "count";
                propertyArray[n].value = oRB.create_any();
                propertyArray[n].value.insert_long(Math.abs(((Random)object).nextInt()) % 100);
                ++n;
                String string = register.export(register, "SubSvc", propertyArray);
                System.out.println("Offer id = " + string);
            }
        }
        catch (InvalidObjectRef invalidObjectRef) {
            System.out.println("Invalid object reference");
        }
        catch (IllegalServiceType illegalServiceType) {
            System.out.println("Illegal service type: " + illegalServiceType.type);
        }
        catch (UnknownServiceType unknownServiceType) {
            System.out.println("Unknown service type: " + unknownServiceType.type);
        }
        catch (InterfaceTypeMismatch interfaceTypeMismatch) {
            System.out.println("Interface type mismatch: " + interfaceTypeMismatch.type);
        }
        catch (IllegalPropertyName illegalPropertyName) {
            System.out.println("Illegal property name: " + illegalPropertyName.name);
        }
        catch (PropertyTypeMismatch propertyTypeMismatch) {
            System.out.println("Property type mismatch: " + propertyTypeMismatch.prop.name);
        }
        catch (ReadonlyDynamicProperty readonlyDynamicProperty) {
            System.out.println("Readonly dynamic property: " + readonlyDynamicProperty.name);
        }
        catch (MissingMandatoryProperty missingMandatoryProperty) {
            System.out.println("Missing mandatory property: " + missingMandatoryProperty.name);
        }
        catch (DuplicatePropertyName duplicatePropertyName) {
            System.out.println("Duplicate property: " + duplicatePropertyName.name);
        }
        System.exit(0);
    }

    protected static void usage() {
        System.out.println("Usage: jtclient.offers.export iorfile");
        System.exit(1);
    }
}

