/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.tar.n2;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.tools.tar.n2.TarConstants;
import org.apache.tools.tar.n2.TarUtils;

public class TarEntry
implements TarConstants {
    private static final Logger log = Logger.getLogger(TarEntry.class);
    private StringBuffer name;
    private int mode;
    private int userId;
    private int groupId;
    private long size;
    private long modTime;
    private byte linkFlag;
    private StringBuffer linkName;
    private StringBuffer magic = new StringBuffer("ustar ");
    private StringBuffer userName;
    private StringBuffer groupName;
    private int devMajor;
    private int devMinor;
    private File file;
    public static final int MAX_NAMELEN = 31;
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int MILLIS_PER_SECOND = 1000;
    private static boolean debug = false;

    private TarEntry() {
        this.name = new StringBuffer();
        this.linkName = new StringBuffer();
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = new StringBuffer(user);
        this.groupName = new StringBuffer("");
        this.file = null;
    }

    public TarEntry(String name) {
        this();
        boolean isDir = name.endsWith("/");
        this.devMajor = 0;
        this.devMinor = 0;
        this.name = new StringBuffer(name);
        this.mode = isDir ? 16877 : 33188;
        this.linkFlag = (byte)(isDir ? 53 : 48);
        this.userId = 0;
        this.groupId = 0;
        this.size = 0L;
        this.modTime = new Date().getTime() / 1000L;
        this.linkName = new StringBuffer("");
        this.userName = new StringBuffer("");
        this.groupName = new StringBuffer("");
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public TarEntry(String name, byte linkFlag) {
        this(name);
        this.linkFlag = linkFlag;
    }

    public TarEntry(File file) {
        this();
        this.file = file;
        String fileName = file.getPath();
        String osname = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osname != null) {
            int colon;
            if (osname.startsWith("windows")) {
                if (fileName.length() > 2) {
                    char ch1 = fileName.charAt(0);
                    char ch2 = fileName.charAt(1);
                    if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                        fileName = fileName.substring(2);
                    }
                }
            } else if (osname.indexOf("netware") > -1 && (colon = fileName.indexOf(58)) != -1) {
                fileName = fileName.substring(colon + 1);
            }
        }
        fileName = fileName.replace(File.separatorChar, '/');
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        this.linkName = new StringBuffer("");
        this.name = new StringBuffer(fileName);
        if (file.isDirectory()) {
            this.mode = 16877;
            this.linkFlag = (byte)53;
            if (this.name.charAt(this.name.length() - 1) != '/') {
                this.name.append("/");
            }
        } else {
            this.mode = 33188;
            this.linkFlag = (byte)48;
        }
        this.size = file.length();
        this.modTime = file.lastModified() / 1000L;
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public TarEntry(byte[] headerBuf) {
        this();
        this.parseTarHeader(headerBuf);
    }

    public boolean equals(TarEntry it) {
        return this.getName().equals(it.getName());
    }

    public boolean equals(Object it) {
        if (it == null || this.getClass() != it.getClass()) {
            return false;
        }
        return this.equals((TarEntry)it);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.getName().startsWith(this.getName());
    }

    public String getName() {
        return this.name.toString();
    }

    public void setName(String name) {
        this.name = new StringBuffer(name);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getLinkName() {
        return this.linkName.toString();
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public void setUserName(String userName) {
        this.userName = new StringBuffer(userName);
    }

    public String getGroupName() {
        return this.groupName.toString();
    }

    public void setGroupName(String groupName) {
        this.groupName = new StringBuffer(groupName);
    }

    public void setIds(int userId, int groupId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
    }

    public void setNames(String userName, String groupName) {
        this.setUserName(userName);
        this.setGroupName(groupName);
    }

    public void setModTime(long time) {
        this.modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.modTime = time.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    public File getFile() {
        return this.file;
    }

    public int getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && this.name.toString().equals("././@LongLink");
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public TarEntry[] getDirectoryEntries() {
        if (this.file == null || !this.file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] list = this.file.list();
        TarEntry[] result = new TarEntry[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new TarEntry(new File(this.file, list[i]));
        }
        return result;
    }

    public void writeEntryHeader(byte[] outbuf) throws IOException {
        int offset = 0;
        offset = TarUtils.getNameBytes(this.name, outbuf, offset, 100);
        offset = TarUtils.getOctalBytes(this.mode, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.userId, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.groupId, outbuf, offset, 8);
        if (this.magic.toString().startsWith("n2tar")) {
            if ((double)this.size < Math.pow(2.0, 44.0)) {
                offset = TarUtils.getLongHexBytes(this.size, outbuf, offset, 12);
            }
        } else if (this.magic.toString().startsWith("ustar ")) {
            if ((double)this.size < Math.pow(2.0, 33.0)) {
                offset = TarUtils.getLongOctalBytes(this.size, outbuf, offset, 12);
            } else {
                BigInteger bi = BigInteger.valueOf(this.size);
                byte[] bb = bi.toByteArray();
                byte[] b = new byte[12];
                Arrays.fill(b, (byte)0);
                System.arraycopy(bb, 0, b, 12 - bb.length, bb.length);
                b[0] = (byte)(b[0] | 0xFFFFFF80);
                System.arraycopy(b, 0, outbuf, offset, 12);
                offset += 12;
            }
        } else if ((double)this.size < Math.pow(2.0, 33.0)) {
            offset = TarUtils.getLongOctalBytes(this.size, outbuf, offset, 12);
        } else {
            throw new IOException("Unsupported POSIX tar entry - maximum size exceeded.");
        }
        int csOffset = offset = TarUtils.getLongOctalBytes(this.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.linkFlag;
        offset = TarUtils.getNameBytes(this.linkName, outbuf, offset, 100);
        offset = TarUtils.getNameBytes(this.magic, outbuf, offset, 8);
        offset = TarUtils.getNameBytes(this.userName, outbuf, offset, 32);
        offset = TarUtils.getNameBytes(this.groupName, outbuf, offset, 32);
        offset = TarUtils.getOctalBytes(this.devMajor, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.devMinor, outbuf, offset, 8);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        long chk = TarUtils.computeCheckSum(outbuf);
        TarUtils.getCheckSumOctalBytes(chk, outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] header) {
        int offset = 0;
        this.name = TarUtils.parseName(header, offset, 100);
        this.mode = (int)TarUtils.parseOctal(header, offset += 100, 8);
        this.userId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.groupId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        byte[] b = new byte[12];
        System.arraycopy(header, offset += 8, b, 0, 12);
        this.modTime = TarUtils.parseOctal(header, offset += 12, 12);
        offset += 12;
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = TarUtils.parseName(header, offset, 100);
        this.magic = TarUtils.parseName(header, offset += 100, 8);
        this.userName = TarUtils.parseName(header, offset += 8, 32);
        this.groupName = TarUtils.parseName(header, offset += 32, 32);
        this.devMajor = (int)TarUtils.parseOctal(header, offset += 32, 8);
        this.devMinor = (int)TarUtils.parseOctal(header, offset += 8, 8);
        TarEntry.debug("sizebuffer=" + this.odbc(b) + ".");
        if (this.magic.toString().startsWith("n2tar")) {
            this.size = new BigInteger(new String(b).trim(), 16).longValue();
        } else if (this.magic.toString().startsWith("ustar ")) {
            if ((b[0] & 0xFFFFFF80) == -128) {
                byte[] B = new byte[8];
                System.arraycopy(b, 4, B, 0, 8);
                this.size = new BigInteger(B).longValue();
            } else {
                this.size = new BigInteger(new String(b).trim(), 8).longValue();
            }
        } else {
            this.size = new BigInteger(new String(b).trim(), 8).longValue();
        }
        TarEntry.debug("parseTarHeader(): " + this.toString());
    }

    private String odbc(byte[] b) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < b.length; i += 16) {
            result.append(String.format("%010o:", i));
            for (int j = 0; j < 16 && i + j < b.length; ++j) {
                byte v = b[i + j];
                if (v >= 32 && v < 128) {
                    result.append(String.format("   %c", v));
                    continue;
                }
                result.append(String.format("\\%03d", v));
            }
            result.append("\n");
        }
        return result.toString().replaceFirst("\\n$", "");
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        return String.format("%s %s %#6o %-25.25s %-15.15s %-15.15s %15d %s", this.isDirectory() ? "d" : "f", this.isGNULongNameEntry() ? "G" : "-", this.getMode(), sdf.format(this.getModTime()), String.format("%s(%d)", this.getUserName(), this.getUserId()).trim(), String.format("%s(%d)", this.getGroupName(), this.getGroupId()).trim(), this.getSize(), this.getName());
    }

    public static void setDebug(boolean debug) {
        TarEntry.debug = debug;
    }

    private static String tstamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("H:m:s.S");
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    private static void debug(String s) {
        if (debug) {
            log.debug((Object)String.format("[%s] %s", TarEntry.tstamp(), s));
        }
    }
}

