/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.custom.rule.implement;

import com.ericsson.cms.epgmgmt.custom.rule.CustomRuleEntryPoint;
import com.ericsson.cms.epgmgmt.custom.rule.context.CustomRuleMetaData;
import com.ericsson.cms.epgmgmt.custom.rule.context.CustomRuleMetaDataWrapper;
import com.ericsson.cms.epgmgmt.custom.rule.implement.BaseCustomNormalizationRule;
import com.ericsson.cms.epgmgmt.custom.rule.param.Parameter;
import com.ericsson.cms.epgmgmt.custom.rule.util.CustomRuleUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRuleEntryPointWrapper
implements CustomRuleEntryPoint {
    private static Logger logger = LoggerFactory.getLogger(CustomRuleEntryPointWrapper.class);
    private static final String RULE_DEFINITIONS_JSON = "custom-rule-definitions.js";

    public List<CustomRuleMetaData> getCustomNormalizationRuleMetaData() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(RULE_DEFINITIONS_JSON);
        CustomRuleMetaDataWrapper wrapper = null;
        try {
            String content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            wrapper = (CustomRuleMetaDataWrapper)CustomRuleUtil.readObject((String)content, CustomRuleMetaDataWrapper.class);
        }
        catch (Exception e) {
            logger.error("Error: ", (Throwable)e);
            throw new IllegalStateException("Error while initializing custom rules", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return wrapper.getRuleMetaData();
    }

    public void execute(Map<String, Object> properties) throws Exception {
        Map epgSysPro = (Map)properties.get("EPG_SYS_PROPERTIES");
        String ruleClass = (String)epgSysPro.get("RULE_CLASS");
        if (StringUtils.isBlank((String)ruleClass)) {
            logger.error("The rule class definition is blank! No custom rule will be run...");
            return;
        }
        BaseCustomNormalizationRule rule = (BaseCustomNormalizationRule)this.loadCustomRuleInstance(StringUtils.strip((String)ruleClass));
        rule.execute(properties);
    }

    public List<String> validate(String ruleClass, List<Parameter> params) throws Exception {
        BaseCustomNormalizationRule rule = (BaseCustomNormalizationRule)this.loadCustomRuleInstance(ruleClass);
        return rule.validate(CustomRuleUtil.convertToMap(params));
    }

    private Object loadCustomRuleInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(className).newInstance();
    }
}

