/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.custom.rule.implement;

import com.ericsson.cms.epgmgmt.custom.manager.interfaces.IScheduleDBOperation;
import com.ericsson.cms.epgmgmt.custom.rule.ISqlExecutor;
import com.ericsson.cms.epgmgmt.custom.rule.db.executor.SqlExecutorImpl;
import com.ericsson.cms.epgmgmt.custom.rule.implement.ScheduleDurationUtil;
import com.ericsson.cms.epgmgmt.entity.ScheduleDuration;
import com.ericsson.cms.epgmgmt.entity.ScheduleTimeExtractor;
import com.ericsson.cms.epgmgmt.entity.StationIDMappingExtractor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;

public class ExportReduceScheduleDuration
implements IScheduleDBOperation {
    private static final String EXP_SELECT_TIME_SQL = "SELECT start_time, end_time AS endtime FROM exp_schedule WHERE station_id=? ORDER BY start_time";
    private static final String EXP_SELECT_STATION_SQL = "SELECT DISTINCT station_id FROM exp_station ORDER BY station_id";
    private static final String EXP_UPDATE_DURATION_SQL = "UPDATE exp_schedule SET duration=?, start_time=?, end_time=? WHERE station_id=? AND start_time=? ";
    private static final String EXP_SELECT_SCHEDULE_SQL = "SELECT SCHEDULE_ID, PROGRAM_ID, START_TIME, DURATION FROM exp_schedule WHERE station_id =? ";
    private static final String EXP_DELETE_SCHEDULE_SQL = "DELETE FROM exp_schedule WHERE station_id =? ";
    private SqlExecutorImpl sqlExecutorImpl;
    private Logger logger;
    private ScheduleDurationUtil filterOverlappingSchedule;

    public ExportReduceScheduleDuration(Logger logger, ISqlExecutor sqlExecutor) {
        this.logger = logger;
        this.sqlExecutorImpl = (SqlExecutorImpl)sqlExecutor;
        this.filterOverlappingSchedule = new ScheduleDurationUtil();
    }

    @Override
    public List<Timestamp> queryScheduleByStation(final String stationID) {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, stationID);
            }
        };
        return (List)this.sqlExecutorImpl.getTemplate().query(EXP_SELECT_TIME_SQL, pss, (ResultSetExtractor)new ScheduleTimeExtractor());
    }

    @Override
    public boolean batchDeleteSchedule(final List<Timestamp> conflictTimestamps, final String stationID) {
        if (conflictTimestamps.isEmpty()) {
            return false;
        }
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, stationID);
                int parameterIndex = 2;
                for (Timestamp timestamp : conflictTimestamps) {
                    ps.setTimestamp(parameterIndex, timestamp);
                    ++parameterIndex;
                }
            }
        };
        RowCallbackHandler rcb = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                ExportReduceScheduleDuration.this.logger.warn("[{},{},{},{},{}]", new Object[]{rs.getString(1), rs.getString(2), stationID, rs.getTimestamp(3), rs.getLong(4)});
            }
        };
        String starttimeInSql = this.filterOverlappingSchedule.getStartTimeIn(conflictTimestamps.size());
        try {
            this.logger.warn(" [{}] schedules was deleted", (Object)conflictTimestamps.size());
            this.logger.warn("SCHEDULE_ID, STATION_ID, PROGRAM_ID, START_TIME, DURATION");
            this.sqlExecutorImpl.getTemplate().query(EXP_SELECT_SCHEDULE_SQL + starttimeInSql, pss, rcb);
            this.sqlExecutorImpl.getTemplate().update(EXP_DELETE_SCHEDULE_SQL + starttimeInSql, pss);
        }
        catch (Exception e) {
            this.logger.error("The schedules delete Exception", (Throwable)e);
        }
        return true;
    }

    @Override
    public List<String> queryStationID() {
        return (List)this.sqlExecutorImpl.getTemplate().query(EXP_SELECT_STATION_SQL, (ResultSetExtractor)new StationIDMappingExtractor());
    }

    @Override
    public void batchUpdateSchedule(final List<ScheduleDuration> scheduleDurations, final String stationID) {
        this.logger.info("Batch update schedule batch size is {} of station {}", (Object)scheduleDurations.size(), (Object)stationID);
        int[] results = this.sqlExecutorImpl.getTemplate().batchUpdate(EXP_UPDATE_DURATION_SQL, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setLong(1, ((ScheduleDuration)scheduleDurations.get(i)).getDuration());
                ps.setTimestamp(2, ((ScheduleDuration)scheduleDurations.get(i)).getNewStartTime());
                ps.setTimestamp(3, ((ScheduleDuration)scheduleDurations.get(i)).getEndTime());
                ps.setString(4, stationID);
                ps.setTimestamp(5, ((ScheduleDuration)scheduleDurations.get(i)).getStartTime());
                ExportReduceScheduleDuration.this.logger.info("Update the schedule: original StartTime{} new StartTime{} Duration{} on stationID {} ", new Object[]{((ScheduleDuration)scheduleDurations.get(i)).getStartTime(), ((ScheduleDuration)scheduleDurations.get(i)).getNewStartTime(), ((ScheduleDuration)scheduleDurations.get(i)).getDuration(), ((ScheduleDuration)scheduleDurations.get(i)).getDuration()});
            }

            public int getBatchSize() {
                return scheduleDurations.size();
            }
        });
        if (this.logger.isInfoEnabled()) {
            this.logger.info("batchUpdateSchedule result:{}", (Object)Arrays.toString(results));
        }
    }
}

