/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.custom.rule.implement;

import com.ericsson.cms.epgmgmt.custom.manager.interfaces.IScheduleDBOperation;
import com.ericsson.cms.epgmgmt.custom.rule.ISqlExecutor;
import com.ericsson.cms.epgmgmt.custom.rule.db.executor.SqlExecutorImpl;
import com.ericsson.cms.epgmgmt.custom.rule.implement.ScheduleDurationUtil;
import com.ericsson.cms.epgmgmt.entity.ScheduleDuration;
import com.ericsson.cms.epgmgmt.entity.ScheduleTimeExtractor;
import com.ericsson.cms.epgmgmt.entity.StationIDMappingExtractor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;

public class IngestReduceScheduleDuration
implements IScheduleDBOperation {
    private static final String STG_SELECT_TIME_SQL = "SELECT start_time, TIMESTAMPADD(SECOND, duration, start_time) AS endtime FROM stg_schedule WHERE provider_id =? AND station_id =?";
    private static final String STG_SELECT_STATION_SQL = "SELECT DISTINCT station_id FROM stg_station WHERE provider_id =? ORDER BY station_id";
    private static final String STG_UPDATE_DURATION_SQL = "UPDATE stg_schedule SET duration=?, start_time=?  WHERE provider_id=? and station_id=? AND start_time=? ";
    private static final String STG_SELECT_SCHEDULE_SQL = "SELECT FILENAME, SCHEDULE_ID, PROGRAM_ID, START_TIME, DURATION FROM stg_schedule WHERE provider_id =? AND station_id =? ";
    private static final String STG_DELETE_SCHEDULE_SQL = "DELETE FROM stg_schedule WHERE provider_id =? AND station_id =? ";
    private SqlExecutorImpl sqlExecutorImpl;
    private ScheduleDurationUtil filterOverlappingSchedule;
    private String startTimeRangeForSQL = "";
    private long partnerId = 0L;
    private Logger logger;
    private Timestamp beforCurrentTimestamp = null;
    private Timestamp afterCurrentTimestamp = null;

    public IngestReduceScheduleDuration(Logger logger, ISqlExecutor sqlExecutor, long partnerId, Integer beforTodayDays, Integer afterTodayDays) {
        this.logger = logger;
        this.sqlExecutorImpl = (SqlExecutorImpl)sqlExecutor;
        this.partnerId = partnerId;
        this.filterOverlappingSchedule = new ScheduleDurationUtil();
        this.setStartTimeRange(beforTodayDays, afterTodayDays);
    }

    public void setStartTimeRange(Integer beforTodayDays, Integer afterTodayDays) {
        this.logger.info("StartTime beforTodayDays:{},afterTodayDays:{}", (Object)beforTodayDays, (Object)afterTodayDays);
        if (beforTodayDays != null && beforTodayDays >= 0) {
            this.startTimeRangeForSQL = this.startTimeRangeForSQL + " AND start_time > ? ";
            this.beforCurrentTimestamp = this.filterOverlappingSchedule.getBeforCurrentTimestamp(beforTodayDays);
        }
        if (afterTodayDays != null && afterTodayDays >= 0) {
            this.startTimeRangeForSQL = this.startTimeRangeForSQL + " AND start_time < ? ";
            this.afterCurrentTimestamp = this.filterOverlappingSchedule.getAfterCurrentTimestamp(afterTodayDays);
        }
        this.startTimeRangeForSQL = this.startTimeRangeForSQL + " ORDER BY start_time";
    }

    @Override
    public List<Timestamp> queryScheduleByStation(final String stationID) {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setLong(1, IngestReduceScheduleDuration.this.partnerId);
                ps.setString(2, stationID);
                int parameterIndex = 3;
                if (IngestReduceScheduleDuration.this.beforCurrentTimestamp != null) {
                    ps.setTimestamp(parameterIndex, IngestReduceScheduleDuration.this.beforCurrentTimestamp);
                    ++parameterIndex;
                }
                if (IngestReduceScheduleDuration.this.afterCurrentTimestamp != null) {
                    ps.setTimestamp(parameterIndex, IngestReduceScheduleDuration.this.afterCurrentTimestamp);
                }
            }
        };
        return (List)this.sqlExecutorImpl.getTemplate().query(STG_SELECT_TIME_SQL + this.startTimeRangeForSQL, pss, (ResultSetExtractor)new ScheduleTimeExtractor());
    }

    @Override
    public void batchUpdateSchedule(final List<ScheduleDuration> scheduleDurations, final String stationID) {
        this.logger.info("Batch update schedule batch size is {} of station {}", (Object)scheduleDurations.size(), (Object)stationID);
        int[] results = this.sqlExecutorImpl.getTemplate().batchUpdate(STG_UPDATE_DURATION_SQL, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setLong(1, ((ScheduleDuration)scheduleDurations.get(i)).getDuration());
                ps.setTimestamp(2, ((ScheduleDuration)scheduleDurations.get(i)).getNewStartTime());
                ps.setLong(3, IngestReduceScheduleDuration.this.partnerId);
                ps.setString(4, stationID);
                ps.setTimestamp(5, ((ScheduleDuration)scheduleDurations.get(i)).getStartTime());
                IngestReduceScheduleDuration.this.logger.info("Update the schedule: original StartTime{} new StartTime{} Duration{} on stationID {} of partnerId {}", new Object[]{((ScheduleDuration)scheduleDurations.get(i)).getStartTime(), ((ScheduleDuration)scheduleDurations.get(i)).getNewStartTime(), ((ScheduleDuration)scheduleDurations.get(i)).getDuration(), ((ScheduleDuration)scheduleDurations.get(i)).getDuration(), IngestReduceScheduleDuration.this.partnerId});
            }

            public int getBatchSize() {
                return scheduleDurations.size();
            }
        });
        this.logger.info("batchUpdateSchedule result:{}", (Object)Arrays.toString(results));
    }

    @Override
    public boolean batchDeleteSchedule(final List<Timestamp> conflictTimestamps, final String stationID) {
        if (conflictTimestamps.isEmpty()) {
            return false;
        }
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setLong(1, IngestReduceScheduleDuration.this.partnerId);
                ps.setString(2, stationID);
                int parameterIndex = 3;
                for (Timestamp timestamp : conflictTimestamps) {
                    ps.setTimestamp(parameterIndex, timestamp);
                    ++parameterIndex;
                }
            }
        };
        RowCallbackHandler rcb = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                IngestReduceScheduleDuration.this.logger.warn("[{},{},{},{},{},{},{}]", new Object[]{IngestReduceScheduleDuration.this.partnerId, rs.getString(1), rs.getString(2), rs.getString(3), stationID, rs.getTimestamp(4), rs.getLong(5)});
            }
        };
        String starttimeInSql = this.filterOverlappingSchedule.getStartTimeIn(conflictTimestamps.size());
        try {
            this.logger.warn(" [{}] schedules was deleted", (Object)conflictTimestamps.size());
            this.logger.warn("PROVIDER_ID, FILENAME, SCHEDULE_ID, STATION_ID, PROGRAM_ID, START_TIME, DURATION");
            this.sqlExecutorImpl.getTemplate().query(STG_SELECT_SCHEDULE_SQL + starttimeInSql, pss, rcb);
            this.sqlExecutorImpl.getTemplate().update(STG_DELETE_SCHEDULE_SQL + starttimeInSql, pss);
        }
        catch (Exception e) {
            this.logger.error("The schedules delete Exception", (Throwable)e);
        }
        return true;
    }

    @Override
    public List<String> queryStationID() {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setLong(1, IngestReduceScheduleDuration.this.partnerId);
            }
        };
        return (List)this.sqlExecutorImpl.getTemplate().query(STG_SELECT_STATION_SQL, pss, (ResultSetExtractor)new StationIDMappingExtractor());
    }
}

