/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.custom.rule.implement;

import com.ericsson.cms.epgmgmt.custom.manager.PartnerTypeLoader;
import com.ericsson.cms.epgmgmt.custom.manager.interfaces.IOverlappingResolveStrategy;
import com.ericsson.cms.epgmgmt.custom.manager.interfaces.IScheduleDBOperation;
import com.ericsson.cms.epgmgmt.custom.rule.Context;
import com.ericsson.cms.epgmgmt.custom.rule.ISqlExecutor;
import com.ericsson.cms.epgmgmt.custom.rule.implement.BaseCustomNormalizationRule;
import com.ericsson.cms.epgmgmt.custom.rule.implement.CropEarlierResolveStrategy;
import com.ericsson.cms.epgmgmt.custom.rule.implement.CropLaterResolveStrategy;
import com.ericsson.cms.epgmgmt.custom.rule.implement.ExportReduceScheduleDuration;
import com.ericsson.cms.epgmgmt.custom.rule.implement.IngestReduceScheduleDuration;
import com.ericsson.cms.epgmgmt.custom.rule.param.Parameter;
import com.ericsson.cms.epgmgmt.custom.rule.param.StringParameter;
import com.ericsson.cms.epgmgmt.entity.ScheduleDuration;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScheduleDurationOverlappingManagerRule
extends BaseCustomNormalizationRule {
    public static final String TYPE_CROP_EARILER = "CROP_THE_EARLIER";
    public static final String TYPE_CROP_LATER = "CROP_THE_LATER";
    public static final String FIELD_NAME_CROP_TYPE = "Resolve Strategy";
    public static final String TODAY_BEFOR_DAYS = "Time Period - Start Date (days before now)";
    public static final String TODAY_AFTER_DAYS = "Time Period - End Date (days after now)";

    public void innerExecute(Context arg0) throws Exception {
        long partnerId = (Long)this.context.getEpgSystemProperty("CURRENT_PARTNER_ID");
        String cropType = (String)this.context.getRuleParameterValue(FIELD_NAME_CROP_TYPE);
        PartnerTypeEnum partnerType = this.getPartnerType(this.context.getRemoteSqlExecutor(), partnerId);
        if (logger.isInfoEnabled()) {
            logger.info("Start verify the overlapping schedule, partnerId:{},cropType:{}, PartnerTypeEnum:{}", new Object[]{partnerId, cropType, partnerType});
        }
        this.scheduleOverlappingReduceDuration(this.getScheduleDBOperation(partnerType, this.context.getLocalSqlExecutor(), partnerId), this.getOverlappingResolveStrategy(cropType));
        logger.info("End of verify the overlapping schedule");
    }

    private IScheduleDBOperation getScheduleDBOperation(PartnerTypeEnum partnerType, ISqlExecutor sqlExecutor, long partnerId) {
        if (partnerType == PartnerTypeEnum.Receiver) {
            return new ExportReduceScheduleDuration(logger, sqlExecutor);
        }
        Integer beforTodayDays = (Integer)this.context.getRuleParameterValue(TODAY_BEFOR_DAYS);
        Integer afterTodayDays = (Integer)this.context.getRuleParameterValue(TODAY_AFTER_DAYS);
        return new IngestReduceScheduleDuration(logger, sqlExecutor, partnerId, beforTodayDays, afterTodayDays);
    }

    private IOverlappingResolveStrategy getOverlappingResolveStrategy(String cropType) {
        if (TYPE_CROP_EARILER.equalsIgnoreCase(cropType)) {
            return new CropEarlierResolveStrategy();
        }
        return new CropLaterResolveStrategy();
    }

    private void scheduleOverlappingReduceDuration(IScheduleDBOperation reduceScheduleDuration, IOverlappingResolveStrategy overlappingResolveStrategy) {
        List<String> stationIDs = reduceScheduleDuration.queryStationID();
        if (stationIDs == null || stationIDs.isEmpty()) {
            logger.info("There's no station for this rule");
            return;
        }
        logger.info("stationIDs number:{}", (Object)stationIDs.size());
        for (String stationID : stationIDs) {
            ArrayList<Timestamp> conflictTimestamps = new ArrayList<Timestamp>();
            List<Timestamp> timestamps = reduceScheduleDuration.queryScheduleByStation(stationID);
            List<ScheduleDuration> scheduleDurations = overlappingResolveStrategy.apply(timestamps, conflictTimestamps);
            if (!conflictTimestamps.isEmpty()) {
                reduceScheduleDuration.batchDeleteSchedule(conflictTimestamps, stationID);
            }
            if (scheduleDurations.isEmpty()) {
                logger.info("There's no overlap schedule for current station {}", (Object)stationID);
                continue;
            }
            reduceScheduleDuration.batchUpdateSchedule(scheduleDurations, stationID);
        }
    }

    public List<String> validate(Map<String, Parameter> parameters) {
        ArrayList<String> errors = new ArrayList<String>();
        StringParameter param = (StringParameter)parameters.get(FIELD_NAME_CROP_TYPE);
        String cropType = param.getValue();
        if (!TYPE_CROP_EARILER.equalsIgnoreCase(cropType) && !TYPE_CROP_LATER.equalsIgnoreCase(cropType)) {
            errors.add("The overlapping resolve strategy type must be CROP_THE_EARLIER or CROP_THE_LATER .");
        }
        return errors;
    }

    private PartnerTypeEnum getPartnerType(ISqlExecutor sqlExecutor, long partnerId) throws Exception {
        PartnerTypeLoader partnerTypeDao = new PartnerTypeLoader(sqlExecutor, partnerId);
        return partnerTypeDao.queryPartnerType();
    }
}

