/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.custom.rule.implement;

import com.ericsson.cms.epgmgmt.entity.ScheduleDuration;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ScheduleDurationUtil {
    private static final int STEP_SIZE = 2;
    private static final int RUN_TO_LAST_INDEX = 3;
    private static final int INDEX_EARLIER_END_TIME = 1;
    private static final int INDEX_LATER_START_TIME = 2;
    private static final int INDEX_LATER_END_TIME = 3;
    private static final long MILLISECOND_TO_SECOND = 1000L;
    private static final long MILLISECONDS_PER_DAY = 86400000L;

    public List<ScheduleDuration> getOverlappingPreSchedule(List<Timestamp> timestamps) {
        ArrayList<ScheduleDuration> scheduleDurations = new ArrayList<ScheduleDuration>();
        int lastIndexEarlierStartTime = timestamps.size() - 3;
        for (int indexEarlierStartTime = 0; indexEarlierStartTime < lastIndexEarlierStartTime; indexEarlierStartTime += 2) {
            if (!timestamps.get(indexEarlierStartTime + 1).after(timestamps.get(indexEarlierStartTime + 2))) continue;
            scheduleDurations.add(this.getScheduleDuration(timestamps.get(indexEarlierStartTime), timestamps.get(indexEarlierStartTime), timestamps.get(indexEarlierStartTime + 2)));
        }
        return scheduleDurations;
    }

    public List<ScheduleDuration> getOverlappingNextSchedule(List<Timestamp> timestamps, List<Timestamp> conflictTimestamps) {
        ArrayList<ScheduleDuration> scheduleDurations = new ArrayList<ScheduleDuration>();
        int lastIndexEarlierStartTime = timestamps.size() - 3;
        Timestamp earlierEndTime = null;
        Timestamp laterEndTime = null;
        Timestamp laterStartTime = null;
        for (int indexEarlierStartTime = 0; indexEarlierStartTime < lastIndexEarlierStartTime; indexEarlierStartTime += 2) {
            if (earlierEndTime == null) {
                earlierEndTime = timestamps.get(indexEarlierStartTime + 1);
            }
            if (!earlierEndTime.after(laterStartTime = timestamps.get(indexEarlierStartTime + 2))) {
                earlierEndTime = null;
                continue;
            }
            laterEndTime = timestamps.get(indexEarlierStartTime + 3);
            if (earlierEndTime.after(laterEndTime)) {
                conflictTimestamps.add(laterStartTime);
                continue;
            }
            scheduleDurations.add(this.getScheduleDuration(laterStartTime, earlierEndTime, laterEndTime));
            earlierEndTime = null;
        }
        return scheduleDurations;
    }

    private ScheduleDuration getScheduleDuration(Timestamp starTime, Timestamp newStartTime, Timestamp endTime) {
        ScheduleDuration scheduleDuration = new ScheduleDuration();
        scheduleDuration.setStartTime(starTime);
        scheduleDuration.setNewStartTime(newStartTime);
        scheduleDuration.setDuration(this.countDuration(endTime, newStartTime));
        scheduleDuration.setEndTime(endTime);
        return scheduleDuration;
    }

    public long countDuration(Timestamp end, Timestamp start) {
        return (end.getTime() - start.getTime()) / 1000L;
    }

    public Timestamp getCurrentDay() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return new Timestamp(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate(), 0, 0, 0, 0);
    }

    public Timestamp getAfterCurrentTimestamp(int afterTodayDays) {
        return new Timestamp(this.getCurrentDay().getTime() + (long)(afterTodayDays + 2) * 86400000L);
    }

    public Timestamp getBeforCurrentTimestamp(int beforTodayDays) {
        return new Timestamp(this.getCurrentDay().getTime() - (long)(beforTodayDays + 1) * 86400000L);
    }

    public String getStartTimeIn(int size) {
        StringBuilder inBuilder = new StringBuilder();
        inBuilder.append(" AND start_time IN (");
        for (int index = 0; index < size; ++index) {
            inBuilder.append("? ,");
        }
        inBuilder.append(") ");
        return inBuilder.toString().replace(",)", ")");
    }
}

