/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.entity.enumeration;

public enum PartnerTypeEnum {
    Provider("EPG Provider", "epgProvider"),
    Receiver("EPG Receiver", "epgReceiver");

    private String text;
    private String localizeKey;

    private PartnerTypeEnum(String text, String key) {
        this.text = text;
        this.localizeKey = key;
    }

    public String getLocalizeKey() {
        return this.localizeKey;
    }

    public String toString() {
        return this.text;
    }

    public String getTablePrefixByPartnerType() {
        if (this == Receiver) {
            return "EXP_";
        }
        if (this == Provider) {
            return "STG_";
        }
        return null;
    }

    public static PartnerTypeEnum fromValue(String partnerType) {
        for (PartnerTypeEnum type : PartnerTypeEnum.values()) {
            if (!type.toString().equals(partnerType)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknow enumeration value [" + partnerType + "]");
    }
}

