{
	"ruleMetaData":[
		   {
	           "ruleClass": "com.ericsson.cms.epgmgmt.custom.rule.implement.ScheduleDurationOverlappingManagerRule",
	           "displayName": "Resolve overlapping schedule",
	           "description": "Crop the schedules to resolve overlapping between schedules",
	           "ruleType": "ALL_NORMALIZATION",
	           "globalName": "ScheduleOverlappingResolver",
	           "parameters": [
	               {
	                   "type": "com.ericsson.cms.epgmgmt.custom.rule.param.StringParameter",
	                   "name": "Resolve Strategy",
	                   "description": "The strategy of cropping overlapping schedules. CROP_THE_EARLIER crops the schedule that starts earlier between two overlapping schedules and CROP_THE_LATER crops the one that starts later.",
	                   "errorMsg": "The overlapping resolve strategy type must be CROP_THE_EARLIER or CROP_THE_LATER .",
	                   "maxLen": 50,
	                   "value": "CROP_THE_EARLIER"
	                },
	                {
	                    "type": "com.ericsson.cms.epgmgmt.custom.rule.param.IntegerParameter",
	                    "name": "Time Period - Start Date (days before now)",
	                    "description": "The start date of resolving overlapping schedule period. If not specified, all schedules before the end time of resolving overlapping schedule period will be resolved. Minimum: 0. Maximum: 10000.",
	                    "errorMsg": "Time Period - Start Date (days before now) must be an integer.",
	                    "minValue": 0,
	                    "maxValue": 10000,
	                    "isNullable": "true"
	                 },
	                 {
	                     "type": "com.ericsson.cms.epgmgmt.custom.rule.param.IntegerParameter",
	                     "name": "Time Period - End Date (days after now)",
	                     "description": "The end date of resolving overlapping schedule period. If not specified, all schedules after the start time of resolving overlapping schedule period will be resolved. Minimum: 0. Maximum: 10000.",
	                     "errorMsg": "Time Period - End Date (days after now) must be an integer.",
	                     "minValue": 0,
	                     "maxValue": 10000,
	                     "isNullable": "true"
	                  }
	           ]
	       }
	 ]
}