resource "azurerm_postgresql_server" "edb1" {
  name                  = "${var.install_name}edb1"
  location              = "${azurerm_resource_group.cms-rg.location}"
  resource_group_name   = "${azurerm_resource_group.cms-rg.name}"

  sku {
    name     = "GP_Gen5_${var.dev_mode ? var.azure_db_cpus_dev : var.azure_db_cpus}"
    capacity = "${var.dev_mode ? var.azure_db_cpus_dev : var.azure_db_cpus}"
    tier     = "GeneralPurpose"
    family   = "Gen5"
  }

  #sku {
  #  name     = "B_Gen5_2"
  #  capacity = 2
  #  tier     = "Basic"
  #  family   = "Gen5"
  #}

  storage_profile {
    storage_mb            = 262144
    backup_retention_days = 7
    geo_redundant_backup  = "Disabled"
  }

  administrator_login          = "postgres"
  administrator_login_password = "${var.rds_db_pass}"
  version                      = "${var.rds_db_version}"
  ssl_enforcement              = "Disabled"
}

#resource "azurerm_postgresql_firewall_rule" "edb1firewall" {
#  name                = "${var.install_name}edb1firewall"
#  resource_group_name = "${azurerm_resource_group.cms-rg.name}"
#  server_name         = "${azurerm_postgresql_server.edb1.name}"
#  start_ip_address    = "10.0.0.0"
#  end_ip_address      = "10.0.0.255"
#}

resource "azurerm_postgresql_virtual_network_rule" "edb1accessrule" {
  name                 = "${var.install_name}edb1accessrule"
  resource_group_name  = "${azurerm_resource_group.cms-rg.name}"
  server_name          = "${azurerm_postgresql_server.edb1.name}"
  subnet_id            = "${azurerm_subnet.cms-subnet.id}"
  ignore_missing_vnet_service_endpoint = true
}