#This file manages high level resources used by the deployment


# Configure the Microsoft Azure Provider
provider "azurerm" {
    subscription_id = "${var.subscription_id}"
    client_id       = "${var.client_id}"
    client_secret   = "${var.client_secret}"
    tenant_id       = "${var.tenant_id}"
	}


# all resources will be created under the following resource group
resource "azurerm_resource_group" "cms-rg" {
    name     = "${var.install_name}-cms-resourcegroup"
    location = "westeurope"

    tags = {
        environment = "${var.tag_environment}"
    }
}

#set locals that will be used to merge values into the config in a provider independent way
