#!/bin/sh
##########################################################################
#        Script_name : installepgmgr.sh                                  #
#        Purpose     : Install database objects for epgmgr schema        #
#        Created by  : Suresh Neravati                                   #
#        Created on  : 10/07/2016                                        #
##########################################################################
TIMESTAMP=`date +%Y%m%d_%H%M%S`
DB_SETTINGS="/opt/db/scripts/install/settings"

if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi

DB_INSTALL_LOG="epgmanager"
INSTALL_DIR=`pwd`
DB_NAME="$1"
HOST_NAME="$2"
DB_TYPE="${DB_TYPE:-postgres}"

if [ "X$1" = "X"  ]; then
   DB_NAME="ttv"
fi
if [ "X$2" = "X"  ]; then
   HOST_NAME="${HOST_NAME:-dbserver}"
fi

/bin/sh ${INSTALL_DIR}/masterepgmgr.sh "${INSTALL_DIR}" "${DB_NAME}" "${HOST_NAME}" "${DB_TYPE}" 2>&1 | tee "${INSTALL_DIR}/${DB_INSTALL_LOG}.log"

echo "*********************************************************"
if [ ! -f "${INSTALL_DIR}/${DB_INSTALL_LOG}.log" ]
then
     echo "CMS EPG Install script probably failed!  ${INSTALL_DIR}/${DB_INSTALL_LOG}.log file is not exists..!"
     echo "*********************************************************"
     exit 1
else
     if  grep -q "ERROR\|SP2-\|FATAL\|Permission denied\|SQL-\|Warning" "${INSTALL_DIR}/${DB_INSTALL_LOG}.log"
     then
          /bin/mv "${INSTALL_DIR}/${DB_INSTALL_LOG}.log" "${INSTALL_DIR}/${DB_INSTALL_LOG}_${TIMESTAMP}.log"   
          echo "CMS EPG Install script probably failed! Check ${INSTALL_DIR}/${DB_INSTALL_LOG}_${TIMESTAMP}.log file for any errors"
          echo "*********************************************************"
          exit 1
     else
          /bin/mv "${INSTALL_DIR}/${DB_INSTALL_LOG}.log" "${INSTALL_DIR}/${DB_INSTALL_LOG}_${TIMESTAMP}.log"   
          echo "CMS EPG INSTALL SCRIPT SUCCEEDED!"
     fi
fi
echo "*********************************************************"
exit 0