#!/bin/sh
##########################################################################
#        Script_name : masterepgmgr.sh                                   #
#        Purpose     : creates database schema for epg and its db objects#
#        Created by  : Suresh Neravati                                   #
#        Created on  : 10/10/2016                                        #
##########################################################################
#INSTALL_DIR=`pwd`
INSTALL_DIR=$1
DB_NAME=$2
HOST_NAME=$3
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
PGPD="${DB_ADMIN_PW:-n2bbsys}"
PGP="epgmanager"
DB_TYPE=$4
DB_VER=${DB_VERSION:-9.5}
PSQLHOME="/usr/pgsql-${DB_VER}/bin"
HOST_NAME="${HOST_NAME:-dbserver}"
AZURE_DB="${AZURE_DB:-edb1}"
DB_USER="epgmanager"

if [ "X$1" = "X"  ]; then
     INSTALL_DIR=`pwd`
fi
if [ "X$2" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$3" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi
TBS_NAME="epgmanager_data"
SUDB="postgres"
SUSER="postgres"
SUSERTOGRANT="postgres"
if [ "X${DB_TYPE}" = "Xedb" ]; then
     SUDB="edb"
     SUSER="edb"
     SUSERTOGRANT="edb"
elif [ "X${DB_TYPE}" = "Xazure" ]; then
     SUSER="postgres@$AZURE_DB"
     DB_USER="epgmanager@$AZURE_DB"
fi
PORT=${DB_PORT:-5432}
export PGPASSWORD=${PGPD}
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='wfs';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "ERROR: Database ${DB_NAME} does not exists, run the installcms.sh script to create the cms database first."
   exit 1
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "SELECT count(*) FROM pg_roles WHERE rolname='epgmanager';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating User epgmanager....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "CREATE ROLE epgmanager;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER epgmanager PASSWORD 'epgmanager';"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "ALTER USER epgmanager with login;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${SUDB} -U ${SUSER} -q -t -c "GRANT epgmanager TO ${SUSERTOGRANT};"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='epgmanager';"| sed 's/^ *//'` -eq 0 ]]; then
   echo -e "\nCreating Schema epgmanager....\n"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "CREATE SCHEMA epgmanager AUTHORIZATION epgmanager;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT create ON DATABASE "${DB_NAME}" TO epgmanager;"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "GRANT all on schema epgmanager to epgmanager;"

   echo -e "\n******* epg schema created with permissions successfully *******\n"
fi
if [[ `${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${SUSER} -q -t -c "select count(*) from information_schema.schemata where schema_name='epgmanager';"| sed 's/^ *//'` -eq 0 ]]; then
   echo "epgmanager schema is not exists, exiting the script....."
   exit 1
fi
export PGPASSWORD=${PGP}
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f createepgmgr.sql
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -c "select MSGDATE, INSTALL_MESSAGE from epgmanager.install_table order by msgdate;"

exit 0