#!/bin/sh
##########################################################################
#        Script_name : cmsdw_grants.sh                                   #
#        Purpose     : Grant permissions on wfs schema objects to wfsdw  #
#        Created by  : Suresh Neravati                                   #
#        Created on  : 08/02/2017                                        #
##########################################################################
INSTALL_DIR=`pwd`
CMSDW_GRANTS_LOGFILE="cmsdw_grants.log"
DB_SETTINGS="/opt/db/scripts/install/settings"
if [[ -f $DB_SETTINGS ]]; then
    . "$DB_SETTINGS"
fi
DB_NAME=$1
HOST_NAME=$2
PGP="Wf\$1234"
DB_TYPE="${DB_TYPE:-postgres}"
PG_VER="${DB_VERSION:-9.5}"
PSQLHOME="/usr/pgsql-${PG_VER}/bin"
SSCHEMA="wfs"
if [ "X$1" = "X"  ]; then
     DB_NAME="ttv"
fi
if [ "X$2" = "X"  ]; then
     HOST_NAME="${HOST_NAME:-dbserver}"
fi
DB_USER="wfs"
AZURE_DB="${AZURE_DB:-edb1}"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfs@$AZURE_DB"
fi

PORT="${DB_PORT:-5432}"
export PGPASSWORD=${PGP}
(
WF_CNT=$( ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from wfs.system_settings where component_name in ('WORKFLOW')"| sed 's/^ *//' )
if [ "${WF_CNT}" -eq "1"  ]; then
   WF_TBL_CNT=$( ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -q -t -c "select count(*) from pg_catalog.pg_tables where tablename in ('ttv_template','ttv_processdefinitiontype','ttv_processinstance','ttv_token')"| sed 's/^ *//' )
   if [ "${WF_TBL_CNT}" -eq "4"  ]; then
      ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} <<EOF
grant select on wfs.ttv_template to wfsdw;
grant select on wfs.ttv_processdefinitiontype to wfsdw;
grant select on wfs.ttv_processinstance to wfsdw;
grant select on wfs.ttv_processpriority to wfsdw;
grant select on wfs.ttv_token to wfsdw;
grant select on wfs.ttv_monitoreddrivehistory to wfsdw;
grant select on wfs.ttv_monitoreddrivestatus to wfsdw;
grant select on wfs.ttv_monitoreddrive to wfsdw;
grant select on wfs.pmm_title_purge_history to wfsdw;
grant select on wfs.ttv_resource to wfsdw;
grant select on wfs.ttv_resourcetype to wfsdw;
grant select on wfs.jbpm_log to wfsdw;
grant select on wfs.ttv_resourcegroup to wfsdw;
grant select on wfs.ttv_accesslevel to wfsdw;
grant select on wfs.pmm_partner to wfsdw;
grant select on wfs.pmm_title to wfsdw;
grant select on wfs.mdm_metadata to wfsdw;
grant select on wfs.vdw_mdm_metadata_Fields to wfsdw;
grant select on wfs.vw_rep_templates_used_by_title to wfsdw; 
grant select on wfs.vw_rep_titles_prossby_template to wfsdw;
EOF

fi
else
   echo "ERROR: Workflow tables not exists, exiting the script..."
   exit 1
fi
) > ${INSTALL_DIR}/${CMSDW_GRANTS_LOGFILE}