﻿DROP FUNCTION IF EXISTS funcMD_LoadData();

CREATE OR REPLACE FUNCTION funcMD_LoadData()  
RETURNS smallint AS $funcMDLoadData$
DECLARE
        v_sqlcode         TEXT;
        etl_process       INT;
        run_instance      INT;
        error_status      INT:=0;
        failedProcs       VARCHAR(1000);
        etlProcessName    VARCHAR(50);
        v_ok_procs        INT;
        ret_status        INT:=0;
        new_dim_sync_date text;
        new_sync_date     text;
        run_date          VARCHAR(10);
        ran_count         INT;
        sync_wo_stat      INT;
        sync_log_stat     INT;
    BEGIN
        SELECT  COUNT(*) INTO v_ok_procs
        FROM   wfsdw.MD_LockableObject
        WHERE   LastObjectStatus = 0;

        IF v_ok_procs = 0 THEN
            raise notice '******* At if loop *******';
            UPDATE wfsdw.MD_LockableObject SET LastObjectStatus = 0;
        END IF;
        raise notice 'At the beginning of ETL functions....';

        SELECT to_char((now()::timestamp - INTERVAL '1 second'), 'mm/dd/yyyy hh24:mi:ss'), 
               to_char((date_trunc('day',now()::timestamp) - INTERVAL '1 second'), 'mm/dd/yyyy hh24:mi:ss'), 
               to_char(now(), 'mm/dd/yyyy') 
          INTO new_dim_sync_date, new_sync_date, run_date;

        SELECT count(*) INTO ran_count FROM wfsdw.md_etlprocessruninstance WHERE to_char(startdate,'mm/dd/yyyy')=run_date;

        IF ran_count > 0 THEN
            raise notice 'ETL already ran for the day, exiting the script.';
            return 0;
        END IF;

        SELECT wfsdw.SPSYNC_WorkOrderStatus(null,null,1,new_dim_sync_date) INTO error_status;
        IF error_status!=0 THEN
           failedProcs:='SPSYNC_WorkOrderStatus,'; ret_status:=1; 
        ELSIF error_status=0 THEN
           raise notice 'Completed loading SPSYNC_WorkOrderStatus';
        END IF;

        SELECT wfsdw.SPSYNC_Template(null,null,1,new_dim_sync_date) INTO error_status;
        IF error_status!=0 THEN
           failedProcs:='SPSYNC_Template,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading SPSYNC_Template';
        END IF;

        SELECT wfsdw.SPSYNC_Resource(null,null,1,new_dim_sync_date) INTO error_status;
        IF error_status!=0 THEN
            failedProcs:=failedProcs||'SPSYNC_Resource,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading SPSYNC_Resource';
        END IF;

        SELECT wfsdw.SPSYNC_ResourceGroup(null,null,1,new_dim_sync_date) INTO error_status;
        IF error_status!=0 THEN
            failedProcs:=failedProcs||'SPSYNC_ResourceGroup,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading SPSYNC_ResourceGroup';
        END IF;

        SELECT wfsdw.spSYNC_VariableInstance(null,null,1,new_dim_sync_date) INTO error_status;
        IF error_status!=0 THEN
            failedProcs:=failedProcs||'spSYNC_VariableInstance,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading spSYNC_VariableInstance';
        END IF;

        SELECT wfsdw.spSYNC_WorkOrder(null,null,1,new_sync_date) INTO error_status;
        IF error_status!=0 THEN
            sync_wo_stat:=1;
            failedProcs:=failedProcs||'spSYNC_WorkOrder,'; ret_status:=1;
        ELSIF error_status=0 THEN
            sync_wo_stat:=0;
           raise notice 'Completed loading spSYNC_WorkOrder';
        END IF;

        SELECT wfsdw.spSYNC_Log(null,null,1,new_sync_date) INTO error_status;
        IF error_status!=0 THEN
            sync_log_stat:=1;
            failedProcs:=failedProcs||'spSYNC_Log,'; ret_status:=1;
        ELSIF error_status=0 THEN
            sync_log_stat:=0;
           raise notice 'Completed loading spSYNC_Log';
        END IF;

        SELECT wfsdw.spSYNC_MonitoredDriveHistory(null,null,1,new_sync_date) INTO error_status;
        IF error_status!=0 THEN
            failedProcs:=failedProcs||'spSYNC_MonitoredDriveHistory,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading spSYNC_MonitoredDriveHistory';
        END IF;

        IF sync_wo_stat=0 THEN
            SELECT wfsdw.spAGG_FactWorkOrderDay(null,null,1,new_sync_date) INTO error_status;
            IF error_status!=0 THEN
               failedProcs:=failedProcs||'spAGG_FactWorkOrderDay,'; ret_status:=1;
            ELSIF error_status=0 THEN
               raise notice 'Completed loading spAGG_FactWorkOrderDay';
            END IF;
/*
           SELECT wfsdw.spAGG_FactWorkOrderMonth(null,null,1,new_sync_date) INTO error_status;
           IF error_status!=0 THEN
              failedProcs:=failedProcs||'spAGG_FactWorkOrderMonth,'; ret_status:=1;
           ELSIF error_status=0 THEN
              raise notice 'Completed loading spAGG_FactWorkOrderMonth';
           END IF;
*/
        END IF;

        IF sync_log_stat=0 THEN
           SELECT wfsdw.spAGG_FactResourceQueueDay(null,null,1,new_sync_date) INTO error_status;
           IF error_status!=0 THEN
              failedProcs:=failedProcs||'spAGG_FactResourceQueueDay,'; ret_status:=1;
           ELSIF error_status=0 THEN
              raise notice 'Completed loading spAGG_FactResourceQueueDay';
           END IF;
/*
           SELECT wfsdw.spAGG_FactResourceQueueMonth(null,null,1,new_sync_date) INTO error_status;
           IF error_status!=0 THEN
              failedProcs:=failedProcs||'spAGG_FactResourceQueueMonth,'; ret_status:=1;
           ELSIF error_status=0 THEN
              raise notice 'Completed loading spAGG_FactResourceQueueMonth';
           END IF;
*/
           SELECT wfsdw.spAGG_FactResourceTaskDay(null,null,1,new_sync_date) INTO error_status;
           IF error_status!=0 THEN
               failedProcs:=failedProcs||'spAGG_FactResourceTaskDay,'; ret_status:=1;
           ELSIF error_status=0 THEN
              raise notice 'Completed loading spAGG_FactResourceTaskDay';
           END IF;
/*
           SELECT wfsdw.spAGG_FactResourceTaskMonth(null,null,1,new_sync_date) INTO error_status;
           IF error_status!=0 THEN
               failedProcs:=failedProcs||'spAGG_FactResourceTaskMonth,'; ret_status:=1;
           ELSIF error_status=0 THEN
              raise notice 'Completed loading spAGG_FactResourceTaskMonth';
           END IF;
*/
        END IF;

        SELECT wfsdw.spAGG_FactMDHistoryDay(null,null,1,new_sync_date) INTO error_status;
        IF error_status!=0 THEN
            failedProcs:=failedProcs||'spAGG_FactMDHistoryDay,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading spAGG_FactMDHistoryDay';
        END IF;
/*
        SELECT wfsdw.spAGG_FactMDHistoryMonth(null,null,1,new_sync_date) INTO error_status;
        IF error_status!=0 THEN
            failedProcs:=failedProcs||'spAGG_FactMDHistoryMonth,'; ret_status:=1;
        ELSIF error_status=0 THEN
           raise notice 'Completed loading spAGG_FactMDHistoryMonth';
        END IF;
*/
        IF LENGTH(failedProcs) > 0 THEN
           raise notice 'Failed Functions are : %', failedProcs;
        END IF;

        RETURN ret_status;
 EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            -- Not raising application errors at this point!
            -- raise_application_error(-20001, 'spMD_LogInfoMessage ERROR: error inserting wfsdw.MD_ETLProcessMessage');
            SELECT spMD_WriteEventLog ('spMD_LoadData'::text, v_sqlcode::text, ''::text, 'Error in loading the data'::text) INTO error_status;
            RETURN ret_status;
 END;
 $funcMDLoadData$ LANGUAGE plpgsql;
