/*
	*****************************************************************************
	PROCEDURE: spAGG_FactWorkOrderDay
	[ETL - MD Compliant]
	*****************************************************************************
	Aggregates data from the FACT_WORKORDERDETAIL table.

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Chris Scherlacher - 04/11/2007]
	*****************************************************************************
	Change Log: Modified the daily report queries to avoid zero values
              by Suresh Neravati on 09-22-2010
	*****************************************************************************
*/
--1
DROP FUNCTION IF EXISTS spagg_factworkorderday(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spAGG_FactWorkOrderDay (
        parent_etl_process	int DEFAULT NULL,
        parent_run_instance	int DEFAULT NULL,
        force_lock		    int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactWorkOrderDay$
DECLARE
        etl_process		    int;
        run_instance		int;
        returned_error_status	int;
        lockable_object		int;
        procname		    varchar (100);
        objectname		    varchar (100);
        last_sync_date		timestamp;
        new_sync_date		timestamp;
        error_message		varchar (500);
        affected_rows		int;
        v_sqlcode		    TEXT;
	    error_status        int;
	    tmp_results         numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactWorkOrderDay';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 200;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process

    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1,'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!')  INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name
        INTO	lockable_object, objectname
        FROM	WFSDW.MD_ETLProcess p
        JOIN	WFSDW.MD_LockableObject o
        ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError (   etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
   EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN returned_error_status;
    END IF;

    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...

    --Select To_Date(To_Char(Sysdate,'mmddyyyy'),'mmddyyyy')- (1/86400) Into New_Sync_Date;
     BEGIN

        Insert Into WFSDW.FACT_WORKORDERDAY(TemplateWK, ProviderWK, DateWK, WorkOrderCount, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
        select wo.templatewk, wo.providerwk, wo.localstartdatewk, coalesce(wo.wo_count, 0), etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM ( SELECT TemplateWK, ProviderWK, LocalStartDateWK, COUNT(*) as WO_COUNT
                   FROM WFSDW.FACT_WORKORDERDETAIL
                  where localstartdatewk between to_number(to_char((last_sync_date + interval '1 second' ),'YYYYMMDD'),'99999999') 
                        and to_number(to_char(new_sync_date,'YYYYMMDD'),'99999999')
                  GROUP BY TemplateWK, ProviderWK, LocalStartDateWK) wo;

        GET DIAGNOSTICS affected_rows = ROW_COUNT; 
        IF (affected_rows = 0) THEN
            -- Source table has no new or updated records. No point in continuing...
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
            SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
            --COMMIT; -- Yay!
            error_status := 0;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN
                --v_sqlcode := SQLCODE;
                error_message := procname || ': DB error loading FACT_WorkOrderDay!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.

    --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN error_status;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactWorkOrderDay$ LANGUAGE plpgsql;

/*
        *****************************************************************************
        PROCEDURE: spAGG_FactWorkOrderMonth
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_WORKORDERDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 04/11/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--2
DROP FUNCTION IF EXISTS spAGG_FactWorkOrderMonth(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spAGG_FactWorkOrderMonth (
        parent_etl_process	int DEFAULT NULL,
        parent_run_instance	int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactWorkOrderMonth$
DECLARE
        etl_process                 int;
        run_instance                int;
        returned_error_status       int;
        lockable_object             int;
        procname                    varchar(100);
        objectname                  varchar(100);
        last_sync_date              timestamp;
        new_sync_date               timestamp;
        last_sync_month             numeric(6);
        new_sync_month_indicator    numeric(6);
        error_message               varchar(500);
        affected_rows               int;
        v_sqlcode                   TEXT;
	    error_status                int;
	    tmp_results                 numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactWorkOrderMonth';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 201;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1, 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!')  INTO returned_error_status;
        RETURN error_status;
    END IF;
    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name
        INTO	lockable_object, objectname
        FROM	WFSDW.MD_ETLProcess p
        JOIN	WFSDW.MD_LockableObject o
        ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;
        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
   EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN returned_error_status;
    END IF;

    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    SELECT MAX(TO_CHAR((d.CALENDERDATE - 1),'YYYYMM')) INTO new_sync_month_indicator
      FROM WFSDW.FACT_WORKORDERDETAIL f JOIN WFSDW.DIM_DATE d ON f.LOCALSTARTDATEWK = d.DATEWK;
    If new_sync_month_indicator is NULL THEN
        -- the Fact table has no records. No point in continuing...
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, last_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
    End If;
    last_sync_month := TO_NUMBER(TO_CHAR(last_sync_date,'YYYYMM'),'999999');
    BEGIN
        If new_sync_month_indicator > last_sync_month THEN
             select (to_date(to_char(new_sync_month_indicator,'999999')||'01','YYYYMMDD') -  interval '1 second' ) into new_sync_date;
             Insert Into WFSDW.FACT_WORKORDERMONTH(TemplateWK, ProviderWK, MonthWK, WorkOrderCount, LASTETLPROCESS,
                                                   LASTRUNINSTANCE,CREATEDATE, UPDATEDATE)
             SELECT a.TemplateWK, a.ProviderWK,  a.MonthWK,  coalesce(wo.WO_COUNT, 0), 
                    etl_process, run_instance, now()::timestamp, now()::timestamp
               FROM (SELECT TemplateWK, ProviderWK, MonthWK
                       FROM (SELECT DISTINCT TemplateWK, ProviderWK
                               FROM wfsdw.FACT_WORKORDERDETAIL
                               JOIN wfsdw.DIM_DATE ON LOCALSTARTDATEWK = DATEWK
                              WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date) tp
                      CROSS JOIN wfsdw.DIM_MONTH d 
                      WHERE d.MonthWK BETWEEN to_number(to_Char((to_date(to_Char(last_sync_month,'999999'),'YYYYMM') + interval '1 Month'),'YYYYMM'),'999999') 
                                      AND to_number(to_char((to_date(to_Char(new_sync_month_indicator,'999999'),'YYYYMM') - interval '1 Month'),'YYYYMM'),'999999')) a
          LEFT JOIN (SELECT TemplateWK, ProviderWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999') as MonthWK, COUNT(*) as WO_COUNT
                       FROM wfsdw.FACT_WORKORDERDETAIL
                       JOIN wfsdw.DIM_DATE ON LOCALSTARTDATEWK = DATEWK
                     WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date
                     GROUP BY TemplateWK, ProviderWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999')) wo
            ON a.TemplateWK = wo.TemplateWK AND
               a.ProviderWK = wo.ProviderWK AND
               a.MonthWK = wo.MonthWK;

          GET DIAGNOSTICS affected_rows = ROW_COUNT; 
          IF (affected_rows = 0) THEN
              -- Source table has no new or updated records. No point in continuing...
              SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
              SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
              --COMMIT; -- Yay!
              error_status := 0;
              RETURN returned_error_status;
          END IF;
    END IF;
    EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                error_message := procname || ': DB error loading FACT_WorkOrderMonth!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN error_status;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactWorkOrderMonth$ LANGUAGE plpgsql;

/*
        *****************************************************************************
        PROCEDURE: spAGG_FactResourceQueueDay
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_RESOURCEQUEUEDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 05/29/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--3
DROP FUNCTION IF EXISTS spAGG_FactResourceQueueDay(int,int,int,text);
CREATE OR REPLACE FUNCTION spAGG_FactResourceQueueDay (
        parent_etl_process      int DEFAULT NULL,
        parent_run_instance     int DEFAULT NULL,
        force_lock              int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactResourceQueueDay$
DECLARE
        etl_process             int;
        run_instance            int;
        returned_error_status   int;
        lockable_object         int;
        procname                varchar (100);
        objectname              varchar (100);
        last_sync_date          timestamp;
        new_sync_date           timestamp;
        error_message           varchar (500);
        affected_rows           int;
        v_sqlcode               TEXT;
	    error_status            int;
	    tmp_results             numeric;
    BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactResourceQueueDay';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 205;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1, 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!') INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT  LockableObjectLoaded, o.Name
        INTO    lockable_object, objectname
        FROM    WFSDW.MD_ETLProcess p
        JOIN    WFSDW.MD_LockableObject o
        ON (    o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE   ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError ( etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN returned_error_status;
    END IF;
    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    --select to_date(to_char(sysdate,'mmddyyyy'),'mmddyyyy')- (1/86400) into new_sync_date;
    BEGIN
        Insert Into Wfsdw.Fact_Resourcequeueday ( TemplateWK,  WorkOrderWK,  NodeWK,  ResourceWK,  Resourcegroupwk,
                    DateWK,  TotalDuration,  TotalQueued,  LASTETLPROCESS,  lastruninstance,  CREATEDATE,  updatedate)
          SELECT a.TemplateWK, a.WorkOrderWK, a.NodeWK, a.ResourceWK, a.ResourceGroupWK, a.localenterdatewk, coalesce(a.RQ_SUM, 0),
                 coalesce(a.RQ_CNT, 0), etl_process, run_instance, now()::timestamp, now()::timestamp
            FROM (Select Templatewk, Workorderwk, Nodewk, Resourcewk, Resourcegroupwk,
                         Localenterdatewk, Count(*) As Rq_Cnt, Sum(Duration) As Rq_Sum
                    From wfsdw.Fact_Resourcequeuedetail
                   where localenterdatewk between to_number(to_char(( last_sync_date+ interval '1 second' ),'YYYYMMDD'),'99999999') 
                         and to_number(to_char(new_sync_date,'YYYYMMDD'),'99999999')
                   group by templatewk, workorderwk, nodewk, resourcewk, resourcegroupwk, localenterdatewk) a;

        GET DIAGNOSTICS affected_rows = ROW_COUNT; 

        IF (affected_rows = 0) THEN
            -- Source table has no new or updated records. No point in continuing...
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
            SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
            --COMMIT; -- Yay!
            error_status := 0;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                error_message := procname || ': DB error loading FACT_ResourceQueueDay!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN error_status;
   EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactResourceQueueDay$ LANGUAGE plpgsql;

/*
        *****************************************************************************
        PROCEDURE: spAGG_FactResourceQueueMonth
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_RESOURCEQUEUEDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 04/11/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--4
DROP FUNCTION IF EXISTS spAGG_FactResourceQueueMonth(int,int,int,text);
CREATE OR REPLACE FUNCTION spAGG_FactResourceQueueMonth (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactResourceQueueMonth$
DECLARE
        etl_process                 int;
        run_instance                int;
        returned_error_status       int;
        lockable_object             int;
        procname                    varchar(100);
        objectname                  varchar(100);
        last_sync_date              timestamp;
        new_sync_date               timestamp;
        last_sync_month             numeric(6);
        new_sync_month_indicator    numeric(6);
        error_message               varchar(500);
        affected_rows               int;
        v_sqlcode                   TEXT;
	    error_status                int;
	    tmp_results                 numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactResourceQueueMonth';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 206;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process

    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1, 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!') INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT  LockableObjectLoaded, o.Name
        INTO    lockable_object, objectname
        FROM    WFSDW.MD_ETLProcess p
        JOIN    WFSDW.MD_LockableObject o
        ON (    o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE   ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError (   etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
   EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN returned_error_status;
    END IF;
    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    SELECT MAX(TO_CHAR((d.CALENDERDATE - 1),'YYYYMM'))
    INTO new_sync_month_indicator
    FROM wfsdw.FACT_WORKORDERDETAIL f
      JOIN wfsdw.DIM_DATE d
        ON f.LOCALSTARTDATEWK = d.DATEWK;
        
    If new_sync_month_indicator is NULL THEN
      -- the Fact table has no records. No point in continuing...
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, last_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
    End If;

    last_sync_month := TO_NUMBER(TO_CHAR(last_sync_date,'YYYYMM'),'999999');

    BEGIN
        If new_sync_month_indicator > last_sync_month THEN
            select (to_date(to_char(new_sync_month_indicator,'999999')||'01','YYYYMMDD') -  interval '1 second' ) into new_sync_date;
            Insert Into WFSDW.FACT_RESOURCEQUEUEMONTH(TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK,
                        MonthWK, TotalDuration, TotalQueued, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
             SELECT a.TemplateWK, a.WorkOrderWK, a.NodeWK, a.ResourceWK, a.ResourceGroupWK, a.MonthWK, coalesce(rq.RQ_SUM, 0),
                     coalesce(rq.RQ_CNT, 0), etl_process, run_instance, now()::timestamp, now()::timestamp
        FROM (SELECT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, MonthWK
              FROM (SELECT DISTINCT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK
                    FROM wfsdw.FACT_RESOURCEQUEUEDETAIL
                      JOIN wfsdw.DIM_DATE
                        ON LOCALENTERDATEWK = DATEWK
                    WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date) tp
                CROSS JOIN wfsdw.DIM_MONTH d
                WHERE d.MonthWK BETWEEN to_number(to_Char((to_date(to_Char(last_sync_month,'999999'),'YYYYMM') + interval '1 Month'),'YYYYMM'),'999999') 
                                    AND to_number(to_char((to_date(to_Char(new_sync_month_indicator,'999999'),'YYYYMM') - interval '1 Month'),'YYYYMM'),'999999')) a
          LEFT JOIN (SELECT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999') as MonthWK, 
                            COUNT(*) as RQ_CNT, SUM(Duration) as RQ_SUM
                     FROM wfsdw.FACT_RESOURCEQUEUEDETAIL
                       JOIN wfsdw.DIM_DATE
                         ON LOCALENTERDATEWK = DATEWK
                     WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date
                     GROUP BY TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999')) rq 
            ON a.TemplateWK = rq.TemplateWK AND
               a.WorkOrderWK = rq.WorkOrderWK AND
	       a.NodeWK = rq.NodeWK AND
	       a.ResourceWK = rq.ResourceWK AND
	       a.ResourceGroupWK = rq.ResourceGroupWK AND
               a.MonthWK = rq.MonthWK;

          GET DIAGNOSTICS affected_rows = ROW_COUNT; 
          IF (affected_rows = 0) THEN

              -- Source table has no new or updated records. No point in continuing...
              SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
              SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
              --COMMIT; -- Yay!
              error_status := 0;
              RETURN returned_error_status;
          END IF;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                error_message := procname || ': DB error loading FACT_ResourceQueueMonth!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;

                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactResourceQueueMonth$ LANGUAGE plpgsql;


/*
        *****************************************************************************
        PROCEDURE: spAGG_FactResourceTaskDay
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_RESOURCETASKDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 05/29/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--5
DROP FUNCTION IF EXISTS spAGG_FactResourceTaskDay(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spAGG_FactResourceTaskDay (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactResourceTaskDay$
DECLARE
        etl_process             int;
        run_instance            int;
        returned_error_status   int;
        lockable_object         int;
        procname                varchar (100);
        objectname              varchar (100);
        last_sync_date          timestamp;
        new_sync_date           timestamp;
        error_message           varchar (500);
        affected_rows           int;
        v_sqlcode               TEXT;
	    error_status            int;
	    tmp_results             numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactResourceTaskDay';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 210;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process

    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1, 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!')  INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT  LockableObjectLoaded, o.Name
        INTO    lockable_object, objectname
        FROM    WFSDW.MD_ETLProcess p
        JOIN    WFSDW.MD_LockableObject o
        ON (    o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE   ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError (   etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
   EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
        RETURN returned_error_status;
    END IF;

    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    --select to_date(to_char(sysdate,'mmddyyyy'),'mmddyyyy')- (1/86400) into new_sync_date;
    BEGIN
        Insert Into WFSDW.FACT_RESOURCETASKDAY(TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, DateWK, 
                    TotalDuration, TotalTasks, TotalErrors, LASTETLPROCESS, Lastruninstance, CREATEDATE, Updatedate)                                             
      Select  A.Templatewk,  A.Workorderwk,  A.Nodewk, A.Resourcewk, A.Resourcegroupwk, A.Localenterdatewk, coalesce(A.Rt_Sum,0), 
              coalesce(A.Rt_Count,0), coalesce(Rte.Rtfail_Count,0), Etl_Process,  Run_Instance, now()::timestamp, now()::timestamp
        From (Select Templatewk, Workorderwk, Nodewk, Resourcewk, Resourcegroupwk, 
                     Localenterdatewk, Count(*) As Rt_Count, Sum(Duration) As Rt_Sum
                From wfsdw.Fact_Resourcetaskdetail
               Where Localenterdatewk Between to_number(TO_CHAR((last_sync_date + interval '1 second' ),'YYYYMMDD'),'99999999')
                     AND to_number(TO_CHAR(new_sync_date,'YYYYMMDD'),'99999999')
               Group By Templatewk, Workorderwk, Nodewk, Resourcewk, Resourcegroupwk, Localenterdatewk) A
        Left Join (Select Templatewk, Workorderwk, Nodewk, Resourcewk, Resourcegroupwk, 
                          Localenterdatewk, Count(*) As Rtfail_Count
                     From wfsdw.Fact_Resourcetaskdetail Frt2
                     Join wfsdw.Dim_Workorderstatus Dwos On Frt2.Operstatuswk = Dwos.Workorderstatuswk
                    Where Dwos.Name = 'ERROR'
                      And  Localenterdatewk Between to_number(TO_CHAR(( last_sync_date + interval '1 second' ),'YYYYMMDD'),'99999999')
                           AND to_number(TO_CHAR(new_sync_date,'YYYYMMDD'),'99999999')
                     Group By Templatewk, Workorderwk, Nodewk, Resourcewk, Resourcegroupwk, Localenterdatewk) Rte
           On A.Templatewk = Rte.Templatewk And
              A.WorkOrderWK = rte.WorkOrderWK And
              A.Nodewk = Rte.Nodewk And
              A.Resourcewk = Rte.Resourcewk And
              A.Resourcegroupwk = Rte.Resourcegroupwk And
              A.Localenterdatewk = Rte.Localenterdatewk;

        GET DIAGNOSTICS affected_rows = ROW_COUNT; 
        IF (affected_rows = 0) THEN

            -- Source table has no new or updated records. No point in continuing...
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
            SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
            --COMMIT; -- Yay!
            error_status := 0;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                error_message := procname || ': DB error loading FACT_ResourceTaskDay!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
   EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactResourceTaskDay$ LANGUAGE plpgsql;

/*
        *****************************************************************************
        PROCEDURE: spAGG_FactResourceTaskMonth
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_RESOURCETASKDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 04/11/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--6
DROP FUNCTION IF EXISTS spAGG_FactResourceTaskMonth(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spAGG_FactResourceTaskMonth (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactResourceTaskMonth$
DECLARE
        etl_process                 int;
        run_instance                int;
        returned_error_status       int;
        lockable_object             int;
        procname                    varchar(100);
        objectname                  varchar(100);
        last_sync_date              timestamp;
        new_sync_date               timestamp;
        last_sync_month             numeric(6);
        new_sync_month_indicator    numeric(6);
        error_message               varchar(500);
        affected_rows               int;
        v_sqlcode                   TEXT;
	    error_status                int;
	    tmp_results                 numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactResourceTaskMonth';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 211;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process

    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1,'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!') INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT  LockableObjectLoaded, o.Name
        INTO    lockable_object, objectname
        FROM    WFSDW.MD_ETLProcess p
        JOIN    WFSDW.MD_LockableObject o
        ON (    o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE   ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError ( etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
   EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
        RETURN returned_error_status;
    END IF;
    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...

    SELECT MAX(TO_CHAR((d.CALENDERDATE - 1),'YYYYMM'))
    INTO new_sync_month_indicator
    FROM wfsdw.FACT_WORKORDERDETAIL f
      JOIN wfsdw.DIM_DATE d
        ON f.LOCALSTARTDATEWK = d.DATEWK;
        
    If new_sync_month_indicator is NULL THEN
    
      -- the Fact table has no records. No point in continuing...
              SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, last_sync_date, 0, 0) INTO returned_error_status;
              SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
              --COMMIT; -- Yay!
              error_status := 0;
              RETURN returned_error_status;
    End If;

    last_sync_month := TO_NUMBER(TO_CHAR(last_sync_date,'YYYYMM'),'999999');

    BEGIN
        If new_sync_month_indicator > last_sync_month THEN
            select (to_date(to_char(new_sync_month_indicator,'999999')||'01','YYYYMMDD') -  interval '1 second' ) into new_sync_date;
            Insert Into WFSDW.FACT_RESOURCETASKMONTH(TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, MonthWK,
                        TotalDuration, TotalTasks, TotalErrors, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
        SELECT a.TemplateWK, a.WorkOrderWK, a.NodeWK, a.ResourceWK, a.ResourceGroupWK, a.MonthWK, coalesce(rt.RT_SUM, 0),
               coalesce(rt.RT_COUNT, 0), coalesce(rte.RTFAIL_COUNT, 0), etl_process, run_instance, now()::timestamp, now()::timestamp
        FROM (SELECT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, MonthWK
              FROM (SELECT DISTINCT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK
                    FROM wfsdw.FACT_RESOURCETASKDETAIL
                      JOIN wfsdw.DIM_DATE
                        ON LOCALENTERDATEWK = DATEWK
                    WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date) tp
                CROSS JOIN wfsdw.DIM_MONTH d
                WHERE d.MonthWK BETWEEN to_number(to_Char((to_date(to_Char(last_sync_month,'999999'),'YYYYMM') + interval '1 Month'),'YYYYMM'),'999999')  
                                    AND to_number(to_char((to_date(to_Char(new_sync_month_indicator,'999999'),'YYYYMM') - interval '1 Month'),'YYYYMM'),'999999')) a
          LEFT JOIN (SELECT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999') as MonthWK, COUNT(*) as RT_COUNT, SUM(Duration) as RT_SUM
                     FROM wfsdw.FACT_RESOURCETASKDETAIL
                       JOIN wfsdw.DIM_DATE
                         ON LOCALENTERDATEWK = DATEWK
                     WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date
                     GROUP BY TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999')) rt
            ON a.TemplateWK = rt.TemplateWK AND
               a.WorkOrderWK = rt.WorkOrderWK AND
               a.NodeWK = rt.NodeWK AND
               a.ResourceWK = rt.ResourceWK AND
               a.ResourceGroupWK = rt.ResourceGroupWK AND
               a.MonthWK = rt.MonthWK
           LEFT JOIN (SELECT TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999') as MonthWK, COUNT(*) as RTFAIL_COUNT 
                     FROM wfsdw.FACT_RESOURCETASKDETAIL
                       JOIN wfsdw.DIM_DATE
                         ON LOCALENTERDATEWK = DATEWK
		       JOIN wfsdw.DIM_WORKORDERSTATUS
			 ON OPERSTATUSWK = WORKORDERSTATUSWK
                     WHERE CALENDERDATE BETWEEN last_sync_date AND new_sync_date AND
                           NAME = 'ERROR'
                     GROUP BY TemplateWK, WorkOrderWK, NodeWK, ResourceWK, ResourceGroupWK, to_number(to_Char(CalenderDate,'YYYYMM'),'999999')) rte
            ON a.TemplateWK = rte.TemplateWK AND
               a.WorkOrderWK = rte.WorkOrderWK AND
               a.NodeWK = rte.NodeWK AND
               a.ResourceWK = rte.ResourceWK AND
               a.ResourceGroupWK = rte.ResourceGroupWK AND
               a.MonthWK = rte.MonthWK;

          GET DIAGNOSTICS affected_rows = ROW_COUNT; 
          IF (affected_rows = 0) THEN
              -- Source table has no new or updated records. No point in continuing...
              SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
              SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
              --COMMIT; -- Yay!
              error_status := 0;
              RETURN returned_error_status;
          END IF;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': DB error loading FACT_ResourceTaskMonth!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
       -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
        -- occur due to problematic data in STG_DIFF.
        --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactResourceTaskMonth$ LANGUAGE plpgsql;

/*
        *****************************************************************************
        PROCEDURE: spAGG_FactMDHistoryDay
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_MDHISTORYDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 05/29/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--7
DROP FUNCTION IF EXISTS spAGG_FactMDHistoryDay(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spAGG_FactMDHistoryDay (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactMDHistoryDay$
DECLARE
        etl_process             int;
        run_instance            int;
        returned_error_status   int;
        lockable_object         int;
        procname                varchar (100);
        objectname              varchar (100);
        last_sync_date          timestamp;
        new_sync_date           timestamp;
        error_message           varchar (500);
        affected_rows           int;
        v_sqlcode               TEXT;
	    error_status            int;
	    tmp_results             numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactMDHistoryDay';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 215;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process

    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname, -1, 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!') INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT  LockableObjectLoaded, o.Name
        INTO    lockable_object, objectname
        FROM    WFSDW.MD_ETLProcess p
        JOIN    WFSDW.MD_LockableObject o
        ON (    o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE   ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError ( etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
   EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
        RETURN returned_error_status;
    END IF;
    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...

    --select to_date(to_char(sysdate,'mmddyyyy'),'mmddyyyy')- (1/86400) into new_sync_date;   --- Current_sysdate

    BEGIN
	Insert Into WFSDW.FACT_MDHISTORYDAY(MONITOREDDRIVEWK, MONITOREDDRIVESTATUSWK, LOCALDATEWK, BYTESUSED, PERCENTUSED, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
	SELECT a.MONITOREDDRIVEWK, MONITOREDDRIVESTATUSWK, LOCALDATEWK, a.MDH_MAX, coalesce((a.MDH_MAX/d.totalcapacity)*100,0), etl_process, run_instance, now()::timestamp, now()::timestamp
	FROM (SELECT MONITOREDDRIVEWK, MONITOREDDRIVESTATUSWK, LOCALDATEWK, MAX(CurrentBytesUsed) as MDH_MAX
	      From wfsdw.Fact_Mdhistorydetail
	      WHERE LOCALDATEWK BETWEEN to_number(TO_CHAR(( last_sync_date+ interval '1 day' ),'YYYYMMDD'),'99999999')
                    AND to_number(TO_CHAR(new_sync_date,'YYYYMMDD'),'99999999')
              GROUP BY MONITOREDDRIVEWK, MONITOREDDRIVESTATUSWK, LOCALDATEWK) a
	  JOIN wfsdw.DIM_MONITOREDDRIVE d
	    ON a.MONITOREDDRIVEWK = d.MONITOREDDRIVEWK; 

        GET DIAGNOSTICS affected_rows = ROW_COUNT; 
        IF (affected_rows = 0) THEN
            -- Source table has no new or updated records. No point in continuing...
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
            SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
            --COMMIT; -- Yay!
            error_status := 0;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                error_message := procname || ': DB error loading FACT_MDHistoryDay!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
   EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactMDHistoryDay$ LANGUAGE plpgsql;

/*
        *****************************************************************************
        PROCEDURE: spAGG_FactMDHistoryMonth
        [ETL - MD Compliant]
        *****************************************************************************
        Aggregates data from the FACT_MDHISTORYDETAIL table.

        *****************************************************************************
        [USED BY]       ETL - DW Load process
        *****************************************************************************
        [By Chris Scherlacher - 05/29/2007]
        *****************************************************************************
        Change Log:

        *****************************************************************************
*/
--8
DROP FUNCTION IF EXISTS spAGG_FactMDHistoryMonth(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spAGG_FactMDHistoryMonth (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text DEFAULT '')
RETURNS smallint AS $func_spAGG_FactMDHistoryMonth$
DECLARE
        etl_process             int;
        run_instance            int;
        returned_error_status   int;
        lockable_object         int;
        procname                varchar (100);
        objectname              varchar (100);
        last_sync_date          timestamp;
        new_sync_date           timestamp;
        last_sync_month             numeric(6);
        new_sync_month_indicator    numeric(6);
        error_message           varchar (500);
        affected_rows           int;
        v_sqlcode               TEXT;
	    error_status            int;
	    tmp_results             numeric;
    BEGIN

    -- Initialize...
    error_status := -1;
    procname := 'spAGG_FactMDHistoryMonth';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 216;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process

    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname,  -1, 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!') INTO returned_error_status;
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT  LockableObjectLoaded, o.Name
        INTO    lockable_object, objectname
        FROM    WFSDW.MD_ETLProcess p
        JOIN    WFSDW.MD_LockableObject o
        ON (    o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE   ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);

    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
        RETURN returned_error_status;
    END IF;
    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...

    SELECT MAX(TO_CHAR((d.CALENDERDATE - 1),'YYYYMM'))
      INTO new_sync_month_indicator
      FROM wfsdw.FACT_MDHISTORYDETAIL f
      JOIN wfsdw.DIM_DATE d
        ON f.LOCALDATEWK = d.DATEWK;

    If new_sync_month_indicator is NULL THEN
      -- the Fact table has no records. No point in continuing...
              SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, last_sync_date, 0, 0) INTO returned_error_status;
              SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
              --COMMIT; -- Yay!
              error_status := 0;
              RETURN returned_error_status;
    End If;

    last_sync_month := TO_CHAR(last_sync_date,'YYYYMM');
    BEGIN
    If new_sync_month_indicator > last_sync_month THEN
            select (to_date(to_char(new_sync_month_indicator,'999999')||'01','YYYYMMDD') -  interval '1 second' ) into new_sync_date;
            Insert Into WFSDW.FACT_MDHISTORYMONTH(MONITOREDDRIVEWK, MONTHWK, MAXPERCENTUSED, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
            SELECT f.MONITOREDDRIVEWK,  to_char(d.CALENDERDATE,'YYYYMM')::numeric, MAX(ROUND(coalesce((f.currentbytesused/md.totalcapacity)*100,0),2)),
                   etl_process, run_instance, now()::timestamp, now()::timestamp
              FROM wfsdw.FACT_MDHISTORYDETAIL f
              JOIN wfsdw.DIM_MONITOREDDRIVE md ON f.MONITOREDDRIVEWK = md.MONITOREDDRIVEWK
          JOIN wfsdw.DIM_DATE d ON f.LOCALDATEWK = d.DATEWK
             WHERE d.CALENDERDATE > last_sync_date AND d.CALENDERDATE <= new_sync_date
             GROUP BY f.MONITOREDDRIVEWK, to_char(d.CALENDERDATE,'YYYYMM');

           GET DIAGNOSTICS affected_rows = ROW_COUNT; 
           IF (affected_rows = 0) THEN
               -- Source table has no new or updated records. No point in continuing...
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
                SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
               --COMMIT; -- Yay!
               error_status := 0;
               RETURN returned_error_status;
            END IF;
    END IF;
    EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                error_message := procname || ': DB error loading FACT_MDHistoryMonth!';
                raise notice 'ERROR % %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN returned_error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN returned_error_status;
   EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': Global exception handler -> unknown error has occurred!';
            raise notice 'ERROR % %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN 1;
    END;
    $func_spAGG_FactMDHistoryMonth$ LANGUAGE plpgsql;
