#!/bin/sh
##
## create the data warehouse objects
##
export DB_NAME=$1
export log_directory=$2
export HOST_NAME=$3
export PORT=$4
export SSCHEMA=$5
create_wfsdw_log=cms_warehouse_install.log
PSQLHOME=$6
DB_TYPE=$7
DB_USER="wfsdw"
AZURE_DB="${AZURE_DB:-edb1}"
if [ "X${DB_TYPE}" = "Xazure" ]; then
     DB_USER="wfsdw@$AZURE_DB"
fi

(
echo " "
echo "Creating the Data Warehouse database objects, please wait........"
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -v "inst_schema=$SSCHEMA" -f createwfsdw.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f createwfsmd_dw.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f createwfsload_dw.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f createwfsagg_dw.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f loadwfsdim_dw.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f createwfsreport_dw.sql
   ${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -f createwfsadmin_dw.sql
sh cmsdw_grants.sh ${DB_NAME} ${HOST_NAME}
${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U ${DB_USER} -c "select msgdate, install_message from ${SSCHEMA}.install_table;"
#${PSQLHOME}/psql -h ${HOST_NAME} -p ${PORT} -d ${DB_NAME} -U wfsdw -q -c "update wfsdw.MD_LOCKABLEOBJECT set lastsyncdate=to_date(to_char(current_date-1,'YYYY-MM-DD'),'YYYY-MM-DD 00:00:00') where name not like 'DIM%';"


) 2>&1 | tee ${log_directory}/${create_wfsdw_log}

