PREPARE get_inst_schema AS SELECT :'inst_schema'::text;

CREATE OR REPLACE FUNCTION createobject(vsql text, errmsg varchar, mask varchar default 'N') RETURNS smallint AS $func_createobject$
DECLARE
  verrmsg    varchar:='';
BEGIN
  EXECUTE vsql;
  return 0;
EXCEPTION 
  WHEN others THEN 
    select substring(errmsg,1,200) into verrmsg;
    verrmsg := sqlstate||' - Error : "'||verrmsg ||'", '||sqlerrm||'-- '||vsql;
    if upper(mask) != 'Y' then
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
    end if;
    return 1;
END;
$func_createobject$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION createseq( vschema varchar, vtabname varchar, vseqstart integer default 1,  vcache integer default 1) RETURNS smallint AS $func_createseq$
DECLARE
  verrmsg    varchar:='';
  pkeycol    varchar:='';
  vsql       varchar;
BEGIN
  EXECUTE 'SELECT  kcu.column_name
             FROM  INFORMATION_SCHEMA.TABLES t
             LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc
                 ON tc.table_catalog = t.table_catalog
                 AND tc.table_schema = t.table_schema
                 AND tc.table_name = t.table_name
                 AND tc.constraint_type = ''PRIMARY KEY''
             LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu
                 ON kcu.table_catalog = tc.table_catalog
                 AND kcu.table_schema = tc.table_schema
                 AND kcu.table_name = tc.table_name
                 AND kcu.constraint_name = tc.constraint_name
            WHERE  t.table_schema = '''||vschema||'''
              AND  upper(t.table_name) = upper('''||vtabname||''')' INTO pkeycol;

  vsql := 'CREATE SEQUENCE '||substr(vtabname,1,26)||'_SEQ INCREMENT BY 1 START WITH '||vseqstart::text||' CACHE '||vcache::text;
  EXECUTE vsql;
  IF  pkeycol IS NOT NULL  OR pkeycol <> '' THEN
     EXECUTE 'ALTER TABLE '||vschema||'.'||vtabname||' ALTER COLUMN '||pkeycol||' set default nextval ('''||substr(vtabname,1,26)||'_SEQ'')';
  END IF;
  return 0;
EXCEPTION 
  WHEN others THEN 
    verrmsg := sqlstate||' - Error : Unable to create '||substr(vtabname,1,26)||'_SEQ ,'||sqlerrm;
    raise notice 'Error: %',verrmsg;
    raise exception 'Error: %',verrmsg;
    return 1;
END;
$func_createseq$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION createupdatetrg( vschema varchar, vtabname varchar) RETURNS smallint AS $func_createupdatetrg$
DECLARE
    verrmsg varchar:='';
    vcount  smallint;
    vsql    varchar;
BEGIN
    EXECUTE 'SELECT count(*) FROM information_schema.columns WHERE table_schema = lower('''||vschema||''') AND upper(table_name) = upper('''||vtabname||''') AND upper(column_name) = ''UPDATEDATE''' INTO vcount;
    if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE FUNCTION FUNC_'||substr(vtabname,1,26)||'UPD() RETURNS TRIGGER AS $$ BEGIN NEW.UPDATEDATE = now(); RETURN NEW; END; $$ language plpgsql';
      EXECUTE vsql;
      vsql := 'CREATE TRIGGER '||substr(vtabname,1,26)||'UPD BEFORE UPDATE ON '||vtabname||' FOR EACH ROW EXECUTE PROCEDURE  FUNC_'||substr(vtabname,1,26)||'UPD()';
      EXECUTE vsql;
   end if;
   return 0;
EXCEPTION 
   WHEN others THEN 
      verrmsg := sqlstate||' - Error : While creating trigger, '||sqlerrm;
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
      return 1;
  END;
$func_createupdatetrg$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION set_version( vschema varchar, from_version varchar, to_version varchar) RETURNS smallint AS $func_set_version$
DECLARE
   wk_message     varchar(500);
   verrmsg        varchar:='';
BEGIN
   EXECUTE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value='''||to_version||''' WHERE setting_type = ''RELEASE''';
   return 0;
EXCEPTION 
   WHEN others THEN 
      verrmsg := sqlstate||' - Error : While setting version from "'||from_version||'", '||sqlerrm;
      raise notice 'Error: % ',verrmsg;
      raise exception 'Error: % ',verrmsg;
      return 1;
END;
$func_set_version$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION get_version (vschema varchar) RETURNS varchar AS $func_get_version$
DECLARE
   cms_comps  integer;
   wk_release varchar:='';    
   ischema    text;
BEGIN
   EXECUTE 'EXECUTE get_inst_schema' INTO ischema;

   execute 'SELECT setting_value FROM '||vschema||'.SYSTEM_SETTINGS WHERE setting_type = ''RELEASE''' into wk_release;
   RETURN wk_release;
EXCEPTION
   WHEN OTHERS THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in func_get_version function : '')';
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
      RETURN wk_release;
END;
$func_get_version$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION createwfsdw (vschema varchar, db_version varchar) RETURNS integer AS $func_createwfsdw$
DECLARE
    vsql                  varchar;
    wk_message            varchar:= '';
    tmp_result            smallint;
    errcnt                smallint;
    idx_tbs    varchar:='ttv_wfsdw_index';
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;

/*
--------------------------------------------------------------------------------
            Create the Metadata database objects and data
--------------------------------------------------------------------------------
*/

    vsql :=  'CREATE TABLE '||vschema||'.SYSTEM_SETTINGS(
                        SETTING_TYPE       varchar(25),
                        SETTING_VALUE      varchar(1024),
                        CREATEDATE TIMESTAMP(6) DEFAULT (CURRENT_TIMESTAMP) NOT NULL)';
    SELECT CREATEOBJECT(vsql,'Unable to create table SYSTEM_SETTINGS') INTO tmp_result;   
  
    -- Create the MD_EVENTLOG table

    vsql :=  'CREATE TABLE '||vschema||'.MD_EVENTLOG (
      EVENTLOGID          numeric NOT NULL,
      PROCESSNAME         varchar(100) NOT NULL,
      SECTION             varchar(500) NULL,
      ERRORCODE           TEXT NOT NULL,
      ERRORMESSAGE        varchar(2000) NOT NULL,
      CREATEDATE          TIMESTAMP(6) NOT NULL,
      CONSTRAINT PK_MD_EVENTLOG PRIMARY KEY(EVENTLOGID) 
	  )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.MD_EVENTLOG') INTO tmp_result;  
    SELECT createseq(vschema,'MD_EVENTLOG',45) INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.MD_ETLPROCESSROLE (
      ETLPROCESSROLEKEY   numeric NOT NULL,
      DESCRIPTION         varchar(50) NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_ETLPROCESSROLE PRIMARY KEY(ETLPROCESSROLEKEY)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESSROLE') INTO tmp_result;   
  
    vsql :=  'CREATE TABLE '||vschema||'.MD_ETLPROCESSSTATUS (
      ETLPROCESSSTATUSKEY numeric NOT NULL,
      DESCRIPTION         varchar(30) NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_ETLPROCESSSTATUS PRIMARY KEY(ETLPROCESSSTATUSKEY)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   

    vsql :=  'CREATE TABLE '||vschema||'.MD_ETLPROCESSTYPE (
      ETLPROCESSTYPEKEY   numeric NOT NULL,
      DESCRIPTION         varchar(50) NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_ETLPROCESSTYPE PRIMARY KEY(ETLPROCESSTYPEKEY)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
    
    vsql :=  'CREATE TABLE '||vschema||'.MD_LOCKABLEOBJECTSTATUS (
      LOCKABLEOBJECTSTATUSKEY     numeric NOT NULL,
      DESCRIPTION                 varchar(30) NOT NULL,
      CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_LOCKABLEOBJECTSTATUS PRIMARY KEY(LOCKABLEOBJECTSTATUSKEY)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
  
    vsql :=  'CREATE TABLE '||vschema||'.MD_LOCKABLEOBJECTTYPE (
      LOCKABLEOBJECTTYPEKEY       numeric NOT NULL,
      DESCRIPTION                 varchar(50) NOT NULL,
      CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_LOCKABLEOBJECTTYPE PRIMARY KEY(LOCKABLEOBJECTTYPEKEY)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   

    vsql :=  'CREATE TABLE '||vschema||'.MD_LOCKABLEOBJECT (
      LOCKABLEOBJECTKEY   numeric NOT NULL,
      LOCKABLEOBJECTTYPE  numeric NOT NULL,
      NAME                varchar(50) NOT NULL,
      DESCRIPTION         varchar(100) NOT NULL,
      LASTOBJECTSTATUS    numeric NULL,
      LASTSYNCDATE        TIMESTAMP(6) DEFAULT to_date(''1974/10/12'', ''yyyy/mm/dd'') NULL,
      LASTETLPROCESS      numeric NULL,
      LASTRUNINSTANCE     numeric NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_LOCKABLEOBJECT PRIMARY KEY(LOCKABLEOBJECTKEY)
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
    
    vsql :=  'CREATE TABLE '||vschema||'.MD_ETLPROCESS (
      ETLPROCESSKEY               numeric NOT NULL,
      NAME                        varchar(50) NOT NULL,
      DESCRIPTION                 varchar(100) NULL,
      ETLPROCESSTYPE              numeric NOT NULL,
      ETLPROCESSROLE              numeric NOT NULL,
      LOCKABLEOBJECTLOADED        numeric NULL,
      SENDEMAILONSUCCESS          numeric(1,0) DEFAULT 0 NOT NULL,
      SENDEMAILONERROR            numeric(1,0) DEFAULT 0 NOT NULL,
      EMAILRECIPIENTS             varchar(255) NULL,
      CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      CONSTRAINT PK_MD_ETLPROCESS PRIMARY KEY(ETLPROCESSKEY)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
  
    vsql :=  'CREATE TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE (
      ETLPROCESS                  numeric NOT NULL,
      RUNINSTANCE                 numeric NOT NULL,
      PARENTETLPROCESS            numeric NULL,
      PARENTRUNINSTANCE           numeric NULL,
      STATUS                      numeric NOT NULL,
      COMMENTS                    varchar(500) NULL,
      LOCKABLEOBJECTLOADED        numeric NULL,
      LOCKABLEOBJECTSTATUS        numeric NULL,
      PREVIOUSSYNCDATE            TIMESTAMP(6) NULL,
      NEWSYNCDATE                 TIMESTAMP(6) NULL,
      AFFECTEDROWS                numeric(19,0) NULL,
      SYSERRORCODE                TEXT NULL,
      DBPROCESSID                 numeric NULL,
      STARTDATE                   TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      ENDDATE                     TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      CONSTRAINT PK_MD_ETLPROCESSRUNINSTANCE PRIMARY KEY(ETLPROCESS,RUNINSTANCE)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   

    -- MESSAGENUMBER column name is with NUMBER, also this column is used in Primary key.
    vsql :=  'CREATE TABLE '||vschema||'.MD_ETLPROCESSMESSAGE (
      ETLPROCESS          numeric NOT NULL,
      RUNINSTANCE         numeric NOT NULL,
      MESSAGENUMBER       numeric NOT NULL,
      MESSAGETYPE         varchar(5) NOT NULL,
      MESSAGE             varchar(4000) NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      CONSTRAINT PK_MD_ETLPROCESSMESSAGE PRIMARY KEY(ETLPROCESS,RUNINSTANCE,MESSAGENUMBER)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
    
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSSTATUS(ETLPROCESSSTATUSKEY, DESCRIPTION, CREATEDATE) VALUES(0, ''Finished OK'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSSTATUS(ETLPROCESSSTATUSKEY, DESCRIPTION, CREATEDATE) VALUES(1, ''Running'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
    
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSSTATUS(ETLPROCESSSTATUSKEY, DESCRIPTION, CREATEDATE) VALUES(2, ''FAILED!'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
	
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSTYPE(ETLPROCESSTYPEKEY, DESCRIPTION, CREATEDATE) VALUES(1, ''Stored Procedure'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   
    
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSROLE(ETLPROCESSROLEKEY, DESCRIPTION, CREATEDATE) VALUES(1, ''Loads ODS table'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSROLE(ETLPROCESSROLEKEY, DESCRIPTION, CREATEDATE) VALUES(2, ''Loads Fact table'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSROLE(ETLPROCESSROLEKEY, DESCRIPTION, CREATEDATE) VALUES(3, ''Loads Dimension table'', now()::timestamp )';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSROLE(ETLPROCESSROLEKEY, DESCRIPTION, CREATEDATE) VALUES(8, ''Auxiliary / Miscellaneous'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTSTATUS(LOCKABLEOBJECTSTATUSKEY, DESCRIPTION, CREATEDATE) VALUES(1, ''Loading'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTSTATUS(LOCKABLEOBJECTSTATUSKEY, DESCRIPTION, CREATEDATE) VALUES(0, ''Loaded OK'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTSTATUS(LOCKABLEOBJECTSTATUSKEY, DESCRIPTION, CREATEDATE) VALUES(2, ''FAILED!'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTTYPE(LOCKABLEOBJECTTYPEKEY, DESCRIPTION, CREATEDATE) VALUES(2, ''Fact Table'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;
	
    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTTYPE(LOCKABLEOBJECTTYPEKEY, DESCRIPTION, CREATEDATE) VALUES(3, ''Dimension Table'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTTYPE(LOCKABLEOBJECTTYPEKEY, DESCRIPTION, CREATEDATE) VALUES(4, ''Aggregate Table'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result; 

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTTYPE(LOCKABLEOBJECTTYPEKEY, DESCRIPTION, CREATEDATE) VALUES(5, ''MD Table / Virtual lock'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result; 

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECTTYPE(LOCKABLEOBJECTTYPEKEY, DESCRIPTION, CREATEDATE) VALUES(1, ''ODS Table'', now()::timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table ') INTO tmp_result;   

    -- Insert MD_ETLPROCESS Reference Data
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(4, ''spSYNC_ResourceGroup'', ''Resource SYNC Process Group'', 1, 3, 4, 0, 0, NULL,
        TO_DATE(''2006-09-30 03:48:14'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-09-30 03:48:14'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;
	
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
      LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(5, ''spSYNC_ProcessDefinition'', ''Process Definition (Template)'', 1, 3, 5, 0, 0, NULL,
        TO_DATE(''2006-10-02 16:07:29'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-02 23:12:59'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(1, ''spSYNC_WorkOrderStatus'', ''WorkOrderStatus SYNC Process'', 1, 3, 1, 0, 1, ''~TLADatabase@tandbergtv.com'',
        TO_DATE(''2006-08-22 16:51:54'',''YYYY-MM-DDHH24:MI:SS''), TO_DATE(''2006-08-22 16:51:54'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(999999, ''Zero Load - Manual processes'',
        ''Used to cover FK on LockableObject and dims to initialize objects that have never been loaded before'', 1, 8,
        NULL, 0, 0, NULL, TO_DATE(''2006-09-11 22:36:12'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-09-11 22:36:12'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(6, ''spSYNC_Node'', ''Node SYNC Process'', 1, 3, 6, 0, 0, NULL, TO_DATE(''2006-10-03 18:38:28'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-03 18:38:28'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(9, ''spSYNC_VariableInstance'', ''Variable Instance SYNC Process'', 1, 3, 9, 0, 0, '' '',
        TO_DATE(''2006-10-05 23:47:26'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-05 23:47:26'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(3, ''spSYNC_Resource'', ''Resource SYNC Process'', 1, 3, 3, 0, 0, NULL,
        TO_DATE(''2006-09-29 12:21:14'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-09-29 12:21:14'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(7, ''spSYNC_WorkOrder'', ''WorkOrder SYNC Process'', 1, 3, 7, 0, 0, NULL,
        TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(10, ''spSYNC_Log'', ''Log SYNC Process'', 1, 3, 10, 0, 0, NULL, TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(11, ''spSYNC_MonitoredDrive'', ''MonitoredDrive SYNC Process'', 1, 3, 11, 0, 0, NULL,
        TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS, SENDEMAILONERROR,EMAILRECIPIENTS, CREATEDATE, UPDATEDATE)
      VALUES(12, ''spSYNC_MonitoredDriveHistory'', ''MonitoredDriveHistory SYNC Process'', 1, 3, 12, 0, 0, NULL,
        TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-04 18:47:15'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(200, ''spAGG_FactWorkOrderDay'', ''Aggregation of WorkOrder Fact Data to the Day'', 1, 8, 13, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(201, ''spAGG_FactWorkOrderMonth'', ''Aggregation of WorkOrder Fact Data to the Month'', 1, 8, 14, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(205, ''spAGG_FactResourceQueueDay'', ''Aggregation of Log Queue Fact Data to the Day'', 1, 8, 15, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(206, ''spAGG_FactResourceQueueMonth'', ''Aggregation of Log Queue Fact Data to the Month'', 1, 8, 16, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(210, ''spAGG_FactResourceTaskDay'', ''Aggregation of Log Task Fact Data to the Day'', 1, 8, 17, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(211, ''spAGG_FactResourceTaskMonth'', ''Aggregation of Log Task Fact Data to the Month'', 1, 8, 18, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table MD_ETLPROCESS data') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(215, ''spAGG_FactMDHistoryDay'', ''Aggregation of MDHisotryDetail Fact Data to the Day'', 1, 8, 19, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY, NAME, DESCRIPTION, ETLPROCESSTYPE, ETLPROCESSROLE,
        LOCKABLEOBJECTLOADED, SENDEMAILONSUCCESS,SENDEMAILONERROR, CREATEDATE, UPDATEDATE)
      VALUES(216, ''spAGG_FactMDHistoryMonth'', ''Aggregation of MDHistoryDetail Fact Data to the Month'', 1, 8, 20, 0, 0, current_timestamp, current_timestamp)';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;
	
    -- Insert MD_ETLPROCESSRUNINSTANCE Reference Data
    vsql :=  'INSERT INTO '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE, PARENTETLPROCESS, PARENTRUNINSTANCE, STATUS, COMMENTS, 
	          LOCKABLEOBJECTLOADED, LOCKABLEOBJECTSTATUS, PREVIOUSSYNCDATE, NEWSYNCDATE, AFFECTEDROWS, SYSERRORCODE, DBPROCESSID,STARTDATE, ENDDATE)
      VALUES(999999, 1, NULL, NULL, 0, ''SEED - ZERO LOAD / INITIAL LOAD'', NULL, NULL, NULL, NULL, NULL, NULL, NULL,
        TO_DATE(''2006-09-11 22:41:12'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-09-11 22:41:12'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESSRUNINSTANCE') INTO tmp_result; 

    --  Insert MD_LOCKABLEOBJECT Reference Data
    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(4, 3, ''DIM_ResourceGroup'', ''Resource Group Dimension'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1,
        TO_DATE(''2006-09-29 03:48:14'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-03 19:50:45'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;
	
    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(5, 3, ''DIM_Template'', ''Template Dimension'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2006-10-02 23:09:16'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-06 18:14:13'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(6, 3, ''DIM_Node'', ''Node Dimension'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2006-10-03 18:37:12'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-06 18:20:55'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(1, 3, ''DIM_WorkOrderStatus'', ''Work Order Status Dimension'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1,
        TO_DATE(''2006-08-23 20:04:16'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-09-28 23:28:37'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(9, 3, ''FACT_VariableInstance'', ''Variable Instance Facts'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1,
        TO_DATE(''2006-10-05 23:45:45'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-06 18:26:50'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(3, 3, ''DIM_Resource'', ''Resource Dimension'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2006-09-29 12:21:14'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-04 19:29:12'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(7, 2, ''FACT_WorkOrder'', ''Work Order Facts'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2006-10-04 18:45:17'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-06 18:22:56'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(10, 2, ''FACT_Log'', ''Log Facts'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2006-10-04 18:45:17'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-06 18:22:56'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(11, 3, ''DIM_Monitoreddrive'', ''Monitoreddrive Dimension'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2006-09-29 12:21:14'',''YYYY-MM-DD HH24:MI:SS''),
        TO_DATE(''2006-10-04 19:29:12'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION, LASTOBJECTSTATUS,
        LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
      VALUES(12, 2, ''FACT_MonitoredDriveHistory'', ''MonitoredDriveHistory Facts'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1,
        TO_DATE(''2006-10-04 18:45:17'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2006-10-06 18:22:56'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(13, 4, ''FACT_WorkOrderDay'', ''Aggregated WorkOrders by Day'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(14, 4, ''FACT_WorkOrderMonth'', ''Aggregated WorkOrders by Month'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(15, 4, ''FACT_ResourceQueueDay'', ''Aggregated Log Queue Durations by Day'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(16, 4, ''FACT_ResourceQueueMonth'', ''Aggregated Log Queue Durations by Month'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(17, 4, ''FACT_ResourceTaskDay'', ''Aggregated Log Task Durations by Day'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(18, 4, ''FACT_ResourceTaskMonth'', ''Aggregated Log Task Durations by Month'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(19, 4, ''FACT_MDHistoryDay'', ''Aggregated Used Drive Space by Day'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

    vsql :=  'INSERT INTO '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY, LOCKABLEOBJECTTYPE, NAME, DESCRIPTION,
        LASTOBJECTSTATUS, LASTSYNCDATE, LASTETLPROCESS, LASTRUNINSTANCE,CREATEDATE,UPDATEDATE)
      VALUES(20, 4, ''FACT_MDHistoryMonth'', ''Aggregated Used Drive Space by Month'', 0, TO_DATE(''2000-01-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), 999999, 1, TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''), TO_DATE(''2007-03-01 00:00:00'',''YYYY-MM-DD HH24:MI:SS''))';
    SELECT CREATEOBJECT(vsql,'Unable to create table data MD_ETLPROCESS') INTO tmp_result;

	
    -- Create CK_MD_ETLPROCESSMESSAGE check constraint
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSMESSAGE
      ADD CONSTRAINT CK_MD_ETLPROCESSMESSAGE
        CHECK (MessageType  = ''INFO''
              OR MessageType  = ''ERROR'')
        NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSMESSAGE to ADD CONSTRAINT CK_MD_ETLPROCESSMESSAGE') INTO tmp_result;
	
    -- Create FK_MD_ETLPROCESSMESSAGE_INST foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSMESSAGE
      ADD   CONSTRAINT FK_MD_ETLPROCESSMESSAGE_INST
            FOREIGN KEY(ETLPROCESS, RUNINSTANCE)
            REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE)
            ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSMESSAGE to ADD CONSTRAINT FK_MD_ETLPROCESSMESSAGE_INST') INTO tmp_result;
	
    -- Create FK_MD_LOCKABLEOBJECT_OBJTYP foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_LOCKABLEOBJECT
      ADD  CONSTRAINT FK_MD_LOCKABLEOBJECT_OBJTYP
            FOREIGN KEY(LOCKABLEOBJECTTYPE)
            REFERENCES '||vschema||'.MD_LOCKABLEOBJECTTYPE(LOCKABLEOBJECTTYPEKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_LOCKABLEOBJECT to ADD CONSTRAINT FK_MD_LOCKABLEOBJECT_OBJTYP') INTO tmp_result;

    -- Create FK_MD_LOCKABLEOBJECT_OBJST foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_LOCKABLEOBJECT
      ADD   CONSTRAINT FK_MD_LOCKABLEOBJECT_OBJST
            FOREIGN KEY(LASTOBJECTSTATUS)
            REFERENCES '||vschema||'.MD_LOCKABLEOBJECTSTATUS(LOCKABLEOBJECTSTATUSKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_LOCKABLEOBJECT to ADD CONSTRAINT FK_MD_LOCKABLEOBJECT_OBJST') INTO tmp_result;

    -- Create FK_MD_LOCKABLEOBJECT_INST
    vsql :=  'ALTER TABLE '||vschema||'.MD_LOCKABLEOBJECT
      ADD   CONSTRAINT FK_MD_LOCKABLEOBJECT_INST
            FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
            REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_LOCKABLEOBJECT to ADD CONSTRAINT FK_MD_LOCKABLEOBJECT_INST') INTO tmp_result;

    -- Create FK_MD_ETLPROCESS_TYPE foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESS
      ADD   CONSTRAINT FK_MD_ETLPROCESS_TYPE
            FOREIGN KEY(ETLPROCESSTYPE)
            REFERENCES '||vschema||'.MD_ETLPROCESSTYPE(ETLPROCESSTYPEKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESS to ADD CONSTRAINT FK_MD_ETLPROCESS_TYPE') INTO tmp_result;

    -- Create FK_MD_ETLPROCESS_ROLE
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESS
      ADD   CONSTRAINT FK_MD_ETLPROCESS_ROLE
            FOREIGN KEY(ETLPROCESSROLE)
            REFERENCES '||vschema||'.MD_ETLPROCESSROLE(ETLPROCESSROLEKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESS to ADD CONSTRAINT FK_MD_ETLPROCESS_ROLE') INTO tmp_result;

    -- Create FK_MD_ETLPROCESS_OBJECT foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESS
      ADD   CONSTRAINT FK_MD_ETLPROCESS_OBJECT
            FOREIGN KEY(LOCKABLEOBJECTLOADED)
            REFERENCES '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESS to ADD CONSTRAINT FK_MD_ETLPROCESS_OBJECT') INTO tmp_result;

    -- Create CK_MD_RUNINSTANCE check constraint
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE
      ADD   CONSTRAINT CK_MD_RUNINSTANCE
            CHECK (RunInstance > 0)
            NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE to ADD CONSTRAINT CK_MD_RUNINSTANCE') INTO tmp_result;

    -- Create FK_MD_RUNINSTANCE_STATUS foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE
      ADD   CONSTRAINT FK_MD_RUNINSTANCE_STATUS
            FOREIGN KEY(STATUS)
            REFERENCES '||vschema||'.MD_ETLPROCESSSTATUS(ETLPROCESSSTATUSKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE to ADD CONSTRAINT FK_MD_RUNINSTANCE_STATUS') INTO tmp_result;

    -- Create FK_MD_RUNINSTANCE_PROC foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE
      ADD   CONSTRAINT FK_MD_RUNINSTANCE_PROC
            FOREIGN KEY(ETLPROCESS)
            REFERENCES '||vschema||'.MD_ETLPROCESS(ETLPROCESSKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE to ADD CONSTRAINT FK_MD_RUNINSTANCE_PROC') INTO tmp_result;

    -- Create FK_MD_ETLPROCESSRUNINSTANCE_PARENT foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE
                        ADD CONSTRAINT FK_MD_RUNINSTANCE_PARENT
                        FOREIGN KEY(PARENTETLPROCESS, PARENTRUNINSTANCE)
                        REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE)
                        ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE to ADD CONSTRAINT FK_MD_RUNINSTANCE_PARENT') INTO tmp_result;

    -- Create FK_MD_RUNINSTANCE_OBJECTST foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE
      ADD   CONSTRAINT FK_MD_RUNINSTANCE_OBJECTST
            FOREIGN KEY(LOCKABLEOBJECTSTATUS)
            REFERENCES '||vschema||'.MD_LOCKABLEOBJECTSTATUS(LOCKABLEOBJECTSTATUSKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE to ADD CONSTRAINT FK_MD_RUNINSTANCE_OBJECTST') INTO tmp_result;

    -- Create FK_MD_RUNINSTANCE_OBJECT foreign key
    vsql :=  'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE
      ADD   CONSTRAINT FK_MD_RUNINSTANCE_OBJECT
            FOREIGN KEY(LOCKABLEOBJECTLOADED)
            REFERENCES '||vschema||'.MD_LOCKABLEOBJECT(LOCKABLEOBJECTKEY)
            ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE to ADD CONSTRAINT FK_MD_RUNINSTANCE_OBJECT') INTO tmp_result;

/*
--------------------------------------------------------------------------------
                        Create Staging Tables
--------------------------------------------------------------------------------
*/
			
    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_LOG (
      ROWID_              numeric NOT NULL,
      LOGID               numeric NOT NULL,
      LOGCLASS            CHAR(1) NULL,
      LOGCLASSNAME        varchar(10) NULL,
      LOCALDATE           TIMESTAMP(6) NULL,
      TEMPLATEWK          numeric NULL,
      PROCESSDEFINITIONID numeric NULL,
      WORKORDERWK         numeric NULL,
      PROCESSINSTANCEID   numeric NULL,
      NODEWK              numeric NULL,
      NODEID              numeric NULL,
      LOCALENTERDATE      TIMESTAMP(6) NULL,
      LOCALENTERDATEWK    numeric NULL,
      LOCALENTERTIMEWK    numeric NULL,
      LOCALLEAVEDATE      TIMESTAMP(6) NULL,
      LOCALLEAVEDATEWK    numeric NULL,
      LOCALLEAVETIMEWK    numeric NULL,
      DURATION            numeric NULL,
      RESOURCEGROUPWK     numeric NULL,
      RESOURCEGROUPID     numeric NULL,
      RESOURCEWK          numeric NULL,
      RESOURCEID          numeric NULL,
      ADMINSTATUSID       numeric NULL,
      ADMINSTATUSWK       numeric NULL,
      OPERSTATUSID        numeric NULL,
      OPERSTATUSWK        numeric NULL,
      INSERTOK            numeric DEFAULT 0 NULL,
      WFSCREATEDATE       TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NULL,
      DIFFETLPROCESS      numeric NULL,
      DIFFRUNINSTANCE     numeric NULL,
      DIFFDATE            TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_)
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_LOG') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_LOG', 1, 100) INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_LOG ADD CONSTRAINT FK_S_LOG_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_LOG ADD CONSTRAINT FK_S_LOG_RUNINST ') INTO tmp_result;   

	vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_MONITOREDDRIVE (
      ROWID_                      numeric NOT NULL,
      MONITOREDDRIVEID            numeric NULL,
      NAME_                       varchar(500) NULL,
      DESCRIPTION                 varchar(500) NULL,
      PATH_                       varchar(1000) NULL,
      RESOURCEWK                  numeric NULL,
      RESOURCEID                  numeric NULL,
      INTERNALDRIVEID             numeric NULL,
      TOTALCAPACITY               numeric(19,0) NULL,
      WARNINGTHRESHOLDPERCENT     numeric NULL,
      ERRORTHRESHOLDPERCENT       numeric NULL,
      CURRENTDRIVESTATUSID        numeric NULL,
      CURRENTDRIVESTATUSNAME      varchar(50) NULL,
      LASTSAMPLEDATETIME          TIMESTAMP(6) NULL,
      INSERTOK                    numeric DEFAULT 0 NULL,
      WFSCREATEDATE               TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE          TIMESTAMP(6) NULL,
      DIFFETLPROCESS              numeric NULL,
      DIFFRUNINSTANCE             numeric NULL,
      DIFFDATE                    TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_)
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_MONITOREDDRIVE') INTO tmp_result; 
    SELECT createseq(vschema,'STG1_DIFF_MONITOREDDRIVE', 1, 20) INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_MONITOREDDRIVE ADD CONSTRAINT FK_S_MONITOREDDRIVE_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_MONITOREDDRIVE ADD CONSTRAINT FK_S_MONITOREDDRIVE_RUNINST') INTO tmp_result;

	vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_DRIVEHISTORY (
      ROWID_                      numeric NOT NULL,
      MONITOREDDRIVEHISTORYID     numeric NULL,
      MONITOREDDRIVEWK            numeric NULL,
      MONITOREDDRIVEID            numeric NULL,
      CURRENTBYTESUSED            numeric(19,0) NULL,
      TOTALCAPACITY               numeric(19,0) NULL,
      WARNINGTHRESHOLDPERCENT     numeric NULL,
      ERRORTHRESHOLDPERCENT       numeric NULL,
      CURRENTDRIVESTATUSID        numeric NULL,
      CURRENTDRIVESTATUSNAME      varchar(50) NULL,
      SAMPLEDATETIME              TIMESTAMP(6) NULL,
      INSERTOK                    numeric DEFAULT 0 NULL,
      WFSCREATEDATE               TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE          TIMESTAMP(6) NULL,
      DIFFETLPROCESS              numeric NULL,
      DIFFRUNINSTANCE             numeric NULL,
      DIFFDATE                    TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_)
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_DRIVEHISTORY') INTO tmp_result;   

	vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_DRIVEHISTORY ADD CONSTRAINT FK_S_DRIVEHISTORY_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_DRIVEHISTORY ADD CONSTRAINT FK_S_DRIVEHISTORY_RUNINST') INTO tmp_result; 

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_NODE (
      ROWID_              numeric NOT NULL,
      NODEID              numeric NULL,
      NODECLASS           varchar(50) NULL,
      NAME                varchar(255) NULL,
      TEMPLATEWK          numeric NULL,
      PROCESSDEFINITIONID numeric NULL,
      NODEINDEX           numeric NULL,
      TASKID              numeric NULL,
      TASKNAME            varchar(255) NULL,
      ISSTARTNODE         numeric NULL,
      RESOURCEGROUPWK     numeric NULL,
      RESOURCEGROUPID     numeric NULL,
      TASKCONTROLLERID    numeric NULL,
      INSERTOK            numeric DEFAULT 0 NULL,
      WFSCREATEDATE       TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NULL,
      DIFFETLPROCESS      numeric NULL,
      DIFFRUNINSTANCE     numeric NULL,
      DIFFDATE            TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_NODE') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_NODE', 1, 20) INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_NODE ADD CONSTRAINT FK_S_NODE_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_NODE to ADD CONSTRAINT FK_S_NODE_RUNINST') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_RESOURCE (
      ROWID_              numeric NOT NULL,
      RESOURCEID          numeric NULL,
      RESOURCENAME        varchar(50) NULL,
      RESOURCETYPEID      numeric NULL,
      RESOURCETYPENAME    varchar(50) NULL,
      ISACTIVE            numeric NULL,
      INSERTOK            numeric DEFAULT 0 NULL,
      WFSCREATEDATE       TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NULL,
      DIFFETLPROCESS      numeric NULL,
      DIFFRUNINSTANCE     numeric NULL,
      DIFFDATE            TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_)
        )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_RESOURCE') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_RESOURCE', 1, 20) INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_RESOURCE ADD CONSTRAINT FK_S_RES_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_RESOURCE to ADD CONSTRAINT FK_S_RES_RUNINST') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_RESOURCEGROUP (
      ROWID_              numeric NOT NULL,
      RESOURCEGROUPID     numeric NULL,
      RESOURCEGROUPNAME   varchar(50) NULL,
      RESOURCETYPEID      numeric NULL,
      RESOURCETYPENAME    varchar(50) NULL,
      ACCESSLEVELID       numeric NULL,
      ACCESSLEVELNAME     varchar(50) NULL,
      INSERTOK            numeric DEFAULT 0 NULL,
      WFSCREATEDATE       TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NULL,
      DIFFETLPROCESS      numeric NULL,
      DIFFRUNINSTANCE     numeric NULL,
      DIFFDATE            TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_RESOURCEGROUP') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_RESOURCEGROUP', 1, 20) INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_RESOURCEGROUP ADD CONSTRAINT FK_S_RESGRP_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_RESOURCEGROUP to ADD CONSTRAINT FK_S_RESGRP_RUNINST') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_TEMPLATE (
      ROWID_                      numeric NOT NULL,
      PROCESSDEFINITIONID         numeric NULL,
      NAME                        varchar(400) NULL,
      PROCESSDEFINITIONTYPEID     numeric NULL,
      PROCESSDEFINITIONTYPENAME   varchar(50) NULL,
      STARTNODEID                 numeric NULL,
      WFSCREATEDATE               TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE          TIMESTAMP(6) NULL,
      DIFFETLPROCESS              numeric NULL,
      DIFFRUNINSTANCE             numeric NULL,
      DIFFDATE                    TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_) 
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_TEMPLATE') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_TEMPLATE', 1, 20) INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_TEMPLATE ADD CONSTRAINT FK_S_TEMPLATE_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_TEMPLATE ADD CONSTRAINT FK_S_TEMPLATE_RUNINST') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_VARIABLEINSTANCE (
      ROWID_                      numeric NOT NULL,
      VARIABLEINSTANCENAME        varchar(255) NULL,
      VARIABLEINSTANCEVALUE       varchar(255) NULL,
      INSERTOK                    numeric DEFAULT 0 NULL,
      WFSCREATEDATE               TIMESTAMP(6) NULL,
      DIFFETLPROCESS              numeric NULL,
      DIFFRUNINSTANCE             numeric NULL,
      DIFFDATE                    TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_VARIABLEINSTANCE') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_VARIABLEINSTANCE', 1, 20) INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_VARIABLEINSTANCE ADD CONSTRAINT FK_S_VARIABLEINSTANCE_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_VARIABLEINSTANCE ADD CONSTRAINT FK_S_VARIABLEINSTANCE_RUNINST') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_WORKORDER (
      ROWID_                      numeric NOT NULL,
      PROCESSINSTANCEID           numeric NULL,
      LOCALSTARTDATE              TIMESTAMP(6) NOT NULL,
      LOCALSTARTDATEWK            numeric(8) NULL,
      LOCALSTARTTIMEWK            numeric(6) NULL,
      LOCALENDDATE                TIMESTAMP(6) NULL,
      ISSUSPENDED                 numeric NULL,
      PROCESSDEFINITIONID         numeric NOT NULL,
      TEMPLATEWK                  numeric NULL,
      PROVIDERWK                  numeric NULL,
      ADMINSTATUSID               numeric NULL,
      ADMINSTATUSWK               numeric NULL,
      OPERSTATUSID                numeric NULL,
      OPERSTATUSWK                numeric NULL,
      PRIORITYID                  numeric NULL,
      PRIORITY                    varchar(50) NULL,
      PROVIDERNAME                varchar(255) NULL,
      PACKAGEASSETID              varchar(255) NULL,
      TITLE                       varchar(255) NULL,
      BRIEFTITLE                  varchar(255) NULL,
      ASSETID                     varchar(255) NULL,
      OBJECTTYPE                  varchar(255) NULL,
      HOUSEMATERIALID             varchar(255) NULL,
      BROADCASTMATERIALID         varchar(255) NULL,
      LICENSESTART                varchar(255) NULL,
      LICENSEEND                  varchar(255) NULL,
      LICENSESTARTDATE            DATE,
      LICENSEENDDATE              DATE,
      DWPROCESSCOMPLETE           numeric(1,0) DEFAULT (0) NULL,
      DWPROCESSERROR              numeric(1,0) DEFAULT (0) NULL,
      DWPROCESSMESSAGE            varchar(500) NULL,
      INSERTOK                    numeric DEFAULT 0 NULL,
      WFSCREATEDATE               TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE          TIMESTAMP(6) NULL,
      DIFFETLPROCESS              numeric NULL,
      DIFFRUNINSTANCE             numeric NULL,
      DIFFDATE                    TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_WORKORDER') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_WORKORDER', 1, 20) INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_WORKORDER ADD CONSTRAINT FK_S_WORKORDER_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_WORKORDER to ADD CONSTRAINT FK_S_WORKORDER_RUNINST') INTO tmp_result;

	vsql := 'CREATE INDEX idx_stg_diff_wo_woid ON '||vschema||'.STG1_DIFF_WORKORDER(PROCESSINSTANCEID)';
	SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_stg_diff_wo_pii ON '||vschema||'.STG1_DIFF_WORKORDER(PROCESSINSTANCEID)') INTO tmp_result;
	
    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_WORKORDERSTATUS (
      ROWID_              numeric NOT NULL,
      PROCESSSTATUSID     numeric NULL,
      NAME                varchar(50) NULL,
      WFSCREATEDATE       TIMESTAMP(6) NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NULL,
      DIFFETLPROCESS      numeric NULL,
      DIFFRUNINSTANCE     numeric NULL,
      DIFFDATE            TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_) 
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_WORKORDERSTATUS') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_WORKORDERSTATUS', 1, 20) INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_WORKORDERSTATUS ADD CONSTRAINT FK_S_WOSTAT_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_WORKORDERSTATUS ADD CONSTRAINT FK_S_WOSTAT_RUNINST') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.STG1_DIFF_MDRIVEHISTORY (
      ROWID_                              numeric          NOT NULL,
      MONITOREDDRIVEHISTORYID             numeric          NULL,
      MONITOREDDRIVEID                    numeric          NULL,
      MONITOREDDRIVEWK                    numeric          NULL,
      CURRENTDRIVENAME                    varchar(1500)  NULL,
      CURRENTDESCRIPTION                  varchar(150)   NULL,
      CURRENTPATH                         varchar(3000)  NULL,
      CURRENTINTERNALDRIVEID              numeric          NULL,
      CURRENTTOTALCAPACITY                numeric          NULL,
      CURRENTWARNINGTHRESHOLDPERCENT      numeric          NULL,
      CURRENTERRORTHRESHOLDPERCENT        numeric          NULL,
      CURRENTBYTESUSED                    numeric          NULL,
      CURRENTDRIVESTATUSID                numeric          NULL,
      MONITOREDDRIVESTATUSWK              numeric          NULL,
      CURRENTDRIVESTATUSNAME              varchar(25)    NULL,
      SAMPLEDATETIME                      TIMESTAMP(6)    NULL,
      LOCALDATEWK                         numeric          NULL,
      LOCALTIMEWK                         numeric          NULL,
      WFSCREATEDATE                       TIMESTAMP(6)    NULL,
      LASTPRODUPDATEDATE                  TIMESTAMP(6)    NULL,
      DIFFETLPROCESS                      numeric          NULL,
      DIFFRUNINSTANCE                     numeric          NULL,
      DIFFDATE                            TIMESTAMP(6) DEFAULT (current_timestamp) NULL,
      PRIMARY KEY(ROWID_) 
      )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.STG1_DIFF_MDRIVEHISTORY') INTO tmp_result;
    SELECT createseq(vschema,'STG1_DIFF_MDRIVEHISTORY', 1, 100) INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.STG1_DIFF_MDRIVEHISTORY ADD CONSTRAINT FK_S_MDHISTORY_RUNINST FOREIGN KEY(DIFFETLPROCESS, DIFFRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.STG1_DIFF_MDRIVEHISTORY ADD CONSTRAINT FK_S_MDHISTORY_RUNINST') INTO tmp_result;

/*
--------------------------------------------------------------------------------
                         Create Dimension Tables
--------------------------------------------------------------------------------
*/
    vsql :=  'CREATE TABLE '||vschema||'.DIM_DATE (
      DATEWK          numeric(8) NOT NULL,
      CALENDERDATE        DATE NOT NULL,
      DAYOFWEEKNAME  varchar(25) NOT NULL,
      DAYOFWEEKNUM    numeric(1) NOT NULL,
      DAYOFMONTH      numeric(2) NOT NULL,
      WEEKOFYEAR      numeric(2) NOT NULL,
      MONTHNAME       varchar(25) NOT NULL,
      MONTHNUM        numeric(2) NOT NULL,
      QUARTER         numeric(1) NOT NULL,
      YEARNUM         numeric(4) NOT NULL,
      CREATEDATE      TIMESTAMP(6) NOT NULL,
      PRIMARY KEY(DATEWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_DATE') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_MONTH (
      MONTHWK          numeric(8) NOT NULL,
      MONTHNAME       varchar(25) NOT NULL,
      MONTHNUM        numeric(2) NOT NULL,
      QUARTER         numeric(1) NOT NULL,
      YEARNUM         numeric(4) NOT NULL,
      CREATEDATE      TIMESTAMP(6) NOT NULL,
      PRIMARY KEY(MONTHWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_MONTH') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_TIME (
      TIMEWK                  numeric(6) NOT NULL,
      TIMEOFDAY               TIMESTAMP NOT NULL,
      STANDARDDISPLAY         varchar(25) NOT NULL,
      MILITARYDISPLAY         varchar(25) NOT NULL,
      STANDARDHOUR            numeric(2) NOT NULL,
      MILITARYHOUR            numeric(2) NOT NULL,
      MERIDIAN                varchar(2) NOT NULL,
      MINUTES                 numeric(2) NOT NULL,
      MINUTESAFTERMIDNIGHT    numeric(4) NOT NULL,
      SECONDS                 numeric(4) NOT NULL,
      SECONDSINHOUR           numeric(4) NOT NULL,
      SECONDSAFTERMIDNIGHT    numeric(5) NOT NULL,
      CREATEDATE              TIMESTAMP(6) NOT NULL,
      PRIMARY KEY(TIMEWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_TIME') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_TEMPLATE (
      TEMPLATEWK                  numeric NOT NULL,
      PROCESSDEFINITIONID         numeric NOT NULL,
      NAME                        varchar(400) NOT NULL,
      PROCESSDEFINITIONTYPEID     numeric NOT NULL,
      PROCESSDEFINITIONTYPENAME   varchar(50) NOT NULL,
      STARTNODEID                 numeric NULL,
      WFSCREATEDATE               TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE          TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS              numeric NOT NULL,
      LASTRUNINSTANCE             numeric NOT NULL,
      CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(TEMPLATEWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_TEMPLATE') INTO tmp_result;
    SELECT createseq(vschema,'DIM_TEMPLATE') INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.DIM_TEMPLATE ADD CONSTRAINT FK_D_TEMPLATE_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_TEMPLATE ADD CONSTRAINT FK_D_TEMPLATE_RUNINST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_DIM_TEMPLATE_ID ON '||vschema||'.DIM_TEMPLATE(PROCESSDEFINITIONID)  ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_TEMPLATE_ID ON '||vschema||'.DIM_TEMPLATE(PROCESSDEFINITIONID)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_MONITOREDDRIVESTATUS (
      MONITOREDDRIVESTATUSWK   numeric NOT NULL,
      DRIVESTATUSID     numeric NOT NULL,
      NAME                varchar(50) NOT NULL,
      WFSCREATEDATE       TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS      numeric NOT NULL,
      LASTRUNINSTANCE     numeric NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(MONITOREDDRIVESTATUSWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_MONITOREDDRIVESTATUS') INTO tmp_result;
    SELECT createseq(vschema,'DIM_MONITOREDDRIVESTATUS') INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.DIM_MONITOREDDRIVESTATUS ADD CONSTRAINT FK_D_MDSTAT_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_MONITOREDDRIVESTATUS ADD CONSTRAINT FK_D_MDSTAT_RUNINST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_D_MDSTATUS_ID ON '||vschema||'.DIM_MONITOREDDRIVESTATUS(DRIVESTATUSID)  ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_D_MDSTATUS_ID ON '||vschema||'.DIM_MONITOREDDRIVESTATUS(DRIVESTATUSID)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_MONITOREDDRIVE (
      MONITOREDDRIVEWK            numeric NOT NULL,
      MONITOREDDRIVEID            numeric NOT NULL,
      NAME_                       varchar(500) NOT NULL,
      DESCRIPTION                 varchar(500) NOT NULL,
      PATH_                       varchar(1000) NOT NULL,
      INTERNALDRIVEID             numeric NOT NULL,
      TOTALCAPACITY               numeric(19,0) NOT NULL,
      WARNINGTHRESHOLDPERCENT     numeric NOT NULL,
      ERRORTHRESHOLDPERCENT       numeric NOT NULL,
      WFSCREATEDATE               TIMESTAMP(6) NOT NULL,
      WFSENDDATE                  TIMESTAMP(6) NULL,
      LASTETLPROCESS              numeric NOT NULL,
      LASTRUNINSTANCE             numeric NOT NULL,
      CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(MONITOREDDRIVEWK)  )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_MONITOREDDRIVE') INTO tmp_result;	
    SELECT createseq(vschema,'DIM_MONITOREDDRIVE') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.DIM_MONITOREDDRIVE ADD CONSTRAINT FK_D_MONITOREDDRIVE_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE ';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_MONITOREDDRIVE ADD CONSTRAINT FK_D_MONITOREDDRIVE_RUNINST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_DIM_MONITOREDDRIVE_ID ON '||vschema||'.DIM_MONITOREDDRIVE(MONITOREDDRIVEID)  ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_MONITOREDDRIVE_ID ON '||vschema||'.DIM_MONITOREDDRIVE(MONITOREDDRIVEID)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_WORKORDERSTATUS (
      WORKORDERSTATUSWK   numeric NOT NULL,
      PROCESSSTATUSID     numeric NOT NULL,
      NAME                varchar(50) NOT NULL,
      WFSCREATEDATE       TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS      numeric NOT NULL,
      LASTRUNINSTANCE     numeric NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(WORKORDERSTATUSWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_WORKORDERSTATUS') INTO tmp_result;
    SELECT createseq(vschema,'DIM_WORKORDERSTATUS') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.DIM_WORKORDERSTATUS ADD CONSTRAINT FK_D_WOSTAT_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
              REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_WORKORDERSTATUS ADD CONSTRAINT FK_D_WOSTAT_RUNINST') INTO tmp_result;	

    vsql :=  'CREATE INDEX IDX_DIM_WORKORDERSTATUS_ID ON '||vschema||'.DIM_WORKORDERSTATUS(PROCESSSTATUSID)  ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_WORKORDERSTATUS_ID ON '||vschema||'.DIM_WORKORDERSTATUS(PROCESSSTATUSID)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_NODE (
      NODEWK              numeric NOT NULL,
      NODEID              numeric NOT NULL,
      NODECLASS           varchar(50) NOT NULL,
      NAME                varchar(255) NOT NULL,
      NODEINDEX           numeric NOT NULL,
      TASKID              numeric NULL,
      TASKNAME            varchar(255) NULL,
      ISSTARTNODE         numeric NOT NULL,
      TASKCONTROLLERID    numeric NULL,
      WFSCREATEDATE       TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS      numeric NOT NULL,
      LASTRUNINSTANCE     numeric NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(NODEWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_NODE') INTO tmp_result;
    SELECT createseq(vschema,'DIM_NODE') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.DIM_NODE ADD CONSTRAINT FK_D_NODE_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_NODE ADD CONSTRAINT FK_D_NODE_RUNINST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_DIM_NODE_ID ON '||vschema||'.DIM_NODE(NODEID)';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_NODE_ID ON '||vschema||'.DIM_NODE(NODEID)') INTO tmp_result;	

    vsql :=  'CREATE TABLE '||vschema||'.DIM_RESOURCE (
      RESOURCEWK          numeric NOT NULL,
      RESOURCEID          numeric NOT NULL,
      RESOURCENAME        varchar(50) NOT NULL,
      RESOURCETYPEID      numeric NOT NULL,
      RESOURCETYPENAME    varchar(50) NOT NULL,
      ISACTIVE            numeric NOT NULL,
      WFSCREATEDATE       TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS      numeric NOT NULL,
      LASTRUNINSTANCE     numeric NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(RESOURCEWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_RESOURCE') INTO tmp_result;
    SELECT createseq(vschema,'DIM_RESOURCE') INTO tmp_result;
	
    vsql :=  'ALTER TABLE '||vschema||'.DIM_RESOURCE ADD CONSTRAINT FK_D_RES_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_RESOURCE ADD CONSTRAINT FK_D_RES_RUNINST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_DIM_RESOURCE_ID ON '||vschema||'.DIM_RESOURCE(RESOURCEID)';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_RESOURCE_ID ON '||vschema||'.DIM_RESOURCE(RESOURCEID)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_RESOURCEGROUP (
      RESOURCEGROUPWK     numeric NOT NULL,
      RESOURCEGROUPID     numeric NOT NULL,
      RESOURCEGROUPNAME   varchar(50) NOT NULL,
      RESOURCETYPEID      numeric NOT NULL,
      RESOURCETYPENAME    varchar(50) NOT NULL,
      ACCESSLEVELID       numeric NOT NULL,
      ACCESSLEVELNAME     varchar(50) NOT NULL,
      WFSCREATEDATE       TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS      numeric NOT NULL,
      LASTRUNINSTANCE     numeric NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(RESOURCEGROUPWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_RESOURCEGROUP') INTO tmp_result;	
    SELECT createseq(vschema,'DIM_RESOURCEGROUP') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.DIM_RESOURCEGROUP ADD CONSTRAINT FK_D_RESGRP_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_RESOURCEGROUP ADD CONSTRAINT FK_D_RESGRP_RUNINST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_DIM_RESOURCEGROUP_ID ON '||vschema||'.DIM_RESOURCEGROUP(RESOURCEGROUPID)';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_RESOURCEGROUP_ID ON '||vschema||'.DIM_RESOURCEGROUP(RESOURCEGROUPID)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_VARIABLEINSTANCE (
      VARIABLEINSTANCEWK          numeric NOT NULL,
      VARIABLEINSTANCENAME        varchar(255) NULL,
      VARIABLEINSTANCEVALUE       varchar(255) NULL,
      WFSCREATEDATE               TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS              numeric NOT NULL,
      LASTRUNINSTANCE             numeric NOT NULL,
      CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(VARIABLEINSTANCEWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_VARIABLEINSTANCE') INTO tmp_result;
    SELECT createseq(vschema,'DIM_VARIABLEINSTANCE') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.DIM_VARIABLEINSTANCE ADD CONSTRAINT FK_D_VARIABLEINSTANCE_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_VARIABLEINSTANCE ADD CONSTRAINT FK_D_VARIABLEINSTANCE_RUNINST') INTO tmp_result;	

    vsql :=  'CREATE UNIQUE INDEX IDX_DIM_VI_NAME_VALUE_UK ON '||vschema||'.DIM_VARIABLEINSTANCE(VARIABLEINSTANCENAME, VARIABLEINSTANCEVALUE)';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE UNIQUE INDEX IDX_DIM_VI_NAME_VALUE_UK ON '||vschema||'.DIM_VARIABLEINSTANCE(VARIABLEINSTANCENAME, VARIABLEINSTANCEVALUE)') INTO tmp_result;

    vsql :=  'CREATE TABLE '||vschema||'.DIM_WORKORDER (
      WORKORDERWK         numeric NOT NULL,
      PROCESSINSTANCEID   numeric NULL,
      SUSPENDED           varchar(3) NULL,
      PRIORITY            varchar(50) NULL,
      LOCALSTARTDATE      TIMESTAMP(6) NOT NULL,
      LOCALENDDATE        TIMESTAMP(6) NULL,
      PACKAGEASSETID      varchar(255) NOT NULL,
      ASSETID             varchar(255) NULL,
      ASSETTYPE           varchar(255) NULL,
      TITLE               varchar(255) NULL,
      BRIEFTITLE          varchar(255) NULL,
      HOUSEMATERIALID     varchar(255) NULL,
      BROADCASTMATERIALID varchar(255) NULL,
      LICENSESTARTDATE    DATE NULL,
      LICENSEENDDATE      DATE NULL,
      WFSCREATEDATE       TIMESTAMP(6) NOT NULL,
      LASTPRODUPDATEDATE  TIMESTAMP(6) NOT NULL,
      LASTETLPROCESS      numeric NOT NULL,
      LASTRUNINSTANCE     numeric NOT NULL,
      CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
      PRIMARY KEY(WORKORDERWK) )';
    SELECT CREATEOBJECT(vsql,'Unable to create table '||vschema||'.DIM_WORKORDER') INTO tmp_result;	
    SELECT createseq(vschema,'DIM_WORKORDER') INTO tmp_result;

    vsql :=  'ALTER TABLE '||vschema||'.DIM_WORKORDER ADD CONSTRAINT FK_D_WORKORDER_RUNINST FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
          REFERENCES '||vschema||'.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE) ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.DIM_WORKORDER ADD CONSTRAINT FK_D_WORKORDER_RUNINST') INTO tmp_result; 

    vsql :=  'CREATE INDEX IDX_DIM_WORKORDER_ID ON '||vschema||'.DIM_WORKORDER(PROCESSINSTANCEID) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_WORKORDER_ID ON '||vschema||'.DIM_WORKORDER(PROCESSINSTANCEID)') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_DIM_WRKORDER_PCKGASSETID ON WFSDW.DIM_WORKORDER(PACKAGEASSETID) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_DIM_WRKORDER_PCKGASSETID ON WFSDW.DIM_WORKORDER(PACKAGEASSETID)') INTO tmp_result;

    vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.DIM_PROVIDER ( VARIABLEINSTANCEWK,
                                              PROVIDERNAME,
                                              WFSCREATEDATE,
                                              LASTETLPROCESS,
                                              LASTRUNINSTANCE,
                                              CREATEDATE,
                                              UPDATEDATE ) 
             AS SELECT VARIABLEINSTANCEWK,
                       VARIABLEINSTANCEVALUE,
                       WFSCREATEDATE,
                       LASTETLPROCESS,
                       LASTRUNINSTANCE,
                       CREATEDATE,
                       UPDATEDATE
                  FROM DIM_VARIABLEINSTANCE
                 WHERE VARIABLEINSTANCENAME = ''providerId'' AND VARIABLEINSTANCEVALUE <>''''';  -- added AND clause here
    SELECT CREATEOBJECT(vsql,'Unable to create VIEW '||vschema||'.DIM_PROVIDER') INTO tmp_result;	

  -- Insert Default Dimension Data
  -- Insert a default DIM_VARIABLEINSTANCE provider value

    vsql :=  'INSERT INTO '||vschema||'.DIM_VARIABLEINSTANCE (VARIABLEINSTANCEWK, VARIABLEINSTANCENAME, VARIABLEINSTANCEVALUE, WFSCREATEDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
              VALUES (''0'', ''providerId'', ''N/A'', TO_TIMESTAMP(''29-NOV-07 10.00.00.000000'', ''DD-MON-RR HH.MI.SS.FF''), ''999999'', ''1'', TO_TIMESTAMP(''29-NOV-07 10.00.00.000000'', ''DD-MON-RR HH.MI.SS.FF''), TO_TIMESTAMP(''29-NOV-07 10.00.00.000000'', ''DD-MON-RR HH.MI.SS.FF''))';
    SELECT CREATEOBJECT(vsql,'Unable to INSERT INTO '||vschema||'.DIM_VARIABLEINSTANCE') INTO tmp_result;
/*
--------------------------------------------------------------------------------
                         Create Dimension Views
--------------------------------------------------------------------------------
*/

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.VDIM_MONITOREDDRIVE (
                         MONITOREDDRIVEWK,
                         MONITOREDDRIVEID,
                         NAME_,
                         DESCRIPTION,
                         PATH_,
                         INTERNALDRIVEID,
                         TOTALCAPACITY,
                         WARNINGTHRESHOLDPERCENT,
                         ERRORTHRESHOLDPERCENT,
                         LASTSAMPLEDATETIME )
                       AS
                       SELECT MONITOREDDRIVEWK,
                              MONITOREDDRIVEID,
                              NAME_,
                              DESCRIPTION,
                              PATH_,
                              INTERNALDRIVEID,
                              TOTALCAPACITY,
                              WARNINGTHRESHOLDPERCENT,
                              ERRORTHRESHOLDPERCENT,
                              WFSCREATEDATE
                      FROM WFSDW.DIM_MONITOREDDRIVE
                      WHERE WFSENDDATE is NULL';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.VDIM_MONITOREDDRIVE') INTO tmp_result;	

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.VDIM_PROVIDER (
                         PROVIDERWK,
                         PROVIDERNAME,
                         LASTETLPROCESS,
                         LASTRUNINSTANCE,
                         CREATEDATE,
                         UPDATEDATE )
                       AS
                       SELECT VARIABLEINSTANCEWK,
                              PROVIDERNAME,
                              LASTETLPROCESS,
                              LASTRUNINSTANCE,
                              CREATEDATE,
                              UPDATEDATE
                       FROM WFSDW.DIM_PROVIDER';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.VDIM_PROVIDER') INTO tmp_result;

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.VDIM_RESOURCE (
                         RESOURCEWK,
                         RESOURCEID,
                         NAME,
                         ISACTIVE )
                       AS
                       SELECT RESOURCEWK,
                              RESOURCEID,
                              RESOURCENAME,
                              ISACTIVE
                       FROM WFSDW.DIM_RESOURCE';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.VDIM_RESOURCE') INTO tmp_result;

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.VDIM_RESOURCEGROUP (
                         RESOURCEGROUPWK,
                         RESOURCEGROUPID,
                         NAME,
                         ACCESSLEVELID )
                       AS
                       SELECT RESOURCEGROUPWK,
                              RESOURCEGROUPID,
                              RESOURCEGROUPNAME,
                              ACCESSLEVELID
                       FROM WFSDW.DIM_RESOURCEGROUP';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.VDIM_RESOURCEGROUP') INTO tmp_result;	

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.VDIM_TEMPLATE (
                         TEMPLATEWK,
                         PROCESSDEFINITIONID,
                         NAME,
                         PROCESSDEFINITIONTYPEID,
                         PROCESSDEFINITIONTYPENAME,
                         STARTNODEID,
                         WFSCREATEDATE,
                         LASTPRODUPDATEDATE,
                         LASTETLPROCESS,
                         LASTRUNINSTANCE,
                         CREATEDATE,
                         UPDATEDATE )
                       AS
                       SELECT TEMPLATEWK,
                              PROCESSDEFINITIONID,
                              NAME,
                              PROCESSDEFINITIONTYPEID,
                              PROCESSDEFINITIONTYPENAME,
                              STARTNODEID,
                              WFSCREATEDATE,
                              LASTPRODUPDATEDATE,
                              LASTETLPROCESS,
                              LASTRUNINSTANCE,
                              CREATEDATE,
                              UPDATEDATE
                       FROM WFSDW.DIM_TEMPLATE';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.VDIM_TEMPLATE') INTO tmp_result;

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.VDIM_OBJECTTYPE (
                         OBJECTTYPENAME )
                       AS
                       SELECT DISTINCT ASSETTYPE
                       FROM WFSDW.DIM_WORKORDER
                       WHERE ASSETTYPE is not null';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.VDIM_OBJECTTYPE') INTO tmp_result;	

    vsql :=  'CREATE OR REPLACE VIEW WFSDW.V_TITLEPURGE (
                              ID_,
                              TITLE_ID,
                              PROVIDER_ID,
                              PROVIDER_NAME,
                              PURGE_DATE,
                              TITLE_BRIEF,
                              PACKAGE_ASSET_ID,
                              ASSET_NAME,
                              LICENSE_START,
                              LICENSE_END,
                              CREATEDATE,
                              UPDATEDATE)
                            AS
                              SELECT ID_,
                                TITLE_ID,
                                PROVIDER_ID,
                                PROVIDER_NAME,
                                CAST(TITLE_RETIREMENT_DATE AS DATE),
                                TITLE_BRIEF,
                                PACKAGE_ASSET_ID,
                                ASSET_NAME,
                                LICENSE_START,
                                LICENSE_END,
                                CREATEDATE,
                                UPDATEDATE
                              FROM WFS.PMM_TITLE_PURGE_HISTORY';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE OR REPLACE VIEW WFSDW.V_TITLEPURGE') INTO tmp_result;

    vsql :=  'CREATE VIEW WFSDW.VDIM_PROVIDERNAME_ID AS '||
                         'SELECT DISTINCT Providerid, Name '||
                         '  FROM WFS.PMM_Partner'||
                         '  WHERE PartnerType<>1';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE VIEW WFSDW.VDIM_PROVIDERNAME_ID') INTO tmp_result;
/*
--------------------------------------------------------------------------------
                         Create Fact Tables
--------------------------------------------------------------------------------
*/

    vsql :=  'CREATE TABLE WFSDW.FACT_WORKORDERDETAIL (
                            WORKORDERWK                 numeric NOT NULL,
                            TEMPLATEWK                  numeric NOT NULL,
                            PROVIDERWK                  numeric NOT NULL,
                            ADMINSTATUSWK               numeric NOT NULL,
                            OPERSTATUSWK                numeric NOT NULL,
                            LOCALSTARTDATEWK            numeric(8) NOT NULL,
                            LOCALSTARTTIMEWK            numeric(6) NOT NULL,
                            WFSCREATEDATE               TIMESTAMP(6) NOT NULL,
                            LASTPRODUPDATEDATE          TIMESTAMP(6) NOT NULL,
                            LASTETLPROCESS              numeric NOT NULL,
                            LASTRUNINSTANCE             numeric NOT NULL,
                            CREATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                            UPDATEDATE                  TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                            PRIMARY KEY(WORKORDERWK,TEMPLATEWK,PROVIDERWK,ADMINSTATUSWK,OPERSTATUSWK,LOCALSTARTDATEWK,LOCALSTARTTIMEWK)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to WFSDW.FACT_WORKORDERDETAIL') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_RUNINST
             FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
             REFERENCES WFSDW.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_RUNINST') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_STARTDATE
             FOREIGN KEY(LOCALSTARTDATEWK)
             REFERENCES WFSDW.DIM_DATE(DATEWK)
             NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_STARTDATE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_STARTTIME
             FOREIGN KEY(LOCALSTARTTIMEWK)
             REFERENCES WFSDW.DIM_TIME(TIMEWK)
             NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_STARTTIME') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_TEMPLATE
             FOREIGN KEY(TEMPLATEWK)
             REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_TEMPLATE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_PROVIDER
             FOREIGN KEY(PROVIDERWK)
             REFERENCES WFSDW.DIM_VARIABLEINSTANCE(VARIABLEINSTANCEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_PROVIDER') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_ADMINSTS
             FOREIGN KEY(ADMINSTATUSWK)
             REFERENCES WFSDW.DIM_WORKORDERSTATUS(WORKORDERSTATUSWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_ADMINSTS') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDETAIL
         ADD CONSTRAINT FK_F_WORKORDERDETAIL_OPERSTS
             FOREIGN KEY(OPERSTATUSWK)
             REFERENCES WFSDW.DIM_WORKORDERSTATUS(WORKORDERSTATUSWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDETAIL to ADD CONSTRAINT FK_F_WORKORDERDETAIL_OPERSTS') INTO tmp_result;
	
    vsql :=  'CREATE INDEX IDX_FACT_WODETAILY ON WFSDW.FACT_WORKORDERDETAIL (LOCALSTARTDATEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_WODETAILY ON WFSDW.FACT_WORKORDERDETAIL (LOCALSTARTDATEWK)') INTO tmp_result;	

    vsql :=  'CREATE TABLE WFSDW.FACT_WORKORDERDAY (
                            TEMPLATEWK          numeric NOT NULL,
                            PROVIDERWK          numeric NOT NULL,
                            DATEWK              numeric NOT NULL,
                            WORKORDERCOUNT      numeric NOT NULL,
                            LASTETLPROCESS      numeric NOT NULL,
                            LASTRUNINSTANCE     numeric NOT NULL,
                            CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                            UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                            PRIMARY KEY(TEMPLATEWK,PROVIDERWK,DATEWK)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_WORKORDERDAY') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDAY
         ADD CONSTRAINT FK_F_WORKORDERDAY_TEMPLATE
             FOREIGN KEY(TEMPLATEWK)
             REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDAY to ADD CONSTRAINT FK_F_WORKORDERDAY_TEMPLATE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDAY
         ADD CONSTRAINT FK_F_WORKORDERDAY_DATE
             FOREIGN KEY(DATEWK)
             REFERENCES WFSDW.DIM_DATE(DATEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDAY to ADD CONSTRAINT FK_F_WORKORDERDAY_DATE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDAY
         ADD CONSTRAINT FK_F_WORKORDERDAY_RUNINST
             FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
             REFERENCES WFSDW.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDAY to ADD CONSTRAINT FK_F_WORKORDERDAY_RUNINST') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERDAY
         ADD CONSTRAINT FK_F_WORKORDERDAY_PROVIDER
             FOREIGN KEY(PROVIDERWK)
             REFERENCES WFSDW.DIM_VARIABLEINSTANCE(VARIABLEINSTANCEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERDAY to ADD CONSTRAINT FK_F_WORKORDERDAY_PROVIDER') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_FACT_WODAY ON WFSDW.FACT_WORKORDERDAY (DATEWK, TEMPLATEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_WODAY ON WFSDW.FACT_WORKORDERDAY (DATEWK, TEMPLATEWK)') INTO tmp_result;	

    vsql :=  'CREATE TABLE WFSDW.FACT_WORKORDERMONTH (
                            TEMPLATEWK          numeric NOT NULL,
                            PROVIDERWK          numeric NOT NULL,
                            MONTHWK             numeric NOT NULL,
                            WORKORDERCOUNT      numeric NOT NULL,
                            LASTETLPROCESS      numeric NOT NULL,
                            LASTRUNINSTANCE     numeric NOT NULL,
                            CREATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                            UPDATEDATE          TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                            PRIMARY KEY(TEMPLATEWK,PROVIDERWK,MONTHWK)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_WORKORDERMONTH') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERMONTH
         ADD CONSTRAINT FK_F_WORKORDERMONTH_TEMPLATE
             FOREIGN KEY(TEMPLATEWK)
             REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERMONTH to ADD CONSTRAINT FK_F_WORKORDERMONTH_TEMPLATE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERMONTH
          ADD CONSTRAINT FK_F_WORKORDERMONTH_RUNINST
              FOREIGN KEY(LASTETLPROCESS, LASTRUNINSTANCE)
              REFERENCES WFSDW.MD_ETLPROCESSRUNINSTANCE(ETLPROCESS, RUNINSTANCE)
              ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERMONTH to ADD CONSTRAINT FK_F_WORKORDERMONTH_RUNINST ') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERMONTH
         ADD CONSTRAINT FK_F_WORKORDERMONTH_PROVIDER
             FOREIGN KEY(PROVIDERWK)
             REFERENCES WFSDW.DIM_VARIABLEINSTANCE(VARIABLEINSTANCEWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERMONTH to ADD CONSTRAINT FK_F_WORKORDERMONTH_PROVIDER') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_WORKORDERMONTH
         ADD CONSTRAINT FK_F_WORKORDERMONTH_MONTH
             FOREIGN KEY(MONTHWK)
             REFERENCES WFSDW.DIM_MONTH(MONTHWK)
             ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_WORKORDERMONTH to ADD CONSTRAINT FK_F_WORKORDERMONTH_MONTH') INTO tmp_result;	
    
    vsql :=  'CREATE TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL (
                                   TEMPLATEWK             numeric NOT NULL,
                                   WORKORDERWK            numeric NOT NULL,
                                   NODEWK                 numeric NULL,
                                   LOCALENTERDATEWK       numeric NOT NULL,
                                   LOCALENTERTIMEWK       numeric NOT NULL,
                                   RESOURCEWK             numeric NOT NULL,
                                   RESOURCEGROUPWK        numeric NOT NULL,
                                   ADMINSTATUSWK          numeric NOT NULL,
                                   OPERSTATUSWK           numeric NOT NULL,
                                   DURATION               numeric NOT NULL,
                                   WFSCREATEDATE          TIMESTAMP(6) NOT NULL,
                                   LASTPRODUPDATEDATE     TIMESTAMP(6) NOT NULL,
                                   LASTETLPROCESS         numeric NOT NULL,
                                   LASTRUNINSTANCE        numeric NOT NULL,
                                   CREATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                   UPDATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                   PRIMARY KEY(TEMPLATEWK,WORKORDERWK,LOCALENTERDATEWK,LOCALENTERTIMEWK,RESOURCEWK,RESOURCEGROUPWK,ADMINSTATUSWK,OPERSTATUSWK,LASTRUNINSTANCE)
                                  )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
              ADD CONSTRAINT FK_F_RESOUREQUEDETAIL_TMPLT
                  FOREIGN KEY (TEMPLATEWK)
                  REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
                  ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOUREQUEDETAIL_TMPLT') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_WRKORDR
                 FOREIGN KEY (WORKORDERWK)
                 REFERENCES WFSDW.DIM_WORKORDER(WORKORDERWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_WRKORDR') INTO tmp_result;	
/*
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_NODE
                 FOREIGN KEY (NODEWK)
                 REFERENCES WFSDW.DIM_NODE(NODEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_NODE') INTO tmp_result;	
*/
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_LCENTDT
                 FOREIGN KEY (LOCALENTERDATEWK)
                 REFERENCES WFSDW.DIM_DATE(DATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_LCENTDT') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_LCENTTM
                 FOREIGN KEY (LOCALENTERTIMEWK)
                 REFERENCES WFSDW.DIM_TIME(TIMEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_LCENTTM') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_RSRC
                 FOREIGN KEY (RESOURCEWK)
                 REFERENCES WFSDW.DIM_RESOURCE(RESOURCEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_RSRC') INTO tmp_result;	
    
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_RSRCBRG
                 FOREIGN KEY (RESOURCEGROUPWK)
                 REFERENCES WFSDW.DIM_RESOURCEGROUP(RESOURCEGROUPWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_RSRCBRG') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_ADMNST
                 FOREIGN KEY (ADMINSTATUSWK)
                 REFERENCES WFSDW.DIM_WORKORDERSTATUS(WORKORDERSTATUSWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_ADMNST') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL
             ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_OPRST
                 FOREIGN KEY (OPERSTATUSWK)
                 REFERENCES WFSDW.DIM_WORKORDERSTATUS(WORKORDERSTATUSWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDETAIL to ADD CONSTRAINT FK_F_RESOURCEQUEDETAIL_OPRST') INTO tmp_result;	

    vsql :=  'CREATE INDEX IDX_FACT_RESQUEDETAIL ON WFSDW.FACT_RESOURCEQUEUEDETAIL (LOCALENTERDATEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_RESQUEDETAIL ON WFSDW.FACT_RESOURCEQUEUEDETAIL (LOCALENTERDATEWK)') INTO tmp_result;	

    vsql :=  'CREATE TABLE WFSDW.FACT_RESOURCEQUEUEDAY (
                                 TEMPLATEWK             numeric NOT NULL,
                                 WORKORDERWK            numeric NOT NULL,
                                 NODEWK                 numeric NULL,
                                 RESOURCEWK             numeric NOT NULL,
                                 RESOURCEGROUPWK        numeric NOT NULL,
                                 DATEWK                 numeric NOT NULL,
                                 TOTALDURATION          numeric NOT NULL,
                                 TOTALQUEUED            numeric NOT NULL,
                                 LASTETLPROCESS         numeric NOT NULL,
                                 LASTRUNINSTANCE        numeric NOT NULL,
                                 CREATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 UPDATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 PRIMARY KEY(TEMPLATEWK,WORKORDERWK,RESOURCEWK,RESOURCEGROUPWK,DATEWK,LASTRUNINSTANCE)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_RESOURCEQUEUEDAY') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY
             ADD CONSTRAINT FK_F_RESOUREQUEDAY_TMPLT
                 FOREIGN KEY (TEMPLATEWK)
                 REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY to ADD CONSTRAINT FK_F_RESOUREQUEDAY_TMPLT') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY
             ADD CONSTRAINT FK_F_RESOURCEQUEDAY_WRKORDR
                 FOREIGN KEY (WORKORDERWK)
                 REFERENCES WFSDW.DIM_WORKORDER(WORKORDERWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY to ADD CONSTRAINT FK_F_RESOURCEQUEDAY_WRKORDR') INTO tmp_result;	
/*
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY
             ADD CONSTRAINT FK_F_RESOURCEQUEDAY_NODE
                 FOREIGN KEY (NODEWK)
                 REFERENCES WFSDW.DIM_NODE(NODEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY to ADD CONSTRAINT FK_F_RESOURCEQUEDAY_NODE') INTO tmp_result;		
*/
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY
             ADD CONSTRAINT FK_F_RESOURCEQUEDAY_DT
                 FOREIGN KEY (DATEWK)
                 REFERENCES WFSDW.DIM_DATE(DATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY to ADD CONSTRAINT FK_F_RESOURCEQUEDAY_DT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY
             ADD CONSTRAINT FK_F_RESOURCEQUEDAY_RSRC
                 FOREIGN KEY (RESOURCEWK)
                 REFERENCES WFSDW.DIM_RESOURCE(RESOURCEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY to ADD CONSTRAINT FK_F_RESOURCEQUEDAY_RSRC') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY
             ADD CONSTRAINT FK_F_RESOURCEQUEDAY_RSRCBRG
                 FOREIGN KEY (RESOURCEGROUPWK)
                 REFERENCES WFSDW.DIM_RESOURCEGROUP(RESOURCEGROUPWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEDAY to ADD CONSTRAINT FK_F_RESOURCEQUEDAY_RSRCBRG') INTO tmp_result;	

    vsql :=  'CREATE INDEX IDX_FACT_RESQUEUEDAY ON WFSDW.FACT_RESOURCEQUEUEDAY (DATEWK, RESOURCEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_RESQUEUEDAY ON WFSDW.FACT_RESOURCEQUEUEDAY (DATEWK, RESOURCEWK)') INTO tmp_result;

    vsql :=  'CREATE TABLE WFSDW.FACT_RESOURCEQUEUEMONTH (
                               TEMPLATEWK             numeric NOT NULL,
                               WORKORDERWK            numeric NOT NULL,
                               NODEWK                 numeric NULL,
                               RESOURCEWK             numeric NOT NULL,
                               RESOURCEGROUPWK        numeric NOT NULL,
                               MONTHWK                numeric NOT NULL,
                               TOTALDURATION          numeric NOT NULL,
                               TOTALQUEUED            numeric NOT NULL,
                               LASTETLPROCESS         numeric NOT NULL,
                               LASTRUNINSTANCE        numeric NOT NULL,
                               CREATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                               UPDATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                               PRIMARY KEY(TEMPLATEWK,WORKORDERWK,RESOURCEWK,RESOURCEGROUPWK,MONTHWK,LASTRUNINSTANCE)
                              )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_RESOURCEQUEUEMONTH') INTO tmp_result;	

    vsql :=  'CREATE INDEX IDX_FACT_RESQUEUEMNTH ON WFSDW.FACT_RESOURCEQUEUEMONTH(MONTHWK, RESOURCEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_RESQUEUEMNTH ON WFSDW.FACT_RESOURCEQUEUEMONTH(MONTHWK, RESOURCEWK)') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH
             ADD CONSTRAINT FK_F_RESOUREQUEMONTH_TMPLT
                 FOREIGN KEY (TEMPLATEWK)
                 REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH to ADD CONSTRAINT FK_F_RESOUREQUEMONTH_TMPLT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH
             ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_WRKORDR
                 FOREIGN KEY (WORKORDERWK)
                 REFERENCES WFSDW.DIM_WORKORDER(WORKORDERWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH to ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_WRKORDR') INTO tmp_result;	
/*
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH
             ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_NODE
                 FOREIGN KEY (NODEWK)
                 REFERENCES WFSDW.DIM_NODE(NODEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH to ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_NODE') INTO tmp_result;	
*/
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH
             ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_DT
                 FOREIGN KEY (MONTHWK)
                 REFERENCES WFSDW.DIM_MONTH(MONTHWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH to ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_DT') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH
             ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_RSRC
                 FOREIGN KEY (RESOURCEWK)
                 REFERENCES WFSDW.DIM_RESOURCE(RESOURCEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH to ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_RSRC') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH
             ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_RSRCBRG
                 FOREIGN KEY (RESOURCEGROUPWK)
                 REFERENCES WFSDW.DIM_RESOURCEGROUP(RESOURCEGROUPWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCEQUEUEMONTH to ADD CONSTRAINT FK_F_RESOURCEQUEMONTH_RSRCBRG') INTO tmp_result;

    vsql :=  'CREATE TABLE WFSDW.FACT_RESOURCETASKDETAIL (
                                 TEMPLATEWK             numeric NOT NULL,
                                 WORKORDERWK            numeric NOT NULL,
                                 NODEWK                 numeric NULL,
                                 LOCALENTERDATEWK       numeric NOT NULL,
                                 LOCALENTERTIMEWK       numeric NOT NULL,
                                 LOCALLEAVEDATEWK       numeric NOT NULL,
                                 LOCALLEAVETIMEWK       numeric NOT NULL,
                                 RESOURCEWK             numeric NOT NULL,
                                 RESOURCEGROUPWK        numeric NOT NULL,
                                 ADMINSTATUSWK          numeric NOT NULL,
                                 OPERSTATUSWK           numeric NOT NULL,
                                 DURATION               numeric NOT NULL,
                                 WFSCREATEDATE          TIMESTAMP(6) NOT NULL,
                                 LASTPRODUPDATEDATE     TIMESTAMP(6) NOT NULL,
                                 LASTETLPROCESS         numeric NOT NULL,
                                 LASTRUNINSTANCE        numeric NOT NULL,
                                 CREATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 UPDATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 PRIMARY KEY(TEMPLATEWK, WORKORDERWK, LOCALENTERDATEWK, LOCALENTERTIMEWK, LOCALLEAVEDATEWK, LOCALLEAVETIMEWK, RESOURCEWK, RESOURCEGROUPWK, ADMINSTATUSWK, OPERSTATUSWK,LASTRUNINSTANCE)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_RESOURCETASKDETAIL') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURETSKDETAIL_TMPLT
                 FOREIGN KEY (TEMPLATEWK)
                 REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURETSKDETAIL_TMPLT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_WRKORDR
                 FOREIGN KEY (WORKORDERWK)
                 REFERENCES WFSDW.DIM_WORKORDER(WORKORDERWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_WRKORDR') INTO tmp_result;	
/*
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_NODE
                 FOREIGN KEY (NODEWK)
                 REFERENCES WFSDW.DIM_NODE(NODEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_NODE') INTO tmp_result;
*/
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCENTDT
                 FOREIGN KEY (LOCALENTERDATEWK)
                 REFERENCES WFSDW.DIM_DATE(DATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCENTDT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCENTTM
                 FOREIGN KEY (LOCALENTERTIMEWK)
                 REFERENCES WFSDW.DIM_TIME(TIMEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCENTTM') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCLVDT
                 FOREIGN KEY (LOCALLEAVEDATEWK)
                 REFERENCES WFSDW.DIM_DATE(DATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCLVDT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCLVTM
                 FOREIGN KEY (LOCALLEAVETIMEWK)
                 REFERENCES WFSDW.DIM_TIME(TIMEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_LCLVTM') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_RSRC
                 FOREIGN KEY (RESOURCEWK)
                 REFERENCES WFSDW.DIM_RESOURCE(RESOURCEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_RSRC') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_RSRCBRG
                 FOREIGN KEY (RESOURCEGROUPWK)
                 REFERENCES WFSDW.DIM_RESOURCEGROUP(RESOURCEGROUPWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_RSRCBRG') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_ADMST
                 FOREIGN KEY (ADMINSTATUSWK)
                 REFERENCES WFSDW.DIM_WORKORDERSTATUS(WORKORDERSTATUSWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_ADMST') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL
             ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_OPRST
                 FOREIGN KEY (OPERSTATUSWK)
                 REFERENCES WFSDW.DIM_WORKORDERSTATUS(WORKORDERSTATUSWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDETAIL to ADD CONSTRAINT FK_F_RESOURCETSKDETAIL_OPRST') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_FACT_RESTASKDETAIL ON WFSDW.FACT_RESOURCETASKDETAIL (LOCALENTERDATEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_RESTASKDETAIL ON WFSDW.FACT_RESOURCETASKDETAIL (LOCALENTERDATEWK)') INTO tmp_result;	

    vsql :=  'CREATE TABLE WFSDW.FACT_RESOURCETASKDAY (
                                 TEMPLATEWK             numeric          NOT NULL,
                                 WORKORDERWK            numeric          NOT NULL,
                                 NODEWK                 numeric          NULL,
                                 RESOURCEWK             numeric          NOT NULL,
                                 RESOURCEGROUPWK        numeric          NOT NULL,
                                 DATEWK                 numeric          NOT NULL,
                                 TOTALDURATION          numeric          NOT NULL,
                                 TOTALTASKS             numeric          NOT NULL,
                                 TOTALERRORS            numeric          NOT NULL,
                                 LASTETLPROCESS         numeric          NOT NULL,
                                 LASTRUNINSTANCE        numeric          NOT NULL,
                                 CREATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 UPDATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 PRIMARY KEY(TEMPLATEWK,WORKORDERWK,RESOURCEWK,RESOURCEGROUPWK,DATEWK,LASTRUNINSTANCE)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_RESOURCETASKDAY') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDAY
             ADD CONSTRAINT FK_F_RESOURETSKDAY_TMPLT
                 FOREIGN KEY (TEMPLATEWK)
                 REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDAY to ADD CONSTRAINT FK_F_RESOURETSKDAY_TMPLT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDAY
             ADD CONSTRAINT FK_F_RESOURCETSKDAY_WRKORDR
                 FOREIGN KEY (WORKORDERWK)
                 REFERENCES WFSDW.DIM_WORKORDER(WORKORDERWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDAY to ADD CONSTRAINT FK_F_RESOURCETSKDAY_WRKORDR') INTO tmp_result;
/*
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDAY
             ADD CONSTRAINT FK_F_RESOURCETSKDAY_NODE
                 FOREIGN KEY (NODEWK)
                 REFERENCES WFSDW.DIM_NODE(NODEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDAY to ADD CONSTRAINT FK_F_RESOURCETSKDAY_NODE') INTO tmp_result;	
*/
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDAY
             ADD CONSTRAINT FK_F_RESOURCETSKDAY_DT
                 FOREIGN KEY (DATEWK)
                 REFERENCES WFSDW.DIM_DATE(DATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDAY to ADD CONSTRAINT FK_F_RESOURCETSKDAY_DT') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDAY
             ADD CONSTRAINT FK_F_RESOURCETSKDAY_RSRC
                 FOREIGN KEY (RESOURCEWK)
                 REFERENCES WFSDW.DIM_RESOURCE(RESOURCEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDAY to ADD CONSTRAINT FK_F_RESOURCETSKDAY_RSRC') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKDAY
             ADD CONSTRAINT FK_F_RESOURCETSKDAY_RSRCBRG
                 FOREIGN KEY (RESOURCEGROUPWK)
                 REFERENCES WFSDW.DIM_RESOURCEGROUP(RESOURCEGROUPWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKDAY to ADD CONSTRAINT FK_F_RESOURCETSKDAY_RSRCBRG') INTO tmp_result;	

    vsql :=  'CREATE TABLE WFSDW.FACT_RESOURCETASKMONTH (
                                 TEMPLATEWK             numeric NOT NULL,
                                 WORKORDERWK            numeric NOT NULL,
                                 NODEWK                 numeric NULL,
                                 RESOURCEWK             numeric NOT NULL,
                                 RESOURCEGROUPWK        numeric NOT NULL,
                                 MONTHWK                numeric NOT NULL,
                                 TOTALDURATION          numeric NOT NULL,
                                 TOTALTASKS             numeric NOT NULL,
                                 TOTALERRORS            numeric NOT NULL,
                                 LASTETLPROCESS         numeric NOT NULL,
                                 LASTRUNINSTANCE        numeric NOT NULL,
                                 CREATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 UPDATEDATE             TIMESTAMP(6) DEFAULT (current_timestamp) NOT NULL,
                                 PRIMARY KEY(TEMPLATEWK,WORKORDERWK,RESOURCEWK,RESOURCEGROUPWK,MONTHWK,LASTRUNINSTANCE)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_RESOURCETASKMONTH') INTO tmp_result;	

    vsql :=  'CREATE INDEX IDX_FACT_RESTASKMNTH ON WFSDW.FACT_RESOURCETASKMONTH(MONTHWK, RESOURCEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_RESTASKMNTH ON WFSDW.FACT_RESOURCETASKMONTH(MONTHWK, RESOURCEWK)') INTO tmp_result;

    vsql :=  'CREATE INDEX IDX_FACT_RESTASKDAY ON WFSDW.FACT_RESOURCETASKDAY (DATEWK, RESOURCEWK) ';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX IDX_FACT_RESTASKDAY ON WFSDW.FACT_RESOURCETASKDAY (DATEWK, RESOURCEWK)') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH
             ADD CONSTRAINT FK_F_RESOURETSKMONTH_TMPLT
                 FOREIGN KEY (TEMPLATEWK)
                 REFERENCES WFSDW.DIM_TEMPLATE(TEMPLATEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH to ADD CONSTRAINT FK_F_RESOURETSKMONTH_TMPLT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH
             ADD CONSTRAINT FK_F_RESOURCETSKMONTH_WRKORDR
                 FOREIGN KEY (WORKORDERWK)
                 REFERENCES WFSDW.DIM_WORKORDER(WORKORDERWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH to ADD CONSTRAINT FK_F_RESOURCETSKMONTH_WRKORDR') INTO tmp_result;	
/*
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH
             ADD CONSTRAINT FK_F_RESOURCETSKMONTH_NODE
                 FOREIGN KEY (NODEWK)
                 REFERENCES WFSDW.DIM_NODE(NODEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH to ADD CONSTRAINT FK_F_RESOURCETSKMONTH_NODE') INTO tmp_result;
*/
    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH
             ADD CONSTRAINT FK_F_RESOURCETSKMONTH_DT
                 FOREIGN KEY (MONTHWK)
                 REFERENCES WFSDW.DIM_MONTH(MONTHWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH to ADD CONSTRAINT FK_F_RESOURCETSKMONTH_DT') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH
             ADD CONSTRAINT FK_F_RESOURCETSKMONTH_RSRC
                 FOREIGN KEY (RESOURCEWK)
                 REFERENCES WFSDW.DIM_RESOURCE(RESOURCEWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH to ADD CONSTRAINT FK_F_RESOURCETSKMONTH_RSRC') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH
             ADD CONSTRAINT FK_F_RESOURCETSKMONTH_RSRCBRG
                 FOREIGN KEY (RESOURCEGROUPWK)
                 REFERENCES WFSDW.DIM_RESOURCEGROUP(RESOURCEGROUPWK)
                 ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_RESOURCETASKMONTH to ADD CONSTRAINT FK_F_RESOURCETSKMONTH_RSRCBRG') INTO tmp_result;	

    vsql :=  'CREATE TABLE WFSDW.FACT_MDHISTORYDETAIL (
                                MONITOREDDRIVEWK        numeric  NOT NULL,
                                MONITOREDDRIVESTATUSWK  numeric  NOT NULL,
                                LOCALDATEWK             numeric  NOT NULL,
                                LOCALTIMEWK             numeric  NOT NULL,
                                CURRENTBYTESUSED        numeric  NOT NULL,
                                LASTETLPROCESS          numeric  NOT NULL,
                                LASTRUNINSTANCE         numeric  NOT NULL,
                                CREATEDATE              TIMESTAMP(6)    DEFAULT(current_timestamp)   NOT NULL,
                                UPDATEDATE              TIMESTAMP(6)    DEFAULT(current_timestamp)   NOT NULL,
                                PRIMARY KEY(MONITOREDDRIVEWK,MONITOREDDRIVESTATUSWK,LOCALDATEWK,LOCALTIMEWK)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_MDHISTORYDETAIL') INTO tmp_result;

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL
             ADD CONSTRAINT FK_F_MDHISTORY_MONDRIVE
                FOREIGN KEY (MONITOREDDRIVEWK)
                REFERENCES WFSDW.DIM_MONITOREDDRIVE(MONITOREDDRIVEWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL to ADD CONSTRAINT FK_F_MDHISTORY_MONDRIVE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL
             ADD CONSTRAINT FK_F_MDHISTORY_MDSTATUS
                FOREIGN KEY (MONITOREDDRIVESTATUSWK)
                REFERENCES WFSDW.DIM_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL to ADD CONSTRAINT FK_F_MDHISTORY_MDSTATUS') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL
             ADD CONSTRAINT FK_F_MDHISTORY_DATE
                FOREIGN KEY (LOCALDATEWK)
                REFERENCES WFSDW.DIM_DATE(DATEWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL to ADD CONSTRAINT FK_F_MDHISTORY_DATE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL
             ADD CONSTRAINT FK_F_MDHISTORY_TIME
                FOREIGN KEY (LOCALTIMEWK)
                REFERENCES WFSDW.DIM_TIME(TIMEWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDETAIL to ADD CONSTRAINT FK_F_MDHISTORY_TIME') INTO tmp_result;

    vsql :=  'CREATE TABLE WFSDW.FACT_MDHISTORYDAY (
                                MONITOREDDRIVEWK        numeric          NOT NULL,
                                MONITOREDDRIVESTATUSWK  numeric          NOT NULL,
                                LOCALDATEWK             numeric          NOT NULL,
                                BYTESUSED               numeric          NOT NULL,
                                PERCENTUSED             numeric(6,3)     NOT NULL,
                                LASTETLPROCESS          numeric          NOT NULL,
                                LASTRUNINSTANCE         numeric          NOT NULL,
                                CREATEDATE              TIMESTAMP(6)    DEFAULT(current_timestamp)   NOT NULL,
                                UPDATEDATE              TIMESTAMP(6)    DEFAULT(current_timestamp)   NOT NULL,
                                PRIMARY KEY(MONITOREDDRIVEWK,MONITOREDDRIVESTATUSWK,LOCALDATEWK)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_MDHISTORYDAY') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDAY
             ADD CONSTRAINT FK_F_MDHISTORYDAY_MONDRIVE
                FOREIGN KEY (MONITOREDDRIVEWK)
                REFERENCES WFSDW.DIM_MONITOREDDRIVE(MONITOREDDRIVEWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDAY to ADD CONSTRAINT FK_F_MDHISTORYDAY_MONDRIVE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDAY
             ADD CONSTRAINT FK_F_MDHISTORYDAY_MDSTATUS
                FOREIGN KEY (MONITOREDDRIVESTATUSWK)
                REFERENCES WFSDW.DIM_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDAY to ADD CONSTRAINT FK_F_MDHISTORYDAY_MDSTATUS') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYDAY
             ADD CONSTRAINT FK_F_MDHISTORYDAY_DATE
                FOREIGN KEY (LOCALDATEWK)
                REFERENCES WFSDW.DIM_DATE(DATEWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYDAY to ADD CONSTRAINT FK_F_MDHISTORYDAY_DATE') INTO tmp_result;

    vsql :=  'CREATE TABLE WFSDW.FACT_MDHISTORYMONTH (
                                MONITOREDDRIVEWK        numeric          NOT NULL,
                                MONTHWK                 numeric          NOT NULL,
                                MAXPERCENTUSED             numeric(10,3)     NOT NULL,
                                LASTETLPROCESS          numeric          NOT NULL,
                                LASTRUNINSTANCE         numeric          NOT NULL,
                                CREATEDATE              TIMESTAMP(6)    DEFAULT(current_timestamp)   NOT NULL,
                                UPDATEDATE              TIMESTAMP(6)    DEFAULT(current_timestamp)   NOT NULL,
                                PRIMARY KEY(MONITOREDDRIVEWK,MONTHWK)
                                )';
    SELECT CREATEOBJECT(vsql,'Unable to CREATE TABLE WFSDW.FACT_MDHISTORYMONTH') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYMONTH
             ADD CONSTRAINT FK_F_MDHISTORYMONTH_MONDRIVE
                FOREIGN KEY (MONITOREDDRIVEWK)
                REFERENCES WFSDW.DIM_MONITOREDDRIVE(MONITOREDDRIVEWK)
                ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYMONTH to ADD CONSTRAINT FK_F_MDHISTORYMONTH_MONDRIVE') INTO tmp_result;	

    vsql :=  'ALTER TABLE WFSDW.FACT_MDHISTORYMONTH
            ADD CONSTRAINT FK_F_MDHISTORYMONTH_MONTH
               FOREIGN KEY (MONTHWK)
               REFERENCES WFSDW.DIM_MONTH(MONTHWK)
               ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE';
    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE WFSDW.FACT_MDHISTORYMONTH to ADD CONSTRAINT FK_F_MDHISTORYMONTH_MONTH') INTO tmp_result;	

    execute 'select COUNT(*) from '||ischema||'.install_table where upper(install_message) like ''%ERROR%''' into errcnt;
    IF errcnt = 0 then
       EXECUTE 'INSERT INTO '||ischema||'.install_table(install_message) values (''Installation of Data WareHouse database for version '||db_version||' completed SUCCESSFULLY'')';
       EXECUTE 'INSERT INTO '||vschema||'.SYSTEM_SETTINGS (setting_type, setting_value) VALUES (''RELEASE'','''||db_version||''')';
    END IF;
    return 0;
  EXCEPTION
    WHEN OTHERS THEN
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in createwfsdw function : '')';
       EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
       return 1;
END;
$func_createwfsdw$ LANGUAGE plpgsql;
  
CREATE OR REPLACE FUNCTION convertwfsdw (vschema varchar, db_version varchar) RETURNS integer AS $func_convertwfsdw$
DECLARE
    vsql       varchar;
    wk_message VARCHAR:= '';
    tmp_result smallint;
    wk_release varchar:='';    
    cms_comps  smallint;
    comp_recs  numeric := 0;
    myvar      varchar(10):='';    
    idx_tbs    varchar:='ttv_wfsdw_index';
    ischema    text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    EXECUTE 'SELECT get_version('''||vschema||''')' into wk_release;
	IF (wk_release =  '2.7') THEN
	    vsql := 'ALTER TABLE '||vschema||'.MD_EVENTLOG ALTER COLUMN errorcode TYPE TEXT USING TO_CHAR(ERRORCODE)';
	    SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_EVENTLOG ALTER COLUMN errorcode TYPE TEXT','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE ALTER COLUMN SYSERRORCODE TYPE TEXT USING TO_CHAR(SYSERRORCODE)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.MD_ETLPROCESSRUNINSTANCE ALTER COLUMN SYSERRORCODE TYPE TEXT','Y') INTO tmp_result;

        vsql := 'CREATE INDEX idx_stg_diff_wo_woid ON '||vschema||'.STG1_DIFF_WORKORDER(PROCESSINSTANCEID)';
        SELECT CREATEOBJECT(vsql,'Unable to CREATE INDEX idx_stg_diff_wo_pii ON '||vschema||'.STG1_DIFF_WORKORDER(PROCESSINSTANCEID)','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.dim_template ALTER COLUMN startnodeid DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.dim_template ALTER COLUMN startnodeid DROP NOT NULL','Y') INTO tmp_result;

        vsql :=  'CREATE OR REPLACE VIEW '||vschema||'.DIM_PROVIDER 
                        (VARIABLEINSTANCEWK, PROVIDERNAME, WFSCREATEDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE) AS 
                  SELECT VARIABLEINSTANCEWK, VARIABLEINSTANCEVALUE, WFSCREATEDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE
                    FROM '||vschema||'.DIM_VARIABLEINSTANCE WHERE VARIABLEINSTANCENAME = ''providerId'' AND VARIABLEINSTANCEVALUE <>'''''; 
        SELECT CREATEOBJECT(vsql,'Unable to create VIEW '||vschema||'.DIM_PROVIDER','Y') INTO tmp_result;        

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL DROP CONSTRAINT FK_F_RESOURCEQUEDETAIL_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL DROP CONSTRAINT FK_F_RESOURCEQUEDETAIL_NODE','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY DROP CONSTRAINT FK_F_RESOURCEQUEDAY_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY DROP CONSTRAINT FK_F_RESOURCEQUEDAY_NODE','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH DROP CONSTRAINT FK_F_RESOURCEQUEMONTH_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH DROP CONSTRAINT FK_F_RESOURCEQUEMONTH_NODE','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL DROP CONSTRAINT FK_F_RESOURCETSKDETAIL_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL DROP CONSTRAINT FK_F_RESOURCETSKDETAIL_NODE','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY DROP CONSTRAINT FK_F_RESOURCETSKDAY_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY DROP CONSTRAINT FK_F_RESOURCETSKDAY_NODE','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH DROP CONSTRAINT FK_F_RESOURCETSKMONTH_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH DROP CONSTRAINT FK_F_RESOURCETSKMONTH_NODE','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.spcontntlistbyprovdrassettyprr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.spcontntlistbyprovdrassettyprr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.spfailuretrendbyresgrouprr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.spfailuretrendbyresgrouprr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.spfailuretrendbyresourcerr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.spfailuretrendbyresourcerr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptavgqtimebyrgrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptavgqtimebyrgrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptavgtaskdurbyrgrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptavgtaskdurbyrgrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptdriveusagerr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptdriveusagerr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptexpiringcontentrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptexpiringcontentrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptmissingcontentrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptmissingcontentrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprpttitlepurgerr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprpttitlepurgerr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptworkordersrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptworkordersrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptwosforallprovrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptwosforallprovrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sprptwospurgerr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sprptwospurgerr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sptaskdetailsbyresourcerr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sptaskdetailsbyresourcerr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.spwoslicensewindowmissrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.spwoslicensewindowmissrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.spwosperpackageassetidrr';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.spwosperpackageassetidrr','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sp_filldate';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sp_filldate','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sp_fillmonth';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sp_fillmonth','Y') INTO tmp_result;

        vsql :=  'DROP PROCEDURE '||vschema||'.sp_filltime';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PROCEDURE '||vschema||'.sp_filltime','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE BODY '||vschema||'.pkg_admin';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE BODY '||vschema||'.pkg_admin','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE '||vschema||'.pkg_admin';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE '||vschema||'.pkg_admin','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE BODY '||vschema||'.pkg_dataagg';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE BODY '||vschema||'.pkg_dataagg','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE '||vschema||'.pkg_dataagg';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE '||vschema||'.pkg_dataagg','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE BODY '||vschema||'.pkg_dataload';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE BODY '||vschema||'.pkg_dataload','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE '||vschema||'.pkg_dataload';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE '||vschema||'.pkg_dataload','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE BODY '||vschema||'.pkg_metadata';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE BODY '||vschema||'.pkg_metadata','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE '||vschema||'.pkg_metadata';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE '||vschema||'.pkg_metadata','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE BODY '||vschema||'.pkg_reports';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE BODY '||vschema||'.pkg_reports','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE '||vschema||'.pkg_reports';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE '||vschema||'.pkg_reports','Y') INTO tmp_result;

        vsql :=  'drop FUNCTION '||vschema||'.FN_STR_WITH_SEPS(iStr varchar2, iSep varchar2)';
        SELECT CREATEOBJECT(vsql,'Unable to drop FUNCTION '||vschema||'.FN_STR_WITH_SEPS','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE BODY '||vschema||'.createwfsdwdb';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE BODY '||vschema||'.createwfsdwdb','Y') INTO tmp_result;

        vsql :=  'DROP PACKAGE '||vschema||'.createwfsdwdb';
        SELECT CREATEOBJECT(vsql,'Unable to DROP PACKAGE '||vschema||'.createwfsdwdb','Y') INTO tmp_result;

        select set_version(vschema,'2.7','6.0.0') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''')' into wk_release;
    IF (wk_release =  '6.0.0') THEN
        DECLARE
           procname text;
        BEGIN
           FOR procname IN (SELECT proname FROM pg_proc WHERE proowner IN (SELECT usesysid FROM pg_user WHERE usename='wfsdw') 
                              AND proname LIKE 'spsync%' OR proname LIKE 'spagg%' ORDER BY 1)
           LOOP
              BEGIN
                 EXECUTE 'drop function '||procname||'(int,int,int)';
              EXCEPTION
                 WHEN OTHERS THEN NULL;
              END;  
           END LOOP;
        END;
        select set_version(vschema,'6.0.0','6.0.1') into tmp_result;
    END IF;	

    EXECUTE 'SELECT get_version('''||vschema||''')' into wk_release;
    IF (wk_release IN ('6.0.1','6.0.2','6.0.3','6.0.4','6.0.5','6.0.6','6.0.7','6.0.8','6.0.9','6.0.10','6.0.11','6.0.12','6.0.13','6.0.14','6.0.15','6.0.16','6.1.0')) THEN
        select set_version(vschema,'6.0.0','6.1.1') into tmp_result;
    END IF;

    EXECUTE 'SELECT get_version('''||vschema||''')' into wk_release;
    IF (wk_release IN ('6.1.1','6.1.2')) THEN

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL DROP CONSTRAINT FACT_RESOURCEQUEUEDETAIL_PKEY';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL DROP CONSTRAINT FACT_RESOURCEQUEUEDETAIL_PKEY','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL ALTER COLUMN NODEWK DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL ALTER COLUMN NODEWK DROP NOT NULL','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL ADD CONSTRAINT fact_resourcequeuedetail_pkey PRIMARY KEY 
                    (templatewk, workorderwk, localenterdatewk, localentertimewk, resourcewk, resourcegroupwk, adminstatuswk, operstatuswk, lastruninstance)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL ADD CONSTRAINT fact_resourcequeuedetail_pkey','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL DROP CONSTRAINT FK_F_RESOURCEQUEDETAIL_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDETAIL DROP CONSTRAINT FK_F_RESOURCEQUEDETAIL_NODE','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY DROP CONSTRAINT FACT_RESOURCEQUEUEDAY_PKEY';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY DROP CONSTRAINT FACT_RESOURCEQUEUEDAY_PKEY','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY ALTER COLUMN NODEWK DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY ALTER COLUMN NODEWK DROP NOT NULL','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY ADD CONSTRAINT fact_resourcequeueday_pkey PRIMARY KEY 
                    (templatewk, workorderwk, resourcewk, resourcegroupwk, datewk, lastruninstance)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY ADD CONSTRAINT fact_resourcequeueday_pkey PRIMARY KEY','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY DROP CONSTRAINT FK_F_RESOURCEQUEDAY_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEDAY DROP CONSTRAINT FK_F_RESOURCEQUEDAY_NODE','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH DROP CONSTRAINT FACT_RESOURCEQUEUEMONTH_PKEY';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH DROP CONSTRAINT FACT_RESOURCEQUEUEMONTH_PKEY','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH ALTER COLUMN NODEWK DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH ALTER COLUMN NODEWK DROP NOT NULL','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH ADD CONSTRAINT fact_resourcequeuemonth_pkey PRIMARY KEY 
                    (templatewk, workorderwk, resourcewk, resourcegroupwk, monthwk, lastruninstance)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH ADD CONSTRAINT fact_resourcequeuemonth_pkey PRIMARY KEY','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH DROP CONSTRAINT FK_F_RESOURCEQUEMONTH_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCEQUEUEMONTH DROP CONSTRAINT FK_F_RESOURCEQUEMONTH_NODE','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL DROP CONSTRAINT FACT_RESOURCETASKDETAIL_PKEY';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL DROP CONSTRAINT FACT_RESOURCETASKDETAIL_PKEY','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL ALTER COLUMN NODEWK DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL ALTER COLUMN NODEWK DROP NOT NULL','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL ADD CONSTRAINT fact_resourcetaskdetail_pkey PRIMARY KEY 
                    (templatewk, workorderwk, localenterdatewk, localentertimewk, localleavedatewk, localleavetimewk, resourcewk, resourcegroupwk, adminstatuswk, operstatuswk, lastruninstance)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL ADD CONSTRAINT fact_resourcetaskdetail_pkey PRIMARY KEY','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL DROP CONSTRAINT FK_F_RESOURCETSKDETAIL_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDETAIL DROP CONSTRAINT FK_F_RESOURCETSKDETAIL_NODE','Y') INTO tmp_result;

          vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY DROP CONSTRAINT FACT_RESOURCETASKDAY_PKEY';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY DROP CONSTRAINT FACT_RESOURCETASKDAY_PKEY','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY ALTER COLUMN NODEWK DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY ALTER COLUMN NODEWK DROP NOT NULL','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY ADD CONSTRAINT fact_resourcetaskday_pkey PRIMARY KEY 
                    (templatewk, workorderwk, resourcewk, resourcegroupwk, datewk, lastruninstance)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY ADD CONSTRAINT fact_resourcetaskday_pkey PRIMARY KEY','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY DROP CONSTRAINT FK_F_RESOURCETSKDAY_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKDAY DROP CONSTRAINT FK_F_RESOURCETSKDAY_NODE','Y') INTO tmp_result;

          vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH DROP CONSTRAINT FACT_RESOURCETASKMONTH_PKEY';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH DROP CONSTRAINT FACT_RESOURCETASKMONTH_PKEY','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH ALTER COLUMN NODEWK DROP NOT NULL';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH ALTER COLUMN NODEWK DROP NOT NULL','Y') INTO tmp_result;

        vsql := 'ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH ADD CONSTRAINT fact_resourcetaskmonth_pkey PRIMARY KEY 
                    (templatewk, workorderwk, resourcewk, resourcegroupwk, monthwk, lastruninstance)';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH ADD CONSTRAINT fact_resourcetaskmonth_pkey PRIMARY KEY','Y') INTO tmp_result;

        vsql :=  'ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH DROP CONSTRAINT FK_F_RESOURCETSKMONTH_NODE';
        SELECT CREATEOBJECT(vsql,'Unable to ALTER TABLE '||vschema||'.FACT_RESOURCETASKMONTH DROP CONSTRAINT FK_F_RESOURCETSKMONTH_NODE','Y') INTO tmp_result;

        select set_version(vschema,'6.1.1','6.1.3') into tmp_result;
    END IF;
    EXECUTE 'SELECT get_version('''||vschema||''')' into wk_release;
    IF (wk_release = '6.1.3') THEN
        -- Changed the database version to CMS7.0 on 03/16/2018
        select set_version(vschema,'6.1.3',db_version) into tmp_result;
    END IF;

    EXECUTE 'INSERT INTO '||ischema||'.install_table (msgdate, install_message) values (now(),''Upgrading warehouse database to '||db_version||' completed SUCCESSFULLY'')';
    RETURN tmp_result;
EXCEPTION
    WHEN OTHERS THEN
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''Error in convertrm function : '')';
      EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''   '||sqlerrm||''')';
      return 1;
END;
$func_convertwfsdw$ LANGUAGE plpgsql;
  
CREATE OR REPLACE FUNCTION install_wfsdw () RETURNS integer AS $func_installwfsdw$
DECLARE
    tbl_count    smallint;
    vschema      varchar := 'wfsdw';
    func_results smallint;
    wk_release   varchar:='';    
    db_version   varchar := '7.0.0';
    ischema      text;
BEGIN
    EXECUTE 'EXECUTE get_inst_schema' INTO ischema;
    execute 'SELECT count(*) from pg_tables where schemaname ='''|| vschema||'''' into tbl_count;
    IF tbl_count = 0 THEN
      SELECT CREATEWFSDW(vschema,db_version) into func_results;
      UPDATE wfsdw.MD_LOCKABLEOBJECT SET lastsyncdate=to_date(to_char(current_date-7,'YYYY-MM-DD'),'YYYY-MM-DD 00:00:00') WHERE name NOT LIKE 'DIM%';
    ELSE
      EXECUTE 'SELECT get_version('''||vschema||''')' into wk_release;
      IF wfs.func_pad_zeros(wk_release) < wfs.func_pad_zeros(db_version)  THEN
         SELECT CONVERTWFSDW(vschema,db_version) into func_results;
      ELSIF wk_release = db_version  THEN
        EXECUTE 'Insert into '||ischema||'.install_table(install_message) values (''There are no database changes in Data WareHouse to upgrade'')';
      END IF;
    END IF;
    return func_results;
END;
$func_installwfsdw$ LANGUAGE plpgsql;

DO $$declare
   results    smallint;
begin
   SELECT INSTALL_WFSDW() into results;
end$$;
