/*
	*****************************************************************************
	PROCEDURE: spSYNC_WorkOrderStatus
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table DIM_WorkOrderStatus. (Type 1)

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Chris Scherlacher - 04/4/2007]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
--NOTE: Pending work: Bring new_sync_date common accross all the procs.

--1
DROP FUNCTION IF EXISTS spSYNC_WorkOrderStatus(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_WorkOrderStatus (
    parent_etl_process	int DEFAULT NULL,
    parent_run_instance	int DEFAULT NULL,
    force_lock		    int DEFAULT 0,
    nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_WorkOrderStatus$
DECLARE
    etl_process            int;
    run_instance           numeric;
    returned_error_status  numeric;
    lockable_object        int;
    procname               varchar (100);
    objectname             varchar (100);
    last_sync_date         timestamp;
    v_last_sync_date       timestamp;
    error_message          varchar (500);
    affected_rows          int;
    v_sqlcode              TEXT;
    error_status           int;
    tmp_results            numeric;
    ret                    record;
    new_sync_date          timestamp ;
    rec_cnt                numeric;
    excp_primary_msg       text;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_WorkOrderStatus';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 1;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * into returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, '' ); 

    IF run_instance < 1 OR returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname,'-1','','METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name
        INTO	lockable_object, objectname
        FROM	WFSDW.MD_ETLProcess p
        JOIN	WFSDW.MD_LockableObject o
        ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;

        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError ( etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) 
              INTO returned_error_status;
            RETURN error_status;
    END;
    -- ETL Metadata: lock this ETL Object!
    SELECT * into returned_error_status, v_last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    select v_last_sync_date into last_sync_date;
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN error_status;
    END IF;
    ---------------------
    -- Here we go!
    ---------------------
    -- Fill up the DIFF table!
BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_WorkOrderStatus;

        INSERT INTO WFSDW.STG1_DIFF_WorkOrderStatus 
              (ROWID_, ProcessStatusId, Name, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate, WFSCreateDate)
        SELECT nextval('STG1_DIFF_WORKORDERSTATUS_SEQ'), ProcessStatusId, Name, UpdateDate, etl_process, run_instance, new_sync_date, CreateDate
        FROM	WFS.TTV_ProcessStatus
        WHERE	UpdateDate BETWEEN last_sync_date AND new_sync_date;

        GET DIAGNOSTICS rec_cnt = ROW_COUNT;
        IF (rec_cnt = 0) THEN
            -- Source table has no new or updated records. No point in continuing...
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
            SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, 0) INTO returned_error_status;
            --COMMIT; 
            error_status := 0;
            RETURN error_status;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN
             v_sqlcode := SQLSTATE;
             GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
             error_message := procname || ': DB error loading STG_DIFF_WorkOrderStatus. Reason for the failure: '|| substring(excp_primary_msg,1,250);
             --raise notice 'At spSYNC_WorkOrderStatus....% - %', SQLSTATE,sqlerrm;
             --ROLLBACK;
             -- Release the object indicating that there was an error
             SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL,1,0) INTO returned_error_status;
             -- Close the etl process.
             SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
             RETURN error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
    ---------------------
    -- Merge data!
    ---------------------
    BEGIN
        UPDATE WFSDW.DIM_WorkOrderStatus d SET  Name = s.Name, 
                                                LastProdUpdateDate = s.LastProdUpdateDate, 
                                                UpdateDate = now()::timestamp
          FROM WFSDW.STG1_DIFF_WorkOrderStatus s WHERE d.ProcessStatusId = s.ProcessStatusId;

        INSERT INTO WFSDW.DIM_WorkOrderStatus 
        SELECT nextval('DIM_WORKORDERSTATUS_SEQ'), s.ProcessStatusId, s.Name, s.WFSCreateDate, 
               s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM WFSDW.STG1_DIFF_WorkOrderStatus s 
          LEFT OUTER JOIN WFSDW.DIM_WorkOrderStatus ON (DIM_WorkOrderStatus.ProcessStatusId = s.ProcessStatusId) 
         WHERE DIM_WorkOrderStatus.ProcessStatusId IS NULL;

        GET DIAGNOSTICS affected_rows = ROW_COUNT;
    EXCEPTION
       WHEN OTHERS THEN
         v_sqlcode := SQLSTATE;
         GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
         error_message := procname || ': DB error merging dimension DIM_WorkOrderStatus. Reason for the failure: '|| substring(excp_primary_msg,1,250);
         raise notice 'sqlstate=% errormsg=%',sqlstate, sqlerrm;
         --ROLLBACK;
         -- Release the object indicating that there was an error
         SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
         -- Close the etl process.
         SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
         RETURN error_status;
    END;
    SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN error_status;
EXCEPTION
    WHEN OTHERS THEN
        raise notice 'at exception.... %', sqlerrm;
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_WorkOrderStatus$ LANGUAGE plpgsql;

--2
/*
	*****************************************************************************
	PROCEDURE: spSYNC_Template
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table DIM_Template. (Type 1)

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Chris Scherlacher - 4/6/2007]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
DROP FUNCTION IF EXISTS spSYNC_Template(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_Template (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_Template$
DECLARE
        etl_process           int;
        run_instance          int;
        returned_error_status int;
        lockable_object       int;
        procname              varchar (100);
        objectname            varchar (100);
        last_sync_date        timestamp;
        error_message         varchar (500);
        affected_rows         int;
        v_sqlcode             TEXT;
        error_status          int;
        tmp_results           numeric;
        new_sync_date         timestamp ;
        vsql                  text;
        rec_cnt               numeric;
        excp_primary_msg      text;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_Template';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 5;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart (etl_process, parent_etl_process, parent_run_instance, NULL); 

    IF run_instance < 1 OR  returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog (procname,'-1','','METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name
        INTO	lockable_object, objectname
        FROM	wfsdw.MD_ETLProcess p
        JOIN	wfsdw.MD_LockableObject o
        ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError (etl_process,run_instance,'Couldn''t determine the LockableObjectLoaded!',affected_rows,NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);

    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN error_status;
    END IF;
    -----------------------------------------------------------------------------

    ---------------------
    -- Here we go!
    ---------------------

    -- Get the new sync date...
    --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.

    -- Fill up the DIFF table!
    BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_Template;
        INSERT INTO WFSDW.STG1_DIFF_Template (ROWID_, ProcessDefinitionId, Name, ProcessDefinitionTypeId, ProcessDefinitionTypeName,
                                              StartNodeId, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate, WFSCreateDate)
        SELECT	nextval('STG1_DIFF_TEMPLATE_SEQ'), a.Id, a.Name||' - v'||a.version, b.ProcessDefinitionTypeId, 
                b.Name, NULL , a.UpdateDate, etl_process, run_instance, new_sync_date, a.CreateDate -- a.startstate_
          FROM	WFS.TTV_Template a, WFS.TTV_ProcessDefinitionType b
         WHERE	b.ProcessDefinitionTypeId = a.TypeId
           AND  a.UpdateDate BETWEEN last_sync_date AND new_sync_date;

        GET DIAGNOSTICS rec_cnt = ROW_COUNT;
        IF (rec_cnt = 0) THEN
            -- Source table has no new or updated records. No point in continuing...
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
            SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, 0) INTO returned_error_status;
            --COMMIT; -- Yay!
            error_status := 0;
            RETURN error_status;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading STG_DIFF_Template. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            raise notice '...func_spSYNC_Template=> spMD_ReleaseObject... % %', SQLSTATE, SQLERRM;
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
    ---------------------
    -- Merge data!
    ---------------------
    BEGIN
        UPDATE WFSDW.DIM_Template d SET  Name = s.Name, ProcessDefinitionTypeId = s.ProcessDefinitionTypeId,
               ProcessDefinitionTypeName= s.ProcessDefinitionTypeName, StartNodeId= s.StartNodeId,
               LastProdUpdateDate = s.LastProdUpdateDate, UpdateDate = now()::timestamp
	FROM   WFSDW.STG1_DIFF_Template s
	WHERE  d.ProcessDefinitionId = s.ProcessDefinitionId;

	INSERT INTO WFSDW.DIM_Template
	SELECT nextval('DIM_TEMPLATE_SEQ'), s.ProcessDefinitionId, s.Name, s.ProcessDefinitionTypeId, s.ProcessDefinitionTypeName,
               s.StartNodeId, s.WFSCreateDate, s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
        FROM   WFSDW.STG1_DIFF_Template s
        LEFT OUTER JOIN WFSDW.DIM_Template ON (DIM_Template.ProcessDefinitionId = s.ProcessDefinitionId)
        WHERE DIM_Template.ProcessDefinitionId IS NULL;

        GET DIAGNOSTICS affected_rows = ROW_COUNT;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error merging dimension DIM_Template. Reason for the failure:'|| substring(excp_primary_msg,1,250);
            raise notice '...% %',SQLSTATE, SQLERRM;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;
    SELECT spMD_ReleaseObject(lockable_object,  etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN error_status;

EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
         -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_Template$ LANGUAGE plpgsql;  -- i.e., Template

--3
/*
	*****************************************************************************
	PROCEDURE: spSYNC_Node
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table DIM_Node. (Type 1)

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Suresh Neravati - 10/03/2006]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
/*
CREATE OR REPLACE FUNCTION spSYNC_Node (
    parent_etl_process				int DEFAULT NULL,
    parent_run_instance				int DEFAULT NULL,
    force_lock						int DEFAULT 0,
    nsync_date                      text)
RETURNS smallint AS $func_spSYNC_Node$
DECLARE
    etl_process					int;
    run_instance					int;
    returned_error_status			        int;
    lockable_object					int;
    procname					varchar (100);
    objectname					varchar (100);
    last_sync_date					timestamp;
    error_message					varchar (500);
    affected_rows					int;
    v_sqlcode					TEXT;
    recs_not_inserted				int;
    recs_to_insert					int;
    error_status                                    int;
    tmp_results                                     numeric;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_Node';
    affected_rows := 0;

    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 6;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT run_instance, returned_error_status FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL ) 
        AS ( run_instance int , returned_error_status int);
    IF run_instance < 1 OR  returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog(procname, '-1', '', 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN returned_error_status;
    END IF;
    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name
        INTO	lockable_object, objectname
        FROM	wfsdw.MD_ETLProcess p
        JOIN	wfsdw.MD_LockableObject o
        ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
             SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN returned_error_status;
        END IF;

    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
        END;

        -- ETL Metadata: lock this ETL Object!
        SELECT  returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0) AS ( returned_error_status int, last_sync_date timestamp);
        IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
            RETURN returned_error_status;
    END IF;
        -----------------------------------------------------------------------------

    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.
    -- Fill up the DIFF table!
    BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_Node;
        INSERT INTO WFSDW.STG1_DIFF_Node(ROWID_, NodeId, NodeClass, Name, NodeIndex, TaskId, TaskName, IsStartNode, 
                    TaskControllerId, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate, WFSCreateDate)
        SELECT  nextval('STG1_DIFF_Node_SEQ'), n.ID_ as NodeId, DECODE (n.CLASS_,'D', 'DECISION', 'E', 'END', 'R', 'START', 'Y', 'MANUAL', 'Z', 'AUTOMATED', 'UNKNOWN') as NodeClass,
                n.NAME_ as NodeName, n.NODECOLLECTIONINDEX_ as NodeIndex, t.ID_ as TaskId, t.NAME_ as TaskName, (case when coalesce(t.STARTSTATE_,-1)=-1 then 0 else 1 end ) as IsStartNode,
                t.TASKCONTROLLER_ as TaskControllerId, n.UpdateDate, etl_process, run_instance, new_sync_date, n.CreateDate
        FROM    WFS.JBPM_NODE n
        LEFT JOIN WFS.JBPM_TASK t ON (t.TASKNODE_ = n.ID_ OR t.STARTSTATE_ = n.ID_) 
        WHERE  n.UpdateDate BETWEEN last_sync_date AND new_sync_date;
*/
/*            INSERT INTO WFSDW.STG1_DIFF_Node(ROWID_,
                                             NodeId,
                                             NodeClass,
                                             Name,
                                             NodeIndex,
                                             TaskId,
                                             TaskName,
                                             IsStartNode,
                                             TaskControllerId,
                                             LastProdUpdateDate,
                                             DIFFETLProcess,
                                             DIFFRunInstance,
                                             DIFFDate,
                                             WFSCreateDate)
            SELECT  nextval('STG1_DIFF_Node_SEQ'),
                    NodeId,
                    NodeClass,
                    NodeName,
                    NodeIndex,
                    TaskId,
                    TaskName,
                    IsStartNode,
                    TaskControllerId,
                    UpdateDate,
                    etl_process,
                    run_instance,
                    new_sync_date,
                    CreateDate
              FROM  WFS.vDW_Node
             WHERE  UpdateDate BETWEEN last_sync_date AND new_sync_date;
*/
/*
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': DB error loading STG_DIFF_Node!';
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN returned_error_status;
    END;

      -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
      -- occur due to problematic data in STG_DIFF.
      --COMMIT;
      ---------------------
      -- Merge data!
      ---------------------
    BEGIN
        UPDATE WFSDW.DIM_Node d SET d.NodeClass = s.NodeClass, d.Name = s.Name, d.NodeIndex = s.NodeIndex, d.TaskId = s.TaskId, 
                                    d.TaskName = s.TaskName, d.IsStartNode = s.IsStartNode, d.TaskControllerId = s.TaskControllerId, 
                                    d.LastProdUpdateDate = s.LastProdUpdateDate, d.UpdateDate = now()::timestamp
          FROM WFSDW.STG1_DIFF_Node s
          WHERE d.NodeId = s.NodeId;

        INSERT INTO WFSDW.DIM_Node
        SELECT nextval('DIM_NODE_SEQ'), s.NodeId, s.NodeClass, s.Name, s.NodeIndex, s.TaskId, s.TaskName, s.IsStartNode, s.TaskControllerId,
               s.WFSCreateDate, s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM WFSDW.STG1_DIFF_Node s
          LEFT OUTER JOIN WFSDW.DIM_Node ON (DIM_Node.NodeId = S.NodeId)
         WHERE DIM_Node.NodeId IS NULL;

        GET DIAGNOSTICS affected_rows = ROW_COUNT;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            error_message := procname || ': DB error merging dimension DIM_Node!';
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN returned_error_status;
    END;

    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN returned_error_status;
EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;

END;
$func_spSYNC_Node$ LANGUAGE plpgsql;
*/
--4
/*
	*****************************************************************************
	PROCEDURE: spSYNC_Resource
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table DIM_Resource.

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Suresh Neravati - 09/29/2006]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
--4
DROP FUNCTION IF EXISTS spSYNC_Resource(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_Resource (
    parent_etl_process  int DEFAULT NULL,
    parent_run_instance int DEFAULT NULL,
    force_lock          int DEFAULT 0,
    nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_Resource$
DECLARE
    etl_process           int;
    run_instance          int;
    returned_error_status int;
    lockable_object       int;
    procname              varchar (100);
    objectname            varchar (100);
    last_sync_date        timestamp;
    error_message         varchar (500);
    affected_rows         int;
    v_sqlcode             text;
    recs_not_inserted     int;
    recs_to_insert        int;
    error_status          int;
    tmp_results           numeric;
    new_sync_date         timestamp ;
    rec_cnt               numeric;
    excp_primary_msg      text;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_Resource';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 3;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);

    IF run_instance < 1 OR  returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog(procname, '-1','', 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN error_status;
    END IF;

    BEGIN
       -- Get the object ID in order to lock it...
        SELECT LockableObjectLoaded, o.Name INTO lockable_object, objectname 
        FROM   wfsdw.MD_ETLProcess p
        JOIN   wfsdw.MD_LockableObject o ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE  ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
             SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
             RETURN error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * into returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
        RETURN error_status;
    END IF;
    -----------------------------------------------------------------------------
    ---------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.

    -- Fill up the DIFF table!
    BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_Resource;

        INSERT INTO WFSDW.STG1_DIFF_Resource(ROWID_, ResourceId, ResourceName,ResourceTypeId, ResourceTypeName, Isactive,
                                             WFSCreateDate, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate)
        SELECT  nextval('STG1_DIFF_RESOURCE_SEQ'), v.ResourceId, v.ResourceName, v.ResourceTypeId, v.ResourceTypeName,
                v.Isactive, v.CreateDate, v.UpdateDate, etl_process, run_instance, new_sync_date
	FROM  ( SELECT r.ResourceId, r.Name as ResourceName, rt.ResourceTypeId, rt.Name as ResourceTypeName, r.Isactive, r.CreateDate, r.UpdateDate
      		  FROM WFS.TTV_Resource r
                  JOIN WFS.TTV_ResourceType rt
                    ON r.ResourceTypeId = rt.ResourceTypeId) v
	WHERE UpdateDate BETWEEN last_sync_date AND new_sync_date;

    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading STG_DIFF_Resource. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;

    ---------------------
    -- Merge data!
    ---------------------
    BEGIN
        UPDATE WFSDW.DIM_Resource d SET ResourceName = s.ResourceName, ResourceTypeId=s.ResourceTypeId, ResourceTypeName = s.ResourceTypeName,
                                        Isactive=s.Isactive, LastProdUpdateDate = s.LastProdUpdateDate, UpdateDate = now()::timestamp
          FROM WFSDW.STG1_DIFF_Resource s
         WHERE d.ResourceId = s.ResourceId;

        INSERT INTO WFSDW.DIM_Resource
        SELECT nextval('DIM_RESOURCE_SEQ'), s.ResourceId, s.ResourceName, s.ResourceTypeId, s.ResourceTypeName, s.Isactive, 
               s.WFSCreateDate, s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM WFSDW.STG1_DIFF_Resource s
          LEFT OUTER JOIN WFSDW.DIM_Resource ON (DIM_Resource.ResourceId = S.ResourceId)
         WHERE DIM_Resource.ResourceId IS NULL;

        GET DIAGNOSTICS affected_rows = ROW_COUNT;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error merging dimension DIM_Resource. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN error_status;
EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_Resource$ LANGUAGE plpgsql;

--5
/*
    ****************************************************************************
        PROCEDURE: spSYNC_ResourceGroup
        [ETL - MD Compliant]
    *****************************************************************************
        Loads dimension table DIM_ResourceGroup.
    *****************************************************************************
        [USED BY]	ETL - DW Load process
    *****************************************************************************
        [By Chris Scherlacher - 04/09/2007]
    *****************************************************************************
        Change Log:

    *****************************************************************************
*/
DROP FUNCTION IF EXISTS spSYNC_ResourceGroup(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_ResourceGroup (
    parent_etl_process  int DEFAULT NULL,
    parent_run_instance int DEFAULT NULL,
    force_lock          int DEFAULT 0,
    nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_ResourceGroup$
DECLARE
    etl_process           int;
    run_instance          int;
    returned_error_status int;
    lockable_object       int;
    procname              varchar (100);
    objectname            varchar (100);
    last_sync_date        timestamp;
    error_message         varchar (500);
    affected_rows         int;
    v_sqlcode             TEXT;
    recs_not_inserted     int;
    recs_to_insert        int;
    error_status          int;
    tmp_results           numeric;
    new_sync_date         timestamp;
    excp_primary_msg      text;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_ResourceGroup';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 4;
    -----------------------------------------------------------------------------

    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);

    IF run_instance < 1 OR  returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog(procname, '-1','', 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name
        INTO	lockable_object, objectname
        FROM	wfsdw.MD_ETLProcess p
        JOIN	wfsdw.MD_LockableObject o ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
        END IF;

    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object,  etl_process,  run_instance,  force_lock, 0);

    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN error_status;
    END IF;
    -----------------------------------------------------------------------------
    -- Here we go!
    ---------------------
    -- Get the new sync date...
    --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.
    -- Fill up the DIFF table!
    BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_ResourceGroup;
        INSERT INTO WFSDW.STG1_DIFF_ResourceGroup(ROWID_,  ResourceGroupId,  ResourceGroupName,  ResourceTypeId,  ResourceTypeName,  AccessLevelId,
                                                  AccessLevelName,  WFSCreateDate,  LastProdUpdateDate,  DIFFETLProcess,  DIFFRunInstance,  DIFFDate)
        SELECT	nextval('STG1_DIFF_RESOURCEGROUP_SEQ'), v.ResourceGroupId, v.ResourceGroupName, v.ResourceTypeId, v.ResourceTypeName,
                v.AccessLevelId,v.AccessLevelName, v.CreateDate, v.UpdateDate, etl_process, run_instance, new_sync_date
        FROM (SELECT rg.ResourceGroupId, rg.Name as ResourceGroupName, rt.ResourceTypeId, rt.Name as ResourceTypeName,
                     a.AccessLevelId, a.Name as AccessLevelName, rg.CreateDate, rg.UpdateDate
                FROM WFS.TTV_ResourceGroup rg
                JOIN WFS.TTV_ResourceType rt ON rg.ResourceTypeId = rt.ResourceTypeId
                JOIN WFS.TTV_AccessLevel a ON rg.AccessLevelId = a.AccessLevelId) v
        WHERE v.UpdateDate > last_sync_date AND v.CreateDate < new_sync_date;

    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading STG_DIFF_ResourceGroup. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
    ---------------------
    -- Merge data!
    ---------------------
    BEGIN
        UPDATE WFSDW.DIM_ResourceGroup d SET ResourceGroupName = s.ResourceGroupName, ResourceTypeId = s.ResourceTypeId,
                                             ResourceTypeName = s.ResourceTypeName, AccesslevelId = s.AccesslevelId,
                                             AccessLevelName = s.AccessLevelName, LastProdUpdateDate = s.LastProdUpdateDate,
                                             UpdateDate = now()::timestamp
          FROM WFSDW.STG1_DIFF_ResourceGroup s
         WHERE d.ResourceGroupId = s.ResourceGroupId;

        INSERT INTO WFSDW.DIM_ResourceGroup
        SELECT nextval('DIM_RESOURCEGROUP_SEQ'), s.ResourceGroupId, s.ResourceGroupName, s.ResourceTypeId, s.ResourceTypeName, s.AccesslevelId,
               s.AccessLevelName, s.WFSCreateDate, s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM WFSDW.STG1_DIFF_ResourceGroup s
          LEFT OUTER JOIN WFSDW.DIM_ResourceGroup ON (DIM_ResourceGroup.ResourceGroupId = S.ResourceGroupId)
         WHERE DIM_ResourceGroup.ResourceGroupId IS NULL;

        GET DIAGNOSTICS affected_rows = ROW_COUNT;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error merging dimension DIM_ResourceGroup. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN error_status;
EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_ResourceGroup$ LANGUAGE plpgsql;

--6
/*
	*****************************************************************************
	PROCEDURE: spSYNC_VariableInstance
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table FACT_VariableInstance.

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Suresh Neravati - 10/05/2006]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
DROP FUNCTION IF EXISTS spSYNC_VariableInstance(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_VariableInstance (
    parent_etl_process  int DEFAULT NULL,
    parent_run_instance int DEFAULT NULL,
    force_lock          int DEFAULT 0,
    nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_VariableInstance$
DECLARE
    etl_process           int;
    run_instance          int;
    returned_error_status int;
    lockable_object       int;
    procname              varchar (100);
    objectname            varchar (100);
    last_sync_date        timestamp;
    error_message         varchar (500);
    affected_rows         int;
    v_sqlcode             TEXT;
    recs_not_inserted     int;
    recs_to_insert        int;
    error_status          int;
    tmp_results           numeric;
    new_sync_date         timestamp ;
    excp_primary_msg      text;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_VariableInstance';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 9;
    -----------------------------------------------------------------------------

    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);

    IF run_instance < 1 OR  returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog(procname, '-1','', 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT LockableObjectLoaded, o.Name INTO lockable_object, objectname
          FROM wfsdw.MD_ETLProcess p
          JOIN wfsdw.MD_LockableObject o ON ( o.LockableObjectKey = p.LockableObjectLoaded )
         WHERE ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT  * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0); 

    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN error_status;
    END IF;

    -----------------------------------------------------------------------------
    -- Get the new sync date...
    --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.
    -- Fill up the DIFF table!
    BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_VariableInstance;
        INSERT INTO WFSDW.STG1_DIFF_VariableInstance(ROWID_, VariableInstanceName, VariableInstanceValue, WFSCreateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate)
          SELECT nextval('STG1_DIFF_VariableInstance_SEQ'), VariableInstanceName, VariableInstanceValue, CREATEDATE, etl_process, run_instance, new_sync_date
           FROM (SELECT 'providerId' AS VariableInstanceName,(vars->'providerId'->>'value')::text AS variableinstancevalue, min(createdate) AS CREATEDATE
                   FROM WFS.TTV_TOKEN 
                  WHERE (vars->>'providerId') is not null
                    AND UpdateDate BETWEEN last_sync_date AND new_sync_date
                  GROUP BY (vars->'providerId'->>'value')::text
                 UNION
                 SELECT 'packageAssetId' AS VariableInstanceName,(vars->'packageAssetId'->>'value')::text AS variableinstancevalue, min(createdate) AS CREATEDATE
                   FROM WFS.TTV_TOKEN
                  WHERE (vars->>'packageAssetId') is not null 
                    AND UpdateDate BETWEEN last_sync_date AND new_sync_date
                  GROUP BY (vars->'packageAssetId'->>'value')::text) AS A;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading STG_DIFF_VariableInstance. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;
    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
    ---------------------
    -- Merge data!
    ---------------------
    BEGIN
        INSERT INTO wfsdw.DIM_VARIABLEINSTANCE(VariableInstanceWK, VariableInstanceName, VariableInstanceValue, 
                                               WFSCreateDate, LastETLProcess, LastRunInstance, CreateDate, UpdateDate)
        SELECT nextval('DIM_VARIABLEINSTANCE_SEQ'), VariableInstanceName, VariableInstanceValue, WFSCreateDate,
               etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM wfsdw.STG1_DIFF_VARIABLEINSTANCE
	 WHERE (VARIABLEINSTANCENAME,VARIABLEINSTANCEVALUE) NOT IN (SELECT VARIABLEINSTANCENAME,VARIABLEINSTANCEVALUE
                                                                               FROM wfsdw.DIM_VARIABLEINSTANCE);
        GET DIAGNOSTICS affected_rows = ROW_COUNT;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error merging dimension DIM_VariableInstance. Reason for the failure: ' || substring(excp_primary_msg,1,250);
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN error_status;
EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_VariableInstance$ LANGUAGE plpgsql;

--7
/*
	*****************************************************************************
	PROCEDURE: spSYNC_WorkOrder
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table FACT_WorkOrder.

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Chris Scherlacher - 04/10/2007]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
DROP FUNCTION IF EXISTS spSYNC_WorkOrder(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_WorkOrder (
    parent_etl_process  int DEFAULT NULL,
    parent_run_instance int DEFAULT NULL,
    force_lock          int DEFAULT 0,
    nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_WorkOrder$
DECLARE
    etl_process           int;
    run_instance          int;
    returned_error_status int;
    lockable_object       int;
    procname              varchar (100);
    objectname            varchar (100);
    last_sync_date        timestamp;
    error_message         varchar (500);
    affected_rows         int;
    v_sqlcode             TEXT;
    recs_not_inserted     int;
    recs_to_insert        int;
    error_status          int;
    tmp_results           numeric;
    new_sync_date         timestamp ;
    excp_primary_msg      text;
BEGIN
    -- Initialize...
    error_status := -1;
    procname := 'spSYNC_WorkOrder';
    affected_rows := 0;
    SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;

    -----------------------------------------------------------------------------
    -- [ETL METADATA INFO]
    -- Unique identifier for this ETL Process, DO NOT CHANGE!
    etl_process := 7;
    -----------------------------------------------------------------------------
    -- [ETL METADATA INITIALIZATION]
    -- Obtain a RunInstance for this ETL Process
    SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL);
    IF run_instance < 1 OR  returned_error_status <> 0 THEN
        SELECT spMD_WriteEventLog(procname, '-1','', 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
        RETURN error_status;
    END IF;

    BEGIN
        -- Get the object ID in order to lock it...
        SELECT	LockableObjectLoaded, o.Name INTO lockable_object, objectname
        FROM	wfsdw.MD_ETLProcess p
        JOIN	wfsdw.MD_LockableObject o ON (	o.LockableObjectKey = p.LockableObjectLoaded)
        WHERE	ETLProcessKey = etl_process;

        -- Not null, etc.
        IF lockable_object IS NULL OR objectname IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
        END IF;

    EXCEPTION
        WHEN OTHERS THEN -- No data found, for instance...
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
    END;

    -- ETL Metadata: lock this ETL Object!
    SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0); 

    IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
          INTO returned_error_status;
        RETURN error_status;
    END IF;
    -----------------------------------------------------------------------------
    -- Get the new sync date...
    --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.
    -- Fill up the DIFF table!
    BEGIN
        TRUNCATE TABLE WFSDW.STG1_DIFF_WorkOrder;
        INSERT INTO WFSDW.STG1_DIFF_WorkOrder(ROWID_, ProcessInstanceId, LocalStartDate, LocalEndDate, IssuSpended, ProcessDefinitionId, 
                                              AdminStatusId, OperStatusId, PriorityId, Priority, ProviderName, PackageAssetID, Title, BriefTitle, 
                                              AssetID, ObjectType, HouseMaterialID, BroadcastMaterialID, LicenseStart, LicenseEnd, LicenseStartDate, 
                                              LicenseEndDate, WFSCreateDate, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate)
         SELECT nextval('STG1_DIFF_WorkOrder_SEQ'), PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, PROCESSDEFINITIONID, ADMINSTATUSID, OPERSTATUSID, 
                PRIORITYID, PRIORITY, PROVIDERNAME, PACKAGEASSETID, TITLE, BRIEFTITLE, ASSETID, OBJECTTYPE, HOUSEMATERIALID, BROADCASTMATERIALID, 
                LICENSESTART, LICENSEEND, TO_TIMESTAMP(LicenseStartDate,'YYYY-MM-DD HH24:MI:SS'), TO_TIMESTAMP(LicenseEndDate,'YYYY-MM-DD HH24:MI:SS'), 
                CREATEDATE, UPDATEDATE, etl_process, run_instance, new_sync_date
           FROM (SELECT wo.processid AS PROCESSINSTANCEID,
                        t.startdate AS LOCALSTARTDATE,
                        t.enddate AS LOCALENDDATE,
                        0 AS ISSUSPENDED,                         -- JBPM_PROCESSINSTANCE.ISSUSPENDED_
                        wo.templateid AS PROCESSDEFINITIONID,
                        t.adminstatus AS ADMINSTATUSID,           -- JBPM_PROCESSINSTANCE.ADMINISTRATIVEPROCESSSTATUSID
                        t.operationalstatus AS OPERSTATUSID,      -- JBPM_PROCESSINSTANCE.OPERATIONALPROCESSSTATUSID
                        wo.priority PRIORITYID,                   -- JBPM_PROCESSINSTANCE.PROCESSPRIORITYID
                        COALESCE(P.NAME, '[N/A]') AS PRIORITY,
                        (t.vars->'providerId'->>'value') AS ProviderName,
                        (t.vars->'packageAssetId'->>'value') AS PackageAssetID,
                        (t.vars->'titleId'->>'value') AS Title,                             -- it was title
                        (t.vars->'titleBrief'->>'value') AS BriefTitle,
                        (t.vars->'assetId'->>'value') AS AssetID,
                        (t.vars->'typeString'->>'value') AS ObjectType,                     -- it was type
                        (t.vars->'houseMaterialId'->>'value') AS HouseMaterialID,           -- not found
                        (t.vars->'broadcastMaterialId'->>'value') AS BroadcastMaterialID,   -- not found
                        (t.vars->'licensingWindowStart'->>'value') AS LicenseStart,         -- it was licStart
                        (t.vars->'licensingWindowEnd'->>'value') AS LicenseEnd,             -- it was licEnd
                        replace((t.vars->'licensingWindowStart'->>'value'),'T',' ') AS LicenseStartDate,     -- it was licStart
                        replace((t.vars->'licensingWindowEnd'->>'value'),'T',' ') AS LicenseEndDate,         -- it was licEnd
                        wo.createdate,
                        CASE WHEN wo.updatedate > t.updatedate THEN wo.updatedate ELSE t.updatedate END AS UPDATEDATE
                      FROM WFS.TTV_PROCESSINSTANCE wo
                      JOIN WFS.TTV_TEMPLATE TP ON (TP.ID = wo.templateid)
                      JOIN WFS.TTV_ProcessDefinitionType dt ON (dt.ProcessDefinitionTypeId = tp.TypeId)
                      LEFT JOIN WFS.TTV_PROCESSPRIORITY P ON (P.PROCESSPRIORITYID = wo.PRIORITY)
                      JOIN ( select t1.tokenid, t1.parenttokenid, t1.processid, 0,t1.adminstatus, t1.operationalstatus, t1.startdate, t1.enddate, t1.vars, t1.updatedate 
                               from wfs.ttv_token t1 where t1.parenttokenid = 0
                             union all
                             select t1.tokenid, t1.parenttokenid, t1.processid, t2.processid, t1.adminstatus, t1.operationalstatus, t1.startdate, t1.enddate, t1.vars, t1.updatedate  
                               from wfs.ttv_token t1, wfs.ttv_token t2 
                              where t1.parenttokenid = t2.tokenid and (t1.processid <> t2.processid)
                            ) t on ( wo.PROCESSID = t.PROCESSID ) 
                      --JOIN WFS.TTV_TOKEN t ON ( wo.PROCESSID = t.PROCESSID AND t.parenttokenid = 0)-- AND t.adminstatus NOT IN (2,6) --AND (vi.TASKINSTANCE_ is null)
                      JOIN WFS.TTV_PROCESSSTATUS ADS ON (ADS.PROCESSSTATUSID = t.adminstatus)
                      JOIN WFS.TTV_PROCESSSTATUS OPS ON (OPS.PROCESSSTATUSID = t.operationalstatus)
                  WHERE (wo.UpdateDate BETWEEN last_sync_date AND new_sync_date OR t.UpdateDate BETWEEN last_sync_date AND new_sync_date)
                     --AND PROCESSINSTANCETYPEID <> 1  
                  ORDER BY wo.processid
                  ) AS A;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading STG_DIFF_WorkOrder. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            raise notice 'ERROR.....%  :  %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    BEGIN
        -- Lookup the TemplateWK field from DIM_Template table data.
        UPDATE WFSDW.STG1_DIFF_WorkOrder a
        SET TemplateWK= (SELECT b.TemplateWK
                           FROM wfsdw.DIM_Template b
                           WHERE b.ProcessDefinitionId = a.ProcessDefinitionId);
        --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        --Replace NULL Provider name with 'N/A'
        UPDATE  WFSDW.STG1_DIFF_WORKORDER
        SET     PROVIDERNAME = 'N/A'
        WHERE   PROVIDERNAME IS NULL OR PROVIDERNAME = '';

        --Replace NULL PackageAssedID with 'N/A'
        UPDATE  WFSDW.STG1_DIFF_WORKORDER
        SET     PACKAGEASSETID = 'N/A'
        WHERE   PACKAGEASSETID IS NULL OR PACKAGEASSETID = '';

        -- Lookup the ProviderWK from DIM_VariableInstance table data.
        UPDATE WFSDW.STG1_DIFF_WORKORDER a
        SET ProviderWK = (SELECT b.VariableInstanceWK
                            FROM wfsdw.DIM_PROVIDER b
                            WHERE b.ProviderName = a.ProviderName);
        --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        -- Set the LocalStartDateWK
        UPDATE WFSDW.STG1_DIFF_WORKORDER
        SET LocalStartDateWK = (to_char(LocalStartDate,'YYYYMMDD'))::numeric;
        --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        -- Lookup the LocalStartTimeWK
        UPDATE WFSDW.STG1_DIFF_WORKORDER
        SET LocalStartTimeWK = (to_char(LocalStartDate,'HH24MISS'))::numeric;
        --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        -- Convert License Dates
        -- We try to Load this from the dateValue_ column in the JBPM_VariableInstance
        -- If it was null I will try to load it from the StringValue_ column

        UPDATE WFSDW.STG1_DIFF_WORKORDER
        SET LicenseStartDate = case when substr(LicenseStart,5,1) = '-' then 
                                           case when substr(LicenseStart,11,1) = 'T' then 
                                              to_timestamp(substr(LicenseStart,1,10)||' '||substr(LicenseStart,12),'RRRR-MM-DD HH24:MI:SS')::TIMESTAMP WITHOUT TIME ZONE
                                           else 
                                               to_date(LicenseStart,'RRRR-MM-DD')
                                           end 
                                else
                                    to_date(LicenseStart,'MM/DD/RRRR')
                                end ,
            LicenseEndDate = case when substr(LicenseEnd,5,1) = '-' then 
                                           case when substr(LicenseEnd,11,1) = 'T' then 
                                              to_timestamp(substr(LicenseEnd,1,10)||' '||substr(LicenseEnd,12),'RRRR-MM-DD HH24:MI:SS')::TIMESTAMP WITHOUT TIME ZONE  
                                           else 
                                               to_date(LicenseEnd,'RRRR-MM-DD')
                                           end 
                                else
                                    to_date(LicenseEnd,'MM/DD/RRRR')
                                end 
        WHERE (LicenseEndDate IS NULL OR LicenseStartDate IS NULL)
        AND   LicenseStart IS NOT NULL
        AND   LicenseEnd   IS NOT NULL
        AND   LicenseStart <> ' '
        AND   LicenseEnd   <> ' ';

	-- Lookup the AdminStatusWK
        UPDATE WFSDW.STG1_DIFF_WORKORDER a
        SET AdminStatusWK = ( SELECT b.WorkOrderStatusWK
                                FROM wfsdw.DIM_WORKORDERSTATUS b
                                WHERE b.ProcessStatusID = a.AdminStatusID);
        --WHERE LastProdUpdateDate BETWEEN last_sync_date AND new_sync_date;

	-- Lookup the OperStatusWK
        UPDATE WFSDW.STG1_DIFF_WORKORDER a
        SET OperStatusWK = (  SELECT b.WorkOrderStatusWK
                                FROM wfsdw.DIM_WORKORDERSTATUS b
                                WHERE b.ProcessStatusID = a.OperStatusID);
        --WHERE LastProdUpdateDate BETWEEN last_sync_date AND new_sync_date;

    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error updating STG_DIFF_WorkOrder. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            raise notice 'ERROR.....%  :  %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
    -- occur due to problematic data in STG_DIFF.
    --COMMIT;
    BEGIN
    ---------------------
    -- Merge Dimension data!
    ---------------------

        UPDATE WFSDW.DIM_WorkOrder d SET  Suspended =  ( case when s.IssuSpended = 1 then 'YES' else 'NO' end ), 
                                          Priority = s.Priority, localstartdate = s.localstartdate,localenddate = s.localenddate, 
                                          PackageAssetID = s.PackageAssetID, AssetID = s.AssetID, AssetType = s.ObjectType, Title = s.Title, 
                                          BriefTitle = s.BriefTitle, HouseMaterialID = s.HouseMaterialID, BroadcastMaterialID = s.BroadcastMaterialID,
                                          LicenseStartDate =s.LicenseStartDate, LicenseEndDate = s.LicenseEndDate, LastProdUpdateDate = s.LastProdUpdateDate,
                                          LastETLProcess = etl_process, LastRunInstance = run_instance, UpdateDate = now()::timestamp
          FROM WFSDW.STG1_DIFF_WorkOrder s
         WHERE d.ProcessInstanceId = s.ProcessInstanceId;

        INSERT INTO WFSDW.DIM_WorkOrder
        SELECT nextval('DIM_WorkOrder_SEQ'), s.ProcessInstanceId, ( case when s.IssuSpended = 1 then 'YES' else 'NO' end), s.Priority, s.localstartdate, 
               s.localenddate, s.PackageAssetID, s.AssetID, s.ObjectType, s.Title, s.BriefTitle, s.HouseMaterialID, s.BroadcastMaterialID, 
               s.LicenseStartDate, s.LicenseEndDate, s.WFSCreateDate, s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
          FROM WFSDW.STG1_DIFF_WorkOrder s
          LEFT OUTER JOIN WFSDW.DIM_WorkOrder ON (DIM_WorkOrder.ProcessInstanceId = S.ProcessInstanceId)
         WHERE DIM_WorkOrder.ProcessInstanceId IS NULL;
        GET DIAGNOSTICS affected_rows = ROW_COUNT;

    ---------------------
    -- Load Fact data!
    ---------------------
    
        INSERT INTO wfsdw.FACT_WORKORDERDETAIL(WorkOrderWK, TemplateWK, ProviderWK, LocalStartDateWK, LocalStartTimeWK, AdminStatusWK, OperStatusWK,
                                               WFSCreateDate, LastProdUpdateDate, LastETLProcess, LastRunInstance, CreateDate, UpdateDate)
        SELECT dim.WorkOrderWK, stg.TemplateWK, stg.ProviderWK, stg.LocalStartDateWK, stg.LocalStartTimeWK, stg.AdminStatusWK, stg.OperStatusWK,
               stg.WFSCreateDate, stg.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
        FROM WFSDW.STG1_DIFF_WORKORDER stg
        JOIN WFSDW.DIM_WORKORDER dim ON (dim.ProcessInstanceId = stg.ProcessInstanceId)
        WHERE stg.WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        UPDATE wfsdw.FACT_WORKORDERDETAIL wod
           SET AdminStatusWK = stgwo.AdminStatusWK, 
	       OperStatusWK = stgwo.OperStatusWK,
	       LastProdUpdateDate = stgwo.LastProdUpdateDate, 
               updatedate = now()::timestamp
        FROM (SELECT  stg.AdminStatusWK, stg.OperStatusWK, stg.LastProdUpdateDate, now()::timestamp, dim.WorkOrderWK
                FROM  WFSDW.STG1_DIFF_WORKORDER stg
                JOIN  WFSDW.DIM_WORKORDER dim ON(dim.ProcessInstanceId = stg.ProcessInstanceId)
               WHERE  stg.WFSCreateDate < last_sync_date
                 AND  stg.LastProdUpdateDate   BETWEEN last_sync_date AND new_sync_date) stgwo
        WHERE wod.WorkOrderWK = stgwo.WorkOrderWK;
        
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading WorkOrder Data. Reason for the failure: '|| substring(excp_primary_msg,1,250);
            raise notice 'ERROR.....%  :  %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;

    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
    SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
    --COMMIT; -- Yay!
    error_status := 0;
    RETURN error_status;
EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        raise notice 'SQLSTATE=%, SQLERRM=%',SQLSTATE, SQLERRM;
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_WorkOrder$ LANGUAGE plpgsql;

--8
/*
	*****************************************************************************
	PROCEDURE: spSYNC_Log
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table FACT_Log.

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Chris Scherlacher - 04/10/2007]
	*****************************************************************************
	Change Log:

	*****************************************************************************
*/
DROP FUNCTION IF EXISTS spSYNC_Log(integer,integer,integer,text);
  CREATE OR REPLACE FUNCTION spSYNC_Log (
        parent_etl_process  int DEFAULT NULL,
        parent_run_instance int DEFAULT NULL,
        force_lock          int DEFAULT 0,
        nsync_date          text default '')
  RETURNS smallint AS $func_spSYNC_Log$
  DECLARE
        etl_process             int;
        run_instance            int;
        returned_error_status   int;
        lockable_object         int;
        procname                varchar (100);
        objectname              varchar (100);
        last_sync_date          timestamp;
        error_message           varchar (500);
        excp_primary_msg        text;
        affected_rows           int;
        v_sqlcode               text;
        recs_not_inserted       int;
        recs_to_insert          int;
        error_status            int;
        tmp_results             numeric;
        new_sync_date           timestamp ;
  BEGIN
        -- Initialize...
        error_status := -1;
        procname := 'spSYNC_Log';
        affected_rows := 0;
        SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
        -----------------------------------------------------------------------------
        -- [ETL METADATA INFO]
        -- Unique identifier for this ETL Process, DO NOT CHANGE!
        etl_process := 10;
        -----------------------------------------------------------------------------
        -- [ETL METADATA INITIALIZATION]
        -- Obtain a RunInstance for this ETL Process
        SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL );
        IF run_instance < 1 OR  returned_error_status <> 0 THEN
            SELECT spMD_WriteEventLog(procname, '-1', '', 'METADATA ERROR: error in call to spMD_LogProcessStart / could not obtain a RunInstance. Exiting procedure!');
            RETURN error_status;
        END IF;

        BEGIN
            -- Get the object ID in order to lock it...
            SELECT	LockableObjectLoaded, o.Name
            INTO	lockable_object, objectname
            FROM	wfsdw.MD_ETLProcess p
            JOIN	wfsdw.MD_LockableObject o
            ON (	o.LockableObjectKey = p.LockableObjectLoaded)
            WHERE	ETLProcessKey = etl_process;

            -- Not null, etc.
            IF lockable_object IS NULL OR objectname IS NULL THEN
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN error_status;
            END IF;
        EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN error_status;
        END;
        -- ETL Metadata: lock this ETL Object!
        SELECT * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);
        IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
            SELECT spMD_LogProcessFinishError(etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) INTO returned_error_status;
            RETURN error_status;
        END IF;
        -----------------------------------------------------------------------------
        -- Get the new sync date...
        --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.
        -- Fill up the DIFF table!

        BEGIN
            TRUNCATE TABLE WFSDW.STG1_DIFF_Log;
            INSERT INTO WFSDW.STG1_DIFF_Log(ROWID_, LOGID, LOGCLASS, LOGCLASSNAME, LOCALDATE, PROCESSDEFINITIONID, PROCESSINSTANCEID,
                                            NODEID, LOCALENTERDATE, LOCALLEAVEDATE, DURATION, RESOURCEGROUPID, RESOURCEID, ADMINSTATUSID,
                                            OPERSTATUSID, WFSCreateDate, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate)
            SELECT nextval('STG1_DIFF_Log_SEQ'), l.ID_ as LOGID, l.CLASS_ as LOGCLASS,
                   (CASE WHEN l.CLASS_ = 'N' THEN 'NODE'
                        WHEN l.CLASS_ = '7' THEN 'MESSAGE'
                        WHEN l.CLASS_ = '8' THEN 'USAGE'
                        WHEN l.CLASS_ = '9' THEN 'QUEUE'
                        ELSE 'UNKNOWN' END) as LOGCLASSNAME,
                   l.DATE_ as LOCALDATE, 
                   d.id,                              --n.PROCESSDEFINITION_, 
                   p.processid as PROCESSINSTANCEID,  -- p.ID_
                   ( CASE WHEN l.NODE_ =  NULL THEN 0 ELSE l.NODE_ END ) as NODEID, l.ENTER_ as LOCALENTERDATE,
                   l.LEAVE_ as LOCALLEAVEDATE, l.DURATION_ as DURATION, l.RESOURCEGROUPID, l.RESOURCEID, ADMINISTRATIVESTATUSID as ADMINSTATUSID,
                   OPERATIONALSTATUSID as OPERSTATUSID, l.CreateDate, l.UpdateDate, etl_process, run_instance, new_sync_date
              FROM WFS.JBPM_LOG l
              --JOIN WFS.JBPM_NODE n ON (n.ID_ = l.NODE_)
              JOIN WFS.ttv_token t ON (t.tokenid = l.TOKEN_)                  --(t.ID_ = l.TOKEN_)
              JOIN WFS.ttv_processinstance p ON  (p.processid = t.processid) --(p.ID_ = t.PROCESSINSTANCE_)
              JOIN WFS.ttv_template d ON (p.templateid = d.id)               --(p.PROCESSDEFINITION_ = d.ID_)
         WHERE d.typeid <> 1 
           AND l.Class_ in ('8','9')
           AND l.UpdateDate BETWEEN last_sync_date AND new_sync_date;

           GET DIAGNOSTICS affected_rows = ROW_COUNT;
        EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                error_message := procname || ': DB error loading STG1_DIFF_Log. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN error_status;
        END;

        BEGIN
         -- Lookup the TemplateWK field from DIM_Template table data.
            UPDATE WFSDW.STG1_DIFF_Log a
            SET TemplateWK= (SELECT b.TemplateWK
                               FROM wfsdw.DIM_Template b
                               WHERE b.ProcessDefinitionId = a.ProcessDefinitionId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the WorkOrderWK field from DIM_WorkOrder table data.
            UPDATE WFSDW.STG1_DIFF_Log a
            SET WorkOrderWK= (SELECT b.WorkOrderWK
                               FROM wfsdw.DIM_WorkOrder b
                               WHERE b.ProcessInstanceId = a.ProcessInstanceId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;
        EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                error_message := procname || ': DB error updating STG1_DIFF_Log. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN error_status;
        END;

        BEGIN
/*********************************************************************************
**********************************************************************************
***********  TEMPORARY FIX TO MAKE Data Warehouse NOT VOD SPECIFIC  *************
*********************************************************************************
*********************************************************************************/

        TRUNCATE TABLE WFSDW.STG1_DIFF_WORKORDER;

        INSERT INTO WFSDW.STG1_DIFF_WorkOrder(ROWID_, ProcessInstanceId, LocalStartDate, LocalEndDate, IssuSpended, ProcessDefinitionId, 
                                                  AdminStatusId, OperStatusId, PriorityId, Priority, ProviderName, PackageAssetID, Title, 
                                                  BriefTitle, AssetID, ObjectType, HouseMaterialID, BroadcastMaterialID, LicenseStart, 
                                                  LicenseEnd, WFSCreateDate, LastProdUpdateDate, DIFFETLProcess, DIFFRunInstance, DIFFDate) 
        SELECT 
               nextval('STG1_DIFF_WorkOrder_SEQ'), PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, 
               PROCESSDEFINITIONID, ADMINSTATUSID, OPERSTATUSID, PRIORITYID, PRIORITY, 'N/A', 'N/A', TITLE, 
               BRIEFTITLE, ASSETID, OBJECTTYPE, HOUSEMATERIALID, BROADCASTMATERIALID, LICENSESTART, LICENSEEND, 
               CREATEDATE, UPDATEDATE, etl_process, run_instance, new_sync_date
        FROM ( SELECT 
                      wo.processid AS PROCESSINSTANCEID, t.startdate AS LOCALSTARTDATE, t.enddate AS LOCALENDDATE, 0 AS ISSUSPENDED,
                      wo.templateid AS PROCESSDEFINITIONID, t.adminstatus AS ADMINSTATUSID, t.operationalstatus AS OPERSTATUSID,
                      wo.priority PRIORITYID, COALESCE (P.NAME, '[N/A]') AS PRIORITY,
                      (t.vars->'providerId'->>'value') AS ProviderName,
                      (t.vars->'packageAssetId'->>'value') AS PackageAssetID,
                      (t.vars->'titleId'->>'value') AS Title,                             -- it was title
                      (t.vars->'titleBrief'->>'value') AS BriefTitle,
                      (t.vars->'assetId'->>'value') AS AssetID,
                      (t.vars->'typeString'->>'value') AS ObjectType,                     -- it was type
                      (t.vars->'houseMaterialId'->>'value') AS HouseMaterialID,           -- not found
                      (t.vars->'broadcastMaterialId'->>'value') AS BroadcastMaterialID,   -- not found
                      (t.vars->'licensingWindowStart'->>'value') AS LicenseStart,         -- it was licStart
                      (t.vars->'licensingWindowEnd'->>'value') AS LicenseEnd,             -- it was licEnd
                      wo.createdate, wo.updatedate
             FROM WFS.TTV_PROCESSINSTANCE wo
             JOIN WFS.TTV_TEMPLATE TP ON (TP.ID = wo.templateid)
             JOIN WFS.TTV_ProcessDefinitionType dt ON (dt.ProcessDefinitionTypeId = tp.TypeId)
             LEFT JOIN WFS.TTV_PROCESSPRIORITY P ON (P.PROCESSPRIORITYID = wo.priority)
             JOIN ( select t1.tokenid, t1.parenttokenid, t1.processid, 0,t1.adminstatus, t1.operationalstatus, t1.startdate, t1.enddate, t1.vars, t1.updatedate 
                      from wfs.ttv_token t1 where t1.parenttokenid = 0
                    union all
                    select t1.tokenid, t1.parenttokenid, t1.processid, t2.processid, t1.adminstatus, t1.operationalstatus, t1.startdate, t1.enddate, t1.vars, t1.updatedate  
                      from wfs.ttv_token t1, wfs.ttv_token t2 
                     where t1.parenttokenid = t2.tokenid and (t1.processid <> t2.processid)
                   ) t on ( wo.PROCESSID = t.PROCESSID ) 
             --JOIN WFS.TTV_TOKEN t ON ( wo.processid = t.processid) -- AND (t.adminstatus NOT IN (2,6) --AND (vi.TASKINSTANCE_ is null)
             JOIN WFS.TTV_PROCESSSTATUS ADS ON ( ADS.PROCESSSTATUSID = t.adminstatus)
             JOIN WFS.TTV_PROCESSSTATUS OPS ON ( OPS.PROCESSSTATUSID = t.operationalstatus)
             JOIN WFSDW.STG1_DIFF_LOG sdl ON ( wo.processid = sdl.PROCESSINSTANCEID )
            WHERE sdl.WORKORDERWK is NULL 
              -- AND PROCESSINSTANCETYPEID <> 1
              AND wo.UpdateDate BETWEEN last_sync_date AND new_sync_date
            ORDER BY wo.processid) AS b;
        EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                error_message := procname || ': DB error loading STG1_DIFF_WorkOrder. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN error_status;
        END;

        BEGIN
            -- Lookup the TemplateWK field from DIM_Template table data.
            UPDATE WFSDW.STG1_DIFF_WorkOrder a
            SET TemplateWK= (SELECT b.TemplateWK
                               FROM wfsdw.DIM_Template b
                               WHERE b.ProcessDefinitionId = a.ProcessDefinitionId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the ProviderWK from DIM_VariableInstance table data.
            UPDATE WFSDW.STG1_DIFF_WORKORDER a
            SET ProviderWK = (SELECT b.VariableInstanceWK
                                FROM wfsdw.DIM_PROVIDER b
                                WHERE b.ProviderName = a.ProviderName);
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Set the LocalStartDateWK
            UPDATE WFSDW.STG1_DIFF_WORKORDER
            SET LocalStartDateWK = (to_char(LocalStartDate,'YYYYMMDD'))::numeric;
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the LocalStartTimeWK
            UPDATE WFSDW.STG1_DIFF_WORKORDER
            SET LocalStartTimeWK = (to_char(LocalStartDate,'HH24MISS'))::numeric;
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Convert License Dates
            UPDATE WFSDW.STG1_DIFF_WORKORDER
            SET LicenseStartDate = case when substr(LicenseStart,5,1) = '-' then to_date(LicenseStart,'RRRR-MM-DD') else to_date(LicenseStart,'MM/DD/RRRR') end,
                                 --decode(substr(LicenseStart,5,1),'-',to_date(LicenseStart,'RRRR-MM-DD'),to_date(LicenseStart,'MM/DD/RRRR')),
                LicenseEndDate = case when substr(LicenseEnd,5,1) = '-' then to_date(LicenseEnd,'RRRR-MM-DD') else to_date(LicenseEnd,'MM/DD/RRRR') end;
                               --decode(substr(LicenseEnd,5,1),'-',to_date(LicenseEnd,'RRRR-MM-DD'),to_date(LicenseEnd,'MM/DD/RRRR'));

        -- Lookup the AdminStatusWK
           UPDATE WFSDW.STG1_DIFF_WORKORDER a
           SET AdminStatusWK = (SELECT b.WorkOrderStatusWK
                                  FROM wfsdw.DIM_WORKORDERSTATUS b
                                  WHERE b.ProcessStatusID = a.AdminStatusID);
           --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        -- Lookup the OperStatusWK
           UPDATE WFSDW.STG1_DIFF_WORKORDER a
           SET OperStatusWK = (SELECT b.WorkOrderStatusWK
                                 FROM wfsdw.DIM_WORKORDERSTATUS b
                                 WHERE b.ProcessStatusID = a.OperStatusID);
           --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;
        EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                error_message := procname || ': DB error updating STG1_DIFF_WorkOrder. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN error_status;
        END;

        BEGIN
            UPDATE WFSDW.DIM_WorkOrder d 
              SET  Suspended = ( CASE WHEN s.IssuSpended = 1 THEN 'YES' ELSE 'NO' END ), Priority = s.Priority, localstartdate = s.localstartdate, 
                   localenddate = s.localenddate, PackageAssetID = s.PackageAssetID, AssetID = s.AssetID, 
                   AssetType = s.ObjectType, Title = s.Title, BriefTitle = s.BriefTitle, HouseMaterialID = s.HouseMaterialID, 
                   BroadcastMaterialID = s.BroadcastMaterialID, LicenseStartDate = s.LicenseStartDate,
                   LicenseEndDate = s.LicenseEndDate, LastProdUpdateDate = s.LastProdUpdateDate, 
                   LastETLProcess = etl_process, LastRunInstance = run_instance, UpdateDate = now()::timestamp
              FROM WFSDW.STG1_DIFF_WorkOrder s
             WHERE d.ProcessInstanceId = s.ProcessInstanceId;

            INSERT INTO WFSDW.DIM_WorkOrder
            SELECT nextval('DIM_WorkOrder_SEQ'), s.ProcessInstanceId, ( CASE WHEN s.IssuSpended = 1 THEN 'YES' ELSE 'NO' END ), s.Priority,
                   s.localstartdate, s.localenddate, s.PackageAssetID, s.AssetID, s.ObjectType, s.Title, s.BriefTitle, 
                   s.HouseMaterialID, s.BroadcastMaterialID, s.LicenseStartDate, s.LicenseEndDate, s.WFSCreateDate, 
                   s.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
              FROM WFSDW.STG1_DIFF_WorkOrder s
              LEFT OUTER JOIN WFSDW.DIM_WorkOrder ON (DIM_WorkOrder.ProcessInstanceId = S.ProcessInstanceId)
             WHERE DIM_WorkOrder.ProcessInstanceId IS NULL;

            INSERT INTO wfsdw.FACT_WORKORDERDETAIL(WorkOrderWK, TemplateWK, ProviderWK, LocalStartDateWK, LocalStartTimeWK, AdminStatusWK, OperStatusWK, 
                                                   WFSCreateDate, LastProdUpdateDate, LastETLProcess, LastRunInstance, CreateDate, UpdateDate)
            SELECT dim.WorkOrderWK, stg.TemplateWK, stg.ProviderWK, stg.LocalStartDateWK, stg.LocalStartTimeWK, stg.AdminStatusWK,
                   stg.OperStatusWK, stg.WFSCreateDate, stg.LastProdUpdateDate, etl_process, run_instance, now()::timestamp, now()::timestamp
            FROM WFSDW.STG1_DIFF_WORKORDER stg
            JOIN WFSDW.DIM_WORKORDER dim ON (dim.ProcessInstanceId = stg.ProcessInstanceId)
            WHERE stg.WFSCreateDate BETWEEN last_sync_date AND new_sync_date;


        /**** RERUN THE WO LOOKUP  *********************************************/
 
            UPDATE WFSDW.STG1_DIFF_Log a
            SET WorkOrderWK= (SELECT b.WorkOrderWK
                               FROM wfsdw.DIM_WorkOrder b
                               WHERE b.ProcessInstanceId = a.ProcessInstanceId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

/*************************************************************************************
**************************************************************************************
*******************  END Of FIX ******************************************************
**************************************************************************************
**************************************************************************************/

         -- Lookup the NodeWK field from DIM_Node table data.
            --UPDATE WFSDW.STG1_DIFF_Log a
            --SET NodeWK= (SELECT b.NodeWK
            --                   FROM wfsdw.DIM_Node b
            --                   WHERE b.NodeId = a.NodeId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

            UPDATE WFSDW.STG1_DIFF_Log a SET NodeWK=0 WHERE (a.NodeWK IS NULL);

         -- Lookup the ResourceGroupWK field from DIM_ResourceGroup table data.
            UPDATE WFSDW.STG1_DIFF_Log a
            SET ResourceGroupWK= (SELECT b.ResourceGroupWK
                               FROM wfsdw.DIM_ResourceGroup b
                               WHERE b.ResourceGroupId = a.ResourceGroupId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the ResourceWK field from DIM_Resource table data.
            UPDATE WFSDW.STG1_DIFF_Log a
            SET ResourceWK= (SELECT b.ResourceWK
                               FROM wfsdw.DIM_Resource b
                               WHERE b.ResourceId = a.ResourceId);
            --WHERE  WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Set the LocalStartDateWK
            UPDATE WFSDW.STG1_DIFF_LOG
            SET LocalEnterDateWK = (to_char(LocalEnterDate,'YYYYMMDD'))::numeric;
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the LocalStartTimeWK
            UPDATE WFSDW.STG1_DIFF_LOG
            SET LocalEnterTimeWK = (to_char(LocalEnterDate,'HH24MISS'))::numeric;
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the LocalLeaveDateWK
            UPDATE WFSDW.STG1_DIFF_LOG
            SET LocalLeaveDateWK = (to_char(LocalLeaveDate,'YYYYMMDD'))::numeric;
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the LocalLeaveTimeWK
            UPDATE WFSDW.STG1_DIFF_LOG
            SET LocalLeaveTimeWK = (to_char(LocalLeaveDate,'HH24MISS'))::numeric;
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the AdminStatusWK
            UPDATE WFSDW.STG1_DIFF_LOG a
            SET AdminStatusWK = (SELECT b.WorkOrderStatusWK
                      FROM wfsdw.DIM_WorkOrderStatus b
                      WHERE b.ProcessStatusID = a.AdminStatusID);
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

            -- Lookup the OperStatusWK
            UPDATE WFSDW.STG1_DIFF_LOG a
            SET OperStatusWK = (SELECT b.WorkOrderStatusWK
                       FROM wfsdw.DIM_WorkOrderStatus b
                      WHERE b.ProcessStatusID = a.OperStatusID);
            --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                error_message := procname || ': DB error updating STG1_DIFF_Log. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN error_status;
        END;
        -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
        -- occur due to problematic data in STG_DIFF.
        --COMMIT;
        -----------------------------------------
        -- Load Fact_ResourceQueueDetail data! --
        -----------------------------------------
        BEGIN

            -- Loading duration in seconds
            INSERT INTO wfsdw.FACT_RESOURCEQUEUEDETAIL(TemplateWK, WorkOrderWK, NodeWK, LocalEnterDateWK, LocalEnterTimeWK, ResourceWK, 
                                                       ResourceGroupWK, AdminStatusWK, OperStatusWK, Duration, WFSCreateDate, 
                                                       LastProdUpdateDate, LastETLProcess, LastRunInstance, CreateDate, UpdateDate)
            SELECT 
                   stg.TemplateWK,stg.WorkOrderWK, stg.NodeWK, stg.LocalEnterDateWK, stg.LocalEnterTimeWK,
                   stg.ResourceWK, stg.ResourceGroupWK, stg.AdminStatusWK, stg.OperStatusWK,
                   max(extract(second from (stg.LocalLeaveDate - stg.LocalEnterDate)) +
                    (extract(minute from (stg.LocalLeaveDate - stg.LocalEnterDate)) * 60) +
                    (extract(hour from (stg.LocalLeaveDate - stg.LocalEnterDate)) * 3600) +
                    (extract(day from (stg.LocalLeaveDate - stg.LocalEnterDate)) * 86400)) as Duration,
                   max(stg.WFSCreateDate) as WFSCreateDate, max(stg.LastProdUpdateDate) as LastProdUpdateDate,
                   etl_process, run_instance, now()::timestamp, now()::timestamp
            FROM WFSDW.STG1_DIFF_LOG stg
            WHERE stg.LOGCLASS = '9' AND stg.AdminStatusID = 4 and stg.WorkOrderWK is not null
              AND stg.OperStatusID = 4 AND stg.WFSCreateDate BETWEEN last_sync_date AND new_sync_date
            GROUP BY stg.TemplateWK, stg.WorkOrderWK, stg.NodeWK, stg.LocalEnterDateWK, stg.LocalEnterTimeWK,
                     stg.ResourceWK, stg.ResourceGroupWK, stg.AdminStatusWK, stg.OperStatusWK;
            EXCEPTION
                WHEN OTHERS THEN
                    v_sqlcode := SQLSTATE;
                    GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                    error_message := procname || ': DB error loading Fact_ResourceQueueDetail Data. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                    --ROLLBACK;
                    -- Release the object indicating that there was an error
                    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                    -- Close the etl process.
                    SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                    RETURN error_status;
        END;
        -----------------------------------------
        -- Load Fact_ResourceTaskDetail data! --
        -----------------------------------------
        BEGIN
            -- Loading duration in seconds
            INSERT INTO wfsdw.FACT_RESOURCETASKDETAIL(
                        TemplateWK, WorkOrderWK, NodeWK, LocalEnterDateWK, LocalEnterTimeWK, LocalLeaveDateWK, 
                        LocalLeaveTimeWK, ResourceWK, ResourceGroupWK, AdminStatusWK, OperStatusWK, Duration, 
                        WFSCreateDate, LastProdUpdateDate, LastETLProcess, LastRunInstance, CreateDate, UpdateDate)
            SELECT stg.TemplateWK, stg.WorkOrderWK, stg.NodeWK, stg.LocalEnterDateWK, stg.LocalEnterTimeWK, stg.LocalLeaveDateWK, 
                   stg.LocalLeaveTimeWK, stg.ResourceWK, stg.ResourceGroupWK, stg.AdminStatusWK, stg.OperStatusWK,
                   max(extract(second from (stg.LocalLeaveDate - stg.LocalEnterDate)) +
                    (extract(minute from (stg.LocalLeaveDate - stg.LocalEnterDate)) * 60) +
                    (extract(hour from (stg.LocalLeaveDate - stg.LocalEnterDate)) * 3600) +
                    (extract(day from (stg.LocalLeaveDate - stg.LocalEnterDate)) * 86400)) as Duration,
                  max(stg.WFSCreateDate) as WFSCreateDate, max(stg.LastProdUpdateDate) as LastProdUpdateDate,
                  etl_process, run_instance, now()::timestamp, now()::timestamp
            FROM WFSDW.STG1_DIFF_LOG stg
            WHERE stg.LOGCLASS = '8' AND  stg.WFSCreateDate BETWEEN last_sync_date AND new_sync_date and stg.WorkOrderWK is not null
            GROUP BY  stg.TemplateWK, stg.WorkOrderWK, stg.NodeWK, stg.LocalEnterDateWK, stg.LocalEnterTimeWK, stg.LocalLeaveDateWK, 
                      stg.LocalLeaveTimeWK, stg.ResourceWK, stg.ResourceGroupWK, stg.AdminStatusWK, stg.OperStatusWK;
        EXCEPTION
                WHEN OTHERS THEN
                    v_sqlcode := SQLSTATE;
                    GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                    error_message := procname || ': DB error loading Fact_ResourceTaskDetail Data. Reason for the failure: '|| substring(excp_primary_msg,1,250);
                    --ROLLBACK;
                    -- Release the object indicating that there was an error
                    SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                    -- Close the etl process.
                    SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                    RETURN error_status;
        END;
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, new_sync_date, 0,0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK(etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
        RETURN error_status;
  EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject(lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError(etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
  END;
  $func_spSYNC_Log$ LANGUAGE plpgsql;

--9
/*
	*****************************************************************************
	PROCEDURE: spSYNC_MonitoredDriveHistory
	[ETL - MD Compliant]
	*****************************************************************************
	Loads dimension table FACT_MonitoredDriveHistory.

	*****************************************************************************
	[USED BY]	ETL - DW Load process
	*****************************************************************************
	[By Chris Scherlacher - 07/09/2007]
	*****************************************************************************
	Change Log: 

	*****************************************************************************
*/ 
DROP FUNCTION IF EXISTS spSYNC_MonitoredDriveHistory(integer,integer,integer,text);
CREATE OR REPLACE FUNCTION spSYNC_MonitoredDriveHistory (
    parent_etl_process  int DEFAULT NULL,
    parent_run_instance int DEFAULT NULL,
    force_lock          int DEFAULT 0,
    nsync_date          text default '')
RETURNS smallint AS $func_spSYNC_MonitoredDriveHistory$
DECLARE
    etl_process           int;
    run_instance          int;
    returned_error_status int;
    lockable_object       int;
    procname              varchar (100);
    objectname            varchar (100);
    last_sync_date        timestamp;
    error_message         varchar (500);
    affected_rows         int;
    v_sqlcode             TEXT;
    recs_not_inserted     int;
    recs_to_insert        int;
    v_exists              char(1);
    v_MonitoredDrive      WFSDW.STG1_DIFF_MDRIVEHISTORY%ROWTYPE;
    v_MonitoredDriveWK    numeric;
    error_status          int;
    tmp_results           numeric;
    new_sync_date         timestamp ;
    excp_primary_msg      text;    

    MonitoredDriveCursor CURSOR FOR
    select MONITOREDDRIVEID, 
           CURRENTDRIVENAME, 
           CURRENTDESCRIPTION,
           CURRENTPATH,
           CURRENTINTERNALDRIVEID,
           CURRENTTOTALCAPACITY,
           CURRENTWARNINGTHRESHOLDPERCENT,
           CURRENTERRORTHRESHOLDPERCENT,
           MIN(WFSCreateDate)
      From wfsdw.STG1_DIFF_MDRIVEHISTORY
     Group by MONITOREDDRIVEID, 
              CURRENTDRIVENAME, 
              CURRENTDESCRIPTION,
              CURRENTPATH,
              CURRENTINTERNALDRIVEID,
              CURRENTTOTALCAPACITY,
              CURRENTWARNINGTHRESHOLDPERCENT,
              CURRENTERRORTHRESHOLDPERCENT
     Order by MIN(WFSCreateDate);

BEGIN
        -- Initialize...
        error_status := -1;
        procname := 'spSYNC_MonitoredDriveHistory';
        affected_rows := 0;
        SELECT to_timestamp(nsync_date,'mm/dd/yyyy hh24:mi:ss')::TIMESTAMP WITHOUT TIME ZONE INTO new_sync_date;
        -----------------------------------------------------------------------------
        -- [ETL METADATA INFO]
        -- Unique identifier for this ETL Process, DO NOT CHANGE!
        etl_process := 12;
        -----------------------------------------------------------------------------

        -- [ETL METADATA INITIALIZATION]
        -- Obtain a RunInstance for this ETL Process
        SELECT * INTO returned_error_status, run_instance FROM spMD_LogProcessStart ( etl_process, parent_etl_process, parent_run_instance, NULL ) ;

        IF run_instance < 1 OR  returned_error_status <> 0 THEN
            SELECT spMD_WriteEventLog (procname, '-1','', 'METADATA ERROR: error in call to spSYNC_MonitoredDriveHistory ProcessStart / could not obtain a RunInstance. Exiting procedure!');
            RETURN error_status;
        END IF;

        BEGIN
            -- Get the object ID in order to lock it...
            SELECT LockableObjectLoaded, o.Name
              INTO lockable_object, objectname
              FROM wfsdw.MD_ETLProcess p
              JOIN wfsdw.MD_LockableObject o ON (o.LockableObjectKey = p.LockableObjectLoaded)
             WHERE ETLProcessKey = etl_process;

            -- Not null, etc.
            IF lockable_object IS NULL OR objectname IS NULL THEN
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN error_status;
            END IF;
        EXCEPTION
            WHEN OTHERS THEN -- No data found, for instance...
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Couldn''t determine the LockableObjectLoaded!', affected_rows, NULL) INTO returned_error_status;
                RETURN error_status;
        END;

        -- ETL Metadata: lock this ETL Object!
        SELECT  * INTO returned_error_status, last_sync_date FROM spMD_LockObject (lockable_object, etl_process, run_instance, force_lock, 0);

        IF returned_error_status <> 0 OR last_sync_date IS NULL THEN
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, 'Unable to lock object ' || objectname || '! Exiting procedure...', affected_rows, NULL) 
              INTO returned_error_status;
            RETURN error_status;
        END IF;

        -----------------------------------------------------------------------------
        -- Get the new sync date...
        --new_sync_date := dateadd ('N', -1, current_systimestamp); -- 1 minute ago, just to be sure.
        -- Fill up the DIFF table!
        BEGIN
            TRUNCATE TABLE WFSDW.STG1_DIFF_MDriveHistory;

            INSERT INTO WFSDW.STG1_DIFF_MDriveHistory (ROWID_, MonitoredDriveHistoryId,  MonitoredDriveId, CurrentDriveName, CurrentDescription, CurrentPath,
                        CurrentInternalDriveID, CurrentTotalCapacity, CurrentWarningThresholdPercent, CurrentErrorThresholdPercent, CurrentBytesUsed,
                        CurrentDriveStatusId, CurrentDriveStatusName, SampleDateTime, LastProdUpdateDate, DIFFETLProcess,  DIFFRunInstance, DIFFDate, WFSCreateDate)
            SELECT nextval('STG1_DIFF_MDriveHistory_SEQ'), mdh.MonitoredDriveHistoryId,  mdh.MonitoredDriveId, md.Name as DriveName, md.DESCRIPTION, md.PATH,
                   md.INTERNALDRIVEID, mdh.TOTALCAPACITY, mdh.WARNINGTHRESHOLDPERCENT, mdh.ERRORTHRESHOLDPERCENT, mdh.CurrentBytesUsed, mdh.CurrentDriveStatusId,  
                   mds.Name as DriveStatusName,  mdh.SampleDateTime, mdh.CreateDate, etl_process, run_instance, new_sync_date, mdh.CreateDate
            FROM  WFS.TTV_MONITOREDDRIVEHISTORY mdh
              JOIN WFS.TTV_MONITOREDDRIVESTATUS mds ON mds.MonitoredDriveStatusId = mdh.CurrentDriveStatusId
              JOIN WFS.TTV_MONITOREDDRIVE md ON md.MONITOREDDRIVEID = mdh.MONITOREDDRIVEID
            WHERE  mdh.CreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Set the LocalStartDateWK
            UPDATE WFSDW.STG1_DIFF_MDRIVEHISTORY
               SET LocalDateWK = (to_char(SampleDateTime,'YYYYMMDD'))::numeric;
             --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

         -- Lookup the LocalStartTimeWK
            UPDATE WFSDW.STG1_DIFF_MDRIVEHISTORY
               SET LocalTimeWK = (to_char(SampleDateTime,'HH24MISS'))::numeric;
             --WHERE WFSCreateDate BETWEEN last_sync_date AND new_sync_date;

        EXCEPTION
            WHEN OTHERS THEN
                v_sqlcode := SQLSTATE;
                GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
                error_message := procname || ': DB error loading STG_DIFF_MonitoredDriveHistory. Reason for the failure: ' || substring(excp_primary_msg,1,250);
                raise notice 'At spSYNC_MonitoredDriveHistory STG_DIFF_MonitoredDriveHistory : ERROR.....%  :  %',sqlstate, sqlerrm;
                --ROLLBACK;
                -- Release the object indicating that there was an error
                SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
                -- Close the etl process.
                SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
                RETURN error_status;
        END;
        -- Commit changes to DIFF table to facilitate the debugging process if there was an error -- typically, errors
        -- occur due to problematic data in STG_DIFF.
        --COMMIT;
        -----------------------------------
        -- Load DIM_MonitoredDriveStatus!!
        -----------------------------------
        BEGIN
            UPDATE WFSDW.DIM_MonitoredDriveStatus d SET  Name = CurrentDriveStatusName,
                                LastProdUpdateDate = s.LastProdUpdateDate,
                                LastETLProcess = etl_process,
                                LastRunInstance = run_instance,
                                UpdateDate = now()::timestamp
            FROM  (SELECT a.CURRENTDRIVESTATUSID, a.CURRENTDRIVESTATUSNAME, b.WFSCREATEDATE, c.LASTPRODUPDATEDATE
                         FROM (SELECT DISTINCT CURRENTDRIVESTATUSID, CURRENTDRIVESTATUSNAME
                               FROM WFSDW.STG1_DIFF_MDRIVEHISTORY) a
                           JOIN (SELECT CurrentDriveStatusId, MIN(WFSCREATEDATE) as WFSCREATEDATE
                                 FROM WFSDW.STG1_DIFF_MDriveHistory
                                GROUP BY CURRENTDRIVESTATUSID) b
                             ON a.CURRENTDRIVESTATUSID = b.CURRENTDRIVESTATUSID
                           JOIN (SELECT CURRENTDRIVESTATUSID, MAX(LASTPRODUPDATEDATE) as LASTPRODUPDATEDATE
                                 FROM WFSDW.STG1_DIFF_MDriveHistory
                                 GROUP BY CURRENTDRIVESTATUSID) c
                             ON a.CURRENTDRIVESTATUSID = c.CURRENTDRIVESTATUSID
                         ORDER BY a.CURRENTDRIVESTATUSID) AS s
            WHERE d.DriveStatusId = s.CurrentDriveStatusId;

            INSERT INTO WFSDW.DIM_MonitoredDriveStatus
	    SELECT nextval('DIM_MONITOREDDRIVESTATUS_SEQ'), CurrentDriveStatusId, CurrentDriveStatusName, WFSCREATEDATE, 
	           WFSCREATEDATE, etl_process, run_instance, now()::timestamp, now()::timestamp
            FROM (SELECT a.CURRENTDRIVESTATUSID, a.CURRENTDRIVESTATUSNAME, b.WFSCREATEDATE, c.LASTPRODUPDATEDATE
                         FROM (SELECT DISTINCT CURRENTDRIVESTATUSID, CURRENTDRIVESTATUSNAME
                               FROM WFSDW.STG1_DIFF_MDRIVEHISTORY) a
                           JOIN (SELECT CurrentDriveStatusId, MIN(WFSCREATEDATE) as WFSCREATEDATE
                                 FROM WFSDW.STG1_DIFF_MDriveHistory
                                GROUP BY CURRENTDRIVESTATUSID) b
                             ON a.CURRENTDRIVESTATUSID = b.CURRENTDRIVESTATUSID
                           JOIN (SELECT CURRENTDRIVESTATUSID, MAX(LASTPRODUPDATEDATE) as LASTPRODUPDATEDATE
                                 FROM WFSDW.STG1_DIFF_MDriveHistory
                                 GROUP BY CURRENTDRIVESTATUSID) c
                             ON a.CURRENTDRIVESTATUSID = c.CURRENTDRIVESTATUSID
            LEFT OUTER JOIN WFSDW.DIM_MonitoredDriveStatus d ON d.DriveStatusId = a.CurrentDriveStatusId
            WHERE d.DriveStatusId IS NULL
            ORDER BY a.CURRENTDRIVESTATUSID) AS x;
            GET DIAGNOSTICS affected_rows = ROW_COUNT;
        --COMMIT; -- Yay!
        --error_status := 0;
    EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
        error_message := procname || ': DB error loading DIM_MonitoredDriveStatus. Reason for the failure:' || substring(excp_primary_msg,1,250);
        raise notice 'At spSYNC_MonitoredDriveHistory DIM_MonitoredDriveStatus : ERROR.....%  :  %',sqlstate, sqlerrm;
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
    END;
    ------------------------------
    -- Load Dim_MonitoredDrive  --
    --    Type 2 Dimension     --
    ------------------------------
    BEGIN
        -- Open Cursor
        OPEN MonitoredDriveCursor;
        -- Loop through cursor and fetch records into variables.
        LOOP
            FETCH MonitoredDriveCursor into v_MonitoredDrive.MONITOREDDRIVEID,
                       			v_MonitoredDrive.CURRENTDRIVENAME,
                 			v_MonitoredDrive.CURRENTDESCRIPTION,
                 			v_MonitoredDrive.CURRENTPATH,
                 			v_MonitoredDrive.CURRENTINTERNALDRIVEID,
                 			v_MonitoredDrive.CURRENTTOTALCAPACITY,
                 			v_MonitoredDrive.CURRENTWARNINGTHRESHOLDPERCENT,
                 			v_MonitoredDrive.CURRENTERRORTHRESHOLDPERCENT,
                 			v_MonitoredDrive.WFSCreateDate;
            -- Exit loop when cursor is not found
            EXIT WHEN NOT FOUND;
            -- Check if a current DIM record exists for the current variables.	
            BEGIN
               -- Does it exist??
	       SELECT 'x'
               INTO v_exists
	       FROM wfsdw.DIM_MONITOREDDRIVE
	       WHERE v_MonitoredDrive.MONITOREDDRIVEID = MONITOREDDRIVEID 
                 AND v_MonitoredDrive.CURRENTDRIVENAME = NAME_ 
                 AND v_MonitoredDrive.CURRENTDESCRIPTION = DESCRIPTION 
                 AND v_MonitoredDrive.CURRENTPATH = PATH_ 
                 AND v_MonitoredDrive.CURRENTINTERNALDRIVEID = INTERNALDRIVEID 
                 AND v_MonitoredDrive.CURRENTTOTALCAPACITY = TOTALCAPACITY 
                 AND v_MonitoredDrive.CURRENTWARNINGTHRESHOLDPERCENT = WARNINGTHRESHOLDPERCENT 
                 AND v_MonitoredDrive.CURRENTERRORTHRESHOLDPERCENT = ERRORTHRESHOLDPERCENT 
                 AND WFSENDDATE is NULL;
                     -- No, the record does not exists an new record or version is needed.
                IF (v_exists IS NULL) THEN
                     -- Check if a new version of and existing DIM record is needed.
                     BEGIN
                         -- Is there a current version??
                         SELECT MONITOREDDRIVEWK
                           INTO v_MonitoredDriveWK
                           FROM wfsdw.DIM_MONITOREDDRIVE
                          WHERE v_MonitoredDrive.MONITOREDDRIVEID = MONITOREDDRIVEID 
                            AND WFSENDDATE is NULL;
                         -- Yes, there is a current version need to set the end date for the version.

                         UPDATE WFSDW.DIM_MONITOREDDRIVE
                            SET WFSENDDATE = v_MonitoredDrive.WFSCreateDate
                          WHERE MONITOREDDRIVEWK = v_MonitoredDriveWK;

                         -- No, there is not a current verion.  Only a new insert is needed. 
                     EXCEPTION 
                         WHEN NO_DATA_FOUND THEN
                         NULL;
                     END;
                     -- Insert New DIM Record
                     INSERT INTO WFSDW.DIM_MONITOREDDRIVE(MONITOREDDRIVEWK, MONITOREDDRIVEID, NAME_, DESCRIPTION, 
                                 PATH_, INTERNALDRIVEID, TOTALCAPACITY, WARNINGTHRESHOLDPERCENT, ERRORTHRESHOLDPERCENT,
                                 WFSCREATEDATE, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
                     VALUES (nextval('DIM_MONITOREDDRIVE_SEQ'),v_MonitoredDrive.MONITOREDDRIVEID,v_MonitoredDrive.CURRENTDRIVENAME,
                             v_MonitoredDrive.CURRENTDESCRIPTION,v_MonitoredDrive.CURRENTPATH,v_MonitoredDrive.CURRENTINTERNALDRIVEID,
                             v_MonitoredDrive.CURRENTTOTALCAPACITY,v_MonitoredDrive.CURRENTWARNINGTHRESHOLDPERCENT,
                             v_MonitoredDrive.CURRENTERRORTHRESHOLDPERCENT,v_MonitoredDrive.WFSCreateDate,
                             etl_process, run_instance, now()::timestamp, now()::timestamp);
                END IF;
            END;
        END LOOP;
        CLOSE MonitoredDriveCursor;
        --COMMIT; -- Yay!
        --error_status := 0;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading DIM_MonitoredDrive. Reason for the failure ' || substring(excp_primary_msg,1,250);
            raise notice 'At spSYNC_MonitoredDriveHistory DIM_MONITOREDDRIVE : ERROR.....%  :  %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;
    -------------------------------------
    -- Load Fact_MonitoredDriveHistory --
    -------------------------------------
    BEGIN
        INSERT INTO WFSDW.FACT_MDHISTORYDETAIL(MONITOREDDRIVEWK, MONITOREDDRIVESTATUSWK, LOCALDATEWK, LOCALTIMEWK,
                                               CURRENTBYTESUSED, LASTETLPROCESS, LASTRUNINSTANCE, CREATEDATE, UPDATEDATE)
        SELECT md.MONITOREDDRIVEWK, d.MONITOREDDRIVESTATUSWK, stg.LOCALDATEWK, stg.LOCALTIMEWK, MAX(stg.CurrentBytesUsed),
               etl_process, run_instance, NOW()::TIMESTAMP, NOW()::TIMESTAMP
          FROM WFSDW.STG1_DIFF_MDriveHistory stg
          JOIN WFSDW.DIM_MONITOREDDRIVESTATUS d ON stg.CurrentDriveStatusID = d.DriveStatusID
          JOIN WFSDW.DIM_MONITOREDDRIVE md ON ( stg.MonitoredDriveID = md.MonitoredDriveID 
                                                AND stg.CurrentDriveName = md.Name_ 
                                                AND stg.CurrentDescription = md.Description 
                                                AND stg.CurrentPath = md.Path_ 
                                                AND stg.CurrentInternalDriveID = md.InternalDriveID 
                                                AND stg.CurrentTotalCapacity = md.TotalCapacity 
                                                AND stg.CurrentWarningThresholdPercent = md.WarningThresholdPercent 
                                                AND stg.CurrentErrorThresholdPercent = md.ErrorThresholdPercent 
                                                AND md.WFSEndDate is NULL )
         WHERE stg.WFSCreateDate BETWEEN last_sync_date AND new_sync_date
         GROUP BY md.MONITOREDDRIVEWK,d.MONITOREDDRIVESTATUSWK,stg.LOCALDATEWK,stg.LOCALTIMEWK;

        GET DIAGNOSTICS affected_rows = ROW_COUNT;
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, new_sync_date, 0, 0) INTO returned_error_status;
        SELECT spMD_LogProcessFinishOK (etl_process, run_instance, NULL, affected_rows) INTO returned_error_status;
        --COMMIT; -- Yay!
        error_status := 0;
    EXCEPTION
        WHEN OTHERS THEN
            v_sqlcode := SQLSTATE;
            GET STACKED DIAGNOSTICS excp_primary_msg = MESSAGE_TEXT;
            error_message := procname || ': DB error loading FACT_MonitoredDriveHistory. Reason for the failure: ' || substring(excp_primary_msg,1,250);
            raise notice 'At spSYNC_MonitoredDriveHistory Fact_MonitoredDriveHistory : ERROR.....%  :  %',sqlstate, sqlerrm;
            --ROLLBACK;
            -- Release the object indicating that there was an error
            SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
            -- Close the etl process.
            SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
            RETURN error_status;
    END;
    RETURN error_status;
EXCEPTION
    WHEN OTHERS THEN
        v_sqlcode := SQLSTATE;
        error_message := procname || ': Global exception handler -> unknown error has occurred!';
        raise notice 'At spSYNC_MonitoredDriveHistory End : ERROR.....%  :  %',sqlstate, sqlerrm;
        --ROLLBACK;
        -- Release the object indicating that there was an error
        SELECT spMD_ReleaseObject (lockable_object, etl_process, run_instance, NULL, 1, 0) INTO returned_error_status;
        -- Close the etl process.
        SELECT spMD_LogProcessFinishError (etl_process, run_instance, error_message, 0, v_sqlcode) INTO returned_error_status;
        RETURN error_status;
END;
$func_spSYNC_MonitoredDriveHistory$ LANGUAGE plpgsql;
